/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseCharacterStreamWrapper;
import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseColumns;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseImplResultSetService;
import com.metamatrix.jdbc.base.BaseInputStreamWrapper;
import com.metamatrix.jdbc.base.BaseTimestamp;
import com.metamatrix.util.UtilSmallDecimal;
import com.metamatrix.util.UtilStringFunctions;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public final class BaseImplResultSetClientSideUpdatable
extends BaseImplResultSetService {
    private static String footprint = "$Revision:   3.10.1.1  $";
    private String tableName;
    private BaseColumns columns;
    private BaseData[] keyValues;
    private BaseData[] updatedValues;
    private BaseConnection connection;
    private PreparedStatement updateStatement;
    private PreparedStatement deleteStatement;
    private PreparedStatement insertStatement;
    private int[] previousUpdateColumns;
    private int[] previousDeleteColumns;
    private int[] previousInsertColumns;
    boolean onInsertRow;
    String identifierQuote;

    BaseImplResultSetClientSideUpdatable(BaseConnection baseConnection, String string, BaseColumns baseColumns, String string2) throws SQLException {
        this.connection = baseConnection;
        this.tableName = string;
        this.columns = baseColumns;
        this.identifierQuote = string2;
        this.onInsertRow = false;
    }

    public void close() throws SQLException {
        super.close();
        if (this.updateStatement != null) {
            this.updateStatement.close();
        }
        if (this.deleteStatement != null) {
            this.deleteStatement.close();
        }
        if (this.insertStatement != null) {
            this.insertStatement.close();
        }
    }

    public int getConcurrency() {
        return 1008;
    }

    public BaseData getData(int n, int n2) throws SQLException {
        if (this.updatedValues != null && this.updatedValues[n - 1] != null) {
            return this.updatedValues[n - 1];
        }
        if (this.onInsertRow) {
            String[] stringArray = new String[]{Integer.toString(n)};
            throw this.exceptions.getException(6102, stringArray);
        }
        if (this.subImplResultSet.getColumnAccess() == 1) {
            this.cacheKeyDataUpToColumn(n);
        }
        BaseData baseData = this.subImplResultSet.getData(n, n2);
        this.setupKeyValues();
        this.keyValues[n - 1] = baseData;
        return baseData;
    }

    private void cacheKeyDataUpToColumn(int n) throws SQLException {
        this.setupKeyValues();
        --n;
        int n2 = 0;
        while (n2 < n) {
            if (this.keyValues[n2] == null && this.columns.get((int)(n2 + 1)).isKey) {
                this.keyValues[n2] = this.subImplResultSet.getData(n2 + 1, this.columns.get((int)(n2 + 1)).baseDataType);
            }
            ++n2;
        }
    }

    public void updateData(int n, BaseData baseData) throws SQLException {
        if (this.subImplResultSet.getColumnAccess() == 1 && !this.onInsertRow) {
            this.cacheKeyDataUpToColumn(n + 1);
        }
        this.setupUpdatedValues();
        this.updatedValues[n - 1] = baseData;
    }

    public void updateRow() throws SQLException {
        this.setupPreviousColumnsLists();
        this.setupUpdatedValues();
        if (this.getUpdatedValuesCount() == 0) {
            throw this.implStatement.implConnection.exceptions.getException(6108);
        }
        this.updateStatement = this.executeStatement(this.updateStatement, this.previousUpdateColumns, "UPDATE " + this.tableName + " set ", " = ? ", true, "", "WHERE ", 6057, 6056);
    }

    public void cancelUpdates() throws SQLException {
        if (this.updatedValues != null) {
            int n = 0;
            while (n < this.updatedValues.length) {
                this.updatedValues[n] = null;
                ++n;
            }
        }
    }

    public void deleteRow() throws SQLException {
        this.setupPreviousColumnsLists();
        this.deleteStatement = this.executeStatement(this.deleteStatement, this.previousDeleteColumns, "DELETE FROM " + this.tableName, null, false, " ", " WHERE ", 6057, 6059);
    }

    public void prepareInsertRow() throws SQLException {
        this.cancelUpdates();
        this.onInsertRow = true;
    }

    public void cancelInsertRow() throws SQLException {
        this.cancelUpdates();
        this.onInsertRow = false;
    }

    public void insertRow() throws SQLException {
        this.setupPreviousColumnsLists();
        String string = "INSERT INTO " + this.tableName;
        this.setupUpdatedValues();
        int n = this.columns.count(1);
        boolean bl = false;
        if (this.getUpdatedValuesCount() == 0) {
            switch (this.connection.implConnection.getEmptyRowInsertSyntax()) {
                case 1: {
                    string = string + " default values";
                    break;
                }
                case 2: {
                    string = string + " values ()";
                    break;
                }
                case 3: {
                    string = string + " values (";
                    int n2 = this.columns.count(1);
                    int n3 = 0;
                    while (n3 < n2) {
                        if (n3 != 0) {
                            string = string + ",";
                        }
                        string = string + "default";
                        ++n3;
                    }
                    string = string + " )";
                    break;
                }
                case 4: {
                    string = string + " values (";
                    int n4 = this.columns.count(1);
                    int n5 = 0;
                    while (n5 < n4) {
                        if (n5 != 0) {
                            string = string + ",";
                        }
                        string = string + "NULL";
                        ++n5;
                    }
                    string = string + " )";
                    break;
                }
                default: {
                    throw this.implStatement.implConnection.exceptions.getException(6076);
                }
            }
            this.insertStatement = this.executeStatement(this.insertStatement, this.previousInsertColumns, string, "", false, "", null, 6062, 0);
        } else {
            string = string + " (";
            int n6 = 0;
            while (n6 < n) {
                BaseColumn baseColumn = this.columns.get(n6 + 1);
                if (this.updatedValues[n6] != null) {
                    if (bl) {
                        string = string + ", ";
                    } else {
                        bl = true;
                    }
                    string = string + this.identifierQuote + baseColumn.name + this.identifierQuote;
                }
                ++n6;
            }
            string = string + ") VALUES (";
            this.insertStatement = this.executeStatement(this.insertStatement, this.previousInsertColumns, string, "? ", false, ")", null, 6062, 0);
        }
    }

    public PreparedStatement executeStatement(PreparedStatement preparedStatement, int[] nArray, String string, String string2, boolean bl, String string3, String string4, int n, int n2) throws SQLException {
        String[] stringArray;
        BaseColumn baseColumn;
        int n3;
        int n4 = 0;
        int n5 = this.getUpdatedValuesCount();
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl2 = false;
        n4 = this.columns.count(0);
        if (string4 != null) {
            n7 = this.columns.count(3);
            this.cacheKeyDataUpToColumn(n4 + 1);
        }
        if (this.statementNeedsBuilding(preparedStatement, nArray)) {
            n3 = 0;
            while (n3 < n4) {
                baseColumn = this.columns.get(n3 + 1);
                if (string2 != null && n3 < this.updatedValues.length && this.updatedValues[n3] != null) {
                    boolean bl3 = true;
                    if (bl) {
                        string = string + this.identifierQuote + UtilStringFunctions.trim((String)baseColumn.name, (int)2) + this.identifierQuote;
                    }
                    string = string + string2;
                    if (++n6 < n5 && bl3) {
                        string = string + ", ";
                    }
                }
                if (string4 != null && baseColumn.isKey) {
                    string4 = this.keyValues[n3].isNull() ? string4 + this.identifierQuote + UtilStringFunctions.trim((String)baseColumn.name, (int)2) + this.identifierQuote + " IS NULL " : string4 + this.identifierQuote + UtilStringFunctions.trim((String)baseColumn.name, (int)2) + this.identifierQuote + " = ? ";
                    if (n8 < n7 - 1) {
                        string4 = string4 + "and ";
                    }
                    ++n8;
                }
                ++n3;
            }
            String string5 = string + string3;
            if (string4 != null) {
                string5 = string5 + string4;
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            stringArray = this.connection.statementPool;
            this.connection.statementPool = null;
            preparedStatement = this.connection.prepareStatement(string5);
            this.connection.statementPool = stringArray;
            bl2 = true;
        }
        n6 = 0;
        n8 = 0;
        n3 = 0;
        while (n3 < n4) {
            baseColumn = this.columns.get(n3 + 1);
            if (string2 != null && n3 < this.updatedValues.length && this.updatedValues[n3] != null) {
                this.setParameter(preparedStatement, n6 + 1, this.updatedValues[n3], baseColumn, false);
                ++n6;
            }
            if (string4 != null && this.keyValues[n3] != null && baseColumn.isKey && !this.keyValues[n3].isNull()) {
                this.setParameter(preparedStatement, n5 + n8 + 1, this.keyValues[n3], baseColumn, true);
                ++n8;
            }
            ++n3;
        }
        this.cacheBoundColumns(nArray);
        int n9 = 0;
        try {
            n9 = preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            if (bl2) {
                preparedStatement.close();
            }
            throw this.implStatement.implConnection.exceptions.getException(sQLException, n);
        }
        if (n9 > 1) {
            stringArray = new String[]{Integer.toString(n9)};
            this.warnings.add(n2, stringArray);
        } else if (n9 != 1) {
            throw this.implStatement.implConnection.exceptions.getException(n);
        }
        return preparedStatement;
    }

    private void setupKeyValues() {
        if (this.keyValues == null) {
            this.keyValues = new BaseData[this.columns.count(0)];
        }
    }

    private void setupUpdatedValues() {
        if (this.updatedValues == null) {
            this.updatedValues = new BaseData[this.columns.count(1)];
        }
    }

    private void setupPreviousColumnsLists() {
        int n = this.columns.count(0) * 2 + 1;
        if (this.previousDeleteColumns == null) {
            this.previousDeleteColumns = new int[n];
            this.previousDeleteColumns[0] = 0;
        }
        if (this.previousInsertColumns == null) {
            this.previousInsertColumns = new int[n];
            this.previousInsertColumns[0] = 0;
        }
        if (this.previousUpdateColumns == null) {
            this.previousUpdateColumns = new int[n];
            this.previousUpdateColumns[0] = 0;
        }
    }

    private int getUpdatedValuesCount() {
        int n = 0;
        if (this.updatedValues != null) {
            int n2 = 0;
            while (n2 < this.updatedValues.length) {
                if (this.updatedValues[n2] != null) {
                    ++n;
                }
                ++n2;
            }
        }
        return n;
    }

    private int getKeyValuesCount() {
        int n = 0;
        if (this.keyValues != null) {
            int n2 = 0;
            while (n2 < this.keyValues.length) {
                if (this.keyValues[n2] != null && !this.keyValues[n2].isNull()) {
                    ++n;
                }
                ++n2;
            }
        }
        return n;
    }

    private void setParameter(PreparedStatement preparedStatement, int n, BaseData baseData, BaseColumn baseColumn, boolean bl) throws SQLException {
        BaseInputStreamWrapper baseInputStreamWrapper = null;
        BaseCharacterStreamWrapper baseCharacterStreamWrapper = null;
        if (baseData.isNull()) {
            preparedStatement.setNull(n, baseColumn.type);
        } else {
            switch (baseData.getType()) {
                case 15: {
                    baseInputStreamWrapper = (BaseInputStreamWrapper)baseData.getASCIIStream(-1, this.connection, this.implStatement.implConnection.exceptions);
                    preparedStatement.setAsciiStream(n, (InputStream)baseInputStreamWrapper, (int)baseInputStreamWrapper.numTotalBytesInStream);
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    baseCharacterStreamWrapper = (BaseCharacterStreamWrapper)baseData.getCharacterStreamReader(-1, this.connection, this.implStatement.implConnection.exceptions);
                    preparedStatement.setCharacterStream(n, (Reader)baseCharacterStreamWrapper, (int)baseCharacterStreamWrapper.numTotalCharsInReader);
                    break;
                }
                case 14: {
                    baseInputStreamWrapper = (BaseInputStreamWrapper)baseData.getBinaryStream(-1, this.connection, this.implStatement.implConnection.exceptions);
                    preparedStatement.setBinaryStream(n, (InputStream)baseInputStreamWrapper, (int)baseInputStreamWrapper.numTotalBytesInStream);
                    break;
                }
                case 21: {
                    preparedStatement.setDouble(n, ((UtilSmallDecimal)baseData.getObject()).doubleValue());
                    break;
                }
                default: {
                    Object object = baseData.getObject();
                    if (object instanceof BaseTimestamp) {
                        object = ((BaseTimestamp)object).getTimestamp();
                    }
                    preparedStatement.setObject(n, object);
                }
            }
        }
    }

    private boolean statementNeedsBuilding(PreparedStatement preparedStatement, int[] nArray) {
        int n;
        int n2;
        if (preparedStatement == null) {
            return true;
        }
        if (nArray[0] != this.getUpdatedValuesCount() + this.getKeyValuesCount()) {
            return true;
        }
        if (this.updatedValues != null) {
            n2 = 0;
            while (n2 < this.updatedValues.length) {
                if (this.updatedValues[n2] != null) {
                    n = 0;
                    while (n < nArray[0]) {
                        if (nArray[n + 1] == n2) break;
                        ++n;
                    }
                    if (n == nArray[0]) {
                        return true;
                    }
                }
                ++n2;
            }
        }
        if (this.keyValues != null) {
            n2 = 0;
            while (n2 < this.keyValues.length) {
                if (this.keyValues[n2] != null && !this.keyValues[n2].isNull()) {
                    n = 0;
                    while (n < nArray[0]) {
                        if (nArray[n + 1] == n2 + 10000) break;
                        ++n;
                    }
                    if (n == nArray[0]) {
                        return true;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    private void cacheBoundColumns(int[] nArray) {
        int n;
        int n2 = 1;
        if (this.updatedValues != null) {
            n = 0;
            while (n < this.updatedValues.length) {
                if (this.updatedValues[n] != null) {
                    nArray[n2] = n;
                    ++n2;
                }
                ++n;
            }
        }
        if (this.keyValues != null) {
            n = 0;
            while (n < this.keyValues.length) {
                if (this.keyValues[n] != null && !this.keyValues[n].isNull()) {
                    nArray[n2] = n + 10000;
                    ++n2;
                }
                ++n;
            }
        }
        nArray[0] = n2 - 1;
    }

    private void commonUpdateInitialize() {
        this.keyValues = null;
        this.updatedValues = null;
    }

    public boolean fetchAtPosition(int n) throws SQLException {
        this.commonUpdateInitialize();
        return this.subImplResultSet.fetchAtPosition(n);
    }

    protected boolean next() throws SQLException {
        this.commonUpdateInitialize();
        return this.subImplResultSet.next();
    }

    protected boolean previous() throws SQLException {
        this.commonUpdateInitialize();
        return this.subImplResultSet.previous();
    }

    protected boolean absolute(int n) throws SQLException {
        this.commonUpdateInitialize();
        return this.subImplResultSet.absolute(n);
    }

    protected boolean relative(int n) throws SQLException {
        this.commonUpdateInitialize();
        return this.subImplResultSet.relative(n);
    }

    protected boolean first() throws SQLException {
        this.commonUpdateInitialize();
        return this.subImplResultSet.first();
    }

    protected boolean last() throws SQLException {
        this.commonUpdateInitialize();
        return this.subImplResultSet.last();
    }

    protected void beforeFirst() throws SQLException {
        this.commonUpdateInitialize();
        this.subImplResultSet.beforeFirst();
    }

    protected void afterLast() throws SQLException {
        this.commonUpdateInitialize();
        this.subImplResultSet.afterLast();
    }

    protected boolean isBeforeFirst() throws SQLException {
        return this.subImplResultSet.isBeforeFirst();
    }

    protected boolean isAfterLast() throws SQLException {
        return this.subImplResultSet.isAfterLast();
    }

    protected boolean isFirst() throws SQLException {
        return this.subImplResultSet.isFirst();
    }

    protected boolean isLast() throws SQLException {
        return this.subImplResultSet.isLast();
    }

    protected int getRow() throws SQLException {
        return this.subImplResultSet.getRow();
    }

    protected boolean isCursorPositionValid() throws SQLException {
        return this.subImplResultSet.isCursorPositionValid();
    }
}

