/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.informix;

import com.metamatrix.jdbc.informix.InformixImplStatement;
import com.metamatrix.jdbc.informix.sqli.InformixSQLICommunication;
import com.metamatrix.util.UtilByteOrderedDataReader;
import com.metamatrix.util.UtilByteOrderedDataWriter;
import com.metamatrix.util.UtilException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;

public class InformixLongInputStream
extends InputStream {
    private static String footprint = "$Revision:   3.1.6.0  $";
    private InformixImplStatement stmt;
    private InformixSQLICommunication comm;
    protected UtilByteOrderedDataReader reader = null;
    protected UtilByteOrderedDataWriter writer = null;
    private byte[] blobRequestData;
    private byte[] blobData;
    private boolean isFetched;
    private int totalDataSize;
    private int numBytesRead;

    InformixLongInputStream(InformixImplStatement informixImplStatement, byte[] byArray) {
        this.stmt = informixImplStatement;
        this.blobRequestData = byArray;
        this.comm = informixImplStatement.comm;
        this.reader = this.comm.getReader();
        this.writer = this.comm.getWriter();
        this.totalDataSize = 0;
        this.numBytesRead = 0;
        this.isFetched = false;
        this.blobData = null;
    }

    private void fetchLongData() throws UtilException, SQLException {
        this.isFetched = true;
        this.stmt.request.writePacket(4);
        this.writer.writeInt16(38);
        this.writer.writeBytes(this.blobRequestData, 0, this.blobRequestData.length);
        this.stmt.request.writePacket(12);
        this.writer.send();
        short s = 0;
        ArrayList<byte[]> arrayList = null;
        byte[] byArray = null;
        while (true) {
            this.reader.readInt16();
            s = this.reader.readInt16();
            if (s == 0) break;
            if (arrayList == null) {
                arrayList = new ArrayList<byte[]>();
            }
            byArray = new byte[s];
            this.reader.readBytes(byArray, 0, (int)s);
            arrayList.add(byArray);
            if (s % 2 == 1) {
                this.reader.readInt8();
            }
            this.totalDataSize += s;
        }
        this.stmt.request.processReply();
        this.blobData = new byte[this.totalDataSize];
        if (this.totalDataSize != 0) {
            int n = arrayList.size();
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                byArray = (byte[])arrayList.get(n3);
                System.arraycopy(byArray, 0, this.blobData, n2, byArray.length);
                n2 += byArray.length;
                ++n3;
            }
        }
    }

    public int read() {
        try {
            if (!this.isFetched) {
                this.fetchLongData();
            }
            if (this.numBytesRead >= this.totalDataSize) {
                return -1;
            }
            return this.blobData[this.numBytesRead++];
        }
        catch (SQLException sQLException) {
            return -1;
        }
        catch (UtilException utilException) {
            return -1;
        }
    }

    public int read(byte[] byArray, int n, int n2) {
        try {
            if (!this.isFetched) {
                this.fetchLongData();
            }
            if (this.numBytesRead >= this.totalDataSize) {
                return -1;
            }
            if (n2 > this.totalDataSize - this.numBytesRead) {
                n2 = this.totalDataSize - this.numBytesRead;
            }
            System.arraycopy(this.blobData, this.numBytesRead, byArray, n, n2);
            this.numBytesRead += n2;
            return n2;
        }
        catch (SQLException sQLException) {
            return -1;
        }
        catch (UtilException utilException) {
            return -1;
        }
    }

    public void close() {
        this.isFetched = true;
        this.numBytesRead = this.totalDataSize;
    }
}

