/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.bridges.internal.ui.wizards;

import com.metamatrix.bridges.internal.ui.util.OptionInfoPropertySourceProvider;
import com.metamatrix.bridges.internal.ui.wizards.BridgeImportWizard;
import com.metamatrix.bridges.io.BridgeImporter;
import com.metamatrix.bridges.ui.IBridgesUiConstants;
import com.metamatrix.core.util.ClassUtil;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelProjectSelectionStatusValidator;
import com.metamatrix.ui.internal.util.UiUtil;
import com.metamatrix.ui.internal.util.WidgetFactory;
import com.metamatrix.ui.internal.util.WidgetUtil;
import com.metamatrix.ui.internal.wizard.AbstractWizardPage;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

public final class BridgeModelImportPage
extends AbstractWizardPage
implements IBridgesUiConstants {
    public static final String PAGE_ID = ClassUtil.getSimpleClassName((Class)(class$com$metamatrix$bridges$internal$ui$wizards$BridgeModelImportPage == null ? (class$com$metamatrix$bridges$internal$ui$wizards$BridgeModelImportPage = BridgeModelImportPage.class$("com.metamatrix.bridges.internal.ui.wizards.BridgeModelImportPage")) : class$com$metamatrix$bridges$internal$ui$wizards$BridgeModelImportPage));
    private static final String PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$bridges$internal$ui$wizards$BridgeModelImportPage == null ? (class$com$metamatrix$bridges$internal$ui$wizards$BridgeModelImportPage = BridgeModelImportPage.class$("com.metamatrix.bridges.internal.ui.wizards.BridgeModelImportPage")) : class$com$metamatrix$bridges$internal$ui$wizards$BridgeModelImportPage));
    private static final String SOURCE_MODEL_LIST = "sourceModels";
    private static final String TARGET_LOCATION_LIST = "targetLocations";
    private Combo cbxSourceModel;
    private Combo cbxTargetLocation;
    private Text txfDatatypeModel;
    private Text txfLogicalModel;
    private Text txfPhysicalModel;
    private Text txfRelationshipsModel;
    private Button updateExisting;
    private BridgeImporter importer;
    private ViewerFilter filter = new ViewerFilter(){

        public boolean select(Viewer theViewer, Object theParent, Object theElement) {
            boolean result = false;
            if (theElement instanceof IProject && ((IProject)theElement).isOpen()) {
                result = true;
            } else if (theElement instanceof IFolder) {
                result = true;
            }
            return result;
        }
    };
    static /* synthetic */ Class class$com$metamatrix$bridges$internal$ui$wizards$BridgeModelImportPage;

    public BridgeModelImportPage(BridgeImporter theImporter) {
        super(PAGE_ID, IBridgesUiConstants.UTIL.getString(PREFIX + "title"));
        this.importer = theImporter;
        this.setPageComplete(this.importer.isValid());
        this.validate();
    }

    public void createControl(Composite theParent) {
        Object selectedObj;
        int COLUMN_COUNT = 3;
        IDialogSettings settings = this.getDialogSettings();
        WidgetUtil.removeMissingResources((IDialogSettings)settings, (String)SOURCE_MODEL_LIST);
        WidgetUtil.removeMissingProjectResources((IDialogSettings)settings, (String)TARGET_LOCATION_LIST);
        Composite pnlMain = WidgetFactory.createPanel((Composite)theParent);
        pnlMain.setLayout((Layout)new GridLayout(3, false));
        this.setControl((Control)pnlMain);
        WidgetFactory.createLabel((Composite)pnlMain, (String)IBridgesUiConstants.UTIL.getString(PREFIX + "label.sourceModel"));
        this.cbxSourceModel = WidgetFactory.createCombo((Composite)pnlMain, (int)0, (int)768, (Object[])settings.getArray(SOURCE_MODEL_LIST));
        this.cbxSourceModel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent theEvent) {
                BridgeModelImportPage.this.handleSourceModelModified();
            }
        });
        Button btnBrowse = WidgetFactory.createButton((Composite)pnlMain, (String)IBridgesUiConstants.UTIL.getString(PREFIX + "button.browse"));
        btnBrowse.setToolTipText(IBridgesUiConstants.UTIL.getString(PREFIX + "button.browse.sourceModel.tip"));
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                BridgeModelImportPage.this.handleBrowseSourceSelected();
            }
        });
        int OPTIONS_COLUMNS = 2;
        Group pnlOptions = WidgetFactory.createGroup((Composite)pnlMain, (String)IBridgesUiConstants.UTIL.getString(PREFIX + "group.importOptions"), (int)1296, (int)3, (int)OPTIONS_COLUMNS);
        Group pnlDestination = WidgetFactory.createGroup((Composite)pnlMain, (String)IBridgesUiConstants.UTIL.getString(PREFIX + "group.destinationInfo"), (int)256, (int)3, (int)3);
        Composite pnlProperties = WidgetFactory.createPanel((Composite)pnlOptions, (int)0, (int)1808, (int)OPTIONS_COLUMNS);
        PropertySheetPage page = new PropertySheetPage();
        page.setPropertySourceProvider((IPropertySourceProvider)new OptionInfoPropertySourceProvider());
        page.createControl(pnlProperties);
        page.getControl().setLayoutData((Object)new GridData(1808));
        page.selectionChanged(null, (ISelection)new StructuredSelection((Object)this.importer.getBridge()));
        WidgetFactory.createLabel((Composite)pnlDestination, (String)IBridgesUiConstants.UTIL.getString(PREFIX + "label.targetLocation"));
        Object[] cachedLocations = settings.getArray(TARGET_LOCATION_LIST);
        this.cbxTargetLocation = WidgetFactory.createCombo((Composite)pnlDestination, (int)8, (int)768, (Object[])cachedLocations);
        this.cbxTargetLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent theEvent) {
                BridgeModelImportPage.this.handleTargetLocationModified();
            }
        });
        IStructuredSelection selection = UiUtil.getStructuredSelection();
        if (selection.size() == 1 && (selectedObj = selection.getFirstElement()) != null && (selectedObj instanceof IProject || selectedObj instanceof IFolder) && ModelerCore.getModelWorkspace().findModelProject((IResource)selectedObj) != null) {
            String resourceName = ((IResource)selectedObj).getFullPath().toString();
            boolean found = false;
            if (cachedLocations != null) {
                for (int ndx = 0; ndx < cachedLocations.length; ++ndx) {
                    if (!resourceName.equals(cachedLocations[ndx])) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                ArrayList<String> newItems = cachedLocations == null ? new ArrayList<String>() : new ArrayList<Object>(Arrays.asList(cachedLocations));
                newItems.add(resourceName);
                WidgetUtil.setComboItems((Combo)this.cbxTargetLocation, newItems);
            }
            WidgetUtil.setComboText((Combo)this.cbxTargetLocation, (Object)resourceName);
        }
        btnBrowse = WidgetFactory.createButton((Composite)pnlDestination, (String)IBridgesUiConstants.UTIL.getString(PREFIX + "button.browse"), (int)128);
        btnBrowse.setToolTipText(IBridgesUiConstants.UTIL.getString(PREFIX + "button.browse.targetLocation.tip"));
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                BridgeModelImportPage.this.handleBrowseTargetSelected();
            }
        });
        WidgetFactory.createLabel((Composite)pnlDestination, (String)IBridgesUiConstants.UTIL.getString(PREFIX + "label.physicalModel"));
        this.txfPhysicalModel = WidgetFactory.createTextField((Composite)pnlDestination, (int)256, (int)2);
        this.txfPhysicalModel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent theEvent) {
                BridgeModelImportPage.this.handlePhysicalModelNameChange();
            }
        });
        WidgetFactory.createLabel((Composite)pnlDestination, (String)IBridgesUiConstants.UTIL.getString(PREFIX + "label.logicalModel"));
        this.txfLogicalModel = WidgetFactory.createTextField((Composite)pnlDestination, (int)256, (int)2);
        this.txfLogicalModel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent theEvent) {
                BridgeModelImportPage.this.handleLogicalModelNameChange();
            }
        });
        WidgetFactory.createLabel((Composite)pnlDestination, (String)IBridgesUiConstants.UTIL.getString(PREFIX + "label.relationshipsModel"));
        this.txfRelationshipsModel = WidgetFactory.createTextField((Composite)pnlDestination, (int)256, (int)2);
        this.txfRelationshipsModel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent theEvent) {
                BridgeModelImportPage.this.handleRelationshipsModelNameChange();
            }
        });
        WidgetFactory.createLabel((Composite)pnlDestination, (String)IBridgesUiConstants.UTIL.getString(PREFIX + "label.datatypeModel"));
        this.txfDatatypeModel = WidgetFactory.createTextField((Composite)pnlDestination, (int)256, (int)2);
        this.txfDatatypeModel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent theEvent) {
                BridgeModelImportPage.this.handleDatatypeModelNameChange();
            }
        });
        String buttonName = IBridgesUiConstants.UTIL.getString(PREFIX + "label.updateExisting");
        this.updateExisting = WidgetFactory.createButton((Composite)pnlDestination, (String)buttonName, (int)0, (int)2, (int)32);
        this.updateExisting.setSelection(false);
        this.updateExisting.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BridgeModelImportPage.this.handleUpdateExistingButtonChange();
            }
        });
        this.validate();
    }

    protected IDialogSettings getDialogSettings() {
        BridgeImportWizard wizard = (BridgeImportWizard)this.getWizard();
        String importerType = wizard.getImporterTypeId();
        IDialogSettings settings = super.getDialogSettings();
        settings = settings.getSection(importerType) == null ? settings.addNewSection(importerType) : settings.getSection(importerType);
        return settings;
    }

    private void handleBrowseSourceSelected() {
        String selectedModel;
        DirectoryDialog dialog;
        if (this.importer.isModelFolder()) {
            dialog = new DirectoryDialog(this.getShell());
            dialog.setText(IBridgesUiConstants.UTIL.getString(PREFIX + "sourceModelChooser.title"));
            selectedModel = dialog.open();
        } else {
            dialog = new FileDialog(this.getShell());
            dialog.setText(IBridgesUiConstants.UTIL.getString(PREFIX + "sourceModelChooser.title"));
            dialog.setFilterExtensions(this.importer.getFileExtensions());
            selectedModel = dialog.open();
        }
        if (selectedModel != null) {
            ArrayList<String> items = new ArrayList<String>(Arrays.asList(this.cbxSourceModel.getItems()));
            if (!items.contains(selectedModel)) {
                items.add(selectedModel);
                WidgetUtil.setComboItems((Combo)this.cbxSourceModel, items);
            }
            WidgetUtil.setComboText((Combo)this.cbxSourceModel, (Object)selectedModel);
        }
    }

    private void handleBrowseTargetSelected() {
        Object[] resources = WidgetUtil.showWorkspaceObjectSelectionDialog((String)IBridgesUiConstants.UTIL.getString(PREFIX + "targetLocationChooser.title"), (String)IBridgesUiConstants.UTIL.getString(PREFIX + "targetLocationChooser.message"), (boolean)false, null, (ViewerFilter)this.filter, (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        if (resources != null && resources.length > 0) {
            ArrayList<String> items;
            IResource selectedResource = (IResource)resources[0];
            String resourceName = selectedResource.toString();
            if (resourceName.indexOf("/") > -1) {
                resourceName = resourceName.substring(resourceName.indexOf("/"));
            }
            if (!(items = new ArrayList<String>(Arrays.asList(this.cbxTargetLocation.getItems()))).contains(resourceName)) {
                items.add(resourceName);
                WidgetUtil.setComboItems((Combo)this.cbxTargetLocation, items);
            }
            WidgetUtil.setComboText((Combo)this.cbxTargetLocation, (Object)resourceName);
        }
    }

    private void handleDatatypeModelNameChange() {
        this.importer.setTargetDatatypeModelName(this.txfDatatypeModel.getText());
        this.validate();
    }

    private void handleUpdateExistingButtonChange() {
        this.importer.setUpdateExisting(this.updateExisting.getSelection());
        this.validate();
    }

    private void handleLogicalModelNameChange() {
        this.importer.setTargetLogicalModelName(this.txfLogicalModel.getText());
        this.validate();
    }

    private void handlePhysicalModelNameChange() {
        this.importer.setTargetPhysicalModelName(this.txfPhysicalModel.getText());
        this.validate();
    }

    private void handleRelationshipsModelNameChange() {
        this.importer.setTargetRelationshipsModelName(this.txfRelationshipsModel.getText());
        this.validate();
    }

    private void handleSourceModelModified() {
        this.importer.setSourceModelName(this.cbxSourceModel.getText());
        String name = this.importer.getTargetPhysicalModelShortName();
        this.txfPhysicalModel.setText(name == null ? "" : name);
        name = this.importer.getTargetLogicalModelShortName();
        this.txfLogicalModel.setText(name == null ? "" : name);
        name = this.importer.getTargetRelationshipsModelShortName();
        this.txfRelationshipsModel.setText(name == null ? "" : name);
        name = this.importer.getTargetDatatypeModelShortName();
        this.txfDatatypeModel.setText(name == null ? "" : name);
        this.validate();
    }

    private void handleTargetLocationModified() {
        String wsPath = this.cbxTargetLocation.getText();
        this.importer.setTargetLocation(wsPath);
        this.validate();
    }

    public void saveSettings() {
        IDialogSettings settings = this.getDialogSettings();
        WidgetUtil.saveSettings((IDialogSettings)settings, (String)SOURCE_MODEL_LIST, (Combo)this.cbxSourceModel);
        WidgetUtil.saveSettings((IDialogSettings)settings, (String)TARGET_LOCATION_LIST, (Combo)this.cbxTargetLocation);
    }

    public boolean isPageComplete() {
        return this.importer.isValid();
    }

    private void validate() {
        this.importer.validate();
        if (this.updateExisting != null) {
            if (this.importer.updatesRequired()) {
                this.updateExisting.setEnabled(true);
            } else {
                this.updateExisting.setEnabled(false);
                if (this.updateExisting.getSelection()) {
                    this.updateExisting.setSelection(false);
                }
            }
        }
        if (this.importer.isValid()) {
            this.setErrorMessage(null);
            if (this.importer.isWarning()) {
                this.setMessage(this.importer.getMessage(), 2);
            } else {
                this.setMessage(this.importer.getMessage());
            }
        } else {
            this.setErrorMessage(this.importer.getMessage());
        }
        this.setPageComplete(this.importer.isValid());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

