/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sybase;

import com.metamatrix.jdbc.base.BaseClassUtility;
import com.metamatrix.jdbc.base.BaseImplConnection;
import com.metamatrix.jdbc.base.BaseImplStatement;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.sybase.SybaseConnection;
import com.metamatrix.jdbc.sybase.SybaseImplStatement;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSCommunication;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSExecuteRequest;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSLoginRequest;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSLogoutRequest;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSOptionCmdRequest;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSRequest;
import com.metamatrix.util.UtilByteOrderedDataReader;
import com.metamatrix.util.UtilByteOrderedDataWriter;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilSocketCreator;
import com.metamatrix.util.UtilTransliterator;
import com.metamatrix.util.UtilTransliteratorForUCS2;
import java.net.Socket;
import java.sql.SQLException;
import java.util.Properties;

public class SybaseImplConnection
extends BaseImplConnection {
    private static String footprint = "$Revision:   3.39.1.1  $";
    public SybaseConnection connection;
    SybaseTDSCommunication comm;
    public String database;
    boolean useServerSideCursor;
    int maxFieldSize;
    static final int defaultMaxFieldSize = Integer.MAX_VALUE;
    public UtilByteOrderedDataWriter writer;
    public UtilByteOrderedDataReader reader;
    public StringBuffer procedureCreationStatement;
    public boolean useAlternateProductInfo;
    public boolean useAlternateMetaData;
    public String errorBehavior;

    public SybaseImplConnection(SybaseConnection sybaseConnection) {
        this.connection = sybaseConnection;
    }

    public void open() throws SQLException {
        String string = this.connectProps.get("useAlternateMetaData");
        this.useAlternateMetaData = false;
        if (string != null && string.equalsIgnoreCase("true")) {
            this.useAlternateMetaData = true;
        }
        string = this.connectProps.get("replyBufferSize");
        int n = 0;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        string = this.connectProps.get("longDataCacheSize");
        int n2 = 0x200000;
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
                if (n2 == 0) {
                    n2 = 0x200000;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String string2 = this.connectProps.get("serverName");
        String string3 = this.connectProps.get("portNumber");
        if (string3 == null || string3.length() == 0) {
            throw this.exceptions.getException(7021);
        }
        Socket socket = null;
        Properties properties = this.connectProps.getSocketDebugProperties();
        try {
            socket = UtilSocketCreator.getSocket((String)string2, (int)Integer.parseInt(string3), (Properties)properties);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{exception.getMessage()};
            throw this.exceptions.getException(6001, stringArray, "08001");
        }
        this.comm = new SybaseTDSCommunication(socket, n, n2, properties != null, this.exceptions, this.connection);
        this.writer = this.comm.getWriter();
        this.reader = this.comm.createReader();
        String string4 = this.connectProps.get("user");
        String string5 = this.connectProps.get("password");
        SybaseTDSLoginRequest sybaseTDSLoginRequest = new SybaseTDSLoginRequest(this.comm, this.reader, this.writer, string4, string5);
        sybaseTDSLoginRequest.submitRequest();
        sybaseTDSLoginRequest.processReply(this.warnings);
        this.connection.setServerVersion(sybaseTDSLoginRequest.majorServerVersion, sybaseTDSLoginRequest.minorServerVersion);
        this.connection.supportsDateAndTimeTypes = sybaseTDSLoginRequest.getCapabilitiesBit(71, true);
        this.connection.supportsUniCharTypes = sybaseTDSLoginRequest.getCapabilitiesBit(66, true);
        if ((double)this.connection.getServerVersion() > 12.0 && this.connection.getPageSize() == 0) {
            this.determineAndSetPageSize();
        }
        SybaseTDSOptionCmdRequest sybaseTDSOptionCmdRequest = new SybaseTDSOptionCmdRequest(this.comm, this.reader, this.writer);
        sybaseTDSOptionCmdRequest.setOption((byte)35, Boolean.TRUE, this.warnings);
        this.quotingChar = (char)39;
        sybaseTDSOptionCmdRequest.setOption((byte)34, Boolean.TRUE, this.warnings);
        sybaseTDSOptionCmdRequest.setOption((byte)26, Boolean.FALSE, this.warnings);
        String string6 = this.connectProps.get("databaseName");
        this.database = sybaseTDSLoginRequest.getDatabase();
        if (string6 != null && string6.length() > 0 && !string6.equals(this.database)) {
            this.executeSQL("use " + string6);
            this.database = string6;
        }
        this.comm.supportsWideTables = sybaseTDSLoginRequest.getCapabilitiesBit(59, true);
        String string7 = this.connectProps.get("codePageOverride");
        this.setupTransliteration(this.warnings, string7);
        this.maxFieldSize = Integer.MAX_VALUE;
        this.executeSQL("set textsize " + this.maxFieldSize);
        String string8 = this.connectProps.get("selectMethod");
        this.useServerSideCursor = string8.equalsIgnoreCase("cursor");
        this.useAlternateProductInfo = BaseClassUtility.isBrandedSunDriver() ? true : new Boolean(this.connectProps.get("useAlternateProductInfo"));
        this.errorBehavior = this.connectProps.get("errorBehavior");
    }

    public void setupTransliteration(BaseWarnings baseWarnings, String string) throws SQLException {
        if (this.connection.serverDefaultCharSet == null) {
            String string2 = "select name as DEFAULT_CHARSET from master.dbo.syscharsets where ((select value from master.dbo.sysconfigures where config=131) =  master.dbo.syscharsets.id)";
            SybaseTDSExecuteRequest sybaseTDSExecuteRequest = new SybaseTDSExecuteRequest(this.comm, this.reader, this.writer, string2);
            sybaseTDSExecuteRequest.submitRequest();
            sybaseTDSExecuteRequest.setProcessMode(1);
            sybaseTDSExecuteRequest.processReply(baseWarnings);
            if (sybaseTDSExecuteRequest.getRow(null)) {
                this.connection.serverDefaultCharSet = (String)sybaseTDSExecuteRequest.getColumnData(1, 10);
            }
            sybaseTDSExecuteRequest.discardReplyBytes();
        }
        try {
            this.comm.transliteratorForDefaultCharset = UtilTransliterator.GetNewTransliterator((String)this.connection.serverDefaultCharSet);
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException), "08001");
        }
        if (string == null || string.length() == 0) {
            this.comm.transliteratorForCharData = this.comm.transliteratorForDefaultCharset;
        } else {
            try {
                this.comm.transliteratorForCharData = UtilTransliterator.GetNewTransliterator((String)string);
            }
            catch (UtilException utilException) {
                throw this.comm.exceptions.getException((Exception)((Object)utilException), "08001");
            }
        }
        this.reader.setTransliterator(this.comm.transliteratorForDefaultCharset);
        this.writer.setTransliterator(this.comm.transliteratorForDefaultCharset);
        this.comm.ucs2Transliterator = new UtilTransliteratorForUCS2();
    }

    public void close() throws SQLException {
        SybaseTDSLogoutRequest sybaseTDSLogoutRequest = new SybaseTDSLogoutRequest(this.comm, this.reader, this.writer);
        sybaseTDSLogoutRequest.submitRequest();
        try {
            this.comm.close();
        }
        catch (Exception exception) {
            throw this.exceptions.getException(7001);
        }
    }

    protected BaseImplStatement createImplStatement(int n, int n2) throws SQLException {
        return new SybaseImplStatement(this.comm, n, n2, this.exceptions);
    }

    public boolean supportsQueryTimeout() {
        return false;
    }

    public Socket getQueryTimeoutSocket() {
        return this.comm.getSocket();
    }

    public boolean supportsCancel() {
        return true;
    }

    public int getEmptyRowInsertSyntax() {
        return 2;
    }

    protected void startManualTransactionMode() throws SQLException {
        this.executeSQL("begin transaction");
    }

    protected void commitTransaction() throws SQLException {
        this.executeSQL("commit transaction begin transaction");
    }

    protected void rollbackTransaction() throws SQLException {
        this.executeSQL("rollback transaction begin transaction");
    }

    protected void stopManualTransactionMode() throws SQLException {
        this.executeSQL("commit transaction");
    }

    protected void setSavepoint(String string) throws SQLException {
        this.executeSQL("save transaction " + string);
    }

    protected void rollbackTransaction(String string) throws SQLException {
        this.executeSQL("rollback transaction " + string);
    }

    protected String getCatalog() throws SQLException {
        return this.database;
    }

    protected void determineAndSetPageSize() {
        try {
            SybaseTDSExecuteRequest sybaseTDSExecuteRequest = new SybaseTDSExecuteRequest(this.comm, this.reader, this.writer, "select @@maxpagesize");
            sybaseTDSExecuteRequest.submitRequest();
            sybaseTDSExecuteRequest.setProcessMode(1);
            sybaseTDSExecuteRequest.processReply(this.warnings);
            if (sybaseTDSExecuteRequest.getRow(null)) {
                Integer n = (Integer)sybaseTDSExecuteRequest.getColumnData(1, 4);
                this.connection.setPageSize(n);
            }
            sybaseTDSExecuteRequest.discardReplyBytes();
        }
        catch (Exception exception) {}
    }

    protected void setCatalog(String string) throws SQLException {
        this.executeSQL("use " + string);
    }

    protected int getTransactionIsolation() throws SQLException {
        return 2;
    }

    protected void setTransactionIsolation(int n) throws SQLException {
        String string = new String("set transaction isolation level ");
        switch (n) {
            case 1: {
                string = string + "read uncommitted";
                break;
            }
            case 2: {
                string = string + "read committed";
                break;
            }
            case 4: {
                string = string + "repeatable read";
                break;
            }
            case 8: {
                string = string + "serializable";
            }
        }
        this.executeSQL(string);
    }

    protected boolean supportsRowId() {
        return true;
    }

    protected boolean enableXlobOnLongVarX() {
        return true;
    }

    protected String[] getAggregateFunctions() {
        String[] stringArray = new String[]{"avg", "count", "max", "min", "sum"};
        return stringArray;
    }

    SybaseTDSRequest executeSQL(String string) throws SQLException {
        return this.executeSQL(string, this.warnings);
    }

    SybaseTDSRequest executeSQL(String string, BaseWarnings baseWarnings) throws SQLException {
        SybaseTDSExecuteRequest sybaseTDSExecuteRequest = new SybaseTDSExecuteRequest(this.comm, this.reader, this.writer, string);
        sybaseTDSExecuteRequest.submitRequest();
        sybaseTDSExecuteRequest.processReply((short)2, baseWarnings);
        return sybaseTDSExecuteRequest;
    }

    protected String setClientApplicationName(String string) throws SQLException {
        if (string.length() > 30) {
            string = string.substring(0, 30);
        }
        if ((double)this.connection.getServerVersion() >= 12.0) {
            this.executeSQL("set clientapplname '" + string + "'", this.warnings);
        }
        return string;
    }

    protected String setClientHostName(String string) throws SQLException {
        if (string.length() > 30) {
            string = string.substring(0, 30);
        }
        if ((double)this.connection.getServerVersion() >= 12.0) {
            this.executeSQL("set clienthostname '" + string + "'", this.warnings);
        }
        return string;
    }

    protected String setClientUser(String string) throws SQLException {
        if (string.length() > 30) {
            string = string.substring(0, 30);
        }
        if ((double)this.connection.getServerVersion() >= 12.0) {
            this.executeSQL("set clientname '" + string + "'", this.warnings);
        }
        return string;
    }
}

