/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.net8;

import com.metamatrix.jdbc.oracle.OracleImplConnection;
import com.metamatrix.jdbc.oracle.net8.OracleDataConsumer;
import com.metamatrix.jdbc.oracle.net8.OracleDataProvider;
import com.metamatrix.jdbc.oracle.net8.TTIDataPacket;
import com.metamatrix.util.UtilException;
import java.sql.SQLException;

public class TTIOERDataPacket
extends TTIDataPacket {
    private static String footprint = "$Revision:   3.11.1.0  $";
    private static final char[] map = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    public int curRowNumber = 0;
    public short retCode = 0;
    public short arrayElemWError = 0;
    public short arrayElemErrNo = 0;
    public short currCursID = 0;
    public short errorPosition = 0;
    public byte sqlType = 0;
    public byte oerFatal = 0;
    public short flags = 0;
    public short userCursorOpt = 0;
    public byte upiParam = 0;
    public byte warningFlag = 0;
    public int rid_ti5_rba = 0;
    public short rid_ti5_partionID = 0;
    public byte rid_tableID = 0;
    public int rid_blockNumber = 0;
    public short rid_slotNumber = 0;
    public int osError = 0;
    public byte stmtNumber = 0;
    public byte callNumber = 0;
    public short pad1 = 0;
    public int successIters = 0;
    public String errMsg;
    String EOFerrMsg = null;
    private OracleImplConnection implConn;
    public boolean isSelect = false;

    public TTIOERDataPacket(OracleImplConnection oracleImplConnection) {
        this.TTCCode = 4;
        this.implConn = oracleImplConnection;
    }

    public short getCursorID() {
        return this.currCursID;
    }

    public void streamOut(OracleDataConsumer oracleDataConsumer) throws UtilException {
    }

    public void streamIn(OracleDataProvider oracleDataProvider) throws UtilException, SQLException {
        if (this.implConn.oracleServerVersion >= 1000000000L) {
            oracleDataProvider.readB4();
        }
        this.curRowNumber = oracleDataProvider.readB4();
        this.retCode = oracleDataProvider.readB2();
        this.arrayElemWError = oracleDataProvider.readB2();
        this.arrayElemErrNo = oracleDataProvider.readB2();
        this.currCursID = oracleDataProvider.readB2();
        this.errorPosition = oracleDataProvider.readB2();
        this.sqlType = oracleDataProvider.readByte();
        this.oerFatal = oracleDataProvider.readByte();
        this.flags = oracleDataProvider.readB2();
        this.userCursorOpt = oracleDataProvider.readB2();
        this.upiParam = oracleDataProvider.readByte();
        this.warningFlag = oracleDataProvider.readByte();
        this.rid_ti5_rba = oracleDataProvider.readB4();
        this.rid_ti5_partionID = oracleDataProvider.readB2();
        this.rid_tableID = oracleDataProvider.readByte();
        this.rid_blockNumber = oracleDataProvider.readB4();
        this.rid_slotNumber = oracleDataProvider.readB2();
        this.osError = oracleDataProvider.readB4();
        this.stmtNumber = oracleDataProvider.readByte();
        this.callNumber = oracleDataProvider.readByte();
        this.pad1 = oracleDataProvider.readB2();
        this.successIters = oracleDataProvider.readB4();
        if (this.retCode != 0) {
            if (this.retCode == 1403) {
                if (this.EOFerrMsg == null || !this.isSelect) {
                    byte[] byArray = oracleDataProvider.readCLR(1024);
                    this.EOFerrMsg = oracleDataProvider.getTransliterator().decode(byArray, 0, byArray.length);
                } else {
                    oracleDataProvider.skipCLR();
                }
                this.errMsg = this.EOFerrMsg;
                return;
            }
            byte[] byArray = oracleDataProvider.readCLR(1024);
            this.errMsg = oracleDataProvider.getTransliterator().decode(byArray, 0, byArray.length);
        }
    }

    public String getRowIdString() {
        char[] cArray = new char[]{map[this.rid_ti5_rba >> 30 & 0x3F], map[this.rid_ti5_rba >> 24 & 0x3F], map[this.rid_ti5_rba >> 18 & 0x3F], map[this.rid_ti5_rba >> 12 & 0x3F], map[this.rid_ti5_rba >> 6 & 0x3F], map[this.rid_ti5_rba & 0x3F], map[this.rid_ti5_partionID >> 12 & 0x3F], map[this.rid_ti5_partionID >> 6 & 0x3F], map[this.rid_ti5_partionID & 0x3F], map[this.rid_blockNumber >> 30 & 0x3F], map[this.rid_blockNumber >> 24 & 0x3F], map[this.rid_blockNumber >> 18 & 0x3F], map[this.rid_blockNumber >> 12 & 0x3F], map[this.rid_blockNumber >> 6 & 0x3F], map[this.rid_blockNumber & 0x3F], map[this.rid_slotNumber >> 12 & 0x3F], map[this.rid_slotNumber >> 6 & 0x3F], map[this.rid_slotNumber & 0x3F]};
        return new String(cArray);
    }

    public String getSQLState() {
        String string = "HY000";
        switch (this.retCode) {
            case 1: 
            case 1400: 
            case 2291: {
                string = "23000";
                break;
            }
            case 256: {
                string = "HYC00";
                break;
            }
            case 900: 
            case 903: 
            case 911: {
                string = "42000";
                break;
            }
            case 904: {
                string = "42S22";
                break;
            }
            case 913: 
            case 947: {
                string = "21S01";
                break;
            }
            case 942: {
                string = "42S02";
                break;
            }
            case 955: {
                string = "42S01";
                break;
            }
            case 1002: {
                string = "HY010";
                break;
            }
            case 1008: {
                string = "07S01";
                break;
            }
            case 604: 
            case 1013: {
                string = "HY008";
                break;
            }
            case 1017: {
                string = "28000";
                break;
            }
            case 1033: 
            case 1034: 
            case 1035: 
            case 1089: 
            case 1090: {
                string = "08001";
                break;
            }
            case 1418: {
                string = "42S12";
                break;
            }
            case 1426: 
            case 1438: {
                string = "22003";
                break;
            }
            case 1430: {
                string = "42S21";
                break;
            }
            case 1476: {
                string = "22012";
                break;
            }
            case 1465: 
            case 1722: {
                string = "22018";
                break;
            }
            case 1730: {
                string = "21S02";
                break;
            }
            default: {
                string = "HY000";
            }
        }
        return string;
    }
}

