/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle;

import com.metamatrix.jdbc.base.BaseCharacterStreamWrapper;
import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseColumns;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseImplBlob;
import com.metamatrix.jdbc.base.BaseImplClob;
import com.metamatrix.jdbc.base.BaseImplResultSet;
import com.metamatrix.jdbc.base.BaseImplResultSetAutoGeneratedKeys;
import com.metamatrix.jdbc.base.BaseImplStatement;
import com.metamatrix.jdbc.base.BaseInputStreamWrapper;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.base.BaseSQL;
import com.metamatrix.jdbc.base.BaseTimestamp;
import com.metamatrix.jdbc.oracle.OracleColumn;
import com.metamatrix.jdbc.oracle.OracleImplBlob;
import com.metamatrix.jdbc.oracle.OracleImplClob;
import com.metamatrix.jdbc.oracle.OracleImplConnection;
import com.metamatrix.jdbc.oracle.OracleImplResultset;
import com.metamatrix.jdbc.oracle.OracleInternalParameter;
import com.metamatrix.jdbc.oracle.OracleInternalParameterSet;
import com.metamatrix.jdbc.oracle.OracleVNU;
import com.metamatrix.jdbc.oracle.net8.OracleDataConsumer;
import com.metamatrix.jdbc.oracle.net8.OracleDataProvider;
import com.metamatrix.jdbc.oracle.net8.OracleNet8Communication;
import com.metamatrix.jdbc.oracle.net8.OracleNet8NSPTDAPacket;
import com.metamatrix.jdbc.oracle.net8.TTIDCBDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIFUNDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OALL7;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OALL8;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OALL_BASE;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OCANCEL;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OCLOSE;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_ODNY;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OLOBOPS;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OOPEN;
import com.metamatrix.jdbc.oracle.net8.TTIIOVDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIOERDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIRXDDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIRXHDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTISCVDataPacket;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilVectorUnsynced;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;

public class OracleImplStatement
extends BaseImplStatement {
    private static String footprint = "$Revision:   3.91.1.16  $";
    public OracleNet8Communication comm;
    public SQLException myException;
    public OracleImplConnection implConn;
    private short m_cursorID;
    private boolean isFirstExecute;
    private short currentCursorId;
    private int currentRefCursorPos;
    int CurrentResultsetIndex;
    private int rowsAffected;
    private int currentResult;
    private int[] lastBatchAffectedRowcounts = null;
    private boolean executeAsNativeBatch;
    private int SQLStmtType;
    private TTIFUN_OALL_BASE m_ttifunall;
    private TTIFUN_OALL7 m_OAll7;
    private TTIFUN_OALL8 m_OAll8;
    private TTISCVDataPacket sentColumnsVector = new TTISCVDataPacket();
    BaseParameters savedProcParams = null;
    boolean stmtContainsWhereClause = false;
    private boolean[] lastRowReturnedByDatabase;
    private boolean defineIsRequired = true;
    private int[] rowsInBuffer;
    private int[] currentRowInBuffer;
    private int resultSetType;
    private int resultSetConcurrency;
    private boolean[] CursorVarsDefined;
    private boolean[] AllRowsFetched;
    private TTIOERDataPacket gTTIoer;
    private int arrayfetchsize = 0;
    private TTIFUN_OALL_BASE[] oAllFetch;
    private TTIRXHDataPacket fetchheader;
    private TTIRXDDataPacket[] fetchrows;
    private int FetchcolCount;
    private boolean isPreparedPreparedStatement = false;
    public BaseColumn[][] CurrentRSDescriptions;
    public int[] m_numRowsToFetch;
    private String lastExecutedSQL;
    private String rememberedNativeSQL = null;
    int TotalNrResultsets;
    private BaseParameters bParams;
    private static byte[] nullValue = new byte[0];
    private static final int SQLTYPE_REF_CURSOR = -999;
    private int[] RememberedColumnTypes;
    private String[] RememberedColumnNames;
    BaseColumns autogencolsdescription = null;
    BaseData[][] autogeneratedKeyArray = null;
    protected OracleNet8NSPTDAPacket NSPTDAPacket;
    protected OracleNet8NSPTDAPacket[] bufferedNSPTDAPackets;
    private byte[][] tempLOBLocatorCollection = null;
    private int numTempLOBs = 0;
    private OracleInternalParameterSet[] m_internalParamSets = null;
    private OracleInternalParameterSet m_orgParamBindInfo = null;
    private OracleInternalParameterSet m_requiredParamBindInfo = null;
    private int actualNumStoredProcParams = -1;
    private boolean isSelect;
    private boolean isUpdate;
    private boolean isStatementSuitableForReexecution;
    private TTIRXDDataPacket TTIRXDDataPacketForParams;
    private TTIFUN_OCANCEL reusablettifuncancel;
    byte[][][] cachedRows = null;
    int[][] cachedLens = null;

    public int getActualNumStoredProcParams() {
        if (this.actualNumStoredProcParams == -1) {
            this.actualNumStoredProcParams = 0;
            if (this.bParams != null) {
                int n = 1;
                while (n <= this.bParams.count()) {
                    try {
                        if (this.bParams.parametersIn[n - 1] != null || this.bParams.parametersOut[n - 1] != null) {
                            ++this.actualNumStoredProcParams;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++n;
                }
            }
        }
        return this.actualNumStoredProcParams;
    }

    public OracleImplStatement(int n, int n2, OracleNet8Communication oracleNet8Communication, OracleImplConnection oracleImplConnection) throws SQLException {
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        this.isPreparedPreparedStatement = false;
        this.comm = oracleNet8Communication;
        this.implConn = oracleImplConnection;
        this.CursorVarsDefined = new boolean[1];
        this.CursorVarsDefined[0] = false;
        this.AllRowsFetched = new boolean[1];
        this.AllRowsFetched[0] = false;
        this.currentRefCursorPos = 0;
        this.CurrentResultsetIndex = 0;
        this.TotalNrResultsets = 0;
        this.bufferedNSPTDAPackets = new OracleNet8NSPTDAPacket[1];
        this.bufferedNSPTDAPackets[0] = new OracleNet8NSPTDAPacket(this.comm, true);
        this.fetchrows = new TTIRXDDataPacket[1];
        this.bParams = null;
        this.NSPTDAPacket = new OracleNet8NSPTDAPacket(this.comm, false);
        this.gTTIoer = new TTIOERDataPacket(this.implConn);
        this.m_ttifunall = null;
        this.TTIRXDDataPacketForParams = null;
        this.m_OAll8 = new TTIFUN_OALL8(this.implConn);
        if (this.implConn.useOAll7) {
            this.oAllFetch = new TTIFUN_OALL7[1];
            this.m_OAll7 = new TTIFUN_OALL7(this.implConn);
            this.m_ttifunall = this.m_OAll7;
        } else {
            this.oAllFetch = new TTIFUN_OALL8[1];
            this.m_ttifunall = this.m_OAll8;
        }
        this.m_cursorID = 0;
    }

    public void processCancelResponse() throws SQLException {
        try {
            OracleDataProvider oracleDataProvider = this.NSPTDAPacket.reader;
            oracleDataProvider.receive();
            if (oracleDataProvider.getNSPacketType() != 12) {
                oracleDataProvider.readByte();
                oracleDataProvider.readByte();
                this.processReply(this.m_ttifunall);
                oracleDataProvider.receivePacket();
            }
            this.NSPTDAPacket.CheckAndProcessMarkerPacket(new OracleDataConsumer(this.comm));
            this.NSPTDAPacket.receiveReply();
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public BaseColumns describeAutoGeneratedKeyColumns() throws SQLException {
        if (this.autogencolsdescription == null) {
            OracleColumn oracleColumn = new OracleColumn(104, "ROWID", 18, 18, 0, 0, 0, 0, this.implConn, this.comm.transliterator);
            this.autogencolsdescription = new BaseColumns();
            this.autogencolsdescription.add((BaseColumn)oracleColumn);
        }
        return this.autogencolsdescription;
    }

    public BaseImplResultSet getAutoGeneratedKeyResultSet() throws SQLException {
        if (this.autogeneratedKeyArray == null) {
            this.autogeneratedKeyArray = new BaseData[1][1];
            this.autogeneratedKeyArray[0][0] = new BaseData((Object)this.gTTIoer.getRowIdString(), (BaseConnection)this.implConn.connection);
        } else {
            this.autogeneratedKeyArray[0][0].setString(this.gTTIoer.getRowIdString());
        }
        return new BaseImplResultSetAutoGeneratedKeys(this.autogeneratedKeyArray);
    }

    public void reset() throws SQLException {
        if (!this.isStatementSuitableForReexecution) {
            this.isPreparedPreparedStatement = false;
        }
    }

    public void setSQL(BaseSQL baseSQL) {
        super.setSQL(baseSQL);
        this.isPreparedPreparedStatement = false;
        this.rememberedNativeSQL = null;
        this.defineIsRequired = this.implConn.useOAll7;
        this.stmtContainsWhereClause = baseSQL.hasWhereClause();
        this.isFirstExecute = true;
        this.SQLStmtType = baseSQL.getType();
        String string = baseSQL.getVerb();
        this.isSelect = this.SQLStmtType == 1 || string.equalsIgnoreCase("WITH");
        this.isStatementSuitableForReexecution = this.SQLStmtType == 4 || this.SQLStmtType == 5 || this.SQLStmtType == 6 || this.isSelect;
        if (string.equalsIgnoreCase("ALTER")) {
            this.implConn.alterStatementHasBeenIssued = true;
        }
        this.isUpdate = baseSQL.getFormatted().toUpperCase().trim().endsWith("UPDATE");
    }

    public String getRowIdColumnName() {
        return "ROWID";
    }

    private OracleImplBlob createTempBlob(BaseParameter baseParameter, byte[] byArray) throws SQLException {
        OracleImplBlob oracleImplBlob = new OracleImplBlob(this, baseParameter, byArray);
        this.tempLOBLocatorCollection[this.numTempLOBs++] = oracleImplBlob.bloblocator;
        return oracleImplBlob;
    }

    private OracleImplClob createTempClob(BaseParameter baseParameter, int n, boolean bl, String string) throws SQLException {
        OracleImplClob oracleImplClob = new OracleImplClob(this, baseParameter, n, bl, string);
        this.tempLOBLocatorCollection[this.numTempLOBs++] = oracleImplClob.cloblocator;
        return oracleImplClob;
    }

    public void cancel() throws SQLException {
        try {
            this.bufferedNSPTDAPackets[0].SendBreakMarkerPacket();
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    private int processBufferedReply(TTIFUNDataPacket tTIFUNDataPacket, int n) throws SQLException {
        boolean bl = false;
        block9: while (!bl) {
            int n2 = this.bufferedNSPTDAPackets[n].getNextTTCCode();
            switch (n2) {
                case 9: {
                    if (this.implConn.oracleServerVersion >= 1000000000L) {
                        try {
                            int n3 = this.bufferedNSPTDAPackets[n].reader.readB4();
                        }
                        catch (UtilException utilException) {
                            throw this.implConn.exceptions.getException(7002, "08001");
                        }
                    }
                }
                case -1: {
                    bl = true;
                    break;
                }
                case 4: {
                    this.bufferedNSPTDAPackets[n].getNextNextTTISubpacket(this.gTTIoer);
                    bl = true;
                    break;
                }
                case 8: {
                    this.bufferedNSPTDAPackets[n].getNextNextTTISubpacket(tTIFUNDataPacket);
                    if (tTIFUNDataPacket != this.m_ttifunall) continue block9;
                    this.m_cursorID = this.m_ttifunall.getCursorID();
                    break;
                }
                case 6: 
                case 7: 
                case 16: 
                case 21: {
                    return n2;
                }
                default: {
                    throw this.implConn.exceptions.getException(7002, "08001");
                }
            }
        }
        return 0;
    }

    private int processReply(TTIFUNDataPacket tTIFUNDataPacket) throws SQLException {
        boolean bl = false;
        block10: while (!bl) {
            int n = this.NSPTDAPacket.getNextTTCCode();
            switch (n) {
                case 9: {
                    if (this.implConn.oracleServerVersion >= 1000000000L) {
                        try {
                            int n2 = this.NSPTDAPacket.reader.readB4();
                        }
                        catch (UtilException utilException) {
                            throw this.implConn.exceptions.getException(7002, "08001");
                        }
                    }
                }
                case -1: {
                    bl = true;
                    break;
                }
                case 4: {
                    this.NSPTDAPacket.getNextNextTTISubpacket(this.gTTIoer);
                    bl = true;
                    break;
                }
                case 8: {
                    this.NSPTDAPacket.getNextNextTTISubpacket(tTIFUNDataPacket);
                    if (tTIFUNDataPacket != this.m_ttifunall) continue block10;
                    this.m_cursorID = this.m_ttifunall.getCursorID();
                    break;
                }
                case 11: {
                    TTIIOVDataPacket tTIIOVDataPacket = new TTIIOVDataPacket();
                    this.NSPTDAPacket.getNextNextTTISubpacket(tTIIOVDataPacket);
                    break;
                }
                case 6: 
                case 7: 
                case 16: 
                case 21: {
                    return n;
                }
                default: {
                    throw this.implConn.exceptions.getException(7002, "08001");
                }
            }
        }
        return 0;
    }

    public int[] getBatchRowsAffectedCount() {
        if (this.lastBatchAffectedRowcounts == null) {
            return new int[0];
        }
        return this.lastBatchAffectedRowcounts;
    }

    public BaseImplResultSet getNextResultSet() throws SQLException {
        OracleImplResultset oracleImplResultset = new OracleImplResultset(this.implConn.connection);
        oracleImplResultset.initialize(this.currentCursorId, this.CurrentResultsetIndex);
        return oracleImplResultset;
    }

    public void setupNextResultSet(BaseImplResultSet baseImplResultSet) throws SQLException {
        ((OracleImplResultset)baseImplResultSet).initialize(this.currentCursorId, this.CurrentResultsetIndex);
    }

    public int getNextResultType() throws SQLException {
        int n = this.currentResult;
        this.currentResult = 1;
        if (this.currentRefCursorPos >= 0 && this.bParams != null) {
            int n2 = this.currentRefCursorPos + 1;
            int n3 = this.currentRefCursorPos;
            while (n2 <= this.bParams.count() && this.currentRefCursorPos == n3) {
                BaseParameter baseParameter = this.bParams.parametersOut[n2 - 1];
                if (baseParameter != null && baseParameter.sqlType == -999) {
                    n = 2;
                    ++this.CurrentResultsetIndex;
                    BaseColumn[] baseColumnArray = null;
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < this.m_internalParamSets[0].getNumParams()) {
                        OracleInternalParameter oracleInternalParameter = this.m_internalParamSets[0].paramSet[n5];
                        if ((oracleInternalParameter.m_direction & 0x10) != 0 && oracleInternalParameter.m_nativeBindType == 102) {
                            if (n4 == this.CurrentResultsetIndex) {
                                baseColumnArray = oracleInternalParameter.m_columnDescriptions;
                                break;
                            }
                            ++n4;
                        }
                        ++n5;
                    }
                    this.CurrentRSDescriptions[this.CurrentResultsetIndex] = baseColumnArray;
                    this.CursorVarsDefined[this.CurrentResultsetIndex] = false;
                    this.AllRowsFetched[this.CurrentResultsetIndex] = false;
                    this.rowsInBuffer[this.CurrentResultsetIndex] = 0;
                    this.m_numRowsToFetch[this.CurrentResultsetIndex] = 0;
                    this.rowsAffected = 0;
                    this.currentRefCursorPos = n2;
                    this.currentCursorId = baseParameter.getShort(this.comm.exceptions);
                    if (!this.implConn.useOAll7) {
                        this.sentColumnsVector.setNumColumns(baseColumnArray.length);
                    }
                }
                ++n2;
            }
        }
        if (n == 1) {
            this.CursorVarsDefined[0] = false;
            this.AllRowsFetched[0] = false;
        }
        return n;
    }

    private Integer convertNativeTypeNameToNativeDataType(String string) {
        if (string.equalsIgnoreCase("CLOB")) {
            return new Integer(112);
        }
        if (string.equalsIgnoreCase("BLOB")) {
            return new Integer(113);
        }
        if (string.equalsIgnoreCase("LONG")) {
            return new Integer(8);
        }
        if (string.equalsIgnoreCase("LONG RAW")) {
            return new Integer(24);
        }
        return new Integer(1);
    }

    private BaseParameters getRealProcParams(String string, String string2, String string3, String string4, BaseParameters baseParameters, boolean[] blArray, boolean[] blArray2) {
        BaseParameters baseParameters2;
        block74: {
            String string5;
            Hashtable hashtable;
            int[] nArray;
            if (!this.implConn.refCursorSupport) {
                return baseParameters;
            }
            if (this.implConn.procParamInfoHashtable == null) {
                this.implConn.procParamInfoHashtable = new Hashtable();
            }
            boolean bl = (nArray = (int[])(hashtable = this.implConn.procParamInfoHashtable).get(string5 = string3 + "." + string2 + "." + string4)) == null;
            baseParameters2 = null;
            String string6 = null;
            if (bl) {
                if (string == null) {
                    string6 = "SELECT UNIQUE POSITION, DATA_TYPE, IN_OUT, OVERLOAD FROM SYS.ALL_ARGUMENTS WHERE DATA_LEVEL=0 ";
                    if (string3 != null) {
                        string6 = string6 + "AND PACKAGE_NAME = '" + string3 + "' ";
                    }
                    if (string2 != null) {
                        string6 = string6 + "AND OWNER = '" + string2 + "' ";
                    }
                    string6 = string6 + " AND OBJECT_NAME = '" + string4 + "' ORDER BY POSITION DESC";
                } else {
                    string6 = "SELECT UNIQUE POSITION, DATA_TYPE, IN_OUT, OVERLOAD FROM SYS.ALL_ARGUMENTS WHERE OBJECT_ID = " + string + " AND OBJECT_NAME = '" + string4 + "' AND DATA_LEVEL=0 ORDER BY POSITION DESC";
                }
                if (this.NSPTDAPacket == null) {
                    this.NSPTDAPacket = new OracleNet8NSPTDAPacket(this.comm);
                }
            }
            try {
                int n;
                int n2;
                boolean bl2;
                int n3;
                OracleColumn oracleColumn = null;
                OracleColumn oracleColumn2 = null;
                OracleColumn oracleColumn3 = null;
                OracleColumn oracleColumn4 = null;
                BaseColumn[] baseColumnArray = null;
                TTIRXDDataPacket tTIRXDDataPacket = null;
                if (bl) {
                    TTIFUN_OALL8 tTIFUN_OALL8 = new TTIFUN_OALL8(this.implConn);
                    tTIFUN_OALL8.setOptions(32865);
                    tTIFUN_OALL8.setCommandText(string6);
                    tTIFUN_OALL8.setParameters(null);
                    tTIFUN_OALL8.setCursorID(this.implConn.getCursorID());
                    tTIFUN_OALL8.setArraySize(1000);
                    tTIFUN_OALL8.setIsSelect(true);
                    this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OALL8);
                    this.NSPTDAPacket.sendRequest();
                    this.NSPTDAPacket.receiveReply();
                    n3 = this.implConn.processReply(tTIFUN_OALL8);
                    if (n3 != 16) {
                        return baseParameters;
                    }
                    TTIDCBDataPacket tTIDCBDataPacket = new TTIDCBDataPacket(this.implConn);
                    this.NSPTDAPacket.getNextNextTTISubpacket(tTIDCBDataPacket);
                    baseColumnArray = tTIDCBDataPacket.getColumns();
                    n3 = this.implConn.processReply(tTIFUN_OALL8);
                    if (n3 != 6) {
                        return baseParameters;
                    }
                    if (this.fetchheader == null) {
                        this.fetchheader = new TTIRXHDataPacket();
                    }
                    this.NSPTDAPacket.getNextNextTTISubpacket(this.fetchheader);
                    oracleColumn = (OracleColumn)baseColumnArray[0];
                    oracleColumn2 = (OracleColumn)baseColumnArray[1];
                    oracleColumn3 = (OracleColumn)baseColumnArray[2];
                    oracleColumn4 = (OracleColumn)baseColumnArray[3];
                    tTIRXDDataPacket = new TTIRXDDataPacket(baseColumnArray, this.implConn, false);
                }
                int n4 = baseParameters == null ? 0 : baseParameters.count();
                n3 = 0;
                int n5 = 0;
                UtilVectorUnsynced utilVectorUnsynced = null;
                int n6 = 0;
                int n7 = 0;
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                if (bl) {
                    bl2 = this.implConn.processReply(this.oAllFetch[0]) == 7;
                } else {
                    n7 = n6 = nArray.length;
                    bl2 = n6 > 0;
                }
                this.TotalNrResultsets = 0;
                byte[] byArray = null;
                while (bl2) {
                    int n8;
                    UtilVectorUnsynced utilVectorUnsynced2;
                    int n9;
                    boolean bl3;
                    String string7;
                    boolean bl4;
                    n2 = 0;
                    if (bl) {
                        tTIRXDDataPacket.m_sentMask = byArray;
                        this.NSPTDAPacket.getNextNextTTISubpacket(tTIRXDDataPacket);
                        String string8 = this.comm.transliterator.decode(oracleColumn4.data, 0, oracleColumn4.data.length);
                        if (string8 != null && string8.length() > 0) {
                            return baseParameters;
                        }
                        n6 = (int)OracleVNU.convertVNUToLong(oracleColumn.data, oracleColumn.data.length, this.comm.exceptions);
                        n7 = n6++;
                        if (blArray[0]) {
                            ++n7;
                        }
                        if (nArray == null) {
                            nArray = new int[n6 > 0 ? n6 : 1];
                        }
                        boolean bl5 = bl4 = (string7 = this.comm.transliterator.decode(oracleColumn3.data, 0, oracleColumn3.data.length)).indexOf("IN") >= 0;
                        if (bl4) {
                            int n10 = n6 - 1;
                            nArray[n10] = nArray[n10] | 1;
                        }
                        boolean bl6 = bl3 = string7.indexOf("OUT") >= 0;
                        if (bl3) {
                            if (n6 == 0) {
                                n9 = baseParameters2 != null ? baseParameters2.count() : 0;
                                utilVectorUnsynced2 = new BaseParameters(n9 + 1, this.comm.exceptions, (BaseConnection)this.implConn.connection);
                                if (!blArray[0]) {
                                    utilVectorUnsynced2.set(1, 2, new BaseParameter(1, 10, null, (BaseConnection)this.implConn.connection));
                                    n2 = 1;
                                }
                                n8 = 1;
                                while (n8 <= n9) {
                                    utilVectorUnsynced2.set(n8 + 1, 1, baseParameters2.parametersIn[n8 - 1]);
                                    utilVectorUnsynced2.set(n8 + 1, 2, baseParameters2.parametersOut[n8 - 1]);
                                    ++n8;
                                }
                                n5 = 1;
                                baseParameters2 = utilVectorUnsynced2;
                                blArray[0] = true;
                                ++n6;
                            }
                            int n11 = n6 - 1;
                            nArray[n11] = nArray[n11] | 2;
                        }
                    } else {
                        bl4 = (nArray[n6 - 1] & 1) > 0;
                        boolean bl7 = bl3 = (nArray[n6 - 1] & 2) > 0;
                    }
                    if (baseParameters2 == null) {
                        n5 = n6;
                        baseParameters2 = new BaseParameters(n5, this.comm.exceptions, (BaseConnection)this.implConn.connection);
                        utilVectorUnsynced = new UtilVectorUnsynced(n5);
                        n3 = this.sql.getFirstTopLevelParenExpListCount(utilVectorUnsynced);
                    }
                    string7 = null;
                    if (bl) {
                        string7 = this.comm.transliterator.decode(oracleColumn2.data, 0, oracleColumn2.data.length);
                        arrayList.add(this.convertNativeTypeNameToNativeDataType(string7));
                        int n12 = n = string7.compareTo("REF CURSOR") == 0 ? 1 : 0;
                        if (n != 0) {
                            blArray2[0] = true;
                            int n13 = n6 - 1;
                            nArray[n13] = nArray[n13] | 4;
                        }
                    } else {
                        int n14 = n = (nArray[n6 - 1] & 4) > 0 ? 1 : 0;
                    }
                    if (n != 0) {
                        blArray2[0] = true;
                        ++this.TotalNrResultsets;
                        baseParameters2.set(n5, 2, new BaseParameter(-999, 10, null, (BaseConnection)this.implConn.connection));
                        if (n7 > 0) {
                            baseParameters2.set(n5, 1, new BaseParameter(-999, 10, null, (BaseConnection)this.implConn.connection));
                        }
                    } else if (n2 == 0) {
                        String string9 = ":";
                        if (n3 > 0) {
                            utilVectorUnsynced2 = this.sql.getFirstTopLevelParenExpListElement(utilVectorUnsynced, n3 - 1);
                            --n3;
                            string9 = ((String)utilVectorUnsynced2.firstElement()).trim();
                            n8 = 1;
                            String string10 = null;
                            while (n8 < utilVectorUnsynced2.size()) {
                                string10 = ((String)utilVectorUnsynced2.elementAt(n8)).trim();
                                if (string10.length() > 0) {
                                    string9 = string9 + string10;
                                }
                                ++n8;
                            }
                            if (string9.charAt(0) == 'N' && string9.charAt(1) == '\'' && string9.charAt(string9.length() - 1) == '\'') {
                                string9 = string9.substring(2, string9.length() - 1);
                            }
                            int n15 = string9.indexOf(39);
                            while (n15 != -1 && n15 < string9.length() - 1) {
                                if (string9.charAt(n15 + 1) == '\'') {
                                    string9 = string9.substring(0, n15) + string9.substring(n15 + 1);
                                }
                                n15 = string9.indexOf(39, n15 + 1);
                            }
                        }
                        if (string9.equalsIgnoreCase("null")) {
                            baseParameters2.set(n5, 1, new BaseParameter(12, 1, null, (BaseConnection)this.implConn.connection));
                            blArray2[0] = true;
                        } else if (string9.charAt(0) == ':') {
                            if (baseParameters != null && n4 > 0) {
                                int n16 = 0;
                                BaseParameter baseParameter = baseParameters.parametersIn[n4 - 1];
                                if (baseParameter != null && bl4) {
                                    n16 = baseParameter.sqlType;
                                    if (bl) {
                                        if (string7.compareTo("CLOB") == 0) {
                                            int n17 = n6 - 1;
                                            nArray[n17] = nArray[n17] | 0x10;
                                            baseParameter.nativeType = baseParameter.sqlType;
                                            baseParameter.sqlType = 2005;
                                            blArray2[0] = true;
                                        } else if (string7.compareTo("BLOB") == 0) {
                                            int n18 = n6 - 1;
                                            nArray[n18] = nArray[n18] | 8;
                                            baseParameter.nativeType = baseParameter.sqlType;
                                            baseParameter.sqlType = 2004;
                                            blArray2[0] = true;
                                        }
                                    } else if ((nArray[n6 - 1] & 0x10) > 0) {
                                        baseParameter.nativeType = baseParameter.sqlType;
                                        baseParameter.sqlType = 2005;
                                        blArray2[0] = true;
                                    } else if ((nArray[n6 - 1] & 8) > 0) {
                                        baseParameter.nativeType = baseParameter.sqlType;
                                        baseParameter.sqlType = 2004;
                                        blArray2[0] = true;
                                    }
                                    baseParameters2.set(n5, 1, baseParameter);
                                } else if (baseParameter == null && bl4) {
                                    baseParameter = new BaseParameter(n16, 0, null, (BaseConnection)this.implConn.connection);
                                    baseParameters2.set(n5, 1, baseParameter);
                                }
                                baseParameter = baseParameters.parametersOut[n4 - 1];
                                if (baseParameter != null && bl3) {
                                    if (bl) {
                                        if (string7.compareTo("CLOB") == 0) {
                                            int n19 = n6 - 1;
                                            nArray[n19] = nArray[n19] | 0x10;
                                            baseParameter.nativeType = baseParameter.sqlType;
                                            baseParameter.sqlType = 2005;
                                            blArray2[0] = true;
                                        } else if (string7.compareTo("BLOB") == 0) {
                                            int n20 = n6 - 1;
                                            nArray[n20] = nArray[n20] | 8;
                                            baseParameter.nativeType = baseParameter.sqlType;
                                            baseParameter.sqlType = 2004;
                                            blArray2[0] = true;
                                        }
                                    } else if ((nArray[n6 - 1] & 0x10) > 0) {
                                        baseParameter.nativeType = baseParameter.sqlType;
                                        baseParameter.sqlType = 2005;
                                        blArray2[0] = true;
                                    } else if ((nArray[n6 - 1] & 8) > 0) {
                                        baseParameter.nativeType = baseParameter.sqlType;
                                        baseParameter.sqlType = 2004;
                                        blArray2[0] = true;
                                    }
                                    baseParameters2.set(n5, 2, baseParameter);
                                } else if (baseParameter == null && bl3) {
                                    baseParameter = new BaseParameter(bl4 ? n16 : 1, 0, null, (BaseConnection)this.implConn.connection);
                                    baseParameters2.set(n5, 2, baseParameter);
                                }
                                --n4;
                            }
                        } else {
                            if (string9.charAt(0) == '\'') {
                                string9 = string9.substring(1, string9.length() - 1);
                            }
                            baseParameters2.set(n5, 1, new BaseParameter(12, 10, (Object)string9, (BaseConnection)this.implConn.connection));
                            blArray2[0] = true;
                        }
                    }
                    --n5;
                    if (bl) {
                        n9 = this.NSPTDAPacket.getNextTTCCode();
                        if (n9 == 21) {
                            this.sentColumnsVector.setNumColumns(baseColumnArray.length);
                            this.NSPTDAPacket.getNextNextTTISubpacket(this.sentColumnsVector);
                            byArray = this.sentColumnsVector.getSentMask();
                            n9 = this.implConn.processReply(this.oAllFetch[0]);
                        } else if (n9 == 6) {
                            this.NSPTDAPacket.getNextNextTTISubpacket(this.fetchheader);
                            n9 = this.NSPTDAPacket.getNextTTCCode();
                            byArray = this.fetchheader.getSentMask();
                        }
                        if (n9 == 7) continue;
                        bl2 = false;
                        continue;
                    }
                    boolean bl8 = bl2 = --n6 > 0;
                }
                if (arrayList.size() <= 0) break block74;
                n2 = arrayList.size();
                this.RememberedColumnTypes = new int[n2];
                n = 0;
                while (n < n2) {
                    this.RememberedColumnTypes[n2 - 1 - n] = (Integer)arrayList.get(n);
                    ++n;
                }
            }
            catch (Exception exception) {
                baseParameters2 = baseParameters;
            }
        }
        return baseParameters2;
    }

    public int getNextRowsAffectedCount() throws SQLException {
        return this.rowsAffected;
    }

    public boolean supportsBatchParameters() {
        return true;
    }

    private String massageQualifier(String string) {
        if (string == null) {
            return string;
        }
        string = string.trim();
        boolean bl = false;
        if (string.charAt(0) == '\"') {
            string = string.substring(1, string.length());
            bl = true;
        }
        if (string.charAt(string.length() - 1) == '\"') {
            string = string.substring(0, string.length() - 1);
            bl = true;
        }
        if (bl) {
            return string;
        }
        return string.toUpperCase();
    }

    private String getProcObjectId(String string) throws SQLException {
        if (this.NSPTDAPacket == null) {
            this.NSPTDAPacket = new OracleNet8NSPTDAPacket(this.comm);
        }
        TTIFUN_OALL8 tTIFUN_OALL8 = new TTIFUN_OALL8(this.implConn);
        tTIFUN_OALL8.setCommandText("begin dbms_utility.name_resolve(:v1,:v2,:v3,:v4,:v5,:v6,:v7,:v8);end;");
        tTIFUN_OALL8.setOptions(1065);
        tTIFUN_OALL8.setCursorID(this.implConn.getCursorID());
        if (this.m_internalParamSets == null) {
            this.m_internalParamSets = new OracleInternalParameterSet[1];
            this.m_internalParamSets[0] = new OracleInternalParameterSet();
        }
        OracleInternalParameterSet oracleInternalParameterSet = this.m_internalParamSets[0];
        oracleInternalParameterSet.reset();
        OracleInternalParameter oracleInternalParameter = oracleInternalParameterSet.getAvailableParameter();
        oracleInternalParameter.setInfo(1, 0, 0, 2 * string.length(), 0, 0, this.comm.transliterator);
        byte[] byArray = null;
        try {
            byArray = this.comm.transliterator.encode(string);
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
        oracleInternalParameter.m_nativeDataIn = byArray;
        oracleInternalParameter.m_nativeDataInLength = byArray.length;
        oracleInternalParameter.m_direction = 32;
        oracleInternalParameter = oracleInternalParameterSet.getAvailableParameter();
        oracleInternalParameter.setInfo(6, 0, 0, 16, 0, 0, this.comm.transliterator);
        byte[] byArray2 = new byte[22];
        int n = OracleVNU.convertIntToVNU(byArray2, 1);
        oracleInternalParameter.m_nativeDataIn = byArray2;
        oracleInternalParameter.m_nativeDataInLength = n;
        oracleInternalParameter.m_direction = 32;
        oracleInternalParameter = oracleInternalParameterSet.getAvailableParameter();
        oracleInternalParameter.setInfo(1, 0, 0, 32, 0, 0, this.comm.transliterator);
        oracleInternalParameter.m_direction = 16;
        oracleInternalParameter = oracleInternalParameterSet.getAvailableParameter();
        oracleInternalParameter.setInfo(1, 0, 0, 32, 0, 0, this.comm.transliterator);
        oracleInternalParameter.m_direction = 16;
        oracleInternalParameter = oracleInternalParameterSet.getAvailableParameter();
        oracleInternalParameter.setInfo(1, 0, 0, 32, 0, 0, this.comm.transliterator);
        oracleInternalParameter.m_direction = 16;
        oracleInternalParameter = oracleInternalParameterSet.getAvailableParameter();
        oracleInternalParameter.setInfo(1, 0, 0, 32, 0, 0, this.comm.transliterator);
        oracleInternalParameter.m_direction = 16;
        oracleInternalParameter = oracleInternalParameterSet.getAvailableParameter();
        oracleInternalParameter.setInfo(1, 0, 0, 32, 0, 0, this.comm.transliterator);
        oracleInternalParameter.m_direction = 16;
        oracleInternalParameter = oracleInternalParameterSet.getAvailableParameter();
        oracleInternalParameter.setInfo(1, 0, 0, 16, 0, 0, this.comm.transliterator);
        oracleInternalParameter.m_direction = 16;
        tTIFUN_OALL8.setParameters(oracleInternalParameterSet);
        tTIFUN_OALL8.setCursorID(this.implConn.getCursorID());
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OALL8);
        TTIRXDDataPacket tTIRXDDataPacket = new TTIRXDDataPacket(oracleInternalParameterSet, this.implConn, false);
        this.NSPTDAPacket.appendTTISubPacket(tTIRXDDataPacket);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        TTIOERDataPacket tTIOERDataPacket = new TTIOERDataPacket(this.implConn);
        this.implConn.processReply(null, tTIOERDataPacket);
        if (tTIOERDataPacket.retCode != 0) {
            String[] stringArray = new String[]{tTIOERDataPacket.errMsg};
            SQLException sQLException = this.comm.exceptions.getException(6001, stringArray, tTIOERDataPacket.getSQLState(), (int)tTIOERDataPacket.retCode);
            throw sQLException;
        }
        this.NSPTDAPacket.getNextNextTTISubpacket(tTIRXDDataPacket);
        oracleInternalParameter = oracleInternalParameterSet.paramSet[7];
        String string2 = null;
        try {
            string2 = this.comm.transliterator.decode(oracleInternalParameter.m_nativeDataOut, 0, oracleInternalParameter.m_nativeDataOutLength);
        }
        catch (UtilException utilException) {}
        return string2;
    }

    public void executeBatch() throws SQLException, BatchUpdateException {
        if (this.isSelect) {
            throw this.comm.exceptions.getException(6053);
        }
        this.execute();
    }

    private void freeLobs() throws SQLException {
        OracleNet8NSPTDAPacket oracleNet8NSPTDAPacket = this.implConn.NSPTDAPacket;
        int n = 0;
        while (n < this.numTempLOBs) {
            byte[] byArray = this.tempLOBLocatorCollection[n];
            TTIFUN_OLOBOPS tTIFUN_OLOBOPS = new TTIFUN_OLOBOPS(273, byArray, this.implConn);
            oracleNet8NSPTDAPacket.appendTTISubPacket(tTIFUN_OLOBOPS);
            oracleNet8NSPTDAPacket.sendRequest();
            oracleNet8NSPTDAPacket.receiveReply();
            TTIOERDataPacket tTIOERDataPacket = new TTIOERDataPacket(this.implConn);
            this.processReply(tTIFUN_OLOBOPS);
            ++n;
        }
        this.numTempLOBs = 0;
    }

    public void execute() throws SQLException {
        Object object;
        int n;
        int n2;
        if (this.numTempLOBs > 0) {
            this.freeLobs();
        }
        if (this.m_cursorID == 0 && this.implConn.useOAll7) {
            this.openCursor();
        }
        this.bParams = null;
        this.TotalNrResultsets = 1;
        this.currentRefCursorPos = -1;
        this.CurrentResultsetIndex = 0;
        String string = null;
        boolean bl = false;
        if (this.parameterSets != null) {
            this.bParams = (BaseParameters)this.parameterSets.elementAt(0);
        }
        if (this.SQLStmtType == 3) {
            int n3;
            int n4;
            this.m_ttifunall = this.m_OAll8;
            this.actualNumStoredProcParams = -1;
            String string2 = this.sql.getOriginal();
            int n5 = n2 = this.lastExecutedSQL != null && this.rememberedNativeSQL != null && this.lastExecutedSQL.compareToIgnoreCase(string2) == 0 ? 1 : 0;
            if (n2 != 0) {
                string = this.rememberedNativeSQL;
                this.bParams = (BaseParameters)this.parameterSets.elementAt(0);
                n = 1;
                while (n <= this.bParams.count()) {
                    BaseParameter baseParameter;
                    n4 = this.savedProcParams.parametersOut[n - 1] != null ? 1 : 0;
                    n3 = this.savedProcParams.parametersIn[n - 1] != null ? 1 : 0;
                    object = this.bParams.parametersIn[n - 1];
                    if (object != null && n3 == 0) {
                        this.bParams.set(n, 1, null);
                    }
                    if ((baseParameter = this.bParams.parametersOut[n - 1]) == null && n4 != 0) {
                        this.bParams.set(n, 2, this.savedProcParams.parametersOut[n - 1]);
                    }
                    if (baseParameter != null && n4 == 0) {
                        this.bParams.set(n, 2, null);
                    }
                    ++n;
                }
            } else {
                int n6;
                int n7;
                this.savedProcParams = null;
                n = string2.length();
                n4 = string2.indexOf("=");
                n3 = string2.toUpperCase().indexOf("CALL");
                boolean bl2 = n4 > 0 && n4 < n3;
                boolean bl3 = false;
                int n8 = n3 + 5;
                while (string2.charAt(n8) == ' ' && n8 < n) {
                    ++n8;
                }
                int n9 = n8;
                int n10 = string2.indexOf("(", n8);
                n9 = n10 == -1 ? ((n7 = string2.indexOf("}", n8)) == -1 ? n : n7) : n10;
                String string3 = string2.substring(n8, n9).trim();
                String string4 = this.getProcObjectId(string3);
                String string5 = null;
                String string6 = null;
                String string7 = null;
                int n11 = -1;
                int n12 = -1;
                n12 = string3.indexOf(46);
                if (n12 > 0) {
                    n11 = string3.lastIndexOf(46);
                    if (n11 == n12) {
                        string5 = string3.substring(0, n12);
                        string7 = string3.substring(n12 + 1);
                    } else {
                        string6 = string3.substring(0, n12);
                        string5 = string3.substring(n12 + 1, n11);
                        string7 = string3.substring(n11 + 1);
                    }
                } else {
                    string7 = string3;
                }
                string5 = this.massageQualifier(string5);
                string6 = this.massageQualifier(string6);
                string7 = this.massageQualifier(string7);
                int n13 = this.bParams == null ? 0 : this.bParams.count();
                boolean[] blArray = new boolean[]{false};
                if (string5 == null || string5.compareToIgnoreCase("JAVA_XA") != 0) {
                    boolean[] blArray2 = new boolean[]{bl2};
                    this.bParams = this.savedProcParams = this.getRealProcParams(string4, string6, string5, string7, this.bParams, blArray2, blArray);
                    if (this.parameterSets != null && this.parameterSets.size() > 1) {
                        n6 = 1;
                        while (n6 <= this.bParams.count()) {
                            if (this.bParams.parametersIn[n6 - 1].sqlType == -999) {
                                throw this.comm.exceptions.getException(6053);
                            }
                            ++n6;
                        }
                    }
                    bl2 = blArray2[0];
                }
                boolean bl4 = false;
                if (this.bParams != null) {
                    n6 = this.getActualNumStoredProcParams();
                    string = "BEGIN " + (bl2 ? ":RETVAL := " : "") + string3 + " (";
                    int n14 = n6 - (bl2 ? 1 : 0);
                    int n15 = 0;
                    while (n15 < n14) {
                        string = string + " :V" + (n15 + 1);
                        if (n15 < n14 - 1) {
                            string = string + ", ";
                        }
                        ++n15;
                    }
                    string = string + "); END;";
                } else {
                    string = this.sql.getFormatted();
                }
                this.rememberedNativeSQL = blArray[0] ? null : string;
            }
        } else {
            if (this.rememberedNativeSQL != null) {
                string = this.rememberedNativeSQL;
            } else {
                this.rememberedNativeSQL = string = this.sql.getFormatted();
            }
            if (string.trim().endsWith(";")) {
                bl = true;
                this.isPreparedPreparedStatement = false;
            }
        }
        this.rowsAffected = -1;
        this.m_ttifunall.reset(this.m_cursorID);
        this.m_ttifunall.setCommandText(string);
        this.m_ttifunall.setIsSelect(this.SQLStmtType == 1);
        int n16 = 32;
        if (this.SQLStmtType == 3 || bl) {
            this.m_ttifunall.setIsStoredProcCall(true);
        } else if (!this.isPreparedPreparedStatement) {
            n16 += 32768;
        }
        if (this.databaseMetaDataResultSet == 12) {
            String string8;
            BaseParameter[] baseParameterArray = new BaseParameter[4];
            n = 0;
            String string9 = (String)this.filterDescriptor.getRestriction(7);
            if (string9 != null) {
                baseParameterArray[n++] = new BaseParameter(1, 10, (Object)string9, (BaseConnection)this.implConn.connection);
            }
            if ((string8 = (String)this.filterDescriptor.getRestriction(6)) != null) {
                baseParameterArray[n++] = new BaseParameter(1, 10, (Object)string8, (BaseConnection)this.implConn.connection);
            }
            if (this.implConn.returnSynonyms) {
                baseParameterArray[n++] = new BaseParameter(1, 10, (Object)(string9 == null ? "" : string9), (BaseConnection)this.implConn.connection);
                baseParameterArray[n++] = new BaseParameter(1, 10, (Object)(string8 == null ? "" : string8), (BaseConnection)this.implConn.connection);
            }
            object = new BaseParameters(n, this.comm.exceptions, (BaseConnection)this.implConn.connection);
            int n17 = 1;
            while (n17 <= n) {
                object.set(n17, 1, baseParameterArray[n17 - 1]);
                ++n17;
            }
            this.filterDescriptor.removeAllRestrictions();
            this.bParams = object;
        }
        this.executeAsNativeBatch = false;
        if (this.bParams == null || this.bParams.count() == 0) {
            this.m_ttifunall.setParameters(null);
            if (this.m_internalParamSets != null) {
                this.m_internalParamSets[0].reset();
            }
        } else {
            if (this.tempLOBLocatorCollection == null || this.tempLOBLocatorCollection.length < this.bParams.count()) {
                this.tempLOBLocatorCollection = new byte[this.bParams.count()][];
            }
            OracleInternalParameterSet oracleInternalParameterSet = this.createInternalParameterSet(this.bParams, this.m_internalParamSets == null ? null : this.m_internalParamSets[0]);
            if (this.parameterSets != null && this.parameterSets.size() > 1) {
                if (this.m_internalParamSets == null) {
                    this.m_internalParamSets = new OracleInternalParameterSet[this.parameterSets.size()];
                } else if (this.parameterSets.size() > this.m_internalParamSets.length) {
                    OracleInternalParameterSet[] oracleInternalParameterSetArray = new OracleInternalParameterSet[this.parameterSets.size()];
                    int n18 = 0;
                    while (n18 < this.m_internalParamSets.length) {
                        oracleInternalParameterSetArray[n18] = this.m_internalParamSets[n18];
                        ++n18;
                    }
                    this.m_internalParamSets = oracleInternalParameterSetArray;
                }
                this.m_internalParamSets[0] = oracleInternalParameterSet;
                n = 1;
                while (n < this.parameterSets.size()) {
                    this.m_internalParamSets[n] = this.createInternalParameterSet((BaseParameters)this.parameterSets.get(n), this.m_internalParamSets[n]);
                    ++n;
                }
                if (this.paramTypesMatchForAllParamSets()) {
                    this.m_ttifunall.setArraySize(this.SQLStmtType == 1 && !this.implConn.useOAll7 ? 0 : this.parameterSets.size());
                    this.executeAsNativeBatch = true;
                }
            } else {
                if (this.m_internalParamSets == null) {
                    this.m_internalParamSets = new OracleInternalParameterSet[1];
                }
                this.m_internalParamSets[0] = oracleInternalParameterSet;
            }
            n = this.parameterSets == null ? 1 : this.parameterSets.size();
            this.formulateParamBindInfo(this.m_internalParamSets, n);
            if (oracleInternalParameterSet.getNumParams() > 0 && (this.isFirstExecute || this.bindTypesOrMaxLensHaveChanged(this.m_requiredParamBindInfo))) {
                this.m_ttifunall.setParameters(this.m_requiredParamBindInfo);
                n16 |= 8;
                if (this.m_orgParamBindInfo == null) {
                    this.m_orgParamBindInfo = new OracleInternalParameterSet();
                } else {
                    this.m_orgParamBindInfo.reset();
                }
                int n19 = 0;
                while (n19 < oracleInternalParameterSet.getNumParams()) {
                    OracleInternalParameter oracleInternalParameter = this.m_orgParamBindInfo.getAvailableParameter();
                    oracleInternalParameter.copy(this.m_requiredParamBindInfo.paramSet[n19]);
                    ++n19;
                }
            } else {
                this.m_ttifunall.setParameters(null);
            }
        }
        if (!this.isPreparedPreparedStatement && this.isFirstExecute || (n16 & 8) != 0 && this.implConn.oracleServerVersion < 902000000L) {
            n16 |= 1;
            if (this.sql.getOriginal() != this.lastExecutedSQL && this.currentCursorId != 0) {
                this.CurrentRSDescriptions = null;
                this.m_numRowsToFetch = null;
            } else if (this.implConn.oracleServerVersion >= 900000000L) {
                n2 = 0;
                try {
                    n2 = this.comm.socket.getSoTimeout();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n2 != 0) {
                    this.CurrentRSDescriptions = null;
                    this.m_numRowsToFetch = null;
                }
            }
        }
        if (this.SQLStmtType == 3 && (this.parameterSets == null || this.parameterSets.size() <= 1)) {
            n16 += 1024;
        }
        this.m_ttifunall.setOptions(n16);
        n2 = 0;
        if (this.isSelect) {
            if (this.CurrentRSDescriptions != null && this.CurrentRSDescriptions[0] != null) {
                n2 = 1;
            } else {
                this.m_ttifunall.setArraySize(this.implConn.useOAll7 ? 1 : 0);
            }
        }
        if (n2 == 0) {
            this.NSPTDAPacket.appendTTISubPacket(this.m_ttifunall);
        }
        this.lastExecutedSQL = this.sql.getOriginal();
        if (this.CurrentRSDescriptions == null || this.CurrentRSDescriptions.length < this.TotalNrResultsets) {
            this.CurrentRSDescriptions = new BaseColumn[this.TotalNrResultsets][];
        }
        if (this.m_numRowsToFetch == null || this.m_numRowsToFetch.length < this.TotalNrResultsets) {
            this.m_numRowsToFetch = new int[this.TotalNrResultsets];
        }
        if (this.bufferedNSPTDAPackets == null || this.bufferedNSPTDAPackets.length < this.TotalNrResultsets) {
            this.bufferedNSPTDAPackets = new OracleNet8NSPTDAPacket[this.TotalNrResultsets];
        }
        if (this.oAllFetch == null || this.oAllFetch.length < this.TotalNrResultsets) {
            this.oAllFetch = this.implConn.useOAll7 ? new TTIFUN_OALL7[this.TotalNrResultsets] : new TTIFUN_OALL8[this.TotalNrResultsets];
        }
        if (this.fetchrows == null || this.fetchrows.length < this.TotalNrResultsets) {
            this.fetchrows = new TTIRXDDataPacket[this.TotalNrResultsets];
        }
        if (this.rowsInBuffer == null || this.rowsInBuffer.length < this.TotalNrResultsets) {
            this.rowsInBuffer = new int[this.TotalNrResultsets];
        }
        if (this.CursorVarsDefined == null || this.CursorVarsDefined.length < this.TotalNrResultsets) {
            this.CursorVarsDefined = new boolean[this.TotalNrResultsets];
        }
        if (this.AllRowsFetched == null || this.AllRowsFetched.length < this.TotalNrResultsets) {
            this.AllRowsFetched = new boolean[this.TotalNrResultsets];
        } else {
            int n20 = 0;
            while (n20 < this.AllRowsFetched.length) {
                this.AllRowsFetched[n20] = false;
                ++n20;
            }
        }
        if (this.cachedRows == null || this.cachedRows.length < this.TotalNrResultsets) {
            this.cachedRows = new byte[this.TotalNrResultsets][][];
            this.cachedLens = new int[this.TotalNrResultsets][];
        }
        if (this.currentRowInBuffer == null || this.cachedRows.length < this.TotalNrResultsets) {
            this.currentRowInBuffer = new int[this.TotalNrResultsets];
        } else {
            int n21 = 0;
            while (n21 < this.currentRowInBuffer.length) {
                this.currentRowInBuffer[n21] = 0;
                ++n21;
            }
        }
        if (this.lastRowReturnedByDatabase == null || this.lastRowReturnedByDatabase.length < this.TotalNrResultsets) {
            this.lastRowReturnedByDatabase = new boolean[this.TotalNrResultsets];
        } else {
            int n22 = 0;
            while (n22 < this.lastRowReturnedByDatabase.length) {
                this.lastRowReturnedByDatabase[n22] = false;
                ++n22;
            }
        }
        if (n2 != 0) {
            this.currentCursorId = this.m_cursorID;
            this.currentResult = 2;
            this.CursorVarsDefined[0] = false;
            this.currentRefCursorPos = -1;
            this.TotalNrResultsets = 1;
            this.CurrentResultsetIndex = 0;
            this.AllRowsFetched[0] = false;
            this.rowsInBuffer[0] = 0;
            this.rowsAffected = 0;
            this.lastRowReturnedByDatabase[0] = false;
            this.fetchNext2(true, 0, this.m_ttifunall);
            this.isFirstExecute = false;
            return;
        }
        if (this.m_internalParamSets != null && this.m_internalParamSets[0].getNumParams() > 0) {
            this.appendParameterdata(this.NSPTDAPacket);
        }
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.gTTIoer.retCode = 0;
        int n23 = this.processReply(this.m_ttifunall);
        if (this.gTTIoer.retCode != 0) {
            int n24;
            this.m_cursorID = this.gTTIoer.getCursorID();
            if (this.gTTIoer.retCode == 932) {
                this.isPreparedPreparedStatement = false;
                this.isFirstExecute = true;
            }
            String[] stringArray = new String[]{this.gTTIoer.errMsg};
            if (this.parameterSets != null && (n24 = this.parameterSets.size()) > 1) {
                object = new int[n24];
                int n25 = 0;
                while (n25 < n24) {
                    object[n25] = (BaseParameter)-3;
                    ++n25;
                }
                throw new BatchUpdateException(this.gTTIoer.errMsg, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode, (int[])object);
            }
            this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
            throw this.myException;
        }
        if (n23 == 16) {
            TTIDCBDataPacket tTIDCBDataPacket = new TTIDCBDataPacket(this.implConn);
            this.NSPTDAPacket.getNextNextTTISubpacket(tTIDCBDataPacket);
            this.CurrentRSDescriptions[this.CurrentResultsetIndex] = tTIDCBDataPacket.getColumns();
            this.m_numRowsToFetch[this.CurrentResultsetIndex] = 0;
            this.sentColumnsVector.setNumColumns(this.CurrentRSDescriptions[this.CurrentResultsetIndex].length);
            n23 = this.processReply(this.m_ttifunall);
        }
        this.isFirstExecute = false;
        if (this.SQLStmtType == 3) {
            if (n23 == 7 && this.bParams != null) {
                TTIRXDDataPacket tTIRXDDataPacket = new TTIRXDDataPacket(this.m_internalParamSets[0], this.implConn, false);
                tTIRXDDataPacket.setBaseExceptions(this.comm.exceptions);
                this.NSPTDAPacket.getNextNextTTISubpacket(tTIRXDDataPacket);
                try {
                    this.convertAndPropagateOutputParams(this.m_internalParamSets[0], this.bParams);
                }
                catch (UtilException utilException) {
                    this.comm.exceptions.getException((Exception)((Object)utilException));
                }
                n23 = this.processReply(this.m_ttifunall);
            }
            this.CurrentResultsetIndex = -1;
            this.currentRefCursorPos = this.bParams != null ? 0 : -1;
            this.rowsAffected = this.gTTIoer.curRowNumber;
            this.currentResult = this.rowsAffected >= 0 ? 3 : 1;
            this.m_ttifunall = this.implConn.useOAll7 ? this.m_OAll7 : this.m_OAll8;
        } else if (this.isSelect) {
            if (n2 == 0) {
                this.currentCursorId = this.m_cursorID;
                this.currentResult = 2;
                this.CursorVarsDefined[0] = false;
                this.currentRefCursorPos = -1;
                this.TotalNrResultsets = 1;
                this.CurrentResultsetIndex = 0;
                this.AllRowsFetched[0] = false;
                this.rowsInBuffer[0] = 0;
                this.rowsAffected = 0;
                this.lastRowReturnedByDatabase[0] = false;
                this.m_ttifunall.setOptions(0);
                this.m_ttifunall.setParameters(null);
                this.fetchNext2(true, 0, null);
            }
        } else {
            if (n23 == 7 && this.outputParametersWereSpecified()) {
                TTIRXDDataPacket tTIRXDDataPacket = new TTIRXDDataPacket(this.m_internalParamSets[0], this.implConn, true, this.implConn.useOAll7);
                this.NSPTDAPacket.getNextNextTTISubpacket(tTIRXDDataPacket);
                try {
                    this.convertAndPropagateOutputParams(this.m_internalParamSets[0], (BaseParameters)this.parameterSets.get(0));
                }
                catch (UtilException utilException) {
                    this.comm.exceptions.getException((Exception)((Object)utilException));
                }
                n23 = this.processReply(this.m_ttifunall);
            }
            this.rowsAffected = this.gTTIoer.curRowNumber;
            if (this.parameterSets != null) {
                int n26 = this.parameterSets.size();
                this.lastBatchAffectedRowcounts = new int[n26];
                int n27 = 0;
                while (n27 < n26) {
                    this.lastBatchAffectedRowcounts[n27] = -2;
                    ++n27;
                }
            }
            this.currentResult = this.rowsAffected >= 0 ? 3 : 1;
        }
    }

    private boolean outputParametersWereSpecified() {
        boolean bl = false;
        if (this.parameterSets != null) {
            BaseParameters baseParameters = (BaseParameters)this.parameterSets.get(0);
            int n = baseParameters.count();
            int n2 = 1;
            while (n2 <= n && !bl) {
                bl = baseParameters.parametersOut[n2 - 1] != null;
                ++n2;
            }
        }
        return bl;
    }

    private void appendParameterdata(OracleNet8NSPTDAPacket oracleNet8NSPTDAPacket) throws SQLException {
        int n;
        if (this.m_internalParamSets == null || this.m_internalParamSets[0].isEmpty()) {
            return;
        }
        if (this.TTIRXDDataPacketForParams == null) {
            this.TTIRXDDataPacketForParams = new TTIRXDDataPacket(null, this.implConn, this.SQLStmtType == 3, this.implConn.useOAll7);
            this.TTIRXDDataPacketForParams.setBaseExceptions(this.comm.exceptions);
        }
        int n2 = n = this.parameterSets == null ? 1 : this.parameterSets.size();
        if (n == 1 || this.executeAsNativeBatch) {
            int n3 = 0;
            while (n3 < n) {
                int n4 = this.m_internalParamSets[n3].getNumParams();
                if (n4 > 0) {
                    this.TTIRXDDataPacketForParams.setParameters(this.m_internalParamSets[n3]);
                    oracleNet8NSPTDAPacket.appendTTISubPacket(this.TTIRXDDataPacketForParams);
                }
                ++n3;
            }
        } else {
            this.TTIRXDDataPacketForParams.setParameters(this.m_internalParamSets[0]);
            oracleNet8NSPTDAPacket.appendTTISubPacket(this.TTIRXDDataPacketForParams);
            this.NSPTDAPacket.sendRequest();
            this.NSPTDAPacket.receiveReply();
            this.gTTIoer.retCode = 0;
            int n5 = this.processReply(this.m_ttifunall);
            if (this.implConn.oracleServerVersion < 902000000L) {
                this.m_ttifunall.addToOptions(1);
            }
            int n6 = 1;
            while (n6 < n) {
                this.m_ttifunall.setParameters(this.m_internalParamSets[n6]);
                this.NSPTDAPacket.appendTTISubPacket(this.m_ttifunall);
                this.TTIRXDDataPacketForParams.setParameters(this.m_internalParamSets[n6]);
                oracleNet8NSPTDAPacket.appendTTISubPacket(this.TTIRXDDataPacketForParams);
                if (n6 != n - 1) {
                    this.NSPTDAPacket.sendRequest();
                    this.NSPTDAPacket.receiveReply();
                    this.gTTIoer.retCode = 0;
                    n5 = this.processReply(this.m_ttifunall);
                }
                ++n6;
            }
        }
    }

    private void openCursor() throws SQLException {
        TTIFUN_OOPEN tTIFUN_OOPEN = new TTIFUN_OOPEN();
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OOPEN);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.gTTIoer.retCode = 0;
        this.processReply(tTIFUN_OOPEN);
        if (this.gTTIoer.retCode != 0) {
            String[] stringArray = new String[]{this.gTTIoer.errMsg};
            this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
            throw this.myException;
        }
        this.m_cursorID = tTIFUN_OOPEN.cid;
    }

    public void prepare() throws SQLException {
        int n = this.sql.getParameterCount();
        this.CurrentRSDescriptions = null;
        this.m_numRowsToFetch = null;
        this.RememberedColumnTypes = null;
        this.RememberedColumnNames = null;
        int n2 = 0;
        while (n2 < n) {
            this.sql.setParameter(n2, ":v" + n2);
            ++n2;
        }
        if (!this.isStatementSuitableForReexecution) {
            return;
        }
        if (this.implConn.describeAtPrepare) {
            String string;
            if (this.m_cursorID == 0 && this.implConn.useOAll7) {
                this.openCursor();
            }
            if ((string = this.sql.getFormatted()).trim().endsWith(";")) {
                this.m_ttifunall.setOptions(1);
            } else {
                this.m_ttifunall.setOptions(32769);
            }
            this.m_ttifunall.setCommandText(string);
            this.m_ttifunall.setCursorID(this.m_cursorID);
            this.m_ttifunall.setArraySize(0);
            this.m_ttifunall.setIsSelect(false);
            this.NSPTDAPacket.appendTTISubPacket(this.m_ttifunall);
            this.NSPTDAPacket.sendRequest();
            this.NSPTDAPacket.receiveReply();
            this.gTTIoer.retCode = 0;
            this.processReply(this.m_ttifunall);
            if (this.gTTIoer.retCode != 0) {
                this.m_cursorID = this.gTTIoer.getCursorID();
                String[] stringArray = new String[]{this.gTTIoer.errMsg};
                this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
                this.closeCursor();
                throw this.myException;
            }
            this.isPreparedPreparedStatement = true;
            this.currentCursorId = this.m_cursorID;
        }
    }

    void closeResultset() throws SQLException {
        this.closeResultset(this.currentCursorId, this.CurrentResultsetIndex);
    }

    void closeResultset(short s, int n) throws SQLException {
        block9: {
            block8: {
                if (!this.lastRowReturnedByDatabase[n]) break block8;
                if (this.SQLStmtType != 3) break block9;
            }
            if (this.reusablettifuncancel == null) {
                this.reusablettifuncancel = new TTIFUN_OCANCEL(s);
            } else {
                this.reusablettifuncancel.reset(s);
            }
            this.NSPTDAPacket.appendTTISubPacket(this.reusablettifuncancel);
            this.NSPTDAPacket.sendRequest();
            this.NSPTDAPacket.receiveReply();
            this.gTTIoer.retCode = 0;
            this.processReply(this.reusablettifuncancel);
            if (this.gTTIoer.retCode != 0) {
                String[] stringArray = new String[]{this.gTTIoer.errMsg};
                this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
                throw this.myException;
            }
            if (s != this.m_cursorID && s != 0) {
                TTIFUN_OCLOSE tTIFUN_OCLOSE = new TTIFUN_OCLOSE(s);
                this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OCLOSE);
                this.NSPTDAPacket.sendRequest();
                this.NSPTDAPacket.receiveReply();
                this.gTTIoer.retCode = 0;
                this.processReply(tTIFUN_OCLOSE);
                if (this.gTTIoer.retCode != 0) {
                    String[] stringArray = new String[]{this.gTTIoer.errMsg};
                    this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
                    throw this.myException;
                }
                this.AllRowsFetched[n] = true;
                this.currentCursorId = 0;
            }
        }
    }

    boolean fetchNext2(boolean bl, int n, TTIFUN_OALL_BASE tTIFUN_OALL_BASE) throws SQLException {
        int n2;
        int[] nArray;
        Object object;
        int n3;
        boolean bl2 = true;
        int n4 = -1;
        if (this.AllRowsFetched[n]) {
            return false;
        }
        if (this.rowsInBuffer[n] == 0 && !this.lastRowReturnedByDatabase[n]) {
            this.fetchNext(true, n, tTIFUN_OALL_BASE);
            this.lastRowReturnedByDatabase[n] = false;
            n3 = 0;
            boolean bl3 = this.AllRowsFetched[n];
            while (!bl3) {
                this.gTTIoer.isSelect = true;
                int n5 = this.processBufferedReply(this.oAllFetch[n], n);
                this.gTTIoer.isSelect = false;
                if (this.gTTIoer.retCode == 1403) {
                    this.lastRowReturnedByDatabase[n] = true;
                    bl3 = true;
                }
                byte[] byArray = this.fetchheader.getSentMask();
                if (n5 == 21) {
                    this.bufferedNSPTDAPackets[n].getNextNextTTISubpacket(this.sentColumnsVector);
                    byArray = this.sentColumnsVector.getSentMask();
                    n5 = this.processBufferedReply(this.oAllFetch[n], n);
                }
                if (n5 == 6) {
                    this.bufferedNSPTDAPackets[n].getNextNextTTISubpacket(this.fetchheader);
                    byArray = this.fetchheader.getSentMask();
                    n5 = this.processBufferedReply(this.oAllFetch[n], n);
                }
                if (n5 != 7) {
                    this.rowsInBuffer[n] = n3;
                    bl2 = false;
                    bl3 = true;
                    continue;
                }
                if (this.fetchrows[n] == null) {
                    this.fetchrows[n] = new TTIRXDDataPacket(this.CurrentRSDescriptions[n], this.implConn, this.implConn.useOAll7);
                } else {
                    this.fetchrows[n].reset(this.CurrentRSDescriptions[n]);
                }
                this.fetchrows[n].m_sentMask = byArray;
                object = this.cachedRows[n];
                nArray = this.cachedLens[n];
                if (n4 == -1) {
                    n4 = this.CurrentRSDescriptions[n].length;
                }
                int n6 = this.arrayfetchsize * n4;
                if (object == null) {
                    byte[][] byArrayArray = new byte[n6][];
                    object = byArrayArray;
                    this.cachedRows[n] = byArrayArray;
                } else if (((byte[][])object).length < n6) {
                    byte[][] byArrayArray = new byte[n6][];
                    int n7 = 0;
                    while (n7 < ((byte[][])object).length) {
                        byArrayArray[n7] = object[n7];
                        ++n7;
                    }
                    object = byArrayArray;
                    this.cachedRows[n] = object;
                }
                if (nArray == null) {
                    nArray = new int[n6];
                    this.cachedLens[n] = nArray;
                } else if (nArray.length < n6) {
                    nArray = new int[n6];
                    this.cachedLens[n] = nArray;
                }
                n2 = n3 * n4;
                this.fetchrows[n].setCurrentRow((byte[][])object, nArray, n2);
                ++n3;
                this.bufferedNSPTDAPackets[n].getNextNextTTISubpacket(this.fetchrows[n]);
            }
            this.currentRowInBuffer[n] = 1;
            if (this.fetchrows[n] != null) {
                this.fetchrows[n].setCurrentRow(null, null, 0);
            }
        }
        if (bl) {
            return false;
        }
        if (this.rowsInBuffer[n] == 0) {
            this.AllRowsFetched[n] = true;
            return false;
        }
        if (n4 == -1) {
            n4 = this.CurrentRSDescriptions[n].length;
        }
        n2 = (this.currentRowInBuffer[n] - 1) * n4;
        object = this.cachedRows[n];
        nArray = this.cachedLens[n];
        n3 = 0;
        while (n3 < n4) {
            OracleColumn oracleColumn = (OracleColumn)this.CurrentRSDescriptions[n][n3];
            oracleColumn.data = object[n2 + n3];
            oracleColumn.len = nArray[n2 + n3];
            oracleColumn.indicator = oracleColumn.data == null || oracleColumn.len <= 0 ? -1 : 0;
            ++n3;
        }
        int n8 = n;
        this.currentRowInBuffer[n8] = this.currentRowInBuffer[n8] + 1;
        int n9 = n;
        this.rowsInBuffer[n9] = this.rowsInBuffer[n9] - 1;
        return true;
    }

    boolean fetchNext(boolean bl, int n, TTIFUN_OALL_BASE tTIFUN_OALL_BASE) throws SQLException {
        int n2;
        boolean bl2 = true;
        if (this.AllRowsFetched[n]) {
            return false;
        }
        if (this.rowsInBuffer[n] == 0) {
            int n3;
            if (this.CursorVarsDefined[n]) {
                this.oAllFetch[n].setOptions(32832);
            } else {
                this.lastRowReturnedByDatabase[n] = false;
                this.AllRowsFetched[n] = false;
                if (tTIFUN_OALL_BASE == null) {
                    if (this.implConn.useOAll7) {
                        this.oAllFetch[n] = new TTIFUN_OALL7(this.implConn);
                        this.oAllFetch[n].setOptions(80);
                        this.defineIsRequired = true;
                    } else {
                        this.oAllFetch[n] = new TTIFUN_OALL8(this.implConn);
                        this.oAllFetch[n].setOptions(64);
                    }
                    this.oAllFetch[n].setCursorID(this.currentCursorId);
                    this.oAllFetch[n].setIsSelect(true);
                } else {
                    if (this.defineIsRequired) {
                        tTIFUN_OALL_BASE.setOptions(tTIFUN_OALL_BASE.getOptions() | 0x10 | 0x40);
                    } else {
                        tTIFUN_OALL_BASE.setOptions(tTIFUN_OALL_BASE.getOptions() | 0x40);
                    }
                    this.oAllFetch[n] = tTIFUN_OALL_BASE;
                }
                if (this.fetchheader == null) {
                    this.fetchheader = new TTIRXHDataPacket();
                }
                if (this.CurrentRSDescriptions[n] == null) {
                    this.describeColumns(n);
                    this.sentColumnsVector.setNumColumns(this.CurrentRSDescriptions[n].length);
                }
                if (this.defineIsRequired) {
                    this.FetchcolCount = this.CurrentRSDescriptions[n].length;
                    this.oAllFetch[n].setDefineArraySize(this.FetchcolCount);
                    n3 = 0;
                    while (n3 < this.FetchcolCount) {
                        OracleColumn oracleColumn = (OracleColumn)this.CurrentRSDescriptions[n][n3];
                        if (this.implConn.useOAll7) {
                            ((TTIFUN_OALL7)this.oAllFetch[n]).defineCol(n3 + 1, oracleColumn.OCINativeType, 0, oracleColumn.m_defineScale, oracleColumn.m_defineMaxLength, oracleColumn.charSetId, oracleColumn.charSetForm);
                        }
                        ++n3;
                    }
                    this.defineIsRequired = false;
                }
            }
            if (this.m_numRowsToFetch[n] == 0) {
                this.FetchcolCount = this.CurrentRSDescriptions[n].length;
                int n4 = 0;
                boolean bl3 = false;
                int n5 = 0;
                while (n5 < this.FetchcolCount) {
                    OracleColumn oracleColumn = (OracleColumn)this.CurrentRSDescriptions[n][n5];
                    n3 = oracleColumn.m_defineMaxLength;
                    if (oracleColumn.OCINativeType == 8 || oracleColumn.OCINativeType == 24) {
                        bl3 = true;
                        break;
                    }
                    if (this.isUpdate && (oracleColumn.OCINativeType == 112 || oracleColumn.OCINativeType == 113)) {
                        bl3 = true;
                        break;
                    }
                    n4 += n3;
                    ++n5;
                }
                if (bl3) {
                    this.m_numRowsToFetch[n] = -1;
                } else {
                    this.arrayfetchsize = 64000 / n4;
                    this.m_numRowsToFetch[n] = this.arrayfetchsize = this.arrayfetchsize < 1 ? 1 : this.arrayfetchsize;
                }
            }
            this.arrayfetchsize = this.m_numRowsToFetch[n] == -1 ? 1 : (this.fetchSize > 0 ? (this.fetchSize > Short.MAX_VALUE ? Short.MAX_VALUE : this.fetchSize) : this.m_numRowsToFetch[n]);
            this.oAllFetch[n].setArraySize(this.arrayfetchsize);
            if (this.bufferedNSPTDAPackets[n] == null) {
                this.bufferedNSPTDAPackets[n] = new OracleNet8NSPTDAPacket(this.comm, true);
            }
            this.bufferedNSPTDAPackets[n].appendTTISubPacket(this.oAllFetch[n]);
            if (tTIFUN_OALL_BASE != null) {
                this.appendParameterdata(this.bufferedNSPTDAPackets[n]);
            }
            this.bufferedNSPTDAPackets[n].sendRequest();
            this.bufferedNSPTDAPackets[n].receiveReply();
            this.gTTIoer.retCode = 0;
            n2 = this.processBufferedReply(this.oAllFetch[n], n);
            if (this.gTTIoer.retCode == 1403) {
                this.oAllFetch[n] = null;
                this.fetchheader = null;
                this.AllRowsFetched[n] = true;
                this.gTTIoer.retCode = 0;
                this.lastRowReturnedByDatabase[n] = true;
            }
            if (this.gTTIoer.retCode != 0) {
                String[] stringArray = new String[]{this.gTTIoer.errMsg};
                this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
                throw this.myException;
            }
            this.CursorVarsDefined[n] = true;
            if (n2 == 16) {
                TTIDCBDataPacket tTIDCBDataPacket = new TTIDCBDataPacket(this.implConn);
                this.bufferedNSPTDAPackets[n].getNextNextTTISubpacket(tTIDCBDataPacket);
                this.CurrentRSDescriptions[n] = tTIDCBDataPacket.getColumns();
                this.m_numRowsToFetch[n] = 0;
                n2 = this.processBufferedReply(this.oAllFetch[n], n);
            }
            if (n2 != 6) {
                bl2 = false;
                this.rowsInBuffer[n] = 0;
                this.AllRowsFetched[n] = true;
                return false;
            }
            this.bufferedNSPTDAPackets[n].getNextNextTTISubpacket(this.fetchheader);
            this.rowsInBuffer[n] = this.fetchheader.CurrIterations;
        }
        if (bl) {
            return false;
        }
        n2 = this.processBufferedReply(this.oAllFetch[n], n);
        if (this.gTTIoer.retCode == 1403) {
            this.lastRowReturnedByDatabase[n] = true;
        }
        if (n2 == 6) {
            this.bufferedNSPTDAPackets[n].getNextNextTTISubpacket(this.fetchheader);
            n2 = this.processBufferedReply(this.oAllFetch[n], n);
        }
        if (n2 != 7) {
            this.rowsInBuffer[n] = 0;
            bl2 = false;
            this.AllRowsFetched[n] = true;
        } else {
            if (this.fetchrows[n] == null) {
                this.fetchrows[n] = new TTIRXDDataPacket(this.CurrentRSDescriptions[n], this.implConn, this.implConn.useOAll7);
            } else {
                this.fetchrows[n].reset(this.CurrentRSDescriptions[n]);
            }
            this.bufferedNSPTDAPackets[n].getNextNextTTISubpacket(this.fetchrows[n]);
            int n6 = n;
            this.rowsInBuffer[n6] = this.rowsInBuffer[n6] - 1;
        }
        return bl2;
    }

    public void close() throws SQLException {
        if (this.numTempLOBs > 0) {
            this.freeLobs();
        }
        this.closeCursor();
        this.isPreparedPreparedStatement = false;
        this.AllRowsFetched = null;
        this.oAllFetch = null;
        this.fetchheader = null;
        this.fetchrows = null;
    }

    private void closeCursor() throws SQLException {
        if (this.m_cursorID != 0) {
            TTIFUN_OCLOSE tTIFUN_OCLOSE = new TTIFUN_OCLOSE(this.m_cursorID);
            this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OCLOSE);
            this.NSPTDAPacket.sendRequest();
            this.NSPTDAPacket.receiveReply();
            this.gTTIoer.retCode = 0;
            this.processReply(tTIFUN_OCLOSE);
            if (this.gTTIoer.retCode != 0) {
                String[] stringArray = new String[]{this.gTTIoer.errMsg};
                this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
                throw this.myException;
            }
            this.m_cursorID = 0;
        }
    }

    public BaseColumns describeColumns(BaseColumns baseColumns) throws SQLException {
        BaseColumn[] baseColumnArray = this.describeColumns(this.CurrentResultsetIndex);
        this.sentColumnsVector.setNumColumns(baseColumnArray.length);
        if (this.databaseMetaDataResultSet != 0) {
            return baseColumns;
        }
        BaseColumns baseColumns2 = new BaseColumns();
        int n = 0;
        while (n < this.CurrentRSDescriptions[this.CurrentResultsetIndex].length) {
            baseColumns2.add(this.CurrentRSDescriptions[this.CurrentResultsetIndex][n]);
            ++n;
        }
        return baseColumns2;
    }

    public BaseColumn[] describeColumns(int n) throws SQLException {
        if (this.CurrentRSDescriptions == null) {
            this.CurrentRSDescriptions = new BaseColumn[n + 1][];
        }
        if (this.m_numRowsToFetch == null) {
            this.m_numRowsToFetch = new int[n + 1];
        }
        if (this.CurrentRSDescriptions[n] != null) {
            return this.CurrentRSDescriptions[n];
        }
        TTIFUN_ODNY tTIFUN_ODNY = this.isPreparedPreparedStatement || this.currentCursorId != 0 && !this.isFirstExecute ? new TTIFUN_ODNY(this.currentCursorId, this.implConn) : new TTIFUN_ODNY(this.sql.getFormatted(), this.implConn);
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_ODNY);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.gTTIoer.retCode = 0;
        this.processReply(tTIFUN_ODNY);
        if (this.gTTIoer.retCode != 0) {
            String[] stringArray = new String[]{this.gTTIoer.errMsg};
            this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), (int)this.gTTIoer.retCode);
            throw this.myException;
        }
        this.CurrentRSDescriptions[n] = tTIFUN_ODNY.getColumnDescriptions();
        this.m_numRowsToFetch[n] = 0;
        return this.CurrentRSDescriptions[n];
    }

    private OracleInternalParameterSet createInternalParameterSet(BaseParameters baseParameters, OracleInternalParameterSet oracleInternalParameterSet) throws SQLException {
        try {
            if (oracleInternalParameterSet == null) {
                oracleInternalParameterSet = new OracleInternalParameterSet();
            } else {
                oracleInternalParameterSet.reset();
            }
            if (baseParameters == null) {
                return oracleInternalParameterSet;
            }
            int n = baseParameters.count();
            if (n == 0) {
                return oracleInternalParameterSet;
            }
            BaseParameter baseParameter = null;
            int n2 = 0;
            while (n2 < n) {
                block87: {
                    int n3;
                    boolean bl;
                    block86: {
                        BaseParameter baseParameter2;
                        block85: {
                            boolean bl2 = false;
                            bl = false;
                            n3 = 0;
                            BaseParameter baseParameter3 = baseParameters.parametersIn[n2];
                            if (baseParameter3 != null) {
                                bl2 = true;
                                n3 = 32;
                            }
                            if ((baseParameter2 = baseParameters.parametersOut[n2]) != null) {
                                bl = true;
                                n3 |= 0x10;
                            }
                            baseParameter = null;
                            if (!bl2) break block85;
                            baseParameter = baseParameter3;
                            if (bl) {
                                baseParameter = baseParameter3;
                                baseParameter.sqlType = baseParameter2.sqlType;
                            }
                            break block86;
                        }
                        if (!bl) break block87;
                        baseParameter = baseParameter2;
                    }
                    if (baseParameter.scale < 0) {
                        baseParameter.scale = 0;
                    }
                    boolean bl3 = false;
                    OracleInternalParameter oracleInternalParameter = oracleInternalParameterSet.getAvailableParameter();
                    boolean bl4 = false;
                    switch (baseParameter.sqlType) {
                        case -10: 
                        case -9: 
                        case -8: {
                            bl3 = true;
                        }
                        case -1: 
                        case 1: 
                        case 12: 
                        case 2005: {
                            int n4;
                            if (!(!bl && this.implConn.oracleServerVersion >= 902000000L || baseParameter.sqlType != 2005 && baseParameter.sqlType != -10)) {
                                oracleInternalParameter.m_nativeBindType = 112;
                                oracleInternalParameter.m_scale = 0;
                                oracleInternalParameter.m_maxlen = 86;
                                oracleInternalParameter.m_precision = 0;
                                if (baseParameter.isNull) {
                                    oracleInternalParameter.m_nativeDataInLength = 0;
                                    break;
                                }
                                OracleImplClob oracleImplClob = this.createTempClob(baseParameter, bl3 ? this.implConn.originalReportedOraNCharset : this.implConn.originalReportedOraCharset, bl3, null);
                                baseParameter.setBytes(oracleImplClob.cloblocator);
                                oracleInternalParameter.m_nativeDataInLength = 86;
                                oracleInternalParameter.m_nativeDataIn = oracleImplClob.cloblocator;
                                break;
                            }
                            if (baseParameter.sqlType == -8 || baseParameter.sqlType == -9 || baseParameter.sqlType == -10) {
                                bl3 = true;
                                n4 = this.implConn.maxLengthOfVarcharParamForNCharset;
                            } else {
                                n4 = this.implConn.maxLengthOfVarcharParam;
                            }
                            oracleInternalParameter.m_nativeBindType = 1;
                            if (this.SQLStmtType != 3 && this.stmtContainsWhereClause) {
                                oracleInternalParameter.m_nativeBindType = 96;
                            }
                            int n5 = oracleInternalParameter.m_maxlen = bl ? Short.MAX_VALUE : 1;
                            if (baseParameter.isNull) {
                                oracleInternalParameter.m_nativeDataInLength = 0;
                            } else {
                                byte[] byArray = null;
                                int n6 = 0;
                                String string = null;
                                switch (baseParameter.getType()) {
                                    case 14: 
                                    case 15: 
                                    case 17: {
                                        BaseInputStreamWrapper baseInputStreamWrapper = (BaseInputStreamWrapper)baseParameter.getASCIIStreamNoConvert();
                                        long l = baseInputStreamWrapper.length();
                                        if (l == -1L || l > (long)n4) break;
                                        string = baseParameter.getString(-1, this.comm.exceptions);
                                        break;
                                    }
                                    case 18: {
                                        BaseCharacterStreamWrapper baseCharacterStreamWrapper = (BaseCharacterStreamWrapper)baseParameter.getCharacterStreamReaderNoConvert();
                                        long l = baseCharacterStreamWrapper.length();
                                        if (l == -1L || l > (long)n4) break;
                                        string = baseParameter.getString(-1, this.comm.exceptions);
                                        break;
                                    }
                                    case 19: 
                                    case 20: {
                                        break;
                                    }
                                    default: {
                                        string = baseParameter.getString(-1, this.comm.exceptions);
                                    }
                                }
                                boolean bl5 = false;
                                if (string == null || string.length() == 0) {
                                    bl5 = true;
                                } else if (string.length() <= n4) {
                                    byArray = bl3 ? this.comm.transliteratorForNationalCharset.encode(string) : this.comm.transliterator.encode(string);
                                    n6 = byArray.length;
                                    if (n6 > n4) {
                                        bl5 = true;
                                    }
                                } else {
                                    bl5 = true;
                                }
                                if (bl5) {
                                    this.createBindingForLongParam(n2, baseParameter, byArray, string, oracleInternalParameter);
                                    bl4 = true;
                                } else {
                                    oracleInternalParameter.m_nativeDataIn = byArray;
                                    oracleInternalParameter.m_nativeDataInLength = n6;
                                    if (oracleInternalParameter.m_nativeDataInLength > oracleInternalParameter.m_maxlen) {
                                        oracleInternalParameter.m_maxlen = oracleInternalParameter.m_nativeDataInLength;
                                    }
                                }
                            }
                            oracleInternalParameter.m_precision = 0;
                            oracleInternalParameter.m_scale = 0;
                            break;
                        }
                        case -4: 
                        case -3: 
                        case -2: 
                        case 2004: {
                            if ((this.implConn.oracleServerVersion < 902000000L || bl) && baseParameter.sqlType == 2004) {
                                oracleInternalParameter.m_nativeBindType = 113;
                                oracleInternalParameter.m_precision = 0;
                                oracleInternalParameter.m_scale = 0;
                                oracleInternalParameter.m_maxlen = 86;
                                if (baseParameter.isNull) {
                                    oracleInternalParameter.m_nativeDataInLength = 0;
                                    break;
                                }
                                OracleImplBlob oracleImplBlob = this.createTempBlob(baseParameter, null);
                                baseParameter.setBytes(oracleImplBlob.bloblocator);
                                oracleInternalParameter.m_nativeDataInLength = 86;
                                oracleInternalParameter.m_nativeDataIn = oracleImplBlob.bloblocator;
                                break;
                            }
                            oracleInternalParameter.m_nativeBindType = 23;
                            int n7 = oracleInternalParameter.m_maxlen = bl ? Short.MAX_VALUE : 4000;
                            if (baseParameter.isNull) {
                                oracleInternalParameter.m_nativeDataInLength = 0;
                            } else {
                                byte[] byArray = null;
                                switch (baseParameter.getType()) {
                                    case 14: 
                                    case 15: 
                                    case 17: {
                                        BaseInputStreamWrapper baseInputStreamWrapper = (BaseInputStreamWrapper)baseParameter.getASCIIStreamNoConvert();
                                        long l = baseInputStreamWrapper.length();
                                        if (l == -1L || l > (long)this.implConn.maxLengthOfRawParam) break;
                                        byArray = baseParameter.getBytes(-1, this.comm.exceptions);
                                        break;
                                    }
                                    case 18: {
                                        BaseCharacterStreamWrapper baseCharacterStreamWrapper = (BaseCharacterStreamWrapper)baseParameter.getCharacterStreamReaderNoConvert();
                                        long l = baseCharacterStreamWrapper.length();
                                        if (l == -1L || l > (long)this.implConn.maxLengthOfRawParam) break;
                                        byArray = baseParameter.getBytes(-1, this.comm.exceptions);
                                        break;
                                    }
                                    case 19: 
                                    case 20: {
                                        break;
                                    }
                                    default: {
                                        byArray = baseParameter.getBytes(-1, this.comm.exceptions);
                                    }
                                }
                                if (byArray == null || byArray.length == 0 || byArray.length > this.implConn.maxLengthOfRawParam) {
                                    this.createBindingForLongParam(n2, baseParameter, byArray, null, oracleInternalParameter);
                                    bl4 = true;
                                } else {
                                    oracleInternalParameter.m_nativeDataIn = byArray;
                                    oracleInternalParameter.m_nativeDataInLength = oracleInternalParameter.m_nativeDataIn.length;
                                }
                            }
                            oracleInternalParameter.m_precision = 0;
                            oracleInternalParameter.m_scale = 0;
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            if (this.implConn.getSendFloatParametersAsString()) {
                                oracleInternalParameter.m_nativeBindType = 1;
                                oracleInternalParameter.m_maxlen = this.implConn.maxLengthOfVarcharParam;
                                if (baseParameter.isNull) {
                                    oracleInternalParameter.m_nativeDataInLength = 0;
                                } else {
                                    String string = baseParameter.getString(-1, this.comm.exceptions);
                                    oracleInternalParameter.m_nativeDataIn = this.comm.transliterator.encode(string);
                                    oracleInternalParameter.m_nativeDataInLength = oracleInternalParameter.m_nativeDataIn.length;
                                }
                                oracleInternalParameter.m_precision = 0;
                                oracleInternalParameter.m_scale = 0;
                                break;
                            }
                            if (this.implConn.oracleServerVersion < 1000000000L) {
                                oracleInternalParameter.m_nativeBindType = 6;
                                if (baseParameter.isNull) {
                                    oracleInternalParameter.m_nativeDataInLength = 0;
                                } else {
                                    String string = baseParameter.getType() == 9 ? (baseParameter.getBoolean(this.comm.exceptions) ? "1" : "0") : baseParameter.getString(-1, this.comm.exceptions);
                                    oracleInternalParameter.setupNativeDataInBuffer(22);
                                    oracleInternalParameter.m_nativeDataInLength = OracleVNU.convertStringToVNU(oracleInternalParameter.m_nativeDataIn, string, this.implConn, this.comm.exceptions);
                                }
                                oracleInternalParameter.m_maxlen = 22;
                                oracleInternalParameter.m_precision = 0;
                                oracleInternalParameter.m_scale = 0;
                                break;
                            }
                            if (baseParameter.sqlType == 7) {
                                oracleInternalParameter.m_nativeBindType = 100;
                                if (baseParameter.isNull) {
                                    oracleInternalParameter.m_nativeDataInLength = 0;
                                } else {
                                    float f = baseParameter.getFloat(this.comm.exceptions);
                                    int n8 = Float.floatToIntBits(f);
                                    n8 = n8 >= 0 ? (n8 |= Integer.MIN_VALUE) : (n8 ^= 0xFFFFFFFF);
                                    oracleInternalParameter.setupNativeDataInBuffer(4);
                                    oracleInternalParameter.m_nativeDataIn[0] = (byte)(n8 >> 24);
                                    oracleInternalParameter.m_nativeDataIn[1] = (byte)(n8 >> 16);
                                    oracleInternalParameter.m_nativeDataIn[2] = (byte)(n8 >> 8);
                                    oracleInternalParameter.m_nativeDataIn[3] = (byte)n8;
                                    oracleInternalParameter.m_nativeDataInLength = 4;
                                }
                                oracleInternalParameter.m_maxlen = 4;
                                oracleInternalParameter.m_precision = 0;
                                oracleInternalParameter.m_scale = 0;
                                break;
                            }
                            oracleInternalParameter.m_nativeBindType = 101;
                            if (baseParameter.isNull) {
                                oracleInternalParameter.m_nativeDataInLength = 0;
                            } else {
                                double d = baseParameter.getDouble(this.comm.exceptions);
                                long l = Double.doubleToLongBits(d);
                                l = l >= 0L ? (l |= Long.MIN_VALUE) : (l ^= 0xFFFFFFFFFFFFFFFFL);
                                oracleInternalParameter.setupNativeDataInBuffer(8);
                                oracleInternalParameter.m_nativeDataIn[0] = (byte)(l >> 56);
                                oracleInternalParameter.m_nativeDataIn[1] = (byte)(l >> 48);
                                oracleInternalParameter.m_nativeDataIn[2] = (byte)(l >> 40);
                                oracleInternalParameter.m_nativeDataIn[3] = (byte)(l >> 32);
                                oracleInternalParameter.m_nativeDataIn[4] = (byte)(l >> 24);
                                oracleInternalParameter.m_nativeDataIn[5] = (byte)(l >> 16);
                                oracleInternalParameter.m_nativeDataIn[6] = (byte)(l >> 8);
                                oracleInternalParameter.m_nativeDataIn[7] = (byte)l;
                                oracleInternalParameter.m_nativeDataInLength = 8;
                            }
                            oracleInternalParameter.m_maxlen = 8;
                            oracleInternalParameter.m_precision = 0;
                            oracleInternalParameter.m_scale = 0;
                            break;
                        }
                        case -7: 
                        case -6: 
                        case -5: 
                        case 4: 
                        case 5: {
                            oracleInternalParameter.m_nativeBindType = 6;
                            oracleInternalParameter.m_maxlen = 22;
                            oracleInternalParameter.setupNativeDataInBuffer(22);
                            if (baseParameter.isNull) {
                                oracleInternalParameter.m_nativeDataInLength = 0;
                            } else if (baseParameter.type == 4) {
                                oracleInternalParameter.m_nativeDataInLength = OracleVNU.convertIntToVNU(oracleInternalParameter.m_nativeDataIn, baseParameter.intValue);
                            } else {
                                long l = baseParameter.getLong(this.comm.exceptions);
                                oracleInternalParameter.m_nativeDataInLength = OracleVNU.convertLongToVNU(oracleInternalParameter.m_nativeDataIn, l);
                            }
                            oracleInternalParameter.m_precision = 0;
                            oracleInternalParameter.m_scale = 0;
                            break;
                        }
                        case 2: 
                        case 3: {
                            oracleInternalParameter.m_nativeBindType = 6;
                            oracleInternalParameter.m_maxlen = 22;
                            if (baseParameter.isNull) {
                                oracleInternalParameter.m_nativeDataInLength = 0;
                            } else {
                                BigDecimal bigDecimal = baseParameter.getBigDecimal(this.comm.exceptions);
                                oracleInternalParameter.setupNativeDataInBuffer(22);
                                oracleInternalParameter.m_nativeDataInLength = OracleVNU.convertBigDecimalToVNU(oracleInternalParameter.m_nativeDataIn, bigDecimal, this.implConn, this.comm.exceptions);
                            }
                            oracleInternalParameter.m_precision = 0;
                            oracleInternalParameter.m_scale = 0;
                            break;
                        }
                        case 91: 
                        case 92: 
                        case 93: {
                            if (baseParameter.sqlType == 93 && this.implConn.oracleServerVersion >= 900000000L) {
                                oracleInternalParameter.m_nativeBindType = 180;
                                oracleInternalParameter.m_maxlen = 11;
                            } else {
                                oracleInternalParameter.m_nativeBindType = 12;
                                oracleInternalParameter.m_maxlen = 7;
                            }
                            if (baseParameter.isNull) {
                                oracleInternalParameter.m_nativeDataInLength = 0;
                            } else {
                                oracleInternalParameter.m_nativeDataInLength = 7;
                                if (baseParameter.sqlType == 93) {
                                    BaseTimestamp baseTimestamp = baseParameter.getTimestamp(this.comm.exceptions);
                                    if (baseTimestamp.getYear() > 9999) {
                                        String[] stringArray = new String[]{"Conversion error - Year in date/timestamp parameter is out of range"};
                                        throw this.comm.exceptions.getException(6001, stringArray, "22008");
                                    }
                                    if (baseTimestamp.getNanos() > 0 && this.implConn.oracleServerVersion >= 900000000L) {
                                        oracleInternalParameter.m_nativeDataInLength = 11;
                                    }
                                    oracleInternalParameter.setupNativeDataInBuffer(11);
                                    int n9 = baseTimestamp.getYear();
                                    oracleInternalParameter.m_nativeDataIn[0] = (byte)(n9 / 100 + 100);
                                    oracleInternalParameter.m_nativeDataIn[1] = (byte)(n9 % 100 + 100);
                                    oracleInternalParameter.m_nativeDataIn[2] = (byte)(baseTimestamp.getMonth() + 1);
                                    oracleInternalParameter.m_nativeDataIn[3] = (byte)baseTimestamp.getDate();
                                    oracleInternalParameter.m_nativeDataIn[4] = (byte)(baseTimestamp.getHours() + 1);
                                    oracleInternalParameter.m_nativeDataIn[5] = (byte)(baseTimestamp.getMinutes() + 1);
                                    oracleInternalParameter.m_nativeDataIn[6] = (byte)(baseTimestamp.getSeconds() + 1);
                                    if (oracleInternalParameter.m_nativeDataInLength == 11) {
                                        int n10 = baseTimestamp.getNanos();
                                        oracleInternalParameter.m_nativeDataIn[7] = (byte)(n10 >> 24);
                                        oracleInternalParameter.m_nativeDataIn[8] = (byte)(n10 >> 16 & 0xFF);
                                        oracleInternalParameter.m_nativeDataIn[9] = (byte)(n10 >> 8 & 0xFF);
                                        oracleInternalParameter.m_nativeDataIn[10] = (byte)(n10 & 0xFF);
                                    }
                                } else {
                                    Date date = baseParameter.sqlType == 92 ? baseParameter.getTime(this.comm.exceptions) : baseParameter.getDate(this.comm.exceptions);
                                    Calendar calendar = Calendar.getInstance();
                                    calendar.setTime(date);
                                    oracleInternalParameter.setupNativeDataInBuffer(11);
                                    int n11 = calendar.get(1);
                                    oracleInternalParameter.m_nativeDataIn[0] = (byte)(n11 / 100 + 100);
                                    oracleInternalParameter.m_nativeDataIn[1] = (byte)(n11 % 100 + 100);
                                    oracleInternalParameter.m_nativeDataIn[2] = (byte)(calendar.get(2) + 1);
                                    oracleInternalParameter.m_nativeDataIn[3] = (byte)calendar.get(5);
                                    oracleInternalParameter.m_nativeDataIn[4] = (byte)(calendar.get(11) + 1);
                                    oracleInternalParameter.m_nativeDataIn[5] = (byte)(calendar.get(12) + 1);
                                    oracleInternalParameter.m_nativeDataIn[6] = (byte)(calendar.get(13) + 1);
                                }
                            }
                            oracleInternalParameter.m_precision = 0;
                            oracleInternalParameter.m_scale = 0;
                            break;
                        }
                        case -999: {
                            oracleInternalParameter.m_maxlen = 1;
                            oracleInternalParameter.m_nativeBindType = 102;
                            oracleInternalParameter.m_precision = 0;
                            oracleInternalParameter.m_scale = 0;
                            oracleInternalParameter.setupNativeDataInBuffer(1);
                            oracleInternalParameter.m_nativeDataIn[0] = 0;
                            oracleInternalParameter.m_nativeDataInLength = 1;
                            break;
                        }
                        default: {
                            String[] stringArray = new String[]{"Unhandled sql type"};
                            throw this.comm.exceptions.getException(6001, stringArray);
                        }
                    }
                    if (!bl4) {
                        if (bl3) {
                            oracleInternalParameter.m_charSetId = this.implConn.originalReportedOraNCharset;
                            oracleInternalParameter.m_charSetForm = 2;
                            oracleInternalParameter.m_transliterator = this.comm.transliteratorForNationalCharset;
                        } else {
                            oracleInternalParameter.m_charSetId = 0;
                            oracleInternalParameter.m_charSetForm = 0;
                            oracleInternalParameter.m_transliterator = this.comm.transliterator;
                        }
                    }
                    oracleInternalParameter.m_direction = n3;
                    if (this.SQLStmtType != 3) {
                        int n12 = oracleInternalParameter.m_nativeBindType;
                        oracleInternalParameter.m_writeDataAtEndOfRXD = n12 == 96 || n12 == 1 || n12 == 8 ? (this.implConn.wireCSmatchesOracleCS ? oracleInternalParameter.m_maxlen > 4000 : oracleInternalParameter.m_maxlen > this.implConn.maxLengthOfVarcharParam) : oracleInternalParameter.m_maxlen > this.implConn.maxLengthOfRawParam;
                    }
                }
                ++n2;
            }
            return oracleInternalParameterSet;
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    private void convertAndPropagateOutputParams(OracleInternalParameterSet oracleInternalParameterSet, BaseParameters baseParameters) throws UtilException, SQLException {
        int n = 1;
        int n2 = 0;
        while (n2 < oracleInternalParameterSet.getNumParams()) {
            OracleInternalParameter oracleInternalParameter = oracleInternalParameterSet.paramSet[n2];
            if ((oracleInternalParameter.m_direction & 0x10) != 0) {
                int n3 = n;
                while (n3 <= baseParameters.count()) {
                    BaseParameter baseParameter = baseParameters.parametersOut[n3 - 1];
                    byte[] byArray = oracleInternalParameter.m_nativeDataOut;
                    boolean bl = false;
                    if (baseParameter != null) {
                        block0 : switch (oracleInternalParameter.m_nativeBindType) {
                            case 102: {
                                short s;
                                short s2;
                                if (byArray == null) {
                                    baseParameter.setNull(3);
                                    break;
                                }
                                switch (oracleInternalParameter.m_nativeDataOutLength) {
                                    case 1: {
                                        short s3 = (short)(byArray[0] >= 0 ? byArray[0] : byArray[0] + 256);
                                        baseParameter.setShort(s3);
                                        break block0;
                                    }
                                    case 2: {
                                        s2 = (short)(byArray[0] >= 0 ? byArray[0] : byArray[0] + 256);
                                        s = (short)(byArray[1] >= 0 ? byArray[1] : byArray[1] + 256);
                                        baseParameter.setShort((short)(s2 * 256 + s));
                                        break block0;
                                    }
                                }
                                baseParameter.setNull(3);
                                break;
                            }
                            case 12: {
                                if (byArray == null) {
                                    baseParameter.setNull(108);
                                    break;
                                }
                                baseParameter.setNativeBytes(byArray, 108);
                                break;
                            }
                            case 180: {
                                if (byArray == null) {
                                    baseParameter.setNull(109);
                                    break;
                                }
                                baseParameter.setNativeBytes(byArray, 109);
                                break;
                            }
                            case 23: 
                            case 24: {
                                if (byArray == null) {
                                    baseParameter.setNull(2);
                                    break;
                                }
                                baseParameter.setBytes(byArray);
                                break;
                            }
                            case 112: {
                                if (baseParameter.sqlType == -10) {
                                    bl = true;
                                }
                                if (byArray == null) {
                                    baseParameter.setNull(20);
                                    break;
                                }
                                baseParameter.setClob((BaseImplClob)new OracleImplClob(byArray, this, bl ? this.implConn.originalReportedOraNCharset : this.implConn.originalReportedOraCharset));
                                break;
                            }
                            case 113: {
                                if (byArray == null) {
                                    baseParameter.setNull(19);
                                    break;
                                }
                                baseParameter.setBlob((BaseImplBlob)new OracleImplBlob(byArray, this));
                                break;
                            }
                            case 6: {
                                switch (baseParameter.sqlType) {
                                    case 2: 
                                    case 3: {
                                        if (byArray == null) {
                                            baseParameter.setData(8, null);
                                            break block0;
                                        }
                                        baseParameter.setData(10, (Object)OracleVNU.convertVNUToString(byArray, oracleInternalParameter.m_nativeDataInOffset, oracleInternalParameter.m_nativeDataOutLength, baseParameter.scale, (OracleImplConnection)this.implConnection));
                                        break block0;
                                    }
                                    case 6: 
                                    case 7: 
                                    case 8: {
                                        if (byArray == null) {
                                            baseParameter.setData(7, null);
                                            break block0;
                                        }
                                        baseParameter.setDouble(OracleVNU.convertVNUToDouble(byArray, oracleInternalParameter.m_nativeDataOutLength));
                                        break block0;
                                    }
                                    case -7: 
                                    case -6: 
                                    case -5: 
                                    case 4: 
                                    case 5: {
                                        if (byArray == null) {
                                            baseParameter.setNull(4);
                                            break block0;
                                        }
                                        baseParameter.setLong(OracleVNU.convertVNUToLong(byArray, oracleInternalParameter.m_nativeDataOutLength, this.comm.exceptions));
                                        break block0;
                                    }
                                }
                                String[] stringArray = new String[]{"Unexpected sqlType"};
                                throw this.comm.exceptions.getException(6001, stringArray);
                            }
                            case 100: {
                                if (byArray == null) {
                                    baseParameter.setData(6, null);
                                    break;
                                }
                                short s2 = byArray[0];
                                short s = byArray[1];
                                int n4 = byArray[2];
                                int n5 = byArray[3];
                                if ((s2 & 0x80) != 0) {
                                    s2 = (short)(s2 & 0x7F);
                                    s = (short)(s & 0xFF);
                                    n4 &= 0xFF;
                                    n5 &= 0xFF;
                                } else {
                                    s2 = (short)(~s2 & 0xFF);
                                    s = (short)(~s & 0xFF);
                                    n4 = ~n4 & 0xFF;
                                    n5 = ~n5 & 0xFF;
                                }
                                int n6 = s2 << 24 | s << 16 | n4 << 8 | n5;
                                baseParameter.setFloat(Float.intBitsToFloat(n6));
                                break;
                            }
                            case 101: {
                                if (byArray == null) {
                                    baseParameter.setData(7, null);
                                    break;
                                }
                                short s2 = byArray[0];
                                short s = byArray[1];
                                int n4 = byArray[2];
                                int n5 = byArray[3];
                                int n6 = byArray[4];
                                int n7 = byArray[5];
                                int n8 = byArray[6];
                                int n9 = byArray[7];
                                if ((s2 & 0x80) != 0) {
                                    s2 = (short)(s2 & 0x7F);
                                    s = (short)(s & 0xFF);
                                    n4 &= 0xFF;
                                    n5 &= 0xFF;
                                    n6 &= 0xFF;
                                    n7 &= 0xFF;
                                    n8 &= 0xFF;
                                    n9 &= 0xFF;
                                } else {
                                    s2 = (short)(~s2 & 0xFF);
                                    s = (short)(~s & 0xFF);
                                    n4 = ~n4 & 0xFF;
                                    n5 = ~n5 & 0xFF;
                                    n6 = ~n6 & 0xFF;
                                    n7 = ~n7 & 0xFF;
                                    n8 = ~n8 & 0xFF;
                                    n9 = ~n9 & 0xFF;
                                }
                                int n10 = s2 << 24 | s << 16 | n4 << 8 | n5;
                                int n11 = n6 << 24 | n7 << 16 | n8 << 8 | n9;
                                long l = (long)n10 << 32 | (long)n11 & 0xFFFFFFFFL;
                                baseParameter.setDouble(Double.longBitsToDouble(l));
                                break;
                            }
                            case 1: 
                            case 96: {
                                if (byArray == null) {
                                    baseParameter.setNull(10);
                                    break;
                                }
                                if (baseParameter.sqlType == -8 || baseParameter.sqlType == -9) {
                                    bl = true;
                                }
                                if (bl) {
                                    baseParameter.setString(this.comm.transliteratorForNationalCharset.decode(byArray, 0, oracleInternalParameter.m_nativeDataOutLength));
                                    break;
                                }
                                baseParameter.setString(this.comm.transliterator.decode(byArray, 0, oracleInternalParameter.m_nativeDataOutLength));
                                break;
                            }
                            default: {
                                String[] stringArray = new String[]{"Unexpected native bind type"};
                                throw this.comm.exceptions.getException(6001, stringArray);
                            }
                        }
                        if (baseParameter.nativeType != 0) {
                            baseParameter.sqlType = baseParameter.nativeType;
                        }
                        n = n3 + 1;
                        break;
                    }
                    ++n3;
                }
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void createBindingForLongParam(int var1_1, BaseParameter var2_2, byte[] var3_3, String var4_4, OracleInternalParameter var5_5) throws UtilException, SQLException {
        block36: {
            block40: {
                block37: {
                    block39: {
                        block38: {
                            var6_6 = 0;
                            if (this.RememberedColumnTypes == null) {
                                var7_7 = this.sql.getUpdateTableSpecification();
                                if (var7_7 == null) {
                                    if (!(this.sql.getType() == 3 && !this.implConn.refCursorSupport || var4_4 != null && var4_4.length() == 0)) {
                                        throw this.implConn.exceptions.getException(7010, "HY004");
                                    }
                                } else {
                                    var8_9 = "select * from " + var7_7 + " where 0=1";
                                    var9_11 = new TTIFUN_ODNY(var8_9, this.implConn);
                                    this.NSPTDAPacket.appendTTISubPacket(var9_11);
                                    this.NSPTDAPacket.sendRequest();
                                    this.NSPTDAPacket.receiveReply();
                                    this.gTTIoer.retCode = 0;
                                    this.processReply(var9_11);
                                    if (this.gTTIoer.retCode != 0) {
                                        throw this.implConn.exceptions.getException(7010, "HY004");
                                    }
                                    var10_15 = var9_11.getColumnDescriptions();
                                    var6_6 = var10_15.length;
                                    this.RememberedColumnTypes = new int[var6_6];
                                    this.RememberedColumnNames = new String[var6_6];
                                    var11_18 = 0;
                                    while (var11_18 < var6_6) {
                                        var12_20 = (OracleColumn)var10_15[var11_18];
                                        this.RememberedColumnNames[var11_18] = var12_20.name;
                                        this.RememberedColumnTypes[var11_18] = var12_20.charSetForm == 2 ? -var12_20.OCINativeType : var12_20.OCINativeType;
                                        ++var11_18;
                                    }
                                }
                            } else {
                                var6_6 = this.RememberedColumnTypes.length;
                            }
                            var7_8 = 0;
                            if (var6_6 != 0) break block38;
                            var7_8 = var2_2.sqlType == -8 || var2_2.sqlType == -9 || var2_2.sqlType == -10 ? -8 : (var2_2.sqlType == 1 || var2_2.sqlType == 12 || var2_2.sqlType == -1 || var2_2.sqlType == -8 ? 8 : 24);
                            break block36;
                        }
                        var8_9 = this.sql.getUpdateColumnSpecification(var1_1 + 1);
                        if (var8_9 != null) break block39;
                        var7_8 = this.RememberedColumnTypes[var1_1];
                        break block36;
                    }
                    var8_9 = var8_9.trim();
                    try {
                        var9_12 = Integer.parseInt(var8_9);
                        var7_8 = this.RememberedColumnTypes[var9_12 - 1];
                        break block36;
                    }
                    catch (Exception var9_13) {
                        var10_16 = false;
                        if (var8_9.charAt(var8_9.length() - 1) != '\"') break block37;
                        var11_18 = var8_9.length() - 2;
                        ** while (var11_18 >= 0)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (var8_9.charAt(var11_18) == '\"') break;
                        --var11_18;
                        continue;
                    }
lbl54:
                    // 2 sources

                    if (var11_18 >= 0) {
                        var8_9 = var8_9.substring(var11_18 + 1, var8_9.length() - 1);
                        var10_16 = true;
                    }
                    break block40;
                }
                var11_18 = var8_9.indexOf(46);
                if (var11_18 != -1) {
                    var12_21 = var11_18;
                    while ((var11_18 = var8_9.indexOf(46, var12_21 + 1)) != -1) {
                        var12_21 = var11_18;
                    }
                    var8_9 = var8_9.substring(var12_21 + 1);
                }
            }
            var11_18 = 0;
            while (var11_18 < var6_6) {
                if (var10_16) {
                    if (var8_9.equals(this.RememberedColumnNames[var11_18])) {
                        var7_8 = this.RememberedColumnTypes[var11_18];
                        break;
                    }
                } else if (var8_9.equalsIgnoreCase(this.RememberedColumnNames[var11_18])) {
                    var7_8 = this.RememberedColumnTypes[var11_18];
                    break;
                }
                ++var11_18;
            }
        }
        var10_17 = false;
        if (var7_8 < 0) {
            var7_8 = -var7_8;
            var10_17 = true;
        }
        var11_19 = this.comm.transliterator;
        var12_22 = this.implConn.originalReportedOraCharset;
        if (var10_17 || var2_2.sqlType == -8 || var2_2.sqlType == -9 || var2_2.sqlType == -10) {
            var11_19 = this.comm.transliteratorForNationalCharset;
            var12_22 = this.implConn.originalReportedOraNCharset;
        }
        switch (var7_8) {
            case 113: {
                var9_14 = 113;
                var13_23 = this.createTempBlob(var2_2, var3_3);
                var2_2.setBytes(var13_23.bloblocator);
                var5_5.m_nativeDataIn = var13_23.bloblocator;
                var8_10 = 86;
                break;
            }
            case 109: 
            case 112: {
                var9_14 = 112;
                var14_24 = this.createTempClob(var2_2, var12_22, var10_17, var4_4);
                var2_2.setBytes(var14_24.cloblocator);
                var5_5.m_nativeDataIn = var14_24.cloblocator;
                var8_10 = 86;
                break;
            }
            case 23: 
            case 24: {
                var9_14 = 24;
                var8_10 = 32767;
                if (var3_3 == null) {
                    var5_5.m_nativeDataIn = var2_2.getBytes(-1, this.comm.exceptions);
                    break;
                }
                var5_5.m_nativeDataIn = var3_3;
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 96: {
                if (var3_3 == null) {
                    if (var4_4 == null) {
                        var4_4 = var2_2.getString(-1, this.comm.exceptions);
                    }
                    var5_5.m_nativeDataIn = var11_19.encode(var4_4);
                } else {
                    var5_5.m_nativeDataIn = var3_3;
                }
                if (var7_8 == 8) ** GOTO lbl122
                if (this.sql.getType() != 3) ** GOTO lbl125
lbl122:
                // 2 sources

                var9_14 = 8;
                var8_10 = 0x7FFFFFFF;
                break;
lbl125:
                // 1 sources

                var9_14 = 96;
                var8_10 = var5_5.m_nativeDataIn.length > 1 ? var5_5.m_nativeDataIn.length : 1;
                break;
            }
            default: {
                var15_25 = new String[]{"Unexpected native column type"};
                throw this.comm.exceptions.getException(6001, var15_25);
            }
        }
        var5_5.m_nativeBindType = var9_14;
        var5_5.m_precision = 0;
        var5_5.m_scale = 0;
        var5_5.m_maxlen = var8_10;
        var5_5.m_transliterator = var11_19;
        if (var10_17) {
            var5_5.m_charSetId = this.implConn.originalReportedOraNCharset;
            var5_5.m_charSetForm = 2;
        } else {
            var5_5.m_charSetId = 0;
            var5_5.m_charSetForm = 0;
        }
        var5_5.m_nativeDataInLength = var5_5.m_nativeDataIn.length;
    }

    private void formulateParamBindInfo(OracleInternalParameterSet[] oracleInternalParameterSetArray, int n) {
        if (this.m_requiredParamBindInfo == null) {
            this.m_requiredParamBindInfo = new OracleInternalParameterSet();
        } else {
            this.m_requiredParamBindInfo.reset();
        }
        int n2 = oracleInternalParameterSetArray[0].getNumParams();
        int n3 = 0;
        while (n3 < n2) {
            OracleInternalParameter oracleInternalParameter = this.m_requiredParamBindInfo.getAvailableParameter();
            OracleInternalParameter oracleInternalParameter2 = oracleInternalParameterSetArray[0].paramSet[n3];
            oracleInternalParameter.copy(oracleInternalParameter2);
            if (oracleInternalParameter2.m_nativeBindType == 96 || oracleInternalParameter2.m_nativeBindType == 1) {
                int n4;
                int n5;
                if (n == 1) {
                    if (this.m_orgParamBindInfo != null && oracleInternalParameter2.m_maxlen > (n5 = this.m_orgParamBindInfo.paramSet[n3].m_maxlen)) {
                        n4 = oracleInternalParameter2.m_maxlen + (oracleInternalParameter2.m_maxlen - n5);
                        if (n4 > this.implConn.maxLengthValueForStringParams) {
                            n4 = this.implConn.maxLengthValueForStringParams;
                        }
                        oracleInternalParameter.m_maxlen = n4;
                    }
                } else {
                    n5 = oracleInternalParameter2.m_maxlen;
                    n4 = 1;
                    while (n4 < n) {
                        oracleInternalParameter2 = oracleInternalParameterSetArray[n4].paramSet[n3];
                        if (n5 < oracleInternalParameter2.m_maxlen) {
                            n5 = oracleInternalParameter2.m_maxlen;
                        }
                        ++n4;
                    }
                    oracleInternalParameter.m_maxlen = n5;
                }
            }
            ++n3;
        }
    }

    private boolean bindTypesOrMaxLensHaveChanged(OracleInternalParameterSet oracleInternalParameterSet) {
        if (this.m_orgParamBindInfo != null) {
            int n = 0;
            while (n < this.m_orgParamBindInfo.getNumParams()) {
                OracleInternalParameter oracleInternalParameter = this.m_orgParamBindInfo.paramSet[n];
                OracleInternalParameter oracleInternalParameter2 = oracleInternalParameterSet.paramSet[n];
                if (oracleInternalParameter.m_nativeBindType != oracleInternalParameter2.m_nativeBindType || oracleInternalParameter.m_maxlen < oracleInternalParameter2.m_maxlen || oracleInternalParameter.m_writeDataAtEndOfRXD != oracleInternalParameter2.m_writeDataAtEndOfRXD) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return true;
    }

    private boolean paramTypesMatchForAllParamSets() {
        int n = this.parameterSets == null ? 1 : this.parameterSets.size();
        int n2 = this.m_internalParamSets[0].getNumParams();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.m_internalParamSets[0].paramSet[n3].m_nativeBindType;
            int n5 = 1;
            while (n5 < n) {
                OracleInternalParameter oracleInternalParameter = this.m_internalParamSets[n5].paramSet[n3];
                if (oracleInternalParameter == null || oracleInternalParameter.m_nativeBindType != n4) {
                    return false;
                }
                ++n5;
            }
            ++n3;
        }
        return true;
    }
}

