#ifndef H_FTDB
#define H_FTDB

struct OneMatch
{
    unsigned int Offset;
    struct OneMatch * Next;
} ;

struct Record
{
    char ** Fields;
    int NextFieldNum;
    char FreeFirstOnly;
} ;

typedef struct FullTextDB * FullTextDB;
typedef struct OneMatch * MatchList;
typedef struct Record * Record;

enum FieldTypesFTDB { FTDB_STRING, FTDB_DATE, FTDB_INT };

char * OpenFTDB(char * Path, FullTextDB * db, int ReadOnly);
char * DefineFieldFTDB(FullTextDB db, char * Name, enum FieldTypesFTDB Type,
			int StoreData, int Index, int UseWriteCache);
char * SearchFTDB(FullTextDB db, char * String, char * Field, 
		  MatchList * Matches);				
char * UnionMatchesFTDB(MatchList One, MatchList Two, MatchList * Result);
char * IntersectMatchesFTDB(MatchList One, MatchList Two, MatchList * Result);
void FreeMatchesFTDB(MatchList List);
char * StartRecordFTDB(FullTextDB db, Record * rec);
char * AddStringFieldToRecordFTDB(FullTextDB db, Record rec, char * data);
char * AddRecordFTDB(FullTextDB db, Record rec);
char * GetRecordFTDB(FullTextDB db, unsigned int RecordOffset, Record * rec);
void FreeRecordFTDB(FullTextDB db, Record Rec);
void CloseFTDB(FullTextDB db);
char * ReindexFTDB(FullTextDB db);

#endif
