#pragma pack(2)

#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>

#include "toggleid.h"
#include "toggle.h"

void undrawbead(int x, int y)
{
	RectangleType rect;
	Word diam;

	x = x*space+xmin;
	y = y*space+ymin;

	rect.topLeft.x = x+2;
	rect.topLeft.y = y+2;
	rect.extent.x = space-4;
	rect.extent.y = space-4;
	diam = 3;
	
	WinEraseRectangle(&rect,diam);
}

void drawbead(int x, int y)
{
	RectangleType rect;
	Word diam;

	x = x*space+xmin;
	y = y*space+ymin;

	rect.topLeft.x = x+2;
	rect.topLeft.y = y+2;
	rect.extent.x = space-4;
	rect.extent.y = space-4;
	diam = 3;
	
	WinDrawRectangle(&rect,diam);
}

static char numbers[count][count] = {
	{0,0,0,0,0},
	{0,0,0,0,0},
	{0,0,0,0,0},
	{0,0,0,0,0},
	{0,0,0,0,0}
};

void flipone(int x, int y)
{
	if ((numbers[x][y] = !numbers[x][y]))
	{
		drawbead(x,y);
	}
	else
	{
		undrawbead(x,y);
	}
}

void doflip(int x, int y)
{
	flipone(x,y);
	if (x > 0)
		flipone(x-1,y);
	if (x < count-1)
		flipone(x+1,y);
	if (y > 0)
		flipone(x,y-1);
	if (y < count-1)
		flipone(x,y+1);
}

int donetest(void)
{
	int i,j;

	for (i=0; i<count; i++)
	{
		for (j=0; j<count; j++)
		{
			if (numbers[i][j])
				return(0);
		}
	}
	return(1);
}

void randomize(void)
{
	int i,j;

	for (i=0; i<count; i++)
	{
		for (j=0; j<count; j++)
		{
			if (SysRandom(0) & 0x1)
			doflip(i,j);
		}
	}
}

void drawframe(void)
{
	int i,j;

	for (i=1; i<width; i++)
	{
		WinDrawLine(xmin-i, ymin-i, xmin-i, ymax+i);
		WinDrawLine(xmax+i, ymin-i, xmax+i, ymax+i);
		WinDrawLine(xmin-i, ymin-i, xmax+i, ymin-i);
		WinDrawLine(xmin-i, ymax+i, xmax+i, ymax+i);
	}
#ifdef DORAND
	for (i=0; i<count; i++)
	{
		for (j=0; j<count; j++)
		{
			if (SysRandom(0) & 0x1)
/* was flipone(i,j); */
			doflip(i,j);
		}
	}
#endif
	for (i=0; i<count; i++)
	{
		for (j=0; j<count; j++)
		{
			if (numbers[i][j])
				drawbead(i,j);
		}
	}
}

DWord PilotMain(Word cmd, Ptr cmdPBP, Word launchFlags)
{
	EventType e;
	short err;
	int x, y;
	unsigned long appid = 0x5467676c;	/* Tggl */
	Int version = 0;

	if (cmd == sysAppLaunchCmdNormalLaunch)
	{


		if (!PrefGetAppPreferences(appid,version,numbers,sizeof(numbers)))
		{
			for (x = 0; x<count; x++)
				for (y = 0; y<count; y++)
					numbers[x][y] = 0;
		}
		FrmGotoForm(MainForm);
		while(1)
		{
			EvtGetEvent(&e, evtWaitForever);
			if (SysHandleEvent(&e))
				continue;
			if (MenuHandleEvent((void *)0, &e, &err))
				continue;
			switch(e.eType)
			{
				case frmLoadEvent:
					FrmSetActiveForm(FrmInitForm(e.data.frmLoad.formID));
					break;
				case frmOpenEvent:
					FrmDrawForm(FrmGetActiveForm());
					drawframe();
					break;
				case frmUpdateEvent:
					FrmDrawForm(FrmGetActiveForm());
					drawframe();
					break;
				case appStopEvent:
					PrefSetAppPreferences(appid,version,numbers,sizeof(numbers));
					return(0);
				case penDownEvent:
					x = e.screenX;
					y = e.screenY;
					if ((x > xmin) && (x < xmax) &&
					    (y > ymin) && (y < ymax)) {
						x = (x-xmin)/space;
						y = (y-ymin)/space;
						doflip(x,y);
						if (donetest())
						{
							FrmAlert(1002);
							randomize();
						}
					} else {
						FrmHandleEvent(FrmGetActiveForm(), &e);
					}
					break;
				case menuEvent:
					switch(e.data.menu.itemID) {
						case 5000:
							randomize();
							break;
						case 5002:
							FrmAlert(1001);
							break;
					}
					break;
				default:
					FrmHandleEvent(FrmGetActiveForm(), &e);
			}
		}
	}
	else
	{
		return(sysErrParamErr);
	}
	return 0;
}
