/*
** makedata_diary.h - Oblique Strategies from Eno's diary header
**
** Copyright 1998, Lonnon Foster <lonnief@pobox.com>
** All rights reserved.
**
** The original Oblique Strategies are Copyright 1975, 78, 79
** by Brian Eno and Peter Schmidt.
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (see LICENSE.TXT); if not, write to the
** Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
** USA.
**
** Created 30 June, 1998.  Last edited 7 July, 1998.
*/

/* Resource constants */
#define makedataAppID   'LFmd'
#define obstratAppID    'LFos'
#define obstratDBType   'Data'
#define obstratVersion  01

/* Application prefs structure */
typedef struct 
{
    short CurrNo;  /* The current Oblique Strategy selected */
} ObStratPrefs;


/* Maximum number of Oblique Strategies and the length of the longest */
/*  one, plus terminating null */

#define MAXNO        16
#define MAXLINE      113

/* Oblique Strategies from Eno's diary */

static char ObStrat[MAXNO][MAXLINE] =
{
    "Steal a solution",
    "Describe the landscape in which this belongs",
    "What else is this like?",
    "List the qualities it has.  List those you'd like.",
    "Instead of changing the thing, change the world around it",
    "What would make this really successful?",
    "Who would make this really successful?",
    "How would you explain this to your parents?",
    "Try faking it. - from Stewart Brand",
    "What were the branch points in the evolution of this entity",
    "Back up a few steps.  What else could you have done?",
    "When is it for?  Who is it for?",
    "What do you do?  Now, what do you do best?",
    "First work alone, then work in unusual pairs",
    "What most recently impressed you?  How is it similar?  What can you learn from it?  What could you take from it?",
    "Take away as much mystery as possible.  What is left?"
};
