#include <stdio.h>
#include <memory.h>
#include <ctype.h>
#include <string.h>

#include <sys/types.h>
#include <sys/time.h>

#include <pi-file.h>

struct pi_file * pdb;
FILE *csv;
unsigned char appInfo[2048];

void csv_to_array(char * str, char **array)
{
    char *p;
    int i;

    i = 0;
    while (*str) {
	/* Skip leading whitespace. */
	while (*str && isspace(*str)) str++;

	p = str;
	while (*str && *str != ',') str++;
	array[i] = p;
	i++;
	if (! *str)
	    break;
	else
	    *str++ = '\0';
    }
    array[i] = NULL;
}

void output_appinfo(void)
{
    char buf[256], *array[32];
    unsigned char *p;
    int numFields, i;

    if (fgets(&buf[0], sizeof(buf), csv) == NULL) {
	fprintf(stderr, "unable to read header line from file\n");
	exit(1);
    }
    if (buf[strlen(buf)-1] == '\n') buf[strlen(buf)-1] = '\0';
    csv_to_array(buf, array);

    numFields = 0;
    while (array[numFields])
	numFields++;

    p = &appInfo[0];

    set_short(p, numFields);
    p += 2;

    for (i = 0; i < 16; i++) {
	if (i < numFields) {
	    set_short(p, 0); /* type */
	    p += 2;
	    memset(p, 0, 32); /* name */
	    strncpy(p, array[i], 31);
	    p += 32;
	    set_short(p, 32); /* length */
	    p += 2;
	    set_short(p, 80); /* width */
	    p += 2;
	} else {
	    set_short(p, 0); /* type */
	    p += 2;
	    memset(p, 0, 32); /* name */
	    p += 32;
	    set_short(p, 32); /* length */
	    p += 2;
	    set_short(p, 80); /* width */
	    p += 2;
	}
    }

    pi_file_set_app_info(pdb, &appInfo[0], p - appInfo);
}

void output_records(void)
{
    char buf[256], *array[32];
    unsigned char rec[512], *p;
    int i,j;

    memset(rec, 0, sizeof(rec));

    j = 0;
    while (fgets(buf, sizeof(buf), csv) != NULL) {
	if (buf[strlen(buf)-1] == '\n') buf[strlen(buf)-1] = '\0';
	csv_to_array(buf, array);
	p = &rec[0];
	for (i = 0; array[i] != NULL; i++) {
	    strcpy(p, array[i]);
	    p += strlen(array[i]) + 1;
	}
	if (pi_file_append_record(pdb, rec, p - rec, 0, 0, j) != 0) {
	    fprintf(stderr, "unable to append record to pdb\n");
	    exit(1);
	}
	j++;
    }
}

int main(int argc, char **argv)
{
    struct DBInfo info;

    if (argc != 4) {
	printf("usage: %s CSV PDB NAME\n");
	exit(0);
    }

    if ((csv = fopen(argv[1], "r")) == NULL) {
	fprintf(stderr, "%s: unable to open csv file\n", argv[0]);
	exit(1);
    }

    memset(&info, 0, sizeof(info));
    info.type = 'DB99';
    info.creator = 'DBOS';
    time(&info.createDate);
    time(&info.modifyDate);
    time(&info.backupDate);
    strcpy(info.name, argv[3]);

    pdb = pi_file_create(argv[2], &info);
    if (!pdb) {
	fprintf(stderr, "%s: unable to create pdb file\n", argv[0]);
	exit(1);
    }

    output_appinfo();
    output_records();

    pi_file_close(pdb);
}
