#ifndef _DBFMT_H
#define _DBFMT_H

#define DBTypeID 'DB99'
#define dbMaxFields 16

typedef struct
{
    Word type;
    Char name[32];
    Word length;
    Word colwidth;
} DBFieldInfoType;

typedef DBFieldInfoType * DBFieldInfoPtr;

typedef struct
{
    int numFields;
    DBFieldInfoType fields[dbMaxFields];
} DBInfoType;

typedef DBInfoType * DBInfoPtr;

typedef struct
{
    DBInfoType dbinfo;
} DBAppInfoType;

typedef DBAppInfoType * DBAppInfoPtr;

/*
 * Each record is stored packed in the Pilot database. We unpack them
 * into a magical structure.
 */

typedef struct
{
    CharPtr field[dbMaxFields];
} DBRecordType;

typedef DBRecordType * DBRecordPtr;

#endif
