/* ----------------------------------------------------- */
/* Buzzword Generator                                    */
/* Dave MacLeod <davmac@netcomuk.co.uk>                  */
/*                                                       */
/* This app loads arrays with industry standard bullshit */
/* and then loops round generating meaningless babble    */
/* (as championed by consultancies the world over) by    */
/* choosing a word at random from each of the arrays.    */
/*                                                       */
/* I've used the source code from "Money" as a template, */
/* along with bits chopped out of the examples that come */
/* with GCC.                                             */
/* ----------------------------------------------------- */
/* v0.1     21/04/97    Creation                         */
/* ----------------------------------------------------- */
/* v0.2     27/04/97    Addition of "About box"          */
/*                      Copy text to clipboard           */
/* ----------------------------------------------------- */
/* v0.3     03/06/97    Fix randomisation bug            */
/* ----------------------------------------------------- */
/* v0.4     05/06/97    Add new words suggested by Peter */
/*                      Allwin.                          */
/* ----------------------------------------------------- */
/* v0.5     05/06/97    Add new words suggested by       */
/*                      Clym_Escudero@idx.com            */
/* ----------------------------------------------------- */
/* v0.6     17/07/97    Add more new words suggested by  */
/*                      Clym_Escudero@idx.com            */
/* ----------------------------------------------------- */

#pragma pack(2)
#include <System/SysAll.h>
#include <UI/UIAll.h>

#define MainForm     1000
#define aboutBuzz    2000
#define menuBuzz     3000
#define menuAbout    3001
#define menuDel      3003

#define MaxE1        62
#define MaxE2        69
#define MaxE3        83
#define MaxC1        19
#define MaxC2        20
#define MaxC3        24

/* ----------------------------------------------------- */
/* Global Variables                                      */
/* ----------------------------------------------------- */

static Char Word1[MaxE1][MaxC1] =
{
  "Exclusive",
  "Total",
  "Fundamental",
  "Phased",
  "Integrated",
  "Object-based",
  "Devolved",
  "Distributed",
  "Right-sized",
  "Decentralized",
  "Centralized",
  "Ameliorated",
  "Digitized",
  "Networked",
  "Focused",
  "Synergized",
  "Polarised",
  "Advanced",
  "Assimilated",
  "Optional",
  "Synchronised",
  "Compatible",
  "Function-based",
  "Future-proofed",
  "Managed",
  "Organised",
  "Up-sized",
  "Down-sized",
  "Mandatory",
  "Customer-focused",
  "Business-focused",
  "Profit-focused",
  "Standalone",
  "Organic",
  "Quality-focused",
  "Secured",
  "Extended",
  "Cloned",
  "Balanced",
  "Reverse-Engineered",
  "Syngergistic",
  "Vision-oriented",
  "Enterprise-wide",
  "De-engineered",
  "Cross-group",
  "Re-engineered",
  "Open-architected",
  "Front-line",
  "Optimized",
  "Grass-roots",
  "Horizontal",
  "Multi-tiered",
  "Team oriented ",
  "Face to face",
  "Versatile",
  "Progressive",
  "Persevering",
  "Diverse",
  "Automated",
  "Proactive",
  "Reactive",
  "Realigned"
};

static Char Word2[MaxE2][MaxC2] =
{
  "client-server",
  "didactic",
  "radial",
  "user-facing",
  "eco-centric",
  "uniform",
  "composite",
  "holistic",
  "stable",
  "coherent",
  "discrete",
  "heuristic",
  "hybrid",
  "modular",
  "optimal",
  "homogeneous",
  "incremental",
  "logistical",
  "mobile",
  "dynamic",
  "executive",
  "RAD/JAD",
  "human-resource",
  "empowering",
  "vertical",
  "cohesive",
  "systematic",
  "responsive",
  "reciprocal",
  "transitional",
  "human-resource",
  "3rd generation",
  "4th generation",
  "5th generation",
  "scalable",
  "fault-tolerant",
  "WYSIWYG",
  "local",
  "national",
  "global",
  "regional",
  "neural",
  "24hr",
  "value-added",
  "multimedia",
  "systematic",
  "maximized",
  "clear-thinking",
  "optimizing",
  "motivating",
  "well-modulated",
  "fresh-thinking",
  "keen",
  "even-keeled",
  "upward-trending",
  "methodical",
  "tangible",
  "bottom-line",
  "actuating",
  "analyzing",
  "encompassing",
  "exuding",
  "solution-oriented",
  "attitude-oriented",
  "client driven",
  "needs based",
  "zero administration",
  "zero tolerance",
  "zero defect"
};

static Char Word3[MaxE3][MaxC3] =
{
  "hub",
  "paradigm",
  "concept",
  "contingency",
  "flexibility",
  "methodology",
  "project",
  "definition",
  "projection",
  "task-force",
  "moderator",
  "implementation",
  "structure",
  "ability",
  "scenario",
  "challenge",
  "solution",
  "installation",
  "knowledgebase",
  "inheritance",
  "throughput",
  "approach",
  "alliance",
  "implementation",
  "data-warehouse",
  "migration",
  "interface",
  "moratorium",
  "parallelism",
  "monitoring",
  "policy",
  "capability",
  "middleware",
  "hardware",
  "software",
  "GUI",
  "LAN/WAN",
  "intranet",
  "toolset",
  "product",
  "support",
  "help-desk",
  "groupware",
  "hit-squad",
  "model",
  "orchestration",
  "emulation",
  "collaboration",
  "focus group",
  "success",
  "conglomeration",
  "attitude",
  "pricing structure",
  "workforce flexibility",
  "synergy",
  "system engine",
  "alliance",
  "utilization",
  "GUI",
  "open architecture",
  "open system",
  "initiative",
  "knowledge user",
  "superstructure",
  "frame",
  "customer loyalty",
  "productivity",
  "flex-time",
  "framework",
  "complexity",
  "protocol",
  "matrix",
  "matrices",
  "core",
  "website",
  "process improvement",
  "business partner",
  "leverage",
  "executive solution",
  "secured line",
  "artificial intelligence",
  "bugetary management",
  "forecast"
};

/* ----------------------------------------------------- */
/* RandN                                                 */
/*   This function generates a random number between 0   */
/*   and MaxNo                                           */
/* Parms                                                 */
/*   MaxNo - Maximum number to be returned               */
/* Returns                                               */
/*   A random integer                                    */
/* ----------------------------------------------------- */

int RandN(int MaxNo)
{
  return((int)(((double)SysRandom(0) * (double)MaxNo) / (double)sysRandomMax));
}

/* ----------------------------------------------------- */
/* DisplayWord                                           */
/*   This function wallops the buzzword out onto the     */
/*   screen.                                             */
/* Parms                                                 */
/*   None                                                */
/* Returns                                               */
/*   Nowt                                                */
/* ----------------------------------------------------- */

void DisplayWord(void)
{
  RectangleType rect;
  char tmp1[MaxC1];
  char tmp2[MaxC2];
  char tmp3[MaxC3];
  char tmp[MaxC1+MaxC2+MaxC3+3];
  SWord xpos;
  SWord ypos = 40;
  SWord yd = 19;

  rect.topLeft.x=10;
  rect.topLeft.y=20;
  rect.extent.x=140;
  rect.extent.y=100;
  WinEraseRectangle(&rect,0);

  StrCopy(tmp1,Word1[RandN(MaxE1)]);
  StrCopy(tmp2,Word2[RandN(MaxE2)]);
  StrCopy(tmp3,Word3[RandN(MaxE3)]);

  xpos = (160 - FntCharsWidth(tmp1,StrLen(tmp1))) / 2;
  WinDrawChars(tmp1,StrLen(tmp1),xpos,ypos);
  ypos = ypos + yd;

  xpos = (160 - FntCharsWidth(tmp2,StrLen(tmp2))) / 2;
  WinDrawChars(tmp2,StrLen(tmp2),xpos,ypos);
  ypos = ypos + yd;

  xpos = (160 - FntCharsWidth(tmp3,StrLen(tmp3))) / 2;
  WinDrawChars(tmp3,StrLen(tmp3),xpos,ypos);
  ypos = ypos + yd;

  StrCopy(tmp,tmp1);
  StrCat(tmp," ");
  StrCat(tmp,tmp2);
  StrCat(tmp," ");
  StrCat(tmp,tmp3);
  ClipboardAddItem(clipboardText,tmp,StrLen(tmp));
}

/* ----------------------------------------------------- */
/* MainViewHandleEvent                                   */
/*   This function loads a form and set the event        */
/*   handler for the form.                               */
/* Parms                                                 */
/*   event - Pointer to an event type structure          */
/* Returns                                               */
/*   True - if the event has been dealt with             */
/* ----------------------------------------------------- */

static Boolean MainViewHandleEvent(EventPtr event)
{
  Boolean handled = false;

  switch (event->eType)
  {
    case frmOpenEvent:
      FrmDrawForm(FrmGetActiveForm());
      DisplayWord();
      handled = true;
      break;
/*    case ctlSelectEvent:
      if (event->data.ctlEnter.controlID == GenButton)
      {
        DisplayWord();
        handled = true;
      }
      break; */
    case penUpEvent:
      DisplayWord();
      handled = true;
      break;
    case menuEvent:
      MenuEraseStatus(0);
      switch (event->data.menu.itemID)
      {
        case menuAbout:
          FrmAlert(aboutBuzz);
          handled = true;
          break;
      }
      handled = true;
      break;
  }
  return(handled);
}


/* ----------------------------------------------------- */
/* ApplicationHandleEvent                                */
/*   This function loads a form and set the event        */
/*   handler for the form.                               */
/* Parms                                                 */
/*   event - Pointer to an event type structure          */
/* Returns                                               */
/*   True - if the event has been dealt with             */
/* ----------------------------------------------------- */

static Boolean ApplicationHandleEvent(EventPtr event)
{
  FormPtr frm;
  Int formId;
  Boolean handled = false;

  if (event->eType == frmLoadEvent)
  {
    formId = event->data.frmLoad.formID;
    frm = FrmInitForm(formId);
    FrmSetActiveForm(frm);
    FrmSetEventHandler(frm, MainViewHandleEvent);
    handled = true;
  }
  return handled;
}

/* ----------------------------------------------------- */
/* StartApplication                                      */
/*   Initialisation etc.                                 */
/* Parms                                                 */
/*   None                                                */
/* Returns                                               */
/*   Nowt                                                */
/* ----------------------------------------------------- */

static Boolean StartApplication(void)
{
  FntSetFont (largeFont);
  SysRandom (TimGetTicks());
  return false;
}

/* ----------------------------------------------------- */
/* StopApplication                                       */
/*   Like my Mum used to say "Tidy up after yourself".   */
/* Parms                                                 */
/*   None                                                */
/* Returns                                               */
/*   Nowt                                                */
/* ----------------------------------------------------- */

static void StopApplication(void)
{
  FrmCloseAllForms ();
}

/* ----------------------------------------------------- */
/* EventLoop                                             */
/*   This function gets events from the Event Manager,   */
/*   passes them to the system, menu and application     */
/*   event handlers before passing them onto our own     */
/*   processing.                                         */
/* Parms                                                 */
/*   None                                                */
/* Returns                                               */
/*   Nowt                                                */
/* ----------------------------------------------------- */

static void EventLoop(void)
{
  EventType event;
  Word error;
  do
  {
    EvtGetEvent(&event, evtWaitForever);
    if (! SysHandleEvent(&event))
      if (! MenuHandleEvent(NULL, &event, &error))
        if (! ApplicationHandleEvent(&event))
          FrmDispatchEvent(&event);
  }
  while (event.eType != appStopEvent);
}


/* ----------------------------------------------------- */
/* PilotMain                                             */
/*   Equivalent of the normal C Main(), it starts the    */
/*   execution of the application.                       */
/* Parms                                                 */
/*   cmd - command specifying how to launch the app      */
/*   cmdPBP - parameter block for the command            */
/*   launchFlags - flags used to config the launch       */
/* Returns                                               */
/*   An applicable error code                            */
/* ----------------------------------------------------- */

DWord PilotMain(Word cmd, Ptr cmdPBP, Word launchFlags)
{
Int err;

    if (cmd == sysAppLaunchCmdNormalLaunch)
    {
      err=StartApplication();
      if(err)
        return(err);
      FrmGotoForm(MainForm);
      EventLoop();
      StopApplication();
    }
    return 0;
}
