/* Abacus for Pilot
 * Copyright 1998 Jon Leonard jleonard@slimy.com
 * Freeware (see License file for details)
 */

#pragma pack(2)

#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>

#include "abacusid.h"
#include "abacus.h"

void undrawbead(int x, int y)
{
	RectangleType rect;
	Word diam;

	x = x*xspace+xmin;
	y = y*yspace+ymin;

	rect.topLeft.x = x;
	rect.topLeft.y = y;
	rect.extent.x = 12;
	rect.extent.y = 8;
	diam = 0;
	
	WinEraseRectangle(&rect,0);
	WinDrawLine(x+5,y  ,x+5,y+7);
	WinDrawLine(x+6,y  ,x+6,y+7);
}

void drawbead(int x, int y)
{
#ifdef BEAD_DOTS
	int flag;

	flag = (y == 7) || (y == 12);
#endif
	x = x*xspace+xmin;
	y = y*yspace+ymin;

	WinDrawLine(x+3,y+1,x+ 8,y+1);
	WinDrawLine(x+2,y+2,x+ 9,y+2);
	WinDrawLine(x+1,y+3,x+10,y+3);
	WinDrawLine(x+1,y+4,x+10,y+4);
	WinDrawLine(x+2,y+5,x+ 9,y+5);
	WinDrawLine(x+3,y+6,x+ 8,y+6);
#ifdef BEAD_DOTS
	if (flag)
	{
		WinEraseLine(x+5,y+3,x+ 6,y+3);
		WinEraseLine(x+5,y+4,x+ 6,y+4);
	}
#endif
}

char numbers[columns];

void donumber(int x, int y)
{
	int i, j;

	switch (y)
	{
		case 0:
		case 1:
			i = numbers[x]/16;
			if (y+i > 1)
				i = 1-y;
			else
				i = 2-y;
			numbers[x] = numbers[x]%16 + i*16;
			break;
		case 2:
		case 3:
			i = numbers[x]/16;
			if (y+i > 3)
				i = 3-y;
			else
				i = 4-y;
			numbers[x] = numbers[x]%16 + i*16;
			break;
		case 4:
			numbers[x] = 0;
			break;
		case 5:
		case 6:
		case 7:
		case 8:
		case 9:
			i = numbers[x] % 16;
			if (y-4 > i)
				i = y-4;
			else
				i = y-5;
			numbers[x] = (numbers[x] & 0xf0) + i;
			break;
		case 10:
		case 11:
		case 12:
		case 13:
		case 14:
			i = numbers[x] % 16;
			if (y-9 > i)
				i = y-9;
			else
				i = y-10;
			numbers[x] = (numbers[x] & 0xf0) + i;
			break;
	}

	i = numbers[x]%16;
	for (j = 0; j < 5; j++)
	{
		if (i > j)
		{
			drawbead(x,j+5);
			undrawbead(x,j+10);
		}
		else
		{
			undrawbead(x,j+5);
			drawbead(x,j+10);
		}
	}
	i = numbers[x]/16;
	for (j = 0; j < 2; j++)
	{
		if (i > j)
		{
			drawbead(x,3-j);
			undrawbead(x,1-j);
		}
		else
		{
			undrawbead(x,3-j);
			drawbead(x,1-j);
		}
	}
}

void drawframe(void)
{
	int i,j,n;

	for (i=1; i<width; i++)
	{
		WinDrawLine(xmin-i, ymin-i, xmin-i, ymax+i);
		WinDrawLine(xmax+i, ymin-i, xmax+i, ymax+i);
		WinDrawLine(xmin-i, ymin-i, xmax+i, ymin-i);
		WinDrawLine(xmin-i, ymax+i, xmax+i, ymax+i);
		/* and the crossbar */
		WinDrawLine(xmin, ybar+1+i, xmax, ybar+1+i);
	}
	for (i=xmin; i<xmax; i+=xspace)
	{
		WinDrawLine(i+5,ymin,i+5,ymax);
		WinDrawLine(i+6,ymin,i+6,ymax);
	}
#ifdef COL_DOTS
	for (i=xmin+3*xspace; i<xmax; i+=3*xspace)
	{
		WinEraseLine(i+5,ybar+3,i+ 6,ybar+3);
		WinEraseLine(i+5,ybar+4,i+ 6,ybar+4);
	}
#endif
	for (i=0; i<columns; i++)
	{
		n = numbers[i]/16;
		for (j = 0; j<2; j++)
		{
			if (j < 2-n)
			{
				drawbead(i,j);
			} else {
				drawbead(i,j+2);
			}
		}
		n = numbers[i]%16;
		for (j = 0; j<5; j++)
		{
			if (j < n)
			{
				drawbead(i,j+5);
			} else {
				drawbead(i,j+10);
			}
		}
	}
}

DWord PilotMain(Word cmd, Ptr cmdPBP, Word launchFlags)
{
	EventType e;
	short err;
	int x, y;
	unsigned long appid = 0x41626163;	/* Abac */
	Int version = 0;

	if (cmd == sysAppLaunchCmdNormalLaunch)
	{
		if (!PrefGetAppPreferences(appid,version,numbers,sizeof(numbers)))
		{
			for (x = 0; x<columns; x++)
				numbers[x] = 0;
		}
		FrmGotoForm(MainForm);
		while(1)
		{
			EvtGetEvent(&e, evtWaitForever);
			if (SysHandleEvent(&e))
				continue;
			if (MenuHandleEvent((void *)0, &e, &err))
				continue;
			switch(e.eType)
			{
				case frmLoadEvent:
					FrmSetActiveForm(FrmInitForm(e.data.frmLoad.formID));
					break;
				case frmOpenEvent:
					FrmDrawForm(FrmGetActiveForm());
					drawframe();
					break;
				case frmUpdateEvent:
					FrmDrawForm(FrmGetActiveForm());
					drawframe();
					break;
				case appStopEvent:
					PrefSetAppPreferences(appid,version,numbers,sizeof(numbers));
					return(0);
				case penDownEvent:
					x = e.screenX;
					y = e.screenY;
					if ((x > xmin) && (x < xmax) &&
					    (y > ymin) && (y < ymax))
					{
						x = (x-xmin)/xspace;
						y = (y-ymin)/yspace;
						donumber(x,y);
					}
					break;
				case penMoveEvent:
					x = e.screenX;
					y = e.screenY;
					if ((x > xmin) && (x < xmax) &&
					    (y > ymin) && (y < ymax))
					{
						x = (x-xmin)/xspace;
						y = (y-ymin)/yspace;
						if (y == 4)
							donumber(x,y);
					}
					break;
				case penUpEvent:
					break;
				case menuEvent:
					switch(e.data.menu.itemID) {
						case 5000:
							for (x = 0; x<columns; x++)
								donumber(x,4);
							break;
						case 5002:
							FrmAlert(1001);
							break;
						default:
							break;
					}
					break;
				default:
					FrmHandleEvent(FrmGetActiveForm(), &e);
			}
		}
	}
	else
	{
		return(sysErrParamErr);
	}
	return 0;
}
