//---------------------------------------------------------------------------

	// SYSTEM HEADER FILES //

#include <Pilot.h>
#include <ErrorMgr.h>
#include <Password.h>

	// PROJECT HEADER FILES //
	
#include "TransitRsrc.h"

//---------------------------------------------------------------------------

	 // FUNCTION PROTOTYPES //
	
DWord		PilotMain (Word, Ptr, Word);
Boolean		StartApplication (DWord, Word);
void		StopApplication (void);
void		EventLoop (void);
VoidPtr		GetObjectPtr (Int objectID);
Boolean		DoPopupList (Word lstID, Word popID, char** items, UInt nItems,
				UInt maxHeight, UInt* current);
Boolean		ApplicationHandleEvent (EventPtr);
Boolean		AboutFormHandleEvent (EventPtr);
Boolean		MainFormHandleEvent (EventPtr);
Boolean		MainFormSwitchDatabase (UInt);
void		MainFormDoCategoryPopup (void);
void		MainFormDoDatabasePopup (void);
void		MainFormOpen (FormPtr);
void		MainFormClose (FormPtr);
void		MainFormLoadTable (UInt);
void		MainFormScroll (Int, Int);
void		MemoPadDrawProc (VoidPtr, Word, Word, RectanglePtr);
void		AddressDrawProc (VoidPtr, Word, Word, RectanglePtr);
void		ToDoDrawProc (VoidPtr, Word, Word, RectanglePtr);
Boolean		ActionMove (void);
//Boolean		ActionDuplicate (void);
Boolean		ActionDelete (void);
Boolean		SeekRecord (UIntPtr, Int, Int);
void		TogglePrivateRecords (void);

//---------------------------------------------------------------------------

	// TYPE DEFINITIONS //

typedef struct
{
	CharPtr					name;
	TableDrawItemFuncPtr	draw;
}
DBINFO;

//---------------------------------------------------------------------------

	// GLOBAL VARIABLES //

#define		ASSERT(c)		ErrFatalDisplayIf(!(c),#c)
#define		CARD_ZERO		0
#define		NONAME			"-Unnamed-"
#define		REQUIRED_ROM_VERSION	0x02000000	// PalmOS 2.0

#define		NUM_DBS	(sizeof (dbNames) / sizeof (CharPtr))
CharPtr		dbNames [] = {
	"Address Book",
	"Memo Pad",
	"To Do List",
	};
DBINFO		dbInfos [] = {
	{ "AddressDB",	AddressDrawProc		},
	{ "MemoDB",		MemoPadDrawProc		},
	{ "ToDoDB",		ToDoDrawProc		},
	};
UInt		currentDB;
DmOpenRef	currentRef;
Word		catFrom, catDest;
UInt		topRecord;
UInt		numRecords, totalRecords;
UInt		dbOpenMode;
VoidHand	recordBits;
Boolean		saveArchive;
Boolean		hideSecretRecords;
DWord		RomVersion;

#define		BITMASK(i)		(1 << (7 - ((i) & 0x7))) 
#define		BITINDEX(i)		((i) >> 3)
#define		BITVALUE(p,i)	(p [ BITINDEX(i) ] &   BITMASK(i))
#define		BITFLIP(p,i)	(p [ BITINDEX(i) ] ^=  BITMASK(i))
#define		BITCLEAR(p,i)	(p [ BITINDEX(i) ] &= ~BITMASK(i))
#define		BITSET(p,i)		(p [ BITINDEX(i) ] |=  BITMASK(i))

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

DWord
PilotMain (Word cmd, Ptr cmdPBP, Word launchFlags)
{
	if (sysAppLaunchCmdNormalLaunch == cmd)
		{
		if (StartApplication (REQUIRED_ROM_VERSION, launchFlags))
			{
			FrmGotoForm (MainForm);
			EventLoop ();
			StopApplication ();
			}
		else
			{
			//	currently, this is only reason to fail StartApplication()
			return (sysErrRomIncompatible);
			}
		}
		
	return (0);
}

//---------------------------------------------------------------------------

Boolean
StartApplication (DWord requiredVersion, Word launchFlags)
{
	SystemPreferencesType sysPrefs;

	currentDB    = -1;
	currentRef   = 0;
	numRecords   = 0;	
	totalRecords = 0;
	recordBits   = NULL;
	saveArchive  = true;
	
	//	check ROM version; still not ready for PalmOS 1.0 yet
	//	both PalmOS 2.0 & 3.0 seem okay
	FtrGet (sysFtrCreator, sysFtrNumROMVersion, &RomVersion);
	if (RomVersion < REQUIRED_ROM_VERSION)
		{
		if ((launchFlags & (sysAppLaunchFlagNewGlobals | sysAppLaunchFlagUIApp)) ==
			(sysAppLaunchFlagNewGlobals | sysAppLaunchFlagUIApp))
			{
			FrmAlert (RomIncompatibleAlert);
		
			// Pilot 1.0 will continuously relaunch this app unless we switch to 
			// another safe one.  The sysFileCDefaultApp is considered "safe".
			if (RomVersion < 0x02000000)
				{
				Err	err;
				AppLaunchWithCommand(sysFileCDefaultApp, sysAppLaunchCmdNormalLaunch,
					NULL);
				}
			}
		
		return (false);
		}
		
	//	we're ROM caompatible; continue as normal
	PrefGetPreferences (&sysPrefs);
	hideSecretRecords = sysPrefs.hideSecretRecords;
	if (hideSecretRecords)
		dbOpenMode = dmModeReadWrite;
	else
		dbOpenMode = dmModeReadWrite | dmModeShowSecret;
	
	return (true);
}

//---------------------------------------------------------------------------

void
StopApplication (void)
{
	if (recordBits)
		{
		MemHandleFree (recordBits);
		recordBits = NULL;
		}

	FrmCloseAllForms ();
}

//---------------------------------------------------------------------------

void
EventLoop (void)
{
	EventType	event;
	Word		error;
	
	do	{
		EvtGetEvent (&event, evtWaitForever);
		
		if (! SysHandleEvent (&event))
			{
			if (! MenuHandleEvent (0, &event, &error))
				{
				if (! ApplicationHandleEvent (&event))
					{
					FrmDispatchEvent (&event);
					}
				}
			}
		}
	while (appStopEvent != event.eType);
}

//---------------------------------------------------------------------------

VoidPtr
GetObjectPtr (Int objectID)
{
	FormPtr frm;
	
	frm = FrmGetActiveForm();
	return (FrmGetObjectPtr (frm, FrmGetObjectIndex (frm, objectID)));
}

//---------------------------------------------------------------------------

Boolean
DoPopupList (Word lstID, Word popID, char** items, UInt nItems,
	UInt maxHeight, UInt* current)
{
	ListPtr		listP;
	UInt		selection;
	
	listP = (ListPtr) GetObjectPtr (lstID);
	
	LstSetListChoices (listP, items, nItems);
	LstSetHeight (listP, (nItems <= maxHeight ? nItems : maxHeight));
	LstSetSelection (listP, *current);
	
	selection = LstPopupList (listP);
	if (-1 != selection  &&  *current != selection)
		{
		CtlSetLabel (GetObjectPtr (popID), items[selection]);
		*current = selection;
		
		//	Indicate that a new selection was chosen.
		return (true);
		}
		
	//	No new selection was made.
	return (false);
}		

//---------------------------------------------------------------------------

Boolean
ApplicationHandleEvent (EventPtr event)
{
	Boolean		eventHandled = false;

	if (frmLoadEvent == event->eType)
		{
		Int			formID;
		FormPtr		frm;
		
		formID = event->data.frmLoad.formID;
		frm = FrmInitForm (formID);
		FrmSetActiveForm (frm);
		
		switch (formID)
			{
			case MainForm:
				FrmSetEventHandler (frm, MainFormHandleEvent);
				break;

			case AboutForm:
				FrmSetEventHandler (frm, AboutFormHandleEvent);
				break;
			}
			
		eventHandled = true;
		}
		
	return (eventHandled);
}

//---------------------------------------------------------------------------

Boolean
AboutFormHandleEvent (EventPtr event)
{
	Boolean		eventHandled = false;

	if (ctlSelectEvent == event->eType)
		{
   		switch (event->data.ctlEnter.controlID)
   			{
   			case AboutOKButton:
				FrmReturnToForm (0);
				eventHandled = true;
				break;
			}
		}
		
	else if (frmOpenEvent == event->eType)
		{
		FormPtr		frm;
		
		frm = FrmGetActiveForm ();
		FrmDrawForm (frm);
		eventHandled = true;
		}

	return (eventHandled);
}

//---------------------------------------------------------------------------

void
ToDoDrawProc (VoidPtr table, Word row, Word col, RectanglePtr bnds)
{
	Word		recordNum;
	Handle		memoH;
	CharPtr		memoP;
	short		x, y, width, titleWidth;
	Boolean		stringFit;
	Int			titleLen;
	Word		charsToDraw;
	CharPtr		string;
		
	recordNum = TblGetRowID (table, row);
	
	memoH = DmQueryRecord (currentRef, recordNum);
	memoP = MemHandleLock (memoH);
	
	x     = bnds->topLeft.x + 1;
	y     = bnds->topLeft.y;
	width = bnds->extent.x - x + 12;
	
	memoP += sizeof (DateType);			// skip over dueDate
	memoP += sizeof (unsigned char);	// skip over priority

	// memoP now points to the description field
	string = (*memoP ? memoP : NONAME);
	charsToDraw = StrLen(string);
		
	titleWidth = width;
	titleLen = charsToDraw;
	FntCharsInWidth (string, &titleWidth, &titleLen, &stringFit);

	if (stringFit)
		{
		WinDrawChars (string, titleLen, x, y);
		}
	else
		{
		width -= (FntCharWidth ('.') * 3);
		while (titleWidth > width || 
			string[titleLen - 1] == ' ' || 
			string[titleLen - 1] == tabChr)
			{
			titleWidth -= FntCharWidth (string[--titleLen]);
			}
		WinDrawChars (string, titleLen, x, y);
		x += titleWidth;
		WinDrawChars ("...", 3, x, y);
		}
		
	MemHandleUnlock (memoH);
}

//---------------------------------------------------------------------------

void
AddressDrawProc (VoidPtr table, Word row, Word col, RectanglePtr bnds)
{
#define	MAXTAGLENGTH	256

	Word		recordNum;
	Handle		memoH;
	CharPtr		memoP;
	short		x, y, width, titleWidth;
	Char		string[ MAXTAGLENGTH ];
	ULong		flags;
	Boolean		hasFirst, hasLast, hasCompany;
	Boolean		stringFit;
	Int			titleLen;
	Word		charsToDraw;
	
	recordNum = TblGetRowID (table, row);
	
	memoH = DmQueryRecord (currentRef, recordNum);
	memoP = MemHandleLock (memoH);
	
	x     = bnds->topLeft.x + 1;
	y     = bnds->topLeft.y;
	width = bnds->extent.x - x + 12;
	
	memoP += sizeof (ULong);		// skip over AddrOptionsType
	flags  = * (ULong *) memoP;		// retrieve AddrDBRecordFlags
	
	hasLast		= flags & 0x01;
	hasFirst	= flags & 0x02;
	hasCompany	= flags & 0x04;
	
	memoP += sizeof (ULong) + 1;	// now pointing at first field
	
	if (!hasLast && !hasFirst && !hasCompany)
		{
		StrCopy (string, NONAME);
		charsToDraw = StrLen (string);
		}
	else 
		{
		StrCopy (string, memoP);
		if (hasLast && hasFirst)
			{
			memoP += StrLen(memoP) + 1;
			StrCat (string, ", ");
			StrCat (string, memoP);
			}
		charsToDraw = StrLen (string);
		}
	
	titleWidth = width;
	titleLen = charsToDraw;
	FntCharsInWidth (string, &titleWidth, &titleLen, &stringFit);

	if (stringFit)
		{
		WinDrawChars (string, titleLen, x, y);
		}
	else
		{
		width -= (FntCharWidth ('.') * 3);
		while (titleWidth > width || 
			string[titleLen - 1] == ' ' || 
			string[titleLen - 1] == tabChr)
			{
			titleWidth -= FntCharWidth (string[--titleLen]);
			}
		WinDrawChars (string, titleLen, x, y);
		x += titleWidth;
		WinDrawChars ("...", 3, x, y);
		}
		
	MemHandleUnlock (memoH);
}

//---------------------------------------------------------------------------

void
MemoPadDrawProc (VoidPtr table, Word row, Word col, RectanglePtr bnds)
{
	//	The basics are copied from MemoMain.c's ListViewDrawRecord
	//	and DrawMemoTitle.
	Word		recordNum;
	Handle		memoH;
	short		x, y, width, titleWidth;
	Int			titleLen;
	Boolean		stringFit;
	CharPtr		memoP;
	Word		charsToDraw;
	CharPtr		ptr;

	// Get the record number that corresponds to the table item to draw.
	// The record number is stored in the "intValue" field of the item.
	recordNum = TblGetRowID (table, row);

	memoH = DmQueryRecord(currentRef, recordNum);
	memoP = MemHandleLock(memoH);

	x     = bnds->topLeft.x + 1;
	y     = bnds->topLeft.y;
	width = bnds->extent.x - x + 12;
	
	// Display the memo's title, the title is the first line of the memo.
//	DrawMemoTitle (memoP, x, y, bnds->extent.x - x);

	ptr = StrChr (memoP, linefeedChr);
	if (ptr)
		charsToDraw = (Word) (ptr - memoP);
	else
		charsToDraw = StrLen (memoP);

	titleWidth = width;
	titleLen = charsToDraw;
	FntCharsInWidth (memoP, &titleWidth, &titleLen, &stringFit);

	if (stringFit)
		{
		WinDrawChars (memoP, titleLen, x, y);
		}
	else
		{
		width -= (FntCharWidth ('.') * 3);
		while (titleWidth > width || 
			memoP[titleLen - 1] == ' ' || 
			memoP[titleLen - 1] == tabChr)
			{
			titleWidth -= FntCharWidth (memoP[--titleLen]);
			}
		WinDrawChars (memoP, titleLen, x, y);
		x += titleWidth;
		WinDrawChars ("...", 3, x, y);
		}

	MemHandleUnlock(memoH);
}

//---------------------------------------------------------------------------

Boolean
MainFormSwitchDatabase (UInt index)
{
	LocalID		dbID;
	DmOpenRef	dbRef;
	TablePtr	table;
	Err			error;
	VoidPtr		pMem;

	ASSERT(index < NUM_DBS);
	
	dbID = DmFindDatabase (CARD_ZERO, dbInfos[index].name);
	if (! dbID)
		return (false);
	
	dbRef = DmOpenDatabase (CARD_ZERO, dbID, dbOpenMode);
	if (dbRef)
		{
		if (currentRef)
			{
			DmCloseDatabase (currentRef);
			}
		currentRef = dbRef;

		if (index != currentDB)
			{
			currentDB = index;
			catFrom = dmAllCategories;
	//		CategoryGetName (currentRef, catDest, catName);
			CategorySetTriggerLabel (GetObjectPtr (MainCategoryPopTrigger),
	//			catName);
				"All");

			catDest = dmUnfiledCategory;
	//		CategoryGetName (currentRef, catDest, catName);
			CategorySetTriggerLabel (GetObjectPtr (MainDestinationPopTrigger),
	//			catName);
				"Unfiled");
			}
		
		numRecords   = DmNumRecordsInCategory (currentRef, catFrom);
		totalRecords = DmNumRecords (currentRef);
		if (recordBits)
			{
			error = MemHandleResize (recordBits, totalRecords / 8 + 1);
			ASSERT (error == 0);
			}
		else
			{
			recordBits = MemHandleNew (totalRecords / 8 + 1);
			}
		ASSERT (recordBits != NULL);
		pMem = MemHandleLock (recordBits);
		MemSet (pMem, totalRecords / 8 + 1, 0);
		MemHandleUnlock (recordBits);
		
		topRecord    = 0;
		DmSeekRecordInCategory (currentRef, &topRecord, 0,
			dmSeekForward, catFrom);

		table = (TablePtr) GetObjectPtr (MainEntryTable);
		TblSetCustomDrawProcedure (table, 1, dbInfos[currentDB].draw);
		}
		
	return (dbRef != 0);
}

//---------------------------------------------------------------------------

void
MainFormDoCategoryPopup (void)
{
	FormPtr		frm;
	Word		selection = catFrom;
	Boolean		changed;
	Char		categoryName [dmCategoryLength];
	
	frm = FrmGetActiveForm ();
	
	if (currentRef)
		{
		changed = CategorySelect (currentRef, frm, MainCategoryPopTrigger,
			MainCategoryList, true, &selection, categoryName, 1, 0);
			
		if (changed || selection != catFrom)
			{
			catFrom    = selection;
			numRecords = DmNumRecordsInCategory (currentRef, catFrom);
			
			topRecord   = 0;
			DmSeekRecordInCategory (currentRef, &topRecord, 0,
				dmSeekForward, catFrom);

			MainFormLoadTable (topRecord);
			}
		}
}

//---------------------------------------------------------------------------

void
MainFormDoDatabasePopup (void)
{
	UInt	chosenDB;
	
	chosenDB = currentDB;
	
	if (DoPopupList (MainDatabaseList, MainDatabasePopTrigger, dbNames,
		NUM_DBS, 8, &chosenDB))
		{
		if (MainFormSwitchDatabase (chosenDB))
			{
			//	Success in switching DB's; load the table.
			MainFormLoadTable (topRecord);
			}
		else
			{
			//	Should report to user; also need to reset the popup label.
			CtlSetLabel (GetObjectPtr (MainDatabasePopTrigger),
				dbNames[currentDB]);
			}
		}
}

//---------------------------------------------------------------------------

Boolean
SeekRecord (UIntPtr pIndex, Int offset, Int direction)
{
	DmSeekRecordInCategory (currentRef, pIndex, offset, direction, catFrom);
	if (DmGetLastErr ())
		return (false);

	return (true);
}

//---------------------------------------------------------------------------

void
MainFormScroll (Int amount, Int direction)
{
	UInt	newTopRecord;

	ASSERT(direction == dmSeekForward  ||  direction == dmSeekBackward);
	ASSERT(amount != 0);

//	if (! amount)
//		return ;

	newTopRecord = topRecord;

	if (dmSeekForward == direction)
		{
		UInt	temp;
		SeekRecord (&newTopRecord, amount, dmSeekForward);
		
		temp = newTopRecord;
		if (! SeekRecord (&temp, amount, dmSeekForward))
			{
			newTopRecord = dmMaxRecordIndex;
			if (! SeekRecord (&newTopRecord, amount, dmSeekBackward))
				{
				newTopRecord = 0;
				SeekRecord (&newTopRecord, 0, dmSeekForward);
				}
			}
		}
	else if (dmSeekBackward == direction)
		{
		if (! SeekRecord (&newTopRecord, amount, dmSeekBackward))
			{
			newTopRecord = 0;
			SeekRecord (&newTopRecord, 0, dmSeekForward);
			}
		}
		
	if (newTopRecord != topRecord)
		{
		topRecord = newTopRecord;
		MainFormLoadTable (topRecord);
		}
}

//---------------------------------------------------------------------------

void
TogglePrivateRecords (void)
{
	Boolean			hide;
	Boolean			db_reloaded;
	FormPtr			frm;
	RectangleType	r;
	VoidHand		hRsrc;
	BitmapPtr		bmap;
	
	hide = hideSecretRecords;
	frm = FrmGetActiveForm ();
	
	if (hide)
		{
		//	user trying to show hidden records
		FormPtr		alert;
		Word		fldIndex;
		Word		buttonHit;
		CharPtr		text;
		Boolean		pwdMatches;
		
		if (! PwdExists ())
			{
			hide = false;
			}
		else
			{
			alert = FrmInitForm (PasswordForm);
			fldIndex = FrmGetObjectIndex (alert, PasswordPasswordField);
			FrmSetFocus (alert, fldIndex);
			
			buttonHit = FrmDoDialog (alert);
			text = FldGetTextPtr (FrmGetObjectPtr (alert, fldIndex));
			
			if (PasswordCancelButton != buttonHit)
				{
				pwdMatches = PwdVerify (text);
				if (pwdMatches)
					hide = false;
				else
					{
					FrmAlert (BadPasswordAlert);
					}
				}
			
			FrmDeleteForm (alert);
			}
		}
	else
		{
		//	user trying to hide hidden records
		//	no need to ask for password, just do it
		hide = true;
		}

	if (hide != hideSecretRecords)
		{
		hideSecretRecords = hide;
		if (hideSecretRecords)
			dbOpenMode = dmModeReadWrite;
		else
			dbOpenMode = dmModeReadWrite | dmModeShowSecret;
		
		//	can't open the same database twice for writing; need
		//	to first close it (this should be safe enough until
		//	better code can be written) before opening with new
		//	dbOpenMode
		DmCloseDatabase (currentRef);
		currentRef = 0;

		//	this should reload the database; unfortunately at this
		//	time it will also reset the categories
		db_reloaded = MainFormSwitchDatabase (currentDB);
		ASSERT(db_reloaded);

		topRecord = 0;
		DmSeekRecordInCategory (currentRef, &topRecord, 0,
			dmSeekForward, catFrom);
		MainFormLoadTable (topRecord);

		hRsrc = DmGetResource (bitmapRsc,
			(hideSecretRecords ? PrivateBitmap : PublicBitmap));
		if (hRsrc)
			{		
			FrmGetObjectBounds (frm, FrmGetObjectIndex(frm,
				MainToggleHiddenButton), &r);
				
			bmap = MemHandleLock (hRsrc);
			WinDrawBitmap (bmap, r.topLeft.x, r.topLeft.y);
			MemHandleUnlock (hRsrc);
			DmReleaseResource (hRsrc);
			}
		}
}

//---------------------------------------------------------------------------

Boolean
MainFormHandleEvent (EventPtr event)
{
	Boolean		eventHandled = false;
	FormPtr		frm;
	Char		catName [dmCategoryLength];
	Boolean		update;
	TablePtr	table;
	
	frm   = FrmGetActiveForm ();
	table = GetObjectPtr (MainEntryTable);
	
	if (keyDownEvent == event->eType)
		{
		Word	rows = TblGetNumberOfRows (table);
		
		switch (event->data.keyDown.chr)
			{
			case pageUpChr:
				MainFormScroll (rows - 1, dmSeekBackward);
				eventHandled = true;
				break;
				
			case pageDownChr:
				MainFormScroll (rows - 1, dmSeekForward);
				eventHandled = true;
				break;
			}
		}
		
	else if (tblSelectEvent == event->eType)
		{
		ASSERT(event->data.tblSelect.tableID == MainEntryTable);
		
		if (0 == event->data.tblSelect.column)
			{
			Word		row, index;
			CharPtr		pMem;
			
			row   = event->data.tblSelect.row;
			index = TblGetRowID (table, row);
			
			pMem = MemHandleLock (recordBits);
			if (TblGetItemInt (table, row, 0))
				BITSET (pMem, index);
			else
				BITCLEAR (pMem, index);
			MemHandleUnlock (recordBits);
			}
		}
	
	else if (ctlRepeatEvent == event->eType)
		{
		switch (event->data.ctlRepeat.controlID)
			{
			case MainLineUpRepeating:
				MainFormScroll (1, dmSeekBackward);
				break;
			
			case MainLineDownRepeating:
				MainFormScroll (1, dmSeekForward);
				break;
			}
		}
		
	else if (ctlSelectEvent == event->eType)
		{
		switch (event->data.ctlEnter.controlID)
			{
			case MainToggleHiddenButton:
				TogglePrivateRecords ();
				eventHandled = true;
				break;
				
/*			case MainInfoButton:
				eventHandled = true;
				break;
*/			
			case MainDatabasePopTrigger:
				MainFormDoDatabasePopup ();
				eventHandled = true;
				break;
				
			case MainCategoryPopTrigger:
				MainFormDoCategoryPopup ();
				eventHandled = true;
				break;
				
			case MainMovePushButton:
				FrmShowObject (frm, FrmGetObjectIndex (frm,
					MainDestinationLabel));
				CtlShowControl (GetObjectPtr (MainDestinationPopTrigger));
				CategoryGetName (currentRef, catDest, catName);
				CategorySetTriggerLabel (
					GetObjectPtr (MainDestinationPopTrigger), catName);
				eventHandled = true;
				break;

			case MainDuplicatePushButton:
			case MainDeletePushButton:
				FrmHideObject (frm, FrmGetObjectIndex (frm,
					MainDestinationLabel));
				CtlHideControl (GetObjectPtr (MainDestinationPopTrigger));
				eventHandled = true;
				break;
				
			case MainDestinationPopTrigger:
				CategorySelect (currentRef, frm, MainDestinationPopTrigger,
					MainDestinationList, false, &catDest, catName, 1, 0);
				eventHandled = true;
				break;
				
			case MainActionButton:
				if (CtlGetValue (GetObjectPtr (MainDeletePushButton)))
					update = ActionDelete ();
//				else if (CtlGetValue (GetObjectPtr(MainDuplicatePushButton)))
//					update = ActionDuplicate ();
				else
					update = ActionMove ();

				if (update)
					{
					CharPtr		pMem;
					Err			error;
					
					numRecords   = DmNumRecordsInCategory (currentRef,
						catFrom);
					totalRecords = DmNumRecords (currentRef);
					if (recordBits)
						{
						error = MemHandleResize (recordBits,
							totalRecords / 8 + 1);
						ASSERT (error == 0);
						}
					else
						{
						recordBits = MemHandleNew (totalRecords / 8 + 1);
						}
					ASSERT (recordBits != NULL);
					pMem = MemHandleLock (recordBits);
					MemSet (pMem, totalRecords / 8 + 1, 0);
					MemHandleUnlock (recordBits);
					
					topRecord    = 0;
					DmSeekRecordInCategory (currentRef, &topRecord, 0,
						dmSeekForward, catFrom);
						
					MainFormLoadTable (topRecord);
					}
					
				eventHandled = true;
				break;
			}
		}
		
	else if (menuEvent == event->eType)
		{
		switch (event->data.menu.itemID)
			{
//			case OptionsPreferences:
//				eventHandled = true;
//				break;
				
			case OptionsAboutMassTransit:
				FrmPopupForm (AboutForm);
				eventHandled = true;
				break;
			}
		}
		
	else if (frmOpenEvent == event->eType)
		{
		MainFormOpen (frm);
		FrmDrawForm (frm);
		eventHandled = true;
		}
	
	else if (frmCloseEvent == event->eType)
		{
		MainFormClose (frm);
		eventHandled = true;
		}

	return (eventHandled);
}

//---------------------------------------------------------------------------

Boolean
ActionDelete (void)
{
	Word		ctlIndex;
	Word		buttonHit;
	FormPtr		alert;
	Boolean		newSaveArchive;
	Word		index;
	CharPtr		mem;
	UInt		attr, catg, from;
	Word		moveCount = 0;
	Err			error;
	Boolean		shifted = false;
	
	alert = FrmInitForm (DeleteForm);
	ctlIndex = FrmGetObjectIndex (alert, DeleteArchiveCheckbox);
	FrmSetControlValue (alert, ctlIndex, saveArchive);

	buttonHit = FrmDoDialog (alert);
	newSaveArchive = FrmGetControlValue (alert, ctlIndex);
	
	FrmDeleteForm (alert);
	
	if (DeleteCancelButton == buttonHit)
		return (false);

	saveArchive = newSaveArchive;

	mem = (CharPtr) MemHandleLock (recordBits);

	for (index = 0; index < totalRecords; index++)
		{
		//	if the last round moved a deleted/archived record to
		//	the end, then we need to adjust the index back one
		if (shifted)
			{
			index--;
			shifted = false;
			}
			
		//	don't delete if it hasn't been selected
		//	(increment index by moveCount for records previously
		//	 moved to the end after deletion/archiving call)
		if (! BITVALUE(mem,index+moveCount))
			continue;
		
		//	also don't delete if it isn't in the current category
		//	or we get an error trying to get it's attributes
		error = DmRecordInfo (currentRef, index, &attr, NULL, NULL);

		catg = attr    & dmRecAttrCategoryMask;
		from = catFrom & dmRecAttrCategoryMask;
		
		if (error  ||  (catFrom != dmAllCategories  &&  catg != from))
			continue;
			
		//	it's been marked and is in the current from category
		//	we can now delete it
		if (saveArchive)
			error = DmArchiveRecord (currentRef, index);
		else
			error = DmDeleteRecord (currentRef, index);
		if (! error)
			{
			error = DmMoveRecord (currentRef, index,
				DmNumRecords (currentRef));
			//	update the movecount if we were able to move the
			//	deleted/archived record to the end
			if (! error)
				{
				shifted = true;
				moveCount++;
				}
			}
		}
		
	MemHandleUnlock (recordBits);
	
	return (true);
}

//---------------------------------------------------------------------------

Boolean
ActionMove (void)
{
	Word		buttonHit;
	FormPtr		alert;
	Word		index;
	CharPtr		mem;
	UInt		attr;
	UInt		from, dest, catg;
	Err			error;
	
	alert = FrmInitForm (MoveForm);
	buttonHit = FrmDoDialog (alert);
	FrmDeleteForm (alert);
	
	if (MoveCancelButton == buttonHit)
		return (false);

	if (catFrom == catDest)
		return (false);

	mem = (CharPtr) MemHandleLock (recordBits);

	for (index = 0; index < totalRecords; index++)
		{			
		//	don't recategorize if it hasn't been selected
		if (! BITVALUE(mem,index))
			continue;
		
		//	also don't recategorize if it isn't in the current category
		//	or we get an error trying to get it's attributes
		error = DmRecordInfo (currentRef, index, &attr, NULL, NULL);

		catg = attr    & dmRecAttrCategoryMask;
		from = catFrom & dmRecAttrCategoryMask;
		dest = catDest & dmRecAttrCategoryMask;
		
		if (error  ||  (catFrom != dmAllCategories  &&  catg != from))
			continue;
		
		//	also, for ActionMove, don't recategorize the record if it
		//	already belongs to the destination category (this can happen
		//	if the current category is All)
		if (catg == dest)
			continue;
		
		//	it's been marked and is in the current from category
		//	we can now move it to the destination category
		attr &= ~dmRecAttrCategoryMask;
		attr |=  dest;
		attr |=  dmRecAttrDirty;

		DmSetRecordInfo (currentRef, index, &attr, NULL);
		}
		
	MemHandleUnlock (recordBits);
	
	return (true);
}

//---------------------------------------------------------------------------

void
MainFormLoadTable (UInt recordNum)
{
	TablePtr	table;
	Word		row;
	Word		numRows;
	CharPtr		bits;
	ULong		uniqueID;
	VoidHand	hRec;
	UInt		temp;
	Word		lineUpIndex, lineDownIndex;
	Boolean		canScrollUp, canScrollDown;
	UInt		index = recordNum;
	FormPtr		frm;
	
	table   = (TablePtr) GetObjectPtr (MainEntryTable);
	numRows = TblGetNumberOfRows (table);
	
	bits = (CharPtr) MemHandleLock (recordBits);
	
	for (row = 0; row < numRows; row++)
		{
		hRec = DmQueryNextInCategory (currentRef, &index, catFrom);
		if (hRec)
			{
			DmRecordInfo (currentRef, index, NULL, &uniqueID, NULL);
			
			TblSetRowData (table, row, uniqueID);
			TblSetRowID (table, row, index);
			TblSetRowUsable (table, row, true);
			TblSetItemInt (table, row, 0, BITVALUE(bits,index));
			
			index++;
			}
		else
			{
			TblSetRowUsable (table, row, false);
			}
		}
	
	MemHandleUnlock (recordBits);

	frm = FrmGetActiveForm ();
	lineUpIndex   = FrmGetObjectIndex (frm, MainLineUpRepeating);
	lineDownIndex = FrmGetObjectIndex (frm, MainLineDownRepeating);

	temp = recordNum;	// check before first record
	canScrollUp   = SeekRecord (&temp, 1, dmSeekBackward);
	temp = index;		// and after last record
	canScrollDown = SeekRecord (&temp, 0, dmSeekForward);

	FrmUpdateScrollers (frm, lineUpIndex, lineDownIndex,
		canScrollUp, canScrollDown);
		
	TblMarkTableInvalid (table);
	TblRedrawTable (table);
}

//---------------------------------------------------------------------------

void
MainFormClose (FormPtr frm)
{
	if (currentRef)
		{
		DmCloseDatabase (currentRef);
		currentRef = 0;
		}
}

//---------------------------------------------------------------------------

void
MainFormOpen (FormPtr frm)
{
	TablePtr		table;
	Word			row;
	Word			rowsInTable;
	RectangleType	bnds;
	VoidHand		hRsrc;
	BitmapPtr		bmap;
	RectangleType	r;
	
	table = (TablePtr) GetObjectPtr (MainEntryTable);
	rowsInTable = TblGetNumberOfRows (table);
	for (row = 0; row < rowsInTable; row++)
		{
		TblSetItemStyle (table, row, 0, checkboxTableItem);
		TblSetItemStyle (table, row, 1, customTableItem);
		TblSetRowUsable (table, row, false);
		}
	
	TblSetColumnUsable (table, 0, true);
	TblSetColumnUsable (table, 1, true);
	
	TblGetBounds (table, &bnds);
	RctInsetRectangle (&bnds, -1);
	WinDrawRectangleFrame (simpleFrame, &bnds);

	FrmShowObject (frm, FrmGetObjectIndex (frm, MainDestinationLabel));
	CtlShowControl (GetObjectPtr (MainDestinationPopTrigger));
	CtlSetValue (GetObjectPtr (MainMovePushButton), true);
	CtlSetValue (GetObjectPtr (MainDeletePushButton), false);
		
	if (MainFormSwitchDatabase (0))
		{
		//	Success in switching DB's; load the table.
		MainFormLoadTable (topRecord);
		CtlSetLabel (GetObjectPtr (MainDatabasePopTrigger),
			dbNames[currentDB]);
		}
	else
		{
		//	Should report to user; also need to reset the popup label.
		CtlSetLabel (GetObjectPtr (MainDatabasePopTrigger),
			"Cannot open DB!");
		CtlSetLabel (GetObjectPtr (MainCategoryPopTrigger),
			"Not availible");
		CtlSetLabel (GetObjectPtr (MainDestinationPopTrigger),
			"Not availible");
		}
/*
	hRsrc = DmGetResource (bitmapRsc, InfoBitmap);
	if (hRsrc)
		{		
		FrmGetObjectBounds (frm, FrmGetObjectIndex(frm, MainInfoButton), &r);
			
		bmap = MemHandleLock (hRsrc);
		WinDrawBitmap (bmap, r.topLeft.x, r.topLeft.y);
		MemHandleUnlock (hRsrc);
		DmReleaseResource (hRsrc);
		}
*/
	hRsrc = DmGetResource (bitmapRsc,
		(hideSecretRecords ? PrivateBitmap : PublicBitmap));
	if (hRsrc)
		{		
		FrmGetObjectBounds (frm, FrmGetObjectIndex(frm,
			MainToggleHiddenButton), &r);
			
		bmap = MemHandleLock (hRsrc);
		WinDrawBitmap (bmap, r.topLeft.x, r.topLeft.y);
		MemHandleUnlock (hRsrc);
		DmReleaseResource (hRsrc);
		}
}

//---------------------------------------------------------------------------

