// Blinken.c
// A Das Blinken Lights port for the Palm OS
//
// by David Berner
//
// Begun 10/20/98
// Finished 10/26/98 
//
// This is my first Palm OS application - actually my first application
// ever.  I'd like to thank Alan Weiner for his Hello World article in 
// PalmPower magazine - from which the bulk of this code is copied.
// Check it out at www.palmpower.com
// Alan's site is www.ajw.com
//
// Also thanks to the many people on IRC Dalnet #pilot-pda who are the 
// first people I turn to whenever I have a programming question I can't 
// answer.  
//-------------------------------------------------------------------------------

#include <Pilot.h>
#include "Blinken.h"

// === prototypes ===

static Boolean StartApplication(void);		
static void StopApplication(void);
static Boolean ApplicationHandleEvent(EventPtr event);
static void EventLoop(void);
static Boolean MainFormHandleEvent(EventPtr event);


// === MenuGetVisible() ===
// this function is from the Hardball code - it determines whether the
// menu bar is visible - so DrawSpot() won't draw 

static Boolean MenuGetVisible(void)
{
	if (UICurrentMenu){
		return UICurrentMenu->attr.visible;
	}
	return false;
}


// === ShowAchtung() ===
// used to call up the Actung! dialog when the application opens

static void ShowAchtung(void) 
{
	FormPtr	achtungfrm;
	achtungfrm = FrmInitForm(AboutForm);
	FrmDoDialog(achtungfrm);
	FrmDeleteForm(achtungfrm);
}


// === DrawSpot() ===
// draws a random colored (black/white) spot at a random location on the
// grid that represents the bank of lights.  

static void DrawSpot(void)
{
	RectangleType 	spot;
	UInt		rand, randX, randY;
	Int 		spotX, spotY;

	rand = (UInt)SysRandom( 0 ) % 3;	// generate 0-2
	randX = (UInt)SysRandom( 0 ) % 16;	// generate 0-15
	randY = (UInt)SysRandom( 0 ) % 16;	// generate 0-15
	
	spotX = (randX * 10) + 1;
	spotY = (randY * 10) + 1;

	spot.extent.y = 8;
	spot.extent.x = 8;
	spot.topLeft.x = spotX;
	spot.topLeft.y = spotY;

	if (rand) {
		WinDrawRectangle(&spot, 3);
	} else {
		WinEraseRectangle(&spot, 3);
	}
}

// === DrawBackground() ===
// used to black out the screen when the app opens.

static void DrawBackground(void)
{
	RectangleType background;

	// Clear a surrounding box to make the text more distinguishable
	background.extent.y = 160;
	background.extent.x = 160;
	background.topLeft.x = 0;
	background.topLeft.y = 0;
	WinDrawRectangle(&background, 0);
}

// From here down the code is all copied from Alan Weiner's Hello World 
// except for a minor modification in the EventLoop where I changed the 
// EvtGetEvent() call and the addition of the  DrawBackground() and ShowAchtung 
// calls and the nilEvent handler in MainFormHandleEvent. 

//=== StartApplication() ===

static Boolean StartApplication(void)
{
	FrmGotoForm(MainForm);		// start the first form
	return false;
}


// === StopApplication() ===

static void StopApplication(void)
{
	FrmCloseAllForms();
}


// === MainFormHandleEvent() ===

static Boolean MainFormHandleEvent(EventPtr event)
{
	Boolean	handled = false;
	FormPtr	frm;
	
	switch (event->eType) {
	case frmOpenEvent:
		frm = FrmGetActiveForm();
		FrmDrawForm(frm);
		DrawBackground();
		ShowAchtung();
		handled = true;
		break;

	case menuEvent:
		MenuEraseStatus(0);

		frm = FrmInitForm(AboutForm);
		FrmDoDialog(frm);
		FrmDeleteForm(frm);
		handled = true;
		break;

	case nilEvent:
		if (! MenuGetVisible()) {
			DrawSpot();
		}
		handled = true;
		break;
	}
	return (handled);
}

// === ApplicationHandleEvent() ===

static Boolean ApplicationHandleEvent(EventPtr event)
{
	FormPtr	frm;
	Int		formId;
	Boolean	handled = false;

	if (event->eType == frmLoadEvent) {

		formId = event->data.frmLoad.formID;	// get the form ID number
		frm = FrmInitForm(formId);		// load it, getting the form's pointer
		FrmSetActiveForm(frm);			// now OS sends events to this form

		switch (formId) {
		case MainForm:
			FrmSetEventHandler(frm, MainFormHandleEvent);
			break;
		}
		handled = true;
	}
	return handled;
}


// === EventLoop() ===

static void EventLoop(void)
{
	EventType	event;
	Word		error;

	do
		{
		EvtGetEvent(&event, 2);
		if (! SysHandleEvent(&event))
		   if (! MenuHandleEvent(0, &event, &error))
		      if (! ApplicationHandleEvent(&event))
		         FrmDispatchEvent(&event);
		}
	while (event.eType != appStopEvent);
}


// === PilotMain() ===

DWord PilotMain(Word cmd, Ptr cmdPBP, Word launchFlags)
{
	if (cmd == sysAppLaunchCmdNormalLaunch) {
		if (!StartApplication()) {
			EventLoop();
			StopApplication();
		}
	}
	return 0;
}