/* rygel-mediathek-video-item.c generated by valac 0.11.2, the Vala compiler
 * generated from rygel-mediathek-video-item.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <stdlib.h>
#include <string.h>
#include <libxml/tree.h>
#include <gee.h>


#define RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM (rygel_mediathek_video_item_get_type ())
#define RYGEL_MEDIATHEK_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM, RygelMediathekVideoItem))
#define RYGEL_MEDIATHEK_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM, RygelMediathekVideoItemClass))
#define RYGEL_MEDIATHEK_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIATHEK_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIATHEK_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM, RygelMediathekVideoItemClass))

typedef struct _RygelMediathekVideoItem RygelMediathekVideoItem;
typedef struct _RygelMediathekVideoItemClass RygelMediathekVideoItemClass;
typedef struct _RygelMediathekVideoItemPrivate RygelMediathekVideoItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST (rygel_mediathek_asx_playlist_get_type ())
#define RYGEL_MEDIATHEK_ASX_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST, RygelMediathekAsxPlaylist))
#define RYGEL_MEDIATHEK_ASX_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST, RygelMediathekAsxPlaylistClass))
#define RYGEL_MEDIATHEK_IS_ASX_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST))
#define RYGEL_MEDIATHEK_IS_ASX_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST))
#define RYGEL_MEDIATHEK_ASX_PLAYLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIATHEK_TYPE_ASX_PLAYLIST, RygelMediathekAsxPlaylistClass))

typedef struct _RygelMediathekAsxPlaylist RygelMediathekAsxPlaylist;
typedef struct _RygelMediathekAsxPlaylistClass RygelMediathekAsxPlaylistClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediathekAsxPlaylistPrivate RygelMediathekAsxPlaylistPrivate;

typedef enum  {
	RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR
} RygelMediathekVideoItemError;
#define RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR rygel_mediathek_video_item_error_quark ()
struct _RygelMediathekVideoItem {
	RygelVideoItem parent_instance;
	RygelMediathekVideoItemPrivate * priv;
};

struct _RygelMediathekVideoItemClass {
	RygelVideoItemClass parent_class;
};

typedef enum  {
	RYGEL_MEDIATHEK_ASX_PLAYLIST_ERROR_XML_ERROR,
	RYGEL_MEDIATHEK_ASX_PLAYLIST_ERROR_NETWORK_ERROR
} RygelMediathekAsxPlaylistError;
#define RYGEL_MEDIATHEK_ASX_PLAYLIST_ERROR rygel_mediathek_asx_playlist_error_quark ()
struct _RygelMediathekAsxPlaylist {
	GObject parent_instance;
	RygelMediathekAsxPlaylistPrivate * priv;
	GeeArrayList* uris;
};

struct _RygelMediathekAsxPlaylistClass {
	GObjectClass parent_class;
};


static gpointer rygel_mediathek_video_item_parent_class = NULL;

GQuark rygel_mediathek_video_item_error_quark (void);
GType rygel_mediathek_video_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIATHEK_VIDEO_ITEM_DUMMY_PROPERTY
};
static RygelMediathekVideoItem* rygel_mediathek_video_item_new (RygelMediaContainer* parent, const gchar* title);
static RygelMediathekVideoItem* rygel_mediathek_video_item_construct (GType object_type, RygelMediaContainer* parent, const gchar* title);
static gboolean rygel_mediathek_video_item_namespace_ok (xmlNode* node);
GType rygel_mediathek_asx_playlist_get_type (void) G_GNUC_CONST;
RygelMediathekAsxPlaylist* rygel_mediathek_video_item_handle_content (xmlNode* group, GError** error);
RygelMediathekAsxPlaylist* rygel_mediathek_asx_playlist_new (const gchar* uri);
RygelMediathekAsxPlaylist* rygel_mediathek_asx_playlist_construct (GType object_type, const gchar* uri);
GQuark rygel_mediathek_asx_playlist_error_quark (void);
void rygel_mediathek_asx_playlist_parse (RygelMediathekAsxPlaylist* self, GError** error);
RygelMediathekVideoItem* rygel_mediathek_video_item_create_from_xml (RygelMediaContainer* parent, xmlNode* item, GError** error);


GQuark rygel_mediathek_video_item_error_quark (void) {
	return g_quark_from_static_string ("rygel_mediathek_video_item_error-quark");
}


static RygelMediathekVideoItem* rygel_mediathek_video_item_construct (GType object_type, RygelMediaContainer* parent, const gchar* title) {
	RygelMediathekVideoItem * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, title, (gsize) (-1));
	_tmp1_ = _tmp0_;
	self = (RygelMediathekVideoItem*) rygel_video_item_construct (object_type, _tmp1_, parent, title, RYGEL_VIDEO_ITEM_UPNP_CLASS);
	_g_free0 (_tmp1_);
	_tmp2_ = g_strdup ("video/x-ms-wmv");
	_tmp3_ = _tmp2_;
	_g_free0 (((RygelMediaItem*) self)->mime_type);
	((RygelMediaItem*) self)->mime_type = _tmp3_;
	_tmp4_ = g_strdup ("ZDF - Second German TV Channel Streams");
	_tmp5_ = _tmp4_;
	_g_free0 (((RygelVideoItem*) self)->author);
	((RygelVideoItem*) self)->author = _tmp5_;
	return self;
}


static RygelMediathekVideoItem* rygel_mediathek_video_item_new (RygelMediaContainer* parent, const gchar* title) {
	return rygel_mediathek_video_item_construct (RYGEL_MEDIATHEK_TYPE_VIDEO_ITEM, parent, title);
}


static gboolean rygel_mediathek_video_item_namespace_ok (xmlNode* node) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	if (node->ns != NULL) {
		_tmp0_ = g_strcmp0 (node->ns->prefix, "media") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


RygelMediathekAsxPlaylist* rygel_mediathek_video_item_handle_content (xmlNode* group, GError** error) {
	RygelMediathekAsxPlaylist* result = NULL;
	RygelMediathekAsxPlaylist* asx;
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	asx = NULL;
	_tmp0_ = rygel_mediathek_video_item_namespace_ok (group);
	if (_tmp0_) {
		xmlAttr* _tmp1_ = NULL;
		xmlAttr* attr;
		_tmp1_ = xmlHasProp (group, "url");
		attr = _tmp1_;
		if (attr != NULL) {
			gchar* _tmp2_;
			gchar* url;
			gboolean _tmp3_;
			_tmp2_ = g_strdup (attr->children->content);
			url = _tmp2_;
			_tmp3_ = g_str_has_suffix (url, ".asx");
			if (_tmp3_) {
				RygelMediathekAsxPlaylist* _tmp4_ = NULL;
				RygelMediathekAsxPlaylist* _tmp5_;
				_tmp4_ = rygel_mediathek_asx_playlist_new (url);
				_tmp5_ = _tmp4_;
				_g_object_unref0 (asx);
				asx = _tmp5_;
				rygel_mediathek_asx_playlist_parse (asx, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == RYGEL_MEDIATHEK_ASX_PLAYLIST_ERROR) {
						goto __catch1_rygel_mediathek_asx_playlist_error;
					}
					_g_free0 (url);
					_g_object_unref0 (asx);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				goto __finally1;
				__catch1_rygel_mediathek_asx_playlist_error:
				{
					GError * _error_;
					RygelMediathekAsxPlaylist* _tmp6_;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					_tmp6_ = NULL;
					_g_object_unref0 (asx);
					asx = _tmp6_;
					_g_error_free0 (_error_);
				}
				__finally1:
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (url);
						_g_object_unref0 (asx);
						return NULL;
					} else {
						_g_free0 (url);
						_g_object_unref0 (asx);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
			}
			_g_free0 (url);
		} else {
			GError* _tmp7_ = NULL;
			_tmp7_ = g_error_new_literal (RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR, RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR, "group node has no 'url' property");
			_inner_error_ = _tmp7_;
			if (_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (asx);
				return NULL;
			} else {
				_g_object_unref0 (asx);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	} else {
		GError* _tmp8_ = NULL;
		_tmp8_ = g_error_new_literal (RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR, RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR, "invalid or no namespace");
		_inner_error_ = _tmp8_;
		if (_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (asx);
			return NULL;
		} else {
			_g_object_unref0 (asx);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = asx;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediathekVideoItem* rygel_mediathek_video_item_create_from_xml (RygelMediaContainer* parent, xmlNode* item, GError** error) {
	RygelMediathekVideoItem* result = NULL;
	gchar* title;
	RygelMediathekVideoItem* video_item;
	RygelMediathekAsxPlaylist* asx;
	RygelMediathekVideoItem* _tmp14_ = NULL;
	RygelMediathekVideoItem* _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	title = NULL;
	video_item = NULL;
	asx = NULL;
	{
		xmlNode* item_child;
		item_child = item->children;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp1_;
				GQuark _tmp2_;
				static GQuark _tmp2__label0 = 0;
				static GQuark _tmp2__label1 = 0;
				if (!_tmp0_) {
					item_child = item_child->next;
				}
				_tmp0_ = FALSE;
				if (!(item_child != NULL)) {
					break;
				}
				_tmp1_ = item_child->name;
				_tmp2_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
				if (_tmp2_ == ((0 != _tmp2__label0) ? _tmp2__label0 : (_tmp2__label0 = g_quark_from_static_string ("title")))) {
					switch (0) {
						default:
						{
							gchar* _tmp3_ = NULL;
							gchar* _tmp4_;
							_tmp3_ = xmlNodeGetContent (item_child);
							_tmp4_ = _tmp3_;
							_g_free0 (title);
							title = _tmp4_;
							break;
						}
					}
				} else if (_tmp2_ == ((0 != _tmp2__label1) ? _tmp2__label1 : (_tmp2__label1 = g_quark_from_static_string ("group")))) {
					switch (0) {
						default:
						{
							gboolean _tmp5_;
							_tmp5_ = rygel_mediathek_video_item_namespace_ok (item_child);
							if (_tmp5_) {
								{
									xmlNode* group;
									group = item_child->children;
									{
										gboolean _tmp6_;
										_tmp6_ = TRUE;
										while (TRUE) {
											if (!_tmp6_) {
												group = group->next;
											}
											_tmp6_ = FALSE;
											if (!(group != NULL)) {
												break;
											}
											if (g_strcmp0 (group->name, "content") == 0) {
												RygelMediathekAsxPlaylist* _tmp7_ = NULL;
												RygelMediathekAsxPlaylist* _tmp8_;
												RygelMediathekAsxPlaylist* _tmp9_;
												_tmp7_ = rygel_mediathek_video_item_handle_content (group, &_inner_error_);
												_tmp8_ = _tmp7_;
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
														g_propagate_error (error, _inner_error_);
														_g_object_unref0 (asx);
														_g_object_unref0 (video_item);
														_g_free0 (title);
														return NULL;
													} else {
														_g_object_unref0 (asx);
														_g_object_unref0 (video_item);
														_g_free0 (title);
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return NULL;
													}
												}
												_tmp9_ = _tmp8_;
												_g_object_unref0 (asx);
												asx = _tmp9_;
											}
										}
									}
								}
							} else {
								gchar* _tmp10_;
								gchar* msg;
								GError* _tmp11_ = NULL;
								_tmp10_ = g_strdup ("Invalid or no namespace on group node");
								msg = _tmp10_;
								_tmp11_ = g_error_new_literal (RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR, RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR, msg);
								_inner_error_ = _tmp11_;
								if (_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (msg);
									_g_object_unref0 (asx);
									_g_object_unref0 (video_item);
									_g_free0 (title);
									return NULL;
								} else {
									_g_free0 (msg);
									_g_object_unref0 (asx);
									_g_object_unref0 (video_item);
									_g_free0 (title);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
								_g_free0 (msg);
							}
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							break;
						}
					}
				}
			}
		}
	}
	if (title == NULL) {
		GError* _tmp12_ = NULL;
		_tmp12_ = g_error_new_literal (RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR, RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR, "Could not find title");
		_inner_error_ = _tmp12_;
		if (_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (asx);
			_g_object_unref0 (video_item);
			_g_free0 (title);
			return NULL;
		} else {
			_g_object_unref0 (asx);
			_g_object_unref0 (video_item);
			_g_free0 (title);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (asx == NULL) {
		GError* _tmp13_ = NULL;
		_tmp13_ = g_error_new_literal (RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR, RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR_XML_PARSE_ERROR, "Could not find URIs");
		_inner_error_ = _tmp13_;
		if (_inner_error_->domain == RYGEL_MEDIATHEK_VIDEO_ITEM_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (asx);
			_g_object_unref0 (video_item);
			_g_free0 (title);
			return NULL;
		} else {
			_g_object_unref0 (asx);
			_g_object_unref0 (video_item);
			_g_free0 (title);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp14_ = rygel_mediathek_video_item_new (parent, title);
	_tmp15_ = _tmp14_;
	_g_object_unref0 (video_item);
	video_item = _tmp15_;
	{
		GeeArrayList* _tmp16_;
		GeeArrayList* _uri_list;
		gint _tmp17_;
		gint _uri_size;
		gint _uri_index;
		_tmp16_ = _g_object_ref0 (asx->uris);
		_uri_list = _tmp16_;
		_tmp17_ = gee_collection_get_size ((GeeCollection*) _uri_list);
		_uri_size = _tmp17_;
		_uri_index = -1;
		while (TRUE) {
			gpointer _tmp18_ = NULL;
			gchar* uri;
			_uri_index = _uri_index + 1;
			if (!(_uri_index < _uri_size)) {
				break;
			}
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _uri_list, _uri_index);
			uri = (gchar*) _tmp18_;
			rygel_media_item_add_uri ((RygelMediaItem*) video_item, uri);
			_g_free0 (uri);
		}
		_g_object_unref0 (_uri_list);
	}
	result = video_item;
	_g_object_unref0 (asx);
	_g_free0 (title);
	return result;
}


static void rygel_mediathek_video_item_class_init (RygelMediathekVideoItemClass * klass) {
	rygel_mediathek_video_item_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_mediathek_video_item_instance_init (RygelMediathekVideoItem * self) {
}


GType rygel_mediathek_video_item_get_type (void) {
	static volatile gsize rygel_mediathek_video_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mediathek_video_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediathekVideoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_mediathek_video_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediathekVideoItem), 0, (GInstanceInitFunc) rygel_mediathek_video_item_instance_init, NULL };
		GType rygel_mediathek_video_item_type_id;
		rygel_mediathek_video_item_type_id = g_type_register_static (RYGEL_TYPE_VIDEO_ITEM, "RygelMediathekVideoItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_mediathek_video_item_type_id__volatile, rygel_mediathek_video_item_type_id);
	}
	return rygel_mediathek_video_item_type_id__volatile;
}



