/*
 * The Guardian Digital EnGarde Secure Linux Installer v1.0.6
 * Copyright (C) 2001 Guardian Digital, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */



#include "install.h"

struct isaDevices isaEthDev, isaSCSIDev;

int scanPCIDev(void) { 
   FILE *pciDevs, *fopen();
   int c = 0;

   if ( (pciDevs = fopen(PCI_DEVLIST_FILE, "r") ) != NULL ) {
     c++;
     fclose (pciDevs); 
   }

   return c;
}

struct isaDevices scanPCIEth(int devNum) {
  struct isaDevices device;
  FILE *pciDevList, *fopen();
  char tempstr[80];

  /* scan device # in tmp file */
  
  if ( (pciDevList = fopen (PCI_DEVLIST_FILE, "r")) != NULL ) {

     fscanf(pciDevList, "%s", device.deviceID);
     fscanf(pciDevList, "%s", device.mfgName);
     fscanf(pciDevList, "%s", device.moduleName);

     strcpy (device.deviceName, "");
     fscanf(pciDevList, "%s", tempstr);
     while ( !feof(pciDevList) ) {
        strcat (device.deviceName, tempstr);
        strcat (device.deviceName, " ");
        fscanf(pciDevList, "%s", tempstr);
     }

  }

  fclose(pciDevList);

 
  return device;
}
