/*
 * The Guardian Digital EnGarde Secure Linux Installer v1.0.6
 * Copyright (C) 2001 Guardian Digital, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "install.h"

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

extern FILE *flog;
extern char *log;

static int getaddresses(struct networkparams *p);
void getISAEthCardListBox(char *isaModule);
void getPCIEthCardListBox(char *pciModule);

/* One nic. */
struct nic {
  char *description;
  char *modulename;
};

struct isaDevices isaEthDev, pciEthDev;



int networkmenu(struct networkparams *p, int noscan) {
  int done = 0;  
  int skip = 0;
  int found = 0;
  int manual = 0;
  int result;
  int rc;
  int c = 0;
  int isaDev;
  int devices;
  int nicType;  

  char commandstring[STRING_SIZE]; 
  char messagestring[STRING_SIZE];

  /* Clear the name.  If this is clear, we known detect failed. */
  strcpy(p->modulename, "");



/* use isa_scan to find network card          */
/* this loop is sloppy and NEEDS to be redone */
/* ------------------------------------------ */

  while ( done != 2 ) {

    if (noscan == 0) {

       if ( ! manual ) {

          sprintf(messagestring, "Autodetecting Ethernet Device");
          statuswindow(60, 4, TITLE, messagestring);

          fprintf(flog, "Scanning PCI...\n");

          if ( (devices = scanPCIDev()) > 0) {
             fprintf(flog,"%c devices found!\n",devices);
             pciEthDev = scanPCIEth(c);
             fprintf(flog, "%sfound!\nModule: %s\n",pciEthDev.deviceName, pciEthDev.moduleName);

             newtPopWindow();

             sprintf(messagestring, "%sfound!", pciEthDev.deviceName);
             newtWinMessage(TITLE, "Ok", messagestring);

             strcpy(p->modulename, pciEthDev.moduleName);
          } 
          else if ( (devices = scanISADev()) > 0) {;
             fprintf(flog,"Scanning ISA bus...\n");

             for (c = 1; c <= devices; c++) {
                isaDev = scanISAType(c);
                if ( isaDev == 1 ) {
                   isaEthDev = scanEth(c);
                }
             }
             newtPopWindow();
 
             sprintf(messagestring, "%s found!", isaEthDev.deviceName);
             newtWinMessage(TITLE, "Ok", messagestring);
     
             strcpy(p->modulename, isaEthDev.moduleName);

             found = 1;
          }
          else {
             fprintf (flog, "No Network cards found.\n");
   
             newtPopWindow();

             sprintf(messagestring, "No Network cards found!");

             found = 0;
          }
       }

       /* attempt to load module */
       /* ---------------------- */    
       fprintf (flog, "Attempting to load %s module.\n", p->modulename);
       sprintf (commandstring, "/sbin/insmod /lib/modules/%s-BOOT/net/%s", KERNEL_VER_I386, p->modulename);
       if (!(mysystem(commandstring))) {
          fprintf (flog, "Module %s successfully loaded.\n", p->modulename);
          sprintf (commandstring, "alias eth0 %s", p->modulename);
          writeModuleconf(commandstring);
          done = 2;
          skip = 0;
       } 
       else {
          fprintf (flog, "Failed to load ethernet card module.\n");
          sprintf(messagestring, "Unable to properly load ethernet card module.");
          result = newtWinChoice(TITLE, "Skip", "Choose", messagestring);

          if ( result == 1 ) { 
             done = 2;
             skip = 1;
          }
          else {
       
              /* call manual eth card selection */
              /**********************************/
        
              manual = 1;

              nicType = (int) newtWinChoice(TITLE, "PCI", "ISA", "What type " \
                            "of network interface?");
              if ( nicType == 1) {
                 getPCIEthCardListBox(isaEthDev.moduleName);
              } 
              else {
                 getISAEthCardListBox(isaEthDev.moduleName);
              }
              strcpy(p->modulename, isaEthDev.moduleName);
           }
       }
    } 
    else {
          /* call manual eth card selection */
          /**********************************/

          fprintf(flog,"Ethernet auto probing disabled.\n");

          nicType = newtWinChoice(TITLE, "PCI", "ISA", "What type " \
                             "of network interface?");
          if ( nicType == 1) {
             getPCIEthCardListBox(isaEthDev.moduleName);
          } 
          else {
             getISAEthCardListBox(isaEthDev.moduleName);
          }
          strcpy(p->modulename, isaEthDev.moduleName);
    } 
  }

  if ( ! skip ) {

     /* Get IP address info. */
     /************************/
     rc = getaddresses(p);
     if (rc != 1) return 0;
  }

  return 1;
}
			


static int getaddresses(struct networkparams *p) {
  int done;
  int rc;
  int c;
  char message[STRING_SIZE];

  char *values[] = { "192.168.10.100", "192.168.10.0", "255.255.255.0", "192.168.10.1", "192.168.10.255", NULL};

  struct newtWinEntry entries[] = { 
    { "IP address", &values[0], 0, },
    { "Network mask", &values[2], 0, }, 
    { "Network address", &values[1], 0 },
    { "Broadcast address", &values[4], 0 },
    { "Gateway", &values[3], 0 },
    { NULL, NULL, 0 }
  };

  /* Simular sort of stuff to the CDROM menu. */
  do {
    done = 1;
	
    rc = newtWinEntries(TITLE, "Enter the IP address information", 50, 5, 5,
                        18, entries, "OK", "Cancel", NULL);

    if (rc != 2) {
      strcpy(message, "The following fields are invalid:\n\n");

      if (inet_addr(values[0]) == INADDR_NONE) {
        strcat(message, "IP address\n"); done = 0;
      }

      if (inet_addr(values[1]) == INADDR_NONE ) {
        strcat(message, "Network address\n"); done = 0;
      }

      if (inet_addr(values[2]) == INADDR_NONE) {
        strcat(message, "Network mask\n"); done = 0;
      }

      if (inet_addr(values[3]) == INADDR_NONE) {
        strcat(message, "Gateway\n"); done = 0;
      }

      if (inet_addr(values[4]) == INADDR_NONE) {
        strcat(message, "Broadcast address\n"); done = 0;
      }

      if (!done) errorbox(message);
    }	
  } while (!done);

  strncpy(p->address, values[0], STRING_SIZE);
  strncpy(p->netaddress, values[1], STRING_SIZE);
  strncpy(p->netmask, values[2], STRING_SIZE);
  strncpy(p->gateway, values[3], STRING_SIZE);
  strncpy(p->broadcast, values[4], STRING_SIZE);
	
  for (c = 0; c < 4; c++) { if (values[c]) free(values[c]); }
	
  return rc;
}



/* ------------------------------------------------------ */
/*                                                        */
/*   void getISAEthCardListBox(char *pciModule)           */
/*                                                        */
/* Read ISA database for ethernet cards and display       */
/* in a listbox.					  */
/* 							  */
/* This will return the module name selected              */
/*                                                        */
/* ------------------------------------------------------ */

void getISAEthCardListBox(char *isaModule) {
   FILE *isa_db, *fopen();
   struct isaDevices device[200];
   newtComponent listbox, form;
   char tempstr[80], mod[80], dname[80];
   int c = 0;

   listbox = newtListbox (1, 2, 18, NEWT_FLAG_SCROLL | NEWT_FLAG_RETURNEXIT);
   newtCenteredWindow(62,20, "Select ISA Ethernet Device:");
   form = newtForm(NULL,NULL,0);

   if ( (isa_db = fopen(ISA_ETH_DB, "r")) != NULL ) {
      while ( !feof(isa_db) ) {
         fscanf(isa_db, "%s", tempstr);
         fscanf(isa_db, "%s", mod);
         fscanf(isa_db, "%s", tempstr);

         strcpy(dname, "");
         fscanf(isa_db, "%s", tempstr);
         while ( ! strstr(tempstr, "#") ) {
            strcat (dname, tempstr);
            strcat (dname, " ");
            fscanf(isa_db, "%s", tempstr);
         }
         strcat (dname, "\0");
         if ( !feof(isa_db) ) {
            strcpy(device[c].deviceName, dname);
            strcpy(device[c].moduleName, mod);
            newtListboxAppendEntry(listbox, dname, (void *) c);
         }
      c++;
      }

   fclose (isa_db);

   }

   newtFormAddComponents(form, listbox, NULL);
   newtFormSetCurrent(form, listbox);

   newtRunForm(form);

   c = (int) newtListboxGetCurrent(listbox);

   strcpy (isaModule, device[c].moduleName);

   newtPopWindow();
}

/* ------------------------------------------------------ */
/*                                                        */
/*   void getPCIEthCardListBox(char *pciModule)           */
/*                                                        */
/* Read PCI database for ethernet cards and display       */
/* in a listbox.					  */
/* 							  */
/* This will return the module name selected              */
/*                                                        */
/* ------------------------------------------------------ */

void getPCIEthCardListBox(char *pciModule) {
   FILE *pci_db, *fopen();
   struct isaDevices device[MAX_ETH_DEVICES];
   newtComponent listbox, form;
   char tempstr[80], mod[80], dname[80];
   int c = 0;

   listbox = newtListbox (1, 2, 18, NEWT_FLAG_SCROLL | NEWT_FLAG_RETURNEXIT);
   newtCenteredWindow(70,20, "Select PCI Ethernet Device:");
   form = newtForm(NULL,NULL,0);

   if ( (pci_db = fopen(PCI_ETH_DB, "r")) != NULL ) {
      while ( !feof(pci_db) ) {
         fscanf(pci_db, "%s", tempstr);
         fscanf(pci_db, "%s", mod);
         fscanf(pci_db, "%s", tempstr);

         strcpy(dname, "");
         fscanf(pci_db, "%s", tempstr);
         while ( ! strstr(tempstr, "#") ) {
            strcat (dname, tempstr);
            strcat (dname, " ");
            fscanf(pci_db, "%s", tempstr);
         }
         strcat (dname, "\0");
         if ( !feof(pci_db) ) {
            strcpy(device[c].deviceName, dname);
            strcpy(device[c].moduleName, mod);
            newtListboxAppendEntry(listbox, dname, (void *) c);
         }
      c++;
      }

   fclose (pci_db);

   }

   newtFormAddComponents(form, listbox, NULL);
   newtFormSetCurrent(form, listbox);

   newtRunForm(form);

   c = (int) newtListboxGetCurrent(listbox);

   strcpy (pciModule, device[c].moduleName);

   newtPopWindow();

}


