/*
 * The Guardian Digital EnGarde Secure Linux Installer v1.0.6
 * Copyright (C) 2001 Guardian Digital, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "install.h"

int checkAddUserInput(struct userInfo info, char * confirm);

int newUserInit(void) {
  int result;  

  char message[] = "Next is the new user creation process.  The new user will be "
                   "added to the admin group and has the ability to "
                   "login from the console.  An SSH key will also be generated for "
                   "this user.\n\n"
                   "During the initial configuration process, after EnGarde Secure "
                   "Linux has been installed, you will have the option to create "
                   "a new user.  You may skip this step now and create your user "
                   "at that point.";

  result = newtWinChoice("New User Creation", "Ok", "Skip", message);

  return result;
}

struct userInfo displayNewUser(void) {
  struct userInfo info;

  int done = 0;

  char *realName;
  char *userName;
  char *password;
  char *passwordConfirm;

  newtComponent userForm;
  newtComponent button;
  newtComponent label1;
  newtComponent label2;
  newtComponent label3;
  newtComponent label4;
  newtComponent divider;
  newtComponent realNameTextbox;
  newtComponent userNameTextbox;
  newtComponent passwordTextbox;
  newtComponent passwordConfirmTextbox;

  /* Create Form for New User */
  /* ------------------------ */
  newtCenteredWindow (32, 12, "Add New User"); 
  userForm = newtForm (NULL, NULL, 0);
  button = newtButton (12, 7, "Ok"); 

  realNameTextbox = newtEntry (14, 1, NULL, 16, &realName, NEWT_ENTRY_SCROLL); 
  userNameTextbox = newtEntry (14, 2, NULL, 16, &userName, NEWT_ENTRY_SCROLL); 
  passwordTextbox = newtEntry (14, 4, NULL, 16, &password, NEWT_FLAG_HIDDEN | NEWT_ENTRY_SCROLL); 
  passwordConfirmTextbox = newtEntry (14, 5, NULL, 16, &passwordConfirm, NEWT_FLAG_HIDDEN | NEWT_ENTRY_SCROLL); 

  label1 = newtLabel (1, 1, "Real Name :");
  label2 = newtLabel (1, 2, "User Name :");
  divider = newtLabel (1, 3, "-----------------------------");
  label3 = newtLabel (2, 4, "Password :");
  label4 = newtLabel (3, 5, "Confirm :");

  newtFormAddComponents (userForm, button, realNameTextbox, userNameTextbox, 
                                   divider, passwordTextbox, passwordConfirmTextbox, 
			           label1, label2, label3, label4, NULL);

  while (!done) {
    newtFormSetCurrent (userForm, realNameTextbox);
    newtRunForm (userForm);
    strcpy (info.realName, realName);
    strcpy (info.userName, userName);
    strcpy (info.password, password);
    if (!(done = checkAddUserInput(info, passwordConfirm))) {
       newtEntrySet (passwordTextbox, "", 0);
       newtEntrySet (passwordConfirmTextbox, "", 0);
    }
  }
  
  newtPopWindow();
  newtFormDestroy (userForm);

  return info;
}

int writeUserInfo(struct userInfo info) {
  char command[STRING_SIZE];
  
  /* create normal user */
  /* ------------------ */
  system("cp /bin/makeUser /harddisk/tmp");
  sprintf (command, "/cdrom/bin/chroot /harddisk/ /tmp/makeUser %s %s", info.userName, info.password);

  return mysystem(command); 
}

int checkAddUserInput(struct userInfo info, char * confirm) {
  int fail = 0;
  char tmpstr[STRING_SIZE];  
 
  if (strlen(info.userName) <= 2) {
    errorbox("Username must be at least 3 characters long");
    fail = 0;
  }
  else if ((strcmp(info.password, confirm))) {
    sprintf(tmpstr, "Passwords don't match.");
    errorbox(tmpstr);
    fail = 0;
  } 
  else if (strlen(info.password) <= 7) {
     errorbox("Password must be at least 8 characters long");
     fail = 0;
  } else {
     fail = 1;
  }

  return fail;
}
