/*
 * The Guardian Digital EnGarde Secure Linux Installer v1.0.6
 * Copyright (C) 2001 Guardian Digital, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "install.h"

extern FILE *flog;

void properArch(void) {
 FILE *cpu_info, *fopen();
 char * messageText;

 if (( (cpu_info = fopen ("/etc/i686", "r")) != NULL) && (cpuVersion() <= 1)) {
     fclose (cpu_info);
     fprintf (flog, "CPU Type : %d\n/etc/i686 : Present\n", cpuVersion());
     messageText = "You are attempting to install the i686 version of EnGarde " \
                      "Secure Linux on a machine that is not i686 architecture. " \
                      "An i386 version is available at www.engardelinux.org and " \
                      "supports Intel 386, 486, " \
                      "Pentium, AMD K6/K6-2/K6-III and Cyrix chips.";
     newtWinMessage("Incompatible Version", "Ok", messageText);
     callReboot(); 
  }
}
