/*
 * The Guardian Digital EnGarde Secure Linux Installer v1.0.6
 * Copyright (C) 2001 Guardian Digital, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <linux/reboot.h>

#include "install.h"

#define CDROM_INSTALL 0
#define URL_INSTALL 1

FILE *flog = NULL;
FILE *partmap = NULL;
char *log;


int main(int argc, char *argv[]) {
  char commandstring[STRING_SIZE];
  char *insertmessage, *insertdevnode;
  char letter;
  char mountcommand[STRING_SIZE];
  char scsiModule[STRING_SIZE];
  char *messageText = "";
  char message[STRING_SIZE];
  char fsOptions[STRING_SIZE]; /* used for DAC960 RAID */

  char rpm_kernel[STRING_SIZE];
  char rpm_inst[STRING_SIZE];

  int cdmounted;
  int installtype = CDROM_INSTALL; 
  int rc;
  int inst_type = -1;
  int disk_size = 0;
  int noscan = 0;
  int cpu_type = 0;

  int swap = 0;
  int root = 0;
  int temp = 0;
  int home = 0;
  int var  = 0;
  int result = 0;
  int done = 2;
  int res = 0;
  int scsiSuccess = 0;

  struct devparams hdparams, cdromparams;
  struct networkparams networkparams;
  struct userInfo newUser;
  struct scsiInfo infoScsi;

  memset(&hdparams, 0, sizeof(struct devparams));
  memset(&cdromparams, 0, sizeof(struct devparams));
  memset(&networkparams, 0, sizeof(struct networkparams));

  /* Open up log file. */
  /* ----------------- */
  if (argc >= 2) {		
    if (!(flog = fopen(argv[1], "w+"))) {
      printf("Couldn't open log terminal\n"); return 0;
    }
  }
  else {
    printf("Log terminal not given\n"); return 0;
  }

  log = argv[1];
  fprintf(flog, "Install program started.\n");


  /* Initialize newt */
  /* --------------- */
  newtInit();
  newtCls();


  /* Print header and footer */
  /* ----------------------- */
  sprintf (commandstring, "Guardian Digital EnGarde Secure Linux v%s", ENGARDE_VER);
  newtDrawRootText(0, 0, commandstring); 
  sprintf (commandstring, "Installer v%s", INSTALLER_VER);
  newtDrawRootText(63, 0, commandstring);
  newtPushHelpLine("             <Tab>/<Alt-Tab> between elements   |  " \
                   "<Space> selects");		
   inst_type = 4;

  
  /* Print the greeting */
  /* ------------------ */
  newtWinMessage(TITLE, "Ok", "Welcome to the installer program for EnGarde " \
                 "Secure Linux.  Selecting Cancel on any of the " \
                 "following screens will cause the installer to quit and the " \
                 "machine to be rebooted.");


  /* Prompt user to enter CD-ROM */
  /* --------------------------- */
  if (installtype == CDROM_INSTALL) {
    fprintf(flog, "Looking for IDE CDROM...\n");

    /* First look for an IDE CDROM. */
    if (!(letter = findidetype(IDE_CDROM))) {
      fprintf(flog, "No IDE CDROM found.\n"); /* If fail, go to CDROM menu. */

      if (!(cdrommenu(&cdromparams))) {
        errorbox("No CDROM found.");
        goto EXIT;
      }
    }
    else {
      snprintf(cdromparams.devnode, STRING_SIZE, "/dev/hd%c", letter);
      cdromparams.module = 0;
    }

    insertmessage = "Please insert the EnGarde CD in the CDROM drive.";
    insertdevnode = cdromparams.devnode;
  }
  else {
    insertmessage = "Please insert the EnGarde driver diskette in the " \
    "floppy drive.";
    insertdevnode = "/dev/fd0";
  }


  /* Try to mount /cdrom in a loop. */
  /* ------------------------------ */
  cdmounted = 0;
  snprintf(mountcommand, STRING_SIZE, "/bin/mount %s /cdrom", insertdevnode);

  while (!cdmounted) {
    rc = newtWinChoice(TITLE, "Ok", "Cancel", insertmessage);

    if (rc != 1) { errorbox("Installation canceled."); goto EXIT; }

    statuswindow(32, 3, "EnGarde Secure Linux", "Attempting to mount %s.", insertdevnode); 

    if (!(mysystem(mountcommand))) cdmounted = 1;
    else fprintf(flog, "Mount command failed.\n");
  }

  fprintf(flog, "HD: devnode=%s, module=%d, modulename=%s, options=%s\n",
          hdparams.devnode, hdparams.module, hdparams.modulename,
          hdparams.options);

  fprintf(flog, "CDROM: devnode=%s, module=%d, modulename=%s, options=%s\n",
          cdromparams.devnode, cdromparams.module, cdromparams.modulename,
          cdromparams.options);

  /* Swap /bin/ash with bash on CD-ROM. */
  /* ---------------------------------- */
  system ("/bin/ln -sf /cdrom/bin/bash /bin/bash");
  system ("/bin/ln -sf /cdrom/bin/bash /bin/sh");

  /* Create a virtual console on tty2 */
  /* -------------------------------- */
  system ("/bin/open -c 2 /bin/bash");

  system ("/bin/touch /tmp/ad_results");
  system ("/bin/touch /tmp/isa_probe_results");
  system ("/bin/touch /tmp/probe.conf");

  /* Check to see if --noscan is on, if not run ISA scan */
  /* --------------------------------------------------- */
  if (argc >= 3) {
     if (strstr(argv[2], "noscan")) {
        noscan = 1;
     }
  }
  if (noscan == 0) {
     system("/bin/pnpdump > /tmp/probe.conf");
     system("/bin/ln -sf /tmp/probe.conf /etc/probe.conf");
     system("/bin/scan_isa_bus");
     system("/bin/scan_pci_bus"); 
  }
  newtPopWindow();


  /* Display license agreement to user */
  /* --------------------------------- */
  if (!(displayLicense())) callReboot(); 


  /* Check to see if user is installing proper version */
  /* ------------------------------------------------- */
  properArch(); 


  /* Decide between SCSI and IDE install */ 
  /* ----------------------------------- */
  while ( done == 2 ) {

     scsiSuccess = 0;

     inst_type = newtWinChoice(TITLE, "SCSI Disk", "IDE Disk", "What disk " \
                            "should I install on?");


     /* We want to install onto an IDE disk */
     /* ----------------------------------- */
     if (inst_type == 2) {

       /* Look for first available IDE drive. */
       /* ----------------------------------- */
       if (!(letter = findidetype(IDE_HD))) {
         errorbox("No IDE harddisk found.");
         done = 2; 
       } else {
       
          fprintf(flog, "Found Harddisk.\n");
	  done = 1;

          /* Make the hdparms struct and print the contents. */
          /* ----------------------------------------------- */
          /* snprintf(hdparams.devnode, STRING_SIZE, "/dev/hda"); */
          snprintf(hdparams.devnode, STRING_SIZE, "/dev/hd%c", letter);
          hdparams.module = 0;
          fprintf(flog, "Installation type: %d\n", installtype);
       }
     }

     

     /* We want to install onto an SCSI disk */
     /* ------------------------------------ */
     else if (inst_type == 1) {
       
       /* Try to autodetect SCSI card */
       /* --------------------------- */
       if ( noscan == 0 ) {
          if ( ( result = scsiPCIScan(scsiModule)) == 0 ) {
    	     result = scsiISAScan(scsiModule);
          }
       }

      if ( result ) { done = 1; }

      /* If autodetect failed display support SCSI to user */
      /* ------------------------------------------------- */ 
      if ( result == 0 ) {
           done = newtWinChoice(TITLE, "Ok", "Back", "SCSI controller auto-detection failed.");
           if ( done != 2 ) {  
	      displaySCSIList(scsiModule); 
	      done = 0;
           }	
      }

      if ( done != 2 ) {
     
         while ( scsiSuccess == 0 ) {     
            statuswindow(35, 3, "Modules", "Loading SCSI module...");
            /* Attempt to load SCSI controller module */
            /* -------------------------------------- */
            scsiSuccess = 1; 
            if ( !(strcmp(scsiModule, "DAC960.o"))) sprintf (commandstring, "/sbin/insmod /lib/modules/%s-BOOT/block/%s", KERNEL_VER_I386, scsiModule);
            else sprintf (commandstring, "/sbin/insmod /lib/modules/%s-BOOT/scsi/%s", KERNEL_VER_I386, scsiModule);
            if (!(mysystem (commandstring))) {
               fprintf (flog, "Module %s successfullyloaded.\n", scsiModule);

	    sprintf (commandstring, "alias scsi_hostadapter %s", scsiModule);
	    writeModuleconf (commandstring);
            } else {
               scsiSuccess = 0;
 	       messageText = "Unable to properly load SCSI controller module";
               res = newtWinChoice(TITLE, "Back", "Choose", messageText);        
               if (res == 1) { 
                  done = 2;
                  scsiSuccess = 1;
               } else {
                  displaySCSIList(scsiModule); 
               }
            }

         }
         newtPopWindow();
       
         /* Make the hdparms struct and print the contents. */
         /* ----------------------------------------------- */
 	 if ( !(strcmp(scsiModule, "DAC960.o"))) snprintf(hdparams.devnode, STRING_SIZE, "/dev/rd/c1d1p");
         else snprintf(hdparams.devnode, STRING_SIZE, "/dev/sda");
         hdparams.module = 0;
         fprintf(flog, "Installation type: %d\n", installtype);
      }
    }
    else { goto EXIT; }
  }
 
  infoScsi.scsi = scsiSuccess; 
 

  /* Get the size of the disk for later manipulation. */
  /* ------------------------------------------------ */
  disk_size = getdisksize(hdparams.devnode);
  if ( disk_size < MIN_SIZE ) {
     sprintf(message, "The current drive is %iMb.  EnGarde Secure Linux requires at least a %iMb harddisk for proper operation.", disk_size, MIN_SIZE);
     errorbox(message);
     goto EXIT;
  }
  
  /* Determine root and swap sizes to use with this disk */
  /* --------------------------------------------------- */
  swap = disk_size * DEF_SWAP;
  if ( swap < MIN_SWAP ) swap = MIN_SWAP;
  if ( swap > MAX_SWAP ) swap = MAX_SWAP;
  
  root = (disk_size - swap) * DEF_ROOT;
  if ( root < MIN_ROOT ) root = MIN_ROOT;
  if ( root > MAX_ROOT ) root = MAX_ROOT;


  /* Prompt the type of system, and create the partitions accordingly. */
  /* ----------------------------------------------------------------- */
/*  rc = newtWinTernary(TITLE, "Web Server", "Mail Server", "Firewall", "The " \ 
                      "installer will now prepare the drive on %s.  The " \
                      "disk will be partitioned and the filesystems will be " \
                      "created, based upon your selection.", hdparams.devnode); */

  rc = newtWinChoice(TITLE, "Web Server", "Mail Server", "The installer will " \
                            "now prepare the drive on %s.  The disk will be " \
			    "partitioned and the filesystems will be created, " \
			    "based upon your selection.", hdparams.devnode);


  if (rc == 1) {
    temp = disk_size - root - swap;
    home = temp * .66;
    var  = temp * .33;
  }
  else if (rc == 2) {
    temp = disk_size - root - swap;
    home = temp * .33;
    var  = temp * .66;
  }
  else if (rc == 3) {
    temp = disk_size - root - swap;
    home = temp * .50;
    var  = temp * .50;
  }
  else{ goto EXIT; }

/***  Debugging information printed to newt console 
  sprintf(message, "DRIVE = %i\nROOT = %i\nSWAP = %i\nHOME = %i\nVAR = %i", disk_size, root, swap, home, var);
  errorbox(message);
***/

  fprintf(flog, "ROOT = %i\n", root);
  fprintf(flog, "SWAP = %i\n", swap);
  fprintf(flog, "HOME = %i\n", home);
  fprintf(flog, "VAR  = %i (the rest)\n", var);

  partmap = fopen("/tmp/partmap", "w+");
    fprintf(partmap, ",%i,82\n", swap);
    fprintf(partmap, ",%i,83\n", root);
    fprintf(partmap, ",%i,83\n", home);
    fprintf(partmap, ",,83\n");
    fflush(partmap);
  fclose(partmap);

  /* Print drive partition warning */
  /* ----------------------------- */
  newtWinMessage("Drive Partitioning", "Ok", "WARNING:\n\n " \
			"All data currently on %s will be destroyed.  " \
			"The drive will automatically be partitioned " \
			"for EnGarde Linux.  If you wish to cancel now " \
                        "you can reboot your system.\n\n " \
			"Press 'Ok' to continue or reboot to exit the installer ", hdparams.devnode);


  /* Partition the drive */
  /* ------------------- */
  snprintf(commandstring, STRING_SIZE, "/installer/bin/sfdisk -uM %s < %s",
           hdparams.devnode, "/tmp/partmap");

  if (runcommandwithstatus(commandstring, "Partitioning disk...")) {
    errorbox("Unable to partition the disk."); goto EXIT;
  }

  unlink("/tmp/partmap");

  /* Make the swap partition */
  /* ----------------------- */
  snprintf(commandstring, STRING_SIZE, "/installer/bin/mkswap %s1",
           hdparams.devnode);

  if (runcommandwithstatus(commandstring, "Making swap partition...")) {
    errorbox("Unable to make swapspace."); goto EXIT;
  }

  if (!(strcmp(scsiModule, "DAC960.o"))) strcpy (fsOptions, "-b 4096 -R stride=16 -i 16384 -s 1"); 
  else strcpy (fsOptions, " ");
    
  /* Make the filesystems */
  /* -------------------- */
  snprintf(commandstring, STRING_SIZE, "/installer/bin/mke2fs %s %s2",
           fsOptions, hdparams.devnode);	
  if (runcommandwithstatus(commandstring, "Making / ...")) {
    errorbox("Unable to make /."); goto EXIT;
  }

  snprintf(commandstring, STRING_SIZE, "/installer/bin/mke2fs %s %s3",
           fsOptions, hdparams.devnode);	
  if (runcommandwithstatus(commandstring, "Making /home ...")) {
    errorbox("Unable to make /home."); goto EXIT;
  }

  snprintf(commandstring, STRING_SIZE, "/installer/bin/mke2fs %s %s4",
           fsOptions, hdparams.devnode);	
  if (runcommandwithstatus(commandstring, "Making /var ...")) {
    errorbox("Unable to make /var."); goto EXIT;
  }


  /* And finally, mount them. */
  /* ------------------------ */
  snprintf(commandstring, STRING_SIZE, "/sbin/mount %s2 /harddisk",
           hdparams.devnode);
  if (runcommandwithstatus(commandstring, "Mounting /...")) {
    errorbox("Unable to mount /."); goto EXIT;
  }


  snprintf(commandstring, STRING_SIZE, "/bin/mkdir -p /harddisk/home");
  mysystem(commandstring);
  snprintf(commandstring, STRING_SIZE, "/bin/mkdir -p /harddisk/var");
  mysystem(commandstring);

  snprintf(commandstring, STRING_SIZE, "/sbin/mount %s3 /harddisk/home",
           hdparams.devnode);
  if (runcommandwithstatus(commandstring, "Mounting /home...")) {
    errorbox("Unable to mount /home."); goto EXIT;
  }

  snprintf(commandstring, STRING_SIZE, "/sbin/mount %s4 /harddisk/var",
           hdparams.devnode);
  if (runcommandwithstatus(commandstring, "Mounting /var...")) {
    errorbox("Unable to mount var."); goto EXIT;
  }

  /* Time to do the actual install */
  /* ----------------------------- */
  mysystem("mkdir -p /harddisk/var/lib/rpm");

  snprintf(rpm_inst, STRING_SIZE, "/cdrom/bin/bash /bin/rpm_inst"); 
  runcommandwithstatus(rpm_inst, "Installing Packages...");


  /* Install appropraite kerenl */
  /******************************/
  cpu_type = cpuVersion(); 
  
  switch (cpu_type) {
 
     case 1 : 
	snprintf(rpm_kernel, STRING_SIZE, "/installer/bin/rpm --rcfile /installer/rpmrc --root /harddisk --excludedocs -Uhv /installer/RPMS/kernels/kernel-lids-mods-%s.i386.rpm", KERNEL_VER_I386);
	break;
     case 2 :
	snprintf(rpm_kernel, STRING_SIZE, "/installer/bin/rpm --rcfile /installer/rpmrc --root /harddisk --excludedocs -Uhv /installer/RPMS/kernels/kernel-lids-mods-%s.i686.rpm", KERNEL_VER_I686);
        break;
     case 3 : 
        snprintf(rpm_kernel, STRING_SIZE, "/installer/bin/rpm --rcfile /installer/rpmrc --root /harddisk --excludedocs -Uhv /installer/RPMS/kernels/kernel-smp-lids-mods-%s.i686.rpm", KERNEL_VER_I686);
        runcommandwithstatus(rpm_kernel, "Installing Secondary System Kernel...");
        snprintf(rpm_kernel, STRING_SIZE, "/installer/bin/rpm --rcfile /installer/rpmrc --root /harddisk --excludedocs -Uhv /installer/RPMS/kernels/kernel-smp-mods-%s-i686.rpm", KERNEL_VER_I686);
        break;
     default : 
        snprintf(rpm_kernel, STRING_SIZE, "/installer/bin/rpm --rcfile /installer/rpmrc --root /harddisk --excludedocs -Uhv /installer/RPMS/kernels/kernel-lids-mods-%s.i386.rpm", KERNEL_VER_I386);
        break;
  }

  runcommandwithstatus(rpm_kernel, "Installing Primary System Kernel...");


  /* Network driver and params. */
  /* -------------------------- */
  if (!(networkmenu(&networkparams, noscan))) {
    errorbox("Network setup failed."); goto EXIT;
  }


  /* Create a new user */
  /* ----------------- */
  if (newUserInit() == 1) {
     newUser = displayNewUser();
     writeUserInfo(newUser);
  }


  /* Create /dev/cdrom link */
  /* ---------------------- */
  sprintf(commandstring, "/bin/ln -s %s /harddisk/dev/cdrom", cdromparams.devnode);
  mysystem (commandstring);


  /* Write the configuration files */
  /* ----------------------------- */
  if (!(writeconfigs(&hdparams, &networkparams))) {
    errorbox("Error writing configuration information."); goto EXIT;
  }


  /* Run LILO */
  /* -------- */
  if (mysystem("chroot /harddisk /sbin/lilo")) {
    errorbox("Could not run LILO."); goto EXIT;
  }


  /* Create system boot disk */
  /* ----------------------- */
  createBootDisk(hdparams.devnode);


  /* Umount /var, /home, and / */
  /* ------------------------- */
  if (mysystem("/sbin/umount /harddisk/var")) {
    errorbox("Unable to unmount /var."); goto EXIT;
  }

  if (mysystem("/sbin/umount /harddisk/home")) {
    errorbox("Unable to unmount /home."); goto EXIT;
  }

  if (mysystem("/sbin/umount /harddisk")) {
    errorbox("Unable to unmount /."); goto EXIT;
  }

  /* Kill bash on tty2 */
  /* ----------------- */
  system ("for n in `ps -x | grep bash | grep tty2 | grep -v grep | cut -c1-5`; do kill -9 $n; done;");
  system ("/bin/open -c 2 /bin/ash");

  if (!mysystem("/bin/umount -f /dev/cdrom")) {

     /* Eject the CD-ROM */
     /* ---------------- */
     if (installtype == CDROM_INSTALL) {
        snprintf(commandstring, STRING_SIZE, "/usr/bin/eject %s",
                 cdromparams.devnode);
        if (mysystem(commandstring)) {
           errorbox("Unable to eject the CDROM.");  
   	
        }
     }
  }


  /* Happy little success message. */
  /* ----------------------------- */
  newtWinMessage("Congratulations!", "Ok" , "You have successfully installed " \
                 "EnGarde Linux.  Please " \
                 "remove any floppy disks or CD-ROMs from your computer at " \
                 "this time.  After the machine reboots you must go through " \
                 "the initial configuration. \n " \
                 "From a remote machine on the same network, enter the " \
                 "following in your Web browser:\n\n " \
                 "             https://192.168.10.100:1023\n\n " \
                 "Replace the IP address above with the one you chose during " \
                 "the network configuration process.\n " \

		 "For further information, view the online manual located on " \
                 "the CDROM or on the engardelinux.org Web site."); 
  callReboot(); 

EXIT:	
  fprintf(flog, "Install program ended.\n");	
  fflush(flog);
  fclose(flog);
		
  newtWinMessage(TITLE, "Ok",	"Press Ok to reboot.");
  newtFinished();

  callReboot();

  return 0;
}





/* stripnl().  Replaces \n with \0 */
void stripnl(char *s) { 
   char *t = strchr(s, '\n'); 
   if (t) *t = '\0'; 
}

/* Little wrapper. */
int mysystem(char *command) {
  char mycommand[STRING_SIZE];
	
  snprintf(mycommand, STRING_SIZE, "%s >>%s 2>>%s", command, log, log);
  fprintf(flog, "Running command: %s\n", command);
  return system(mycommand);
}

void errorbox(char *message) { newtWinMessage("ERROR", "Ok", message); }

void statuswindow(int width, int height, char *title, char *text, ...) {
  newtComponent t, f;
  char *buf = NULL;
  int size = 0;
  int i = 0;
  va_list args;

  va_start(args, text);
    do {
      size += 1000;
      if (buf) free(buf);
      buf = malloc(size);
      i = vsnprintf(buf, size, text, args);
    } while (i == size);
  va_end(args);

  newtCenteredWindow(width, height, title);

  t = newtTextbox(1, 1, width - 2, height - 2, NEWT_TEXTBOX_WRAP);
  newtTextboxSetText(t, buf);
  f = newtForm(NULL, NULL, 0);

  free(buf);

  newtFormAddComponent(f, t);

  newtDrawForm(f);
  newtRefresh();
  newtFormDestroy(f);
}


int runcommandwithstatus(char *command, char *message) {
  int rc;
	
  statuswindow(60, 3, TITLE, message);
  rc = mysystem(command);
  newtPopWindow();

  return rc;
}


/* This one borrowed from redhat installer. */
int runcommandwithprogress(int width, int height, char *title, char *command,
                           int lines, char *text, ...) {
  newtComponent t, f, s;
  char *buf = NULL;
  int size = 0;
  int i = 0;
  va_list args;
  int rc = 0;
  FILE *p;
  char buffer[STRING_SIZE];
  int progress = 0;

  va_start(args, text);
    do {
      size += 1000;
      if (buf) free(buf);
      buf = malloc(size);
      i = vsnprintf(buf, size, text, args);
    } while (i == size);
  va_end(args);

  newtCenteredWindow(width, height, title);

  t = newtTextbox(1, 1, width - 2, height - 2, NEWT_TEXTBOX_WRAP);
  newtTextboxSetText(t, buf);
  f = newtForm(NULL, NULL, 0);

  free(buf);

  newtFormAddComponent(f, t);
	
  s = newtScale(1, 3, width - 2, lines);
  newtScaleSet(s, progress);
	
  newtFormAddComponent(f, s);

  newtDrawForm(f);
  newtRefresh();
	
  if (!(p = popen(command, "r"))) { rc = 1; goto EXIT; }

  setvbuf(p, NULL, _IOLBF, 255);
	
  while (fgets(buffer, STRING_SIZE, p)) {
    newtScaleSet(s, ++progress);
    newtRefresh();	
    fprintf(flog, "%s", buffer);
  }
		
  pclose(p);
  rc = 0;
	
EXIT:
  newtFormDestroy(f);
  newtPopWindow();

  callReboot(); 
		
  return rc;
}


void writeModuleconf (char *moduleString) {
   FILE *outfile, *fopen();
   char tmpstr[STRING_SIZE] = "";

   fprintf (flog, "Writting to modules.conf:\n%s\n", moduleString);
 
   strncpy (tmpstr, moduleString, ( strlen(moduleString) - 2));
 
   if (!(outfile = fopen("/tmp/modules.conf", "a"))) 
       errorbox("Unable to write to /tmp/modules.conf.");
   else {

     fprintf (outfile, "%s\n", tmpstr);
     fprintf (flog, "Writing %s to module.conf\n", tmpstr);

     fclose (outfile);
   }
}

int cpuVersion() {
  FILE *cpu_info, *fopen();
  int cpu_type = 1;

  if ( (cpu_info = fopen ("/etc/i386", "r")) != NULL) {
     cpu_type = 1;
     fclose (cpu_info);
  } else {
     if ( (cpu_info = fopen ("/tmp/cpu_info", "r")) != NULL) {
        fscanf (cpu_info, "%d", &cpu_type);
        fclose (cpu_info);
     }
  }  

  return cpu_type;
}

void callReboot() {
   FILE *CtrlAltDel, *fopen();

   if (!(CtrlAltDel = fopen("/tmp/modules.conf", "w"))) {
      fprintf (CtrlAltDel, "1");
      fclose (CtrlAltDel);
   } 

   reboot(LINUX_REBOOT_CMD_RESTART);

}

