/*
 * The Guardian Digital EnGarde Secure Linux Installer v1.0.6
 * Copyright (C) 2001 Guardian Digital, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */



#include "install.h"

struct isaDevices isaEthDev, isaSCSIDev;

struct isaDevices scanEth(int ethDevice) {
  struct isaDevices device;
  FILE *isaDevList, *ad_result, *fopen();
  char tempstr[80], ethernetDeviceID[80];
  int tmpdev = 0, devType = 0;

  /* scan device # in tmp file */
  if ( (isaDevList = fopen (ISA_DEVLIST_FILE, "r")) != NULL ) {
     while ( !feof(isaDevList) ) {
        fscanf(isaDevList, "%d", &tmpdev);
	fscanf(isaDevList, "%d", &devType);
        fscanf(isaDevList, "%s", tempstr);
	if (tmpdev == ethDevice) {
	   strcpy(ethernetDeviceID, tempstr);
	}
     }
  fclose(isaDevList);
  }  

  /* scan isa_eth.db for device */
  
  sprintf (tempstr, "/bin/card_detect.pl %s %s", ethernetDeviceID, ISA_ETH_DB); 
  system (tempstr);

  device = initDevStruct (device);
   
  /* Read results in from /tmp/ad_results */

  sprintf (tempstr, "Unknown"); 

  if ( (ad_result = fopen ("/tmp/ad_results", "r")) != NULL ) {
     fscanf(ad_result, "%s", device.deviceID);
     fscanf(ad_result, "%s", device.moduleName);
     fscanf(ad_result, "%s", device.mfgName);

     strcpy (device.deviceName, "");
     fscanf(ad_result, "%s", tempstr);
     while ( !feof(ad_result) ) {
	strcat (device.deviceName, tempstr);
        strcat (device.deviceName, " ");
        fscanf(ad_result, "%s", tempstr);
     } 
  } 
 
  return device;
  
}

struct isaDevices scanSCSI(int scsiDevice) {
  struct isaDevices device;
  FILE *isaDevList, *ad_result, *fopen();
  char tempstr[80], SCSIDeviceID[80];
  int tmpdev = 0, devType = 0;

  device = initDevStruct(device);

  /* scan device # in tmp file */
  if ( (isaDevList = fopen (ISA_DEVLIST_FILE, "r")) != NULL ) {
     while ( !feof(isaDevList) ) {
        fscanf(isaDevList, "%d", &tmpdev);
        fscanf(isaDevList, "%d", &devType);
        fscanf(isaDevList, "%s", tempstr);
        if (tmpdev == scsiDevice) {
           strcpy(SCSIDeviceID, tempstr);
        }
     }
  fclose(isaDevList);
  }

  /* scan isa_scsi.db for device */

  sprintf (tempstr, "/bin/card_detect.pl %s %s", SCSIDeviceID, ISA_SCSI_DB);
  system (tempstr);

  device = initDevStruct (device);

  /* Read results in from /tmp/ad_results */

  sprintf (tempstr, "Unknown");

  if ( (ad_result = fopen ("/tmp/ad_results", "r")) != NULL ) {
     fscanf(ad_result, "%s", device.deviceID);
     fscanf(ad_result, "%s", device.moduleName);
     fscanf(ad_result, "%s", device.mfgName);

     strcpy (device.deviceName, "");
     fscanf(ad_result, "%s", tempstr);
     while ( !feof(ad_result) ) {
        strcat (device.deviceName, tempstr);
        strcat (device.deviceName, " ");
        fscanf(ad_result, "%s", tempstr);
     }
  }

 
  return device;  

}

int scanISADev(void) { 
   FILE *isaDevs, *fopen();
   int c = -1, tmpdev, devType;
   char tempstr[80];

   if ( (isaDevs = fopen(ISA_DEVLIST_FILE, "r") ) != NULL ) {
      while ( !feof(isaDevs) ) {
         fscanf(isaDevs, "%d", &tmpdev);
	 fscanf(isaDevs, "%d", &devType);
         fscanf(isaDevs, "%s", tempstr);
	 c++;
      }
   fclose (isaDevs); 
   }


   return c;
}

int scanISAType(int deviceNum) { /* return 1 for ethernet 2 for SCSI */
  FILE *isaDevList, *fopen();
  char tempstr[80];
  int tmpdev = 0, devType = 0;

  /* scan device # in tmp file */
  if ( (isaDevList = fopen (ISA_DEVLIST_FILE, "r")) != NULL ) {
     while ( !feof(isaDevList) ) {
        fscanf(isaDevList, "%d", &tmpdev);
        fscanf(isaDevList, "%d", &devType);
        fscanf(isaDevList, "%s", tempstr);
        if (tmpdev == deviceNum) {
	   return devType;
        }
     }
  }
 
  return devType;
}

struct isaDevices initDevStruct(struct isaDevices device) {
   strcpy(device.deviceName, "Unknown");
   strcpy(device.deviceID, "Unknown");
   strcpy(device.mfgName, "Unknown");
   strcpy(device.moduleName, "Unknown");

   return device;
}
