/*
 * The Guardian Digital EnGarde Linux Installer v1.0.6
 * Copyright (C) 2001 Guardian Digital, Inc. 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <newt.h>

#define TITLE "EnGarde Secure Linux v1.0.1"
#define ENGARDE_VER "1.0.1"
#define INSTALLER_VER "1.0.11"
#define STRING_SIZE 256

#define PCI_DEVLIST_FILE "/tmp/pci_probe_results"
#define PCI_SCSILIST_FILE "/tmp/pci_scsi_results"
#define PCI_ETH_DB "/etc/pci_eth.db"
#define PCI_SCSI_DB "/etc/pci_scsi.db"

#define ISA_DEVLIST_FILE "/tmp/isa_probe_results"
#define ISA_SCSILIST_FILE "/tmp/isa_scsi_results"
#define ISA_ETH_DB "/etc/isa_eth.db"
#define ISA_SCSI_DB "/etc/isa_scsi.db"

#define KERNEL_VER_NUM "2.2.19"
#define KERNEL_REL_I686 "1.0.6"
#define KERNEL_REL_I386 "1.0.9"
#define KERNEL_VER_I686 "2.2.19-1.0.6" 
#define KERNEL_VER_I386 "2.2.19-1.0.9"
#define KERNEL_VER ( cpuVersion() == 1 ? KERNEL_VER_I386 : KERNEL_VER_I686 )
#define KERNEL_BLOCKS 570

/*
* Define default partitioning information
*
* Drives are partitioned as follows:
* swap = 5% of total drive, no less than or greater than defined below 
* root = 25% of total drive - swap, no greater or less than defined below
* var and home percentages based on total drive - swap - root.
*/

#define DEF_SWAP .05   /* default swap percentage */
#define MAX_SWAP 256   /* maximum size swap partition */
#define MIN_SWAP 32    /* minimum size swap partition */
#define DEF_ROOT .25   /* default root percentage */
#define MAX_ROOT 2048  /* Maximum size root partition */
#define MIN_ROOT 320   /* minimum size root partition */
#define MIN_SIZE 520   /* smallest size drive to install on */

#define MAX_ETH_DEVICES 200

#define IDE_EMPTY 0
#define IDE_CDROM 1
#define IDE_HD 2
#define IDE_UNKNOWN 3

/* CDROMS and harddisks. */
struct devparams
{
	char devnode[STRING_SIZE];
	int module;
	char modulename[STRING_SIZE];
	char options[STRING_SIZE];
};

/* Network parameters.  Driver and addresses. */
struct networkparams
{
	char modulename[STRING_SIZE];
	char options[STRING_SIZE]; /* unused. */
	char address[STRING_SIZE];
	char netaddress[STRING_SIZE];
	char netmask[STRING_SIZE];
	char gateway[STRING_SIZE];
	char broadcast[STRING_SIZE];
};

/* ISA Bus Scan */
struct isaDevices
{
	char deviceName[80];
	char deviceID[80];
	char mfgName[80];
	char moduleName[80];
};

struct scsiInfo {
        char moduleName[80];
        char controllerName[80];
        int scsi;
};

struct userInfo {
	char realName[STRING_SIZE];
	char userName[STRING_SIZE];
	char password[STRING_SIZE];
        int  skip;
};

/* main.c */
int reboot (int flag);
void stripnl(char *s);
int mysystem(char *command);
void errorbox(char *message);
void statuswindow(int width, int height, char *title, char *text, ...);
int runcommandwithprogress(int width, int height, char *title, char *command,
	int lines, char *text, ...);
int runcommandwithstatus(char *command, char *message);
void writeModuleconf(char *moduleString);
int cpuVersion(void); 
void callReboot(void);

/* ide.c */
int checkide(char letter);
char findidetype(int type);
int getdisksize(char* devnode);

/* cdrom.c */
int cdrommenu(struct devparams *p);

/* nic.c */
int networkmenu(struct networkparams *p, int noscan);

/* config.c */
int writeconfigs(struct devparams *dp, struct networkparams *np);

/* isa_scan.c */
int scanISADev(void); /* Gets the total number of ISA devices */
struct isaDevices scanEth(int ethDevice);
struct isaDevices scanSCSI(int scsiDevice);
int scanISAType(int deviceNum); /* returns ethernet or SCSI device */
struct isaDevices initDevStruct(struct isaDevices device);

/* pci_scan.c */
int scanPCIDev(void); /* Gets the total number of ISA devices */
struct isaDevices scanPCIEth(int devNum);

/* scsi.c */
int scsiPCIScan(char moduleName[80]);
int scsiISAScan(char moduleName[80]);
void displaySCSIList(char *scsiModule);

/* newuser.c */
int newUserInit(void);
struct userInfo displayNewUser(void);
int writeUserInfo(struct userInfo info);

/* license.c */
int displayLicense(void);

/* bootdisk.c */
int createBootDisk(char device[STRING_SIZE]);

/* misc.c */
void properArch(void);
