/*
 * The Guardian Digital EnGarde Secure Linux Installer v1.0.6
 * Copyright (C) 2001 Guardian Digital, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */


#include "install.h"

/* checkide().  Scans the named drive letter and returns the IDE_??? type. */
int checkide(char letter)
{
	FILE *f = NULL;
	char filename[STRING_SIZE];
	char buffer[STRING_SIZE];
	
	sprintf(filename, "/proc/ide/hd%c/media", letter);
	
	if (!(f = fopen(filename, "r")))
		return IDE_EMPTY;
		
	if (!(fgets(buffer, STRING_SIZE, f)))
	{
		printf("Couldn't read from %s\n", filename);
		fclose(f);
		return IDE_EMPTY;
	}
		
	fclose(f);
	
	stripnl(buffer);
	
	if (strcmp(buffer, "cdrom") == 0)
		return IDE_CDROM;
	else if (strcmp(buffer, "disk") == 0)
		return IDE_HD;
	else
		return IDE_UNKNOWN;
}

/* findidetype().  Finds the first ide deveice of the given IDE_?? type. */
char findidetype(int type)
{
	char letter;
	
	for (letter = 'a'; letter <= 'z'; letter++)
	{
		if ((checkide(letter)) == type)
		{
			return letter;
		}
	}
	return '\0';
}

int getdisksize(char* devnode) {
  FILE *f = NULL;
  char filename[STRING_SIZE];
  char command[STRING_SIZE];

  int size = 0;

  /* Find out the size of the drive */
  /* ------------------------------ */
  snprintf(command, STRING_SIZE, "/installer/bin/sfdisk -s %s > /tmp/sfdisk.out", devnode);
  system(command);

  sprintf(filename, "/tmp/sfdisk.out");
  if (!(f = fopen(filename, "r"))) { perror("No open\n"); exit(-1); }

    if (!(fscanf(f, "%i", &size))) {
      printf("Couldn't read from %s\n", filename);
      fclose(f);
      exit(-2);
    }
  fclose(f);
  unlink("/tmp/sfdisk.out");

  size /= 1024;

  return size;
}
