/*
 * The Guardian Digital EnGarde Secure Linux Installer v1.0.6
 * Copyright (C) 2001 Guardian Digital, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "install.h"

extern FILE *flog;
extern char *log;

void makeInitrd(char * initrdName);

int writeconfigs(struct devparams *dp, struct networkparams *np) {
  FILE *f;
  char commandstring[STRING_SIZE];
  char password[STRING_SIZE];
  char devnode[STRING_SIZE];
  char moddepstr[STRING_SIZE];  
  char options[STRING_SIZE];
  char opt[STRING_SIZE];
  char tmpstr[STRING_SIZE];
  char letter;

  int scsi = 0;
  int diskSize = 0;

  struct scsiInfo infoScsi;

  /* Write /etc/network/interfaces from scratch. */
  /* ------------------------------------------- */
  if (!(f = fopen("/harddisk/etc/network/interfaces", "w"))) {
    errorbox("Unable to write to /etc/network/interfaces.");
    return 0;
  }
    fprintf(f, "# /etc/network/interfaces -- configuration file for ifup(8), " \
               "ifdown(8)\n\n");
    fprintf(f, "# The loopback interface\n");
    fprintf(f, "iface lo inet loopback\n");
    fprintf(f, "  up route add -net 127.0.0.0 netmask 255.0.0.0 dev lo\n\n");
    fprintf(f, "# The first network card - this entry was created during the " \
               "initial\n");
    fprintf(f, "# configuration (network, broadcast and gateway are " \
               "optional)\n");
    fprintf(f, "iface eth0 inet static\n");
    fprintf(f, "  address %s\n", np->address);
    fprintf(f, "  netmask %s\n", np->netmask);
    fprintf(f, "  network %s\n", np->netaddress);
    fprintf(f, "  broadcast %s\n", np->broadcast);
    fprintf(f, "  up route add default gw %s\n", np->gateway);
  fclose(f);


  /* Write /etc/hosts from scratch. */
  /* ------------------------------ */
  if (!(f = fopen("/harddisk/etc/hosts", "w"))) {
    errorbox("Unable to write /etc/hosts."); return 0;
  }
    fprintf(f, "127.0.0.1\tlocalhost\n");
    fprintf(f, "%s\tengarde\n", np->address);
  fclose(f);


  /* Create empty modules.dep files */
  /* ------------------------------ */
  sprintf (moddepstr, "/harddisk/lib/modules/%s/modules.dep", KERNEL_VER);  
  if (f = fopen(moddepstr, "w")) fclose(f);

  fprintf (flog, "CPU type %d Detected.\n", cpuVersion());

  if ( cpuVersion() == 3) { /* We have a dual processor 686 */
     sprintf (moddepstr, "/harddisk/lib/modules/%s-smp-mods/modules.dep", KERNEL_VER);  
     if (f = fopen(moddepstr, "w")) fclose(f);
     sprintf (moddepstr, "/harddisk/lib/modules/%s-smp-lids-mods/modules.dep", KERNEL_VER);  
     if (f = fopen(moddepstr, "w")) fclose(f);
  }
  else { 
     sprintf (moddepstr, "/harddisk/lib/modules/%s-lids-mods/modules.dep", KERNEL_VER);
     if (f = fopen(moddepstr, "w")) fclose(f);
  }

  /* Write /etc/fstab from scratch. */
  /* ------------------------------ */
  if (!(f = fopen("/harddisk/etc/fstab", "w"))) {
    errorbox("Unable to write /etc/fstab."); return 0;
  }
    fprintf(f, "%s2	/		ext2	defaults	1 1\n", dp->devnode);
    fprintf(f, "%s3	/home		ext2	defaults	1 1\n", dp->devnode);
    fprintf(f, "%s4	/var		ext2	defaults	1 1\n", dp->devnode);
    fprintf(f, "%s1	swap		swap	defaults	0 0\n", dp->devnode);
    fprintf(f, "/dev/cdrom	/mnt/cdrom	iso9660	noauto,owner,ro	0 0\n", dp->devnode);
    fprintf(f, "/dev/fd0	/mnt/floppy	auto	noauto,owner	0 0\n", dp->devnode);
    fprintf(f, "none		/proc		proc	defaults	0 0\n", dp->devnode);
    fprintf(f, "none		/dev/pts	devpts	gid=5,mode=620	0 0\n", dp->devnode);
  fclose(f);



  /* Copy temp modules.conf to etc */
  /* ----------------------------- */
  sprintf (commandstring, "if [ -f /tmp/modules.conf ]; then cp -f /tmp/modules.conf /harddisk/etc/modules.conf; fi");
  mysystem (commandstring); 

  scsi = infoScsi.scsi;

  /* Write /etc/lilo.conf from scratch. */
  /* ---------------------------------- */
  diskSize = getdisksize(dp->devnode);

  if (!(f = fopen("/harddisk/etc/lilo.conf", "w"))) {
    errorbox("Unable to write /etc/lilo.conf."); return 0;
  }

  if (!(strcmp (dp->devnode, "/dev/sda"))) {
     scsi = 1;
     fprintf (flog, "Install device SCSI (%s).  Creating initial ramdisk image\n", dp->devnode);
     if (letter = findidetype(IDE_HD)) fprintf (f, "boot=/dev/hd%c\n", letter);
     else fprintf (f, "boot=/dev/sda\n");
  }
  else if (!(strcmp (dp->devnode, "/dev/c0d0p"))) { /* DAC960 found */
     scsi = 1;
     fprintf (flog, "Install device SCSI DAC960 (%s).  Creating initial ramdisk image\n", dp->devnode);
     if (letter = findidetype(IDE_HD)) fprintf (f, "boot=/dev/hd%c\n", letter);
     else fprintf (f, "boot=/dev/c0d0\n");
  }
  else {
     letter = findidetype(IDE_HD);
     fprintf (flog, "Install device IDE (%s).  No initial ramdisk necessary.\n", dp->devnode);
     fprintf (f, "boot=/dev/hd%c\n", letter);
     scsi = 0;
  } 

  if ( (cpuVersion() <= 1) && (diskSize <= 2048) ) strcpy (opt, "linear");
  else strcpy (opt, "lba32");

    fprintf(f, "map=/boot/map\n");
    fprintf(f, "install=/boot/boot.b\n");
    fprintf(f, "message=/boot/boot.msg\n");
    fprintf(f, "%s\n", opt);
    fprintf(f, "prompt\n");
    fprintf(f, "timeout=50\n");
    fprintf(f, "default=secure\n\n");
 

    if ( cpuVersion() <= 2) {  
       /* single processor machine lids kernel */
       if ( cpuVersion() == 2 ) strcpy (options, "-lids-mods");
       else strcpy (options, "-lids-mods");
       fprintf(f, "image=/boot/vmlinuz-%s%s\n", KERNEL_VER, options);
       if (scsi) { 
          sprintf (tmpstr, "%s%s\0", KERNEL_VER, options);
          makeInitrd(tmpstr);
          fprintf(f, "   initrd=/boot/initrd-%s%s\n", KERNEL_VER, options);
       }
       fprintf(f, "   label=secure\n");
       fprintf(f, "   read-only\n");
       fprintf(f, "   root=%s2\n\n", dp->devnode);

    } else {
       /* dual processor machine, use SMP kernels */
       fprintf(f, "image=/boot/vmlinuz-%s-smp-mods\n", KERNEL_VER);
       if (scsi) {
          sprintf (tmpstr, "%s-smp-mods", KERNEL_VER);
          makeInitrd(tmpstr);
          fprintf(f, "   initrd=/boot/initrd-%s-smp-mods\n", KERNEL_VER);
       }
       fprintf(f, "   label=standard\n");
       fprintf(f, "   read-only\n");
       fprintf(f, "   root=%s2\n\n", dp->devnode);

       fprintf(f, "image=/boot/vmlinuz-%s-smp-lids-mods\n", KERNEL_VER);
       if (scsi) {
          sprintf (tmpstr, "%s-smp-lids-mods", KERNEL_VER);
          makeInitrd(tmpstr);
          fprintf(f, "   initrd=/boot/initrd-%s-smp-lids-mods\n", KERNEL_VER, options);
       }
       fprintf(f, "   label=standard-smp\n");
       fprintf(f, "   read-only\n");
       fprintf(f, "   root=%s2\n\n", dp->devnode);
   }
    /* Setup standard non-smp non-lids kernel */
    fprintf(f, "image=/boot/vmlinuz-%s\n", KERNEL_VER);
    if (scsi) {
        sprintf (tmpstr, "%s", KERNEL_VER);
        makeInitrd(tmpstr);
        fprintf(f, "   initrd=/boot/initrd-%s\n", KERNEL_VER);
    }
    fprintf(f, "   label=standard\n");
    fprintf(f, "   read-only\n");
    fprintf(f, "   root=%s2\n", dp->devnode);

  fclose(f);

  /*  Clear out temporary space */
  /* -------------------------- */
  mysystem ("rm -rf /harddisk/tmp/*");

  return 1;
}


void makeInitrd(char kern[STRING_SIZE]) {
   char initrdName[STRING_SIZE];
   char command[STRING_SIZE];    
   
   sprintf (initrdName, "/boot/initrd-%s", kern); 
   sprintf (command, "/bin/create_initrd %s %s 2>&1 > /tmp/results", initrdName, kern);

   mysystem(command);
}
