/*
 * The Guardian Digital EnGarde Secure Linux Installer v1.0.6
 * Copyright (C) 2001 Guardian Digital, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */


#include "install.h"

extern FILE *flog;
extern char *log;

static int getparams(char *title, int suggestio, int *pio, int suggestirq, int *pirq);

/* cdrommenu().  Shows a menu of cdrom devices and attemtps to load the
 * module. */
int cdrommenu(struct devparams *p)
{
	int giveup = 0, try = 0;
	int choice;
	int io, irq;
	char commandstring[STRING_SIZE];
	char *cdroms[] = { "LaserMate", "SoundBlaster", "SoundScape", "16bit Teac",
		"CDU13A or CDU33A", "Philips/LMS", "MITSUMI", "Sanyo HR94A",
		"Sony CDU 535/531", "Optics Storage 8000 AT (Dolphin)", NULL };
	int rc;
	
	while (!giveup)
	{
		rc = newtWinMenu("Select CDROM type", "No IDE CDROM was detected in this " \
			"machine.  Please select which of the following drivers you wish "\
			"to use so that SmoothWall can access the CDROM.", 50, 5, 5, 6,
			cdroms, &choice, "Ok", "Cancel", NULL);
		
		/* rc will be 0 if return was pressed on the list, or 1 for the Ok or
		 * 2 for the cancel buttons. */
		if (rc == 2)
			return 0;
		
		switch (choice)
		{			
			/* Read any IO/IRQ info and set up the devparam struct. */
			case 0:
				strncpy(p->devnode, "/dev/sbpcd0", STRING_SIZE);
				strncpy(p->modulename, "sbpcd", STRING_SIZE);
				if (getparams(cdroms[choice], 0x320, &io, 0, NULL) == 1)
				{
					snprintf(p->options, STRING_SIZE, "sbpcd=0x%x,0", io);
					try = 1;
				}
				break;
				
			case 1:
				strncpy(p->devnode, "/dev/sbpcd0", STRING_SIZE);			
				strncpy(p->modulename, "sbpcd", STRING_SIZE);
				if (getparams(cdroms[choice], 0x230, &io, 0, NULL) == 1)
				{
					snprintf(p->options, STRING_SIZE, "sbpcd=0x%x,1", io);
					try = 1;
				}
				break;

			case 2:
				strncpy(p->devnode, "/dev/sbpcd0", STRING_SIZE);			
				strncpy(p->modulename, "sbpcd", STRING_SIZE);
				if (getparams(cdroms[choice], 0x338, &io, 0, NULL) == 1)
				{
					snprintf(p->options, STRING_SIZE, "sbpcd=0x%x,2", io);
					try = 1;
				}
				break;
				
			case 3:
				strncpy(p->devnode, "/dev/sbpcd0", STRING_SIZE);			
				strncpy(p->modulename, "sbpcd", STRING_SIZE);
				if (getparams(cdroms[choice], 0x2c0, &io, 0, NULL) == 1)
				{
					snprintf(p->options, STRING_SIZE, "sbpcd=0x%x,3", io);
					try = 1;
				}
				break;	
				
			case 4:
				strncpy(p->devnode, "/dev/cdu31a", STRING_SIZE);			
				strncpy(p->modulename, "cdu31a", STRING_SIZE);
				if (getparams(cdroms[choice], 0, &io, 0, &irq) == 1)
				{
					snprintf(p->options, STRING_SIZE,
						"cdu31a_port=%d cdu31a_irq=0x%x", io, irq);
					try = 1;
				}
				break;
			
			case 5:
				strncpy(p->devnode, "/dev/cm206cd", STRING_SIZE);
				strncpy(p->modulename, "cm206", STRING_SIZE);
				if (getparams(cdroms[choice], 0x300, &io, 11, &irq) == 1)
				{
					snprintf(p->options, STRING_SIZE, "cd206=0x%x,%d", io, irq);
					try = 1;
				}
				break;
				
			case 6:
				strncpy(p->devnode, "/dev/mcd", STRING_SIZE);
				strncpy(p->modulename, "mcdx", STRING_SIZE);
				if (getparams(cdroms[choice], 0, &io, 0, &irq) == 1)
				{
					snprintf(p->options, STRING_SIZE, "mcdx=0x%x,%d", io, irq);
					try = 1;
				}
				break;
				
			case 7:
				strncpy(p->devnode, "/dev/sjcd", STRING_SIZE);
				strncpy(p->modulename, "sjcd", STRING_SIZE);
				if (getparams(cdroms[choice], 0x340, &io, 0, NULL) == 1)
				{
					snprintf(p->options, STRING_SIZE, "sjcd_base=0x%x", io);
					try = 1;
				}
				break;
				
			case 8:
				strncpy(p->devnode, "/dev/cdu535", STRING_SIZE);
				strncpy(p->modulename, "sonycd535", STRING_SIZE);
				if (getparams(cdroms[choice], 0x320, &io, 0, &irq) == 1)
				{
					snprintf(p->options, STRING_SIZE, "sonycd535=0x%x", io);
					try = 1;
				}
				break;
				
			case 9:
				strncpy(p->devnode, "/dev/optcd", STRING_SIZE);
				strncpy(p->modulename, "optcd", STRING_SIZE);
				if (getparams(cdroms[choice], 0x340, &io, 0, NULL) == 1)
				{
					snprintf(p->options, STRING_SIZE, "optcd=0x%x", io);
					try = 1;
				}
				break;
							
			default:
				break;
		}
		
		if (try)
		{
			try = 0;
			/* Format command.  If it works, exit funct.  If not, loop. */
			snprintf(commandstring, STRING_SIZE, "/sbin/modprobe %s %s", p->modulename,
				p->options);
			
			if (!(mysystem(commandstring)))
			{
				p->module = 1;
				return 1;
			}
			else
			{
				errorbox("Module failed to load.");
			}
		}
	}

	return 0;
}

/* getparams().  Gets the requesting thingy if the pointer is non null. */
static int getparams(char *title, int suggestio, int *pio, int suggestirq, int *pirq)
{
	char message[STRING_SIZE];
	char temp[STRING_SIZE];
	struct newtWinEntry entries[3];
	char *values[3];		/* pointers for the values. */
	int c = 0;
	int ioslot = 0, irqslot = 0;	/* indexs in entries for the bits. */
	int rc = 0;
	int done = 0;
	
	/* If io... */
	if (pio)
	{
		values[c] = NULL;
		strcpy(message, "IO: ");	
		/* If a suggest io is givne, add it to the text, and format the values. */
		if (suggestio)
		{
			snprintf(temp, STRING_SIZE, "(suggest %x)", suggestio);
			strncat(message, temp, STRING_SIZE);
		
			snprintf(temp, STRING_SIZE, "%x", suggestio);		
			values[c] = strdup(temp);
		}
		entries[c].text = strdup(message);
		entries[c].value = &values[c];		
		entries[c].flags = 0;
		ioslot = c;
		c++;
	}
	
	if (pirq)
	{
		values[c] = NULL;
		strcpy(message, "IRQ: ");
		if (suggestirq)
		{
			snprintf(temp, STRING_SIZE, "(suggest %d)", suggestirq);
			strncat(message, temp, STRING_SIZE);

			snprintf(temp, STRING_SIZE, "%d", suggestirq);		
			values[c] = strdup(temp);	
		}
		entries[c].text = strdup(message);
		entries[c].value = &values[c];
		entries[c].flags = 0;
		irqslot = c;
		c++;
	}

	entries[c].text = NULL;
	entries[c].value = NULL;
	entries[c].flags = 0;
	
	/* Set at top of loop, cleared on error condition. */
	do
	{
		done = 1;
		
		rc = newtWinEntries(title, "Configure the CDROM by choosing the " \
			"appropriate IO address and/or IRQ.", 50, 5, 5, 5, entries, "OK", "Cancel", NULL);
		
		/* If ok... */
		if (rc != 2)
		{	
			/* message is the error message. */
			strcpy(message, "");
			if (pio)
			{
				/* pio mode.  Go through pointer and get value. */
				*pio = strtol(*entries[ioslot].value, NULL, 16);
				if (!(*pio))
				{
					strcat(message, "The IO port details entered are invalid. ");
					done = 0;
				}	
			}
			if (pirq)
			{
				*pirq = strtol(*entries[irqslot].value, NULL, 10);
				if (!(*pirq))
				{
					strcat(message, "The IRQ details entered are invalid.");
					done = 0;
				}
			}	
			if (!done)
				errorbox(message);
		}
	}
	while (!done);	

	/* free bits. */
	if (pio)
	{
		free(entries[ioslot].text);	
		if (*entries[ioslot].value)
			free(*entries[ioslot].value);
	}
	if (pirq)
	{
		free(entries[irqslot].text);
		if (*entries[irqslot].value)
			free(*entries[irqslot].value);
	}
		
	return rc;	/* 1 for ok, 2 for cancel. */
}

	
