/* Guardian Digital EnGarde Secure Linux Installer v1.0.6
 * Copyright (C) 2001 Guardian Digital, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "install.h"

extern FILE *flog;
extern char *log;

int askMakeDisk(void);
int insertDisk(void);
int createDisk(char dev[STRING_SIZE]);
void removeDisk(void);

char section[STRING_SIZE] = "Bootdisk Creation";

int createBootDisk(char device[STRING_SIZE]) {

  if ( askMakeDisk() ) {
      if ( insertDisk() ) createDisk(device); 
      else return 0;

      removeDisk();
   }
   else return 0;
 
   return 1;
}

/*******************/

int askMakeDisk(void) {
  int rc;  
  
  return ( (rc = newtWinChoice (section, "Ok", "Skip", "A boot disk can " \
                      "be created specifically for this system in the event " \
                      "of a boot failure.  The boot disk will contain a working " \
                      "kernel and will mount your root file system.\n\n" \
                      "Do you wish to create a boot disk?")) == 2) ? 0 : 1;
}
 
int insertDisk(void) {
  int rc;

  return ( (rc = newtWinChoice (section, "Ok", "Cancel", "Insert a blank disk.")) == 2) ? 0 : 1;
}

int createDisk(char dev[STRING_SIZE]) {
  char commandstring[STRING_SIZE];

  fprintf (flog, "Creating rescue disk on /dev/fd0 for /dev/%s", dev);
  sprintf (commandstring, "/bin/chroot /harddisk/ /sbin/mkbootdisk --noprompt --device /dev/fd0 %s\n", KERNEL_VER);

  return runcommandwithstatus(commandstring, "Creating system boot disk...");
}

void removeDisk(void) {
  newtWinMessage (section, "Ok", "Boot disk has been successfully created.\n\n " \
                           "Please remove the disk from the drive at this time " \
                           "and select the 'Ok' button to continue.");
}
