#include "einit.h"

int main(void) {

   printf("Running %s\n", TITLE);

   if (getKernelCommand() == 1) {
	startRescueMode();
   }
   else {
 	startInstall(getKernelCommand());
   }

  return 0;

}

int getKernelCommand(void) {
  
  FILE *k_cmdFile, *fopen();
  char *tmpstr[80];
  int result = 0; 

  if ( (k_cmdFile = fopen (CMDLINE_FILE, "r")) != NULL ) { 
    while ( !feof(k_cmdFile) ) { 
        fscanf(k_cmdFile, "%s", tmpstr);
        if ( strstr(tmpstr, "rescue") != 0 ) {
	   result = 1;
	}
	else if ( strstr(tmpstr, "noscan") != 0 ) {
	   result = 2;
	}
     }
  } 

  fclose (k_cmdFile); 
  
  return result;

}

void startInstall(int scanMode) {
   int result = 0;

   if ( scanMode != 0 ) {
	system ("/bin/einstall /dev/tty3 --noscan");
	system ("echo \"Not scanning for ISA devices\" > /dev/tty3"); 
   }
   else {
	system ("/bin/einstall /dev/tty3");
   }

}

void startRescueMode(void) {
   char *openConsole;
   int c, result = 0;

   printf ("Running in \033[35;1mRescue\033[0m mode\n\n");
   printf ("Rescue mode is designed to help you troubleshoot your system.\n\n");
   printf ("If you wish to reboot the system use \033[37;1mCTRL-ALT-DEL\033[0m.\n");
   printf ("To start the installer from rescue mode type \033[37;1mexit\033[0m.\n\n");

   if ( (result = mountEnGardeCD()) == 0) {
      
      system("/cdrom/bin/ln -sf /cdrom/bin/bash /bin/ash");
      system("/cdrom/bin/ln -sf /cdrom/bin/bash /bin/sh"); 
      for (c = 2; c <= RESCUE_CONSOLES - 1; c++) {
         sprintf (openConsole, "/bin/open -c%d /bin/bash", c);
	 system (openConsole);
      }
      system ("/bin/bash");
 
   }
   else {
     printf ("  \033[31;1mCDROM NOT MOUNTED\033[0m\n\n");
   }

   unmountEnGardeCD();
   system("/bin/einstall /dev/tty3"); 
}

int mountEnGardeCD(void) {
   char cdDev = findidetype(IDE_CDROM);
   char devName[80], mountCall[80];
   int pid, status, result = 1;

   sprintf (devName, "/dev/hd%c", cdDev);
 
/* Attempt to get result if mount successfully mounted the
   cdrom drive

   pid = fork();
   if ( pid == 0 ) { 
      result = execl ("/bin/mount", "mount", devName, "/cdrom", 0);
      while ( wait(&status) != pid) ;
   }
*/

   sprintf (mountCall, "/bin/mount %s /cdrom", devName); 
   system (mountCall);
   sleep (2);

   return 0; 
}

int unmountEnGardeCD(void) {
   char cdDev = findidetype(IDE_CDROM);
   char *devName;
   int pid, status, result = 1;

   sprintf (devName, "/dev/hd%c", cdDev);

   pid = fork();
   if ( pid == 0 ) { 
      result = execl ("/bin/umount", "mount", devName, "/cdrom", 0);
      while ( wait(&status) != pid) ;
   }

   return 0;
}

void stripnl(char *s) {
   char t = strchr(s, '\n');
   if (t) t = '\0';
}

