#!/usr/bin/perl


@ARGV == 2 or die "usage: $0 pci.ids pcitable\n";


my ($class, $classid);
open F, $ARGV[0] or die;
foreach (<F>) {
    chop; s/
//;
    if (/^\t{2}/ || /^#/ || /^;/ || /^\s*$/) {
	#ignore
    } elsif (/^C\s/) {
	last;
    } elsif (/^\t(\S+)\s+(.*)/) {
	$class or die "unexpected device\n";
	$drivers{sprintf "0x%s\t0x%s", lc $classid, lc $1} = qq("unknown"\t"$class|$2"\n);
    } elsif (/^(\S+)\s+(.*)/) {
	$classid = $1;
	$class = $classtr{$2} || $2;
    } else {
	die "bad line: $_";
    }
}

open F, $ARGV[1] or die;
foreach (<F>) {
    next if /^#/ || /^\s*$/;
    if (my @l = split "\t", $_, 3) {
	$drivers{lc "$l[0]\t$l[1]"} = $l[2];
    }
}

foreach (keys %drivers) {
    print "$_\t$drivers{$_}";
}



BEGIN {
    my %classtr = (
"Compaq Computer Corporation" => "Compaq",
"Symbios Logic Inc. (formerly NCR)" => "Symbios",
"ATI Technologies Inc" => "ATI",
"VLSI Technology Inc" => "VLSI",
"National Semiconductor Corporation" => "National Semi",
"Digital Equipment Corporation" => "DEC",
"Acer Incorporated" => "Acer",
"NEC Corporation" => "NEC",
"Chips and Technologies" => "C&T",
"Matrox Graphics, Inc." => "Matrox",
"Silicon Integrated Systems" => "SIS",
"Hewlett-Packard Company" => "HP",
"Sun Microsystems Computer Corp." => "Sun",
"Distributed Processing Technology" => "Distributed Tech",
"Miro Computer Products AG" => "Miro",
"Future Domain Corp." => "Future Domain",
"SGS Thomson Microelectronics" => "SGS Thomson",
"Data Technology Corporation" => "Data Technology",
"Forex Computer Corporation" => "Forex",
"Quantum Designs (H.K.) Ltd" => "Quantum Designs",
"Advanced System Products, Inc" => "Advanced System Products", 
"Integrated Micro Solutions Inc." => "Integrated Micro",
"Tekram Technology Co.,Ltd." => "Tekram",
"Applied Micro Circuits Corporation" => "Applied Micro",
"Realtek Semiconductor Co., Ltd." => "Realtek",
"Triones Technologies, Inc." => "Triones",
"Cogent Data Technologies, Inc." => "Cogent Data",
"Accton Technology Corporation" => "Accton",
"ICP Vortex Computersysteme GmbH" => "ICP Vortex",
"Alliance Semiconductor Corporation" => "Alliance",
"Toshiba America Info Systems" => "Toshiba",
"Dolphin Interconnect Solutions AS" => "Dolphin",
"Kinetic Systems Corporation" => "Kinetic",
"AVM Audiovisuelles MKTG & Computer System GmbH" => "AVM Audiovisuelles",
"Stallion Technologies, Inc." => "Stallion",
"NVidia / SGS Thomson (Joint Venture)" => "NVidia / SGS Thomson",
"Tekram Technology Co.,Ltd." => "Tekram",
"c't Magazin fr Computertechnik" => "c't Magazin",
"Decision Computer International Co." => "Decision Computer",
"Eicon Technology Corporation" => "Eicon",
"American Megatrends Inc." => "AMI",
"Number 9 Computer Company" => "Number 9",
"United Microelectronics" => "United",
"Acer Laboratories Inc." => "Acer",
"VIA Technologies, Inc." => "VIA Technologies",
"Lite-On Communications Inc" => "Lite-On",
);
}
