#include <fcntl.h>
#include <linux/types.h>
#include <linux/cdrom.h>
#include <sys/ioctl.h>
#include <strings.h>
#include <newt.h>
#include <stdlib.h>
#include <unistd.h>

#include "devices.h"
#include "install.h"
#include "intl.h"
#include "log.h"
#include "newt.h"
#include "scsi.h"
#include "windows.h"
#include "fs.h"

#define CD_IDE 1
#define CD_SCSI 2
#define CD_OTHER 3

static struct { char * modname, * devname; } transTable[] = {
	{ "cm206", "cm206cd" },
	{ "sonycd535", "cdu535" },
	{ NULL, NULL }
} ;


static int setupCDdevicePanel(int * type) {
    char * menuItems[3];
    int cdromType = 0, rc;

    menuItems[0] = "SCSI";
    menuItems[1] = _("Other CDROM");
    menuItems[2] = NULL;

    if (*type == CD_OTHER)
	cdromType = 1;

    rc = newtWinMenu(_("CDROM type"), _("What type of CDROM do you have?"),
		     30, 5, 5, 7, menuItems,
		     &cdromType, _("Ok"), _("Back"), NULL);

    if (rc == 2) return INST_CANCEL;

    if (cdromType == 0)
	*type = CD_SCSI;
    else
	*type = CD_OTHER;

    return 0;
}

int findAtapi(char **cddevs) {
    struct deviceInfo * ide;
    int i, nb = 0;

    loadModule("ide-probe", DRIVER_SCSI, DRIVER_MINOR_NONE, NULL);
    loadModule("ide-probe-mod", DRIVER_SCSI, DRIVER_MINOR_NONE, NULL);
    loadModule("ide-cd", DRIVER_CDROM, DRIVER_MINOR_NONE, NULL);
    if (ideGetDevices(&ide)) return 0;

    for (i = 0; ide[i].deviceName; i++) 
      if (ide[i].type == DEVICE_CDROM)
	cddevs[nb++] = ide[i].deviceName;

    return nb;
}

char *tryMounting(char ** cddevs, int nb)
{
  int i;
  for (i = 0; i < nb; i++) {
    winStatus(35, 3, "CDROM", _("Initializing CDROM..."));
    if (doMount(cddevs[i], "/tmp/rhimage", "iso9660", 1, 666) == 0) return cddevs[i];
  }
  return NULL;
}

int setupCDdevice(char ** cddev, struct driversLoaded ** dl) {
    int type = 0, rc = 0;
    #define MAX_CD_DEVS 100
    char *cddevs[MAX_CD_DEVS];
    struct driversLoaded * d;
    int i, nb = 0;
    int done = 0;

    /* Let's see if any CDROM's are already available */
    if (nb += findAtapi(&cddevs[nb])) 
      if ((*cddev = tryMounting(cddevs, nb))) return 0;

    setupSCSIInterfaces(0, dl, 1, 1);

    nb += findSCSIcdrom(&cddevs[nb]);

    if (nb > 1) {
      int choice;
      cddevs[nb] = NULL;
      newtWinMenu(_("Choose a cdrom drive"), _("More than one cdrom drive has been detected,\n\
which one do you want to use for the installation?"), 50, 5, 5, 4, cddevs, &choice, _("Ok"), NULL);
      done = 1;
      *cddev = cddevs[choice];
    }

	while (rc || !done) {
	    rc = setupCDdevicePanel(&type);
	    if (rc) return rc;

	    switch (type) {
	      case CD_SCSI:
		rc = setupSCSIInterfaces(0, dl, 0, 1);
		if (rc == INST_ERROR) return rc;
		*cddev = "scd0";
		done = 1;
		break;

	      case CD_OTHER:
		rc = loadDeviceDriver(DRIVER_CDROM, dl, 0);
		if (!rc) {
		    d = *dl;
		    *cddev = "bad_device";
		    while (d) {
			if (d->type == DRIVER_CDROM) {
			    *cddev = d->module;
			    break;
			}
			d = d->next;
		    }

		    for (i = 0; transTable[i].modname; i++) {
			if (!strcmp(*cddev, transTable[i].modname)) {
			    *cddev = transTable[i].devname;
			    break;
			}
		    }
		    done = 1;
		}
		break;
	    }
	} 

	if (!tryMounting(cddev, 1)) {
	  removeCDmodule(dl);
	  newtWinMessage(_("Error"), _("Ok"), 
			 _("I could not mount a CD on device /dev/%s"), *cddev);
	  rmdir("/tmp/rhimage");
	  return INST_CANCEL;
	}

    return 0;
}

int removeCDmodule(struct driversLoaded ** dl) {
    /* this wil fail silently if no CD module has been loaded */
    removeDeviceDriver(DRIVER_CDROM, dl);

    return 0;
}

int findSCSIcdrom(char ** cddevs) {
    struct deviceInfo * scsi;
    int i, nb = 0;

    if (!scsiDeviceAvailable()) return 0;

    if (scsiGetDevices(&scsi)) return 0;

    loadModule("sr_mod", DRIVER_CDROM, DRIVER_MINOR_NONE, NULL);

    for (i = 0; scsi[i].deviceName; i++)
	if (scsi[i].type == DEVICE_CDROM)
	    cddevs[nb++] = scsi[i].deviceName;

    return nb;
}
