#-########################################################################
#- Pixel's implementation of Perl-GTK  :-)  [DDX]
#-########################################################################
package my_gtk;

use diagnostics;
use strict;
use vars qw(@ISA %EXPORT_TAGS @EXPORT_OK $border @grabbed);

@ISA = qw(Exporter);
%EXPORT_TAGS = (
    helpers => [ qw(create_okcancel createScrolledWindow create_notebook create_packtable create_adjustment create_box_with_title create_treeitem) ],
    wrappers => [ qw(gtksignal_connect gtkpack gtkpack_ gtkpack__ gtkappend gtkadd gtktext_insert gtkset_usize gtkshow gtkdestroy gtkset_mousecursor gtkset_background) ],
    ask => [ qw(ask_from_list ask_file) ],
);
$EXPORT_TAGS{all} = [ map { @$_ } values %EXPORT_TAGS ];
@EXPORT_OK = map { @$_ } values %EXPORT_TAGS;

use DrakXGtk::DrakXGtk; #- !! provides DrakXGtk and not DrakXGtk::DrakXGtk
use c;
use common qw(:common :functional);

my $forgetTime = 1000; #- in milli-seconds
$border = 5;

1;

#-###############################################################################
#- OO stuff
#-###############################################################################
sub new {
    my ($type, $title, %opts) = @_;

    DrakXGtk::init();
    my $o = bless { %opts }, $type;
    $o->_create_window($title);
    while (my $e = shift @tempory::objects) { $e->destroy }
    push @interactive::objects, $o unless $opts{no_interactive_objects};

    top(@grabbed)->grab_remove if @grabbed;
    push(@grabbed, $o->{rwindow}), $o->{rwindow}->grab_add if $my_gtk::grab || $o->{grab};

    $o;
}
sub main($;$) {
    my ($o, $f) = @_;
    $o->show;

    do {
	local $::setstep = 1;
	DrakXGtk::main();
    } while ($o->{retval} && $f && !&$f());
    $o->destroy;
    $o->{retval}
}
sub show($) {
    my ($o) = @_;
    $o->{window}->show;
    $o->{rwindow}->show;
}
sub destroy($) {
    my ($o) = @_;
    (pop @grabbed)->grab_remove if @grabbed;
    top(@grabbed)->grab_add if @grabbed;
    $o->{rwindow}->destroy;
    DrakXGtk::flush();
}
sub DESTROY { goto &destroy }
sub sync($) {
    my ($o) = @_;
    show($o);
    flush();
}

sub at_least_wlabel { ref $_[0] ? $_[0] : DrakXGtk::label_new($_[0]) }

sub gtkpack($@) {
    my $box = shift;
    gtkpack_($box, map {; 1, $_ } @_);
}
sub gtkpack__($@) {
    my $box = shift;
    gtkpack_($box, map {; 0, $_ } @_);
}
sub gtkpack_($@) {
    my $box = shift;
    for (my $i = 0; $i < @_; $i += 2) {
	my $l = at_least_wlabel($_[$i + 1]);
	$box->pack_start($l, $_[$i]);
	$l->show;
    }
    $box
}
sub gtkappend($@) {
    my $w = shift;
    foreach (@_) {
	$w->append(my $l = at_least_wlabel $_);
	$l->show;
    }
    $w
}
sub gtkadd($@) {
    my $w = shift;
    foreach (@_) {
	$w->add(my $l = at_least_wlabel $_);
	$l->show;
    }
    $w
}

#-sub gtkset_default_fontset($) {
#-    my ($fontset) = @_;
#-
#-    my $style = DrakXGtk::Widget->get_default_style;
#-    my $f = DrakXGtk::Gdk::Font->fontset_load($fontset) or die '';
#-    $style->font($f);
#-    DrakXGtk::Widget->set_default_style($style);
#-}


#-###############################################################################
#- createXXX functions

#- these functions return a widget
#-###############################################################################

sub create_okcancel($;$$) {
    my ($w, $ok, $cancel) = @_;

    DrakXGtk::hbutton_box_new()->add(
	  ($w->{ok} = DrakXGtk::button_new($ok || _("Ok")))->signal_connect("clicked" => $w->{ok_clicked} || sub { $w->{retval} = 1; DrakXGtk::main_quit() }),
	  ($ok xor $cancel) ? () : DrakXGtk::button_new($cancel || _("Cancel"))->signal_connect("clicked" => $w->{cancel_clicked} || sub { $w->{retval} = 0; DrakXGtk::main_quit() }),
    );
}

sub create_box_with_title($@) {
    my $o = shift;

    $o->{box} = (@_ <= 2 && (map { split "\n" } @_) > 6) ?
      gtkpack(DrakXGtk::vbox_new(0,0),
	      createScrolledWindow(DrakXGtk::new_text(join "\n", @_))->set_usize(400, 250)) :
      gtkpack__(DrakXGtk::vbox_new(0,0),
		(map { at_least_wlabel($_) } 
		 map { ref $_ ? $_ : warp_text($_) } @_),
		DrakXGtk::hseparator_new(),
	      );
}

#sub createScrolledWindow($) {
#    my ($W) = @_;
#    my $w = new DrakXGtk::ScrolledWindow(undef, undef);
#    $w->set_policy('automatic', 'automatic');
#    member(ref $W, qw(DrakXGtk::CList DrakXGtk::CTree DrakXGtk::Text)) ?
#      $w->add($W) :
#      $w->add_with_viewport($W);
#    $W->show;
#    $w
#}

#sub create_menu($@) {
#    my $title = shift;
#    my $w = new DrakXGtk::MenuItem($title);
#    $w->set_submenu(gtkshow(gtkappend(new DrakXGtk::Menu, @_)));
#    $w
#}

sub add2notebook {
    my ($n, $title, $book) = @_;

    my ($w1, $w2) = map { DrakXGtk::label_new($_) } $title, $title;
    $book->{widget_title} = $w1;
    $n->append_page_menu($book, $w1, $w2);
    $book->show;
    $w1->show;
    $w2->show;
}

sub create_notebook(@) {
    my $n = DrakXGtk::notebook_new();
    add2notebook($n, splice(@_, 0, 2)) while @_;
    $n
}

sub create_adjustment($$$) {
    my ($val, $min, $max) = @_;
    new DrakXGtk::Adjustment($val, $min, $max + 1, 1, ($max - $min + 1) / 10, 1);
}

sub create_packtable($@) {
    my $options = shift;
    my $w = new DrakXGtk::Table(0, 0, $options->{homogeneous} || 0);
    map_index {
	my ($i) = @_;
	map_index {
	    my ($j) = @_;
	    if (defined $_) {
		ref $_ or $_ = DrakXGtk::label_new($_);
		$w->attach_defaults($_, $j, $j + 1, $i, $i + 1);
		$_->show;
	    }
	} @$_;
    } @_;
    $w->set_col_spacings($options->{col_spacings} || 0);
    $w->set_row_spacings($options->{row_spacings} || 0);
    $w
}

sub _create_window($$) {
    my ($o, $title) = @_;
    my $w = DrakXGtk::window_new($title);
    $w->set_name("Title");

    gtkadd($w, my $f = DrakXGtk::frame_new(undef));

    $w->signal_connect(expose_event => sub { c::XSetInputFocus($w->window->XWINDOW); }) if $my_gtk::force_focus || $o->{force_focus};
    $w->signal_connect(delete_event => sub { undef $o->{retval}; DrakXGtk::main_quit() });
    $w->set_uposition(@{$my_gtk::force_position || $o->{force_position}}) if $my_gtk::force_position || $o->{force_position};

    $w->signal_connect("key_press_event" => sub {
	my $d = ${{ 65481 => 'next',
		    65480 => 'previous' }}{$_[1]->{keyval}} or return;
	my $s = $::o->{step};
	do { $s = $::o->{steps}{$s}{$d} } until !$s || $::o->{steps}{$s}{reachable};
	$::setstep && $s and die "setstep $s\n";
    });

    $w->signal_connect(size_allocate => sub {
	my ($wi, $he) = @{$_[1]}[2,3];
	my ($X, $Y, $Wi, $He) = @{$my_gtk::force_center || $o->{force_center}};
        $w->set_uposition(max(0, $X + ($Wi - $wi) / 2), max(0, $Y + ($He - $he) / 2));
    }) if ($my_gtk::force_center || $o->{force_center}) && !($my_gtk::force_position || $o->{force_position}) ;

    $o->{window} = $f;
    $o->{rwindow} = $w;
}

my ($next_child, $left, $right, $up, $down);
{
    my $next_child = sub {
	my ($c, $dir) = @_;

	my @childs = $c->parent->children;
   
	my $i; for ($i = 0; $i < @childs; $i++) {
	    last if $childs[$i] == $c || $childs[$i]->subtree == $c;
	}
	$i += $dir;
	0 <= $i && $i < @childs ? $childs[$i] : undef;
    };
    $left = sub { &$next_child($_[0]->parent, 0); };
    $right = sub {
	my ($c) = @_;
	if ($c->subtree) {
	    $c->expand;
	    ($c->subtree->children)[0];
	} else {
	    $c;
	}
    };
    $down = sub {
	my ($c) = @_;
	return &$right($c) if ref $c eq "DrakXGtk::TreeItem" && $c->subtree && $c->expanded;

	if (my $n = &$next_child($c, 1)) {
	    $n;
	} else {
	    return if ref $c->parent ne 'DrakXGtk::Tree';	
	    &$down($c->parent);
	}
    };
    $up = sub {
	my ($c) = @_;
	if (my $n = &$next_child($c, -1)) {
	    $n = ($n->subtree->children)[-1] while ref $n eq "DrakXGtk::TreeItem" && $n->subtree && $n->expanded;
	    $n;
	} else {
	    return if ref $c->parent ne 'DrakXGtk::Tree';	
	    &$left($c);
	}
    };
}

sub create_treeitem($) {
    my ($name) = @_;
    
    my $w = new DrakXGtk::TreeItem($name);
    $w->signal_connect(key_press_event => sub {
        my (undef, $e) = @_;
        local $_ = chr ($e->{keyval} & 0xff);

	if ($e->{keyval} > 0x100) {
	    my $n;
	    $n = &$left($w)  if /[Q\x96]/;
	    $n = &$right($w) if /[S\x98]/;
	    $n = &$up($w)    if /[R\x97]/;
	    $n = &$down($w)  if /[T\x99]/;
	    if ($n) {
		$n->focus('up');
		$w->signal_emit_stop("key_press_event"); 
	    }
	    $w->expand if /[+]/;
	    $w->collapse if /[-\xad]/;
	    do { 
		$w->expanded ? $w->collapse : $w->expand; 
		$w->signal_emit_stop("key_press_event"); 
	    } if /[\r\x8d]/;
	}
        1;
    });
    $w;
}



#-###############################################################################
#- ask_XXX

#- just give a title and some args, and it will return the value given by the user
#-###############################################################################
sub ask_from_list  { my $w = my_gtk->new($_[0]); $w->_ask_from_list(@_); main($w); }
sub ask_file       { my $w = my_gtk->new(''); $w->_ask_file(@_); main($w); }

sub _ask_from_list {
    my ($o, $title, $messages, $l, $def) = @_;
    my (undef, @okcancel) = ref $title ? @$title : $title;
    my $list = DrakXGtk::clist_new(1);
    my ($first_time, $starting_word, $start_reg) = (1, '', "^");
    my (@widgets, $timeout, $curr);

    my $leave = sub { $o->{retval} = $l->[$curr]; DrakXGtk::main_quit() };
    my $select = sub { $list->clist_super_select_row($_[0]) };

    ref $title && !@okcancel ?
      $list->signal_connect(button_release_event => $leave) :
      $list->signal_connect(button_press_event => sub { &$leave if $_[1]{type} =~ /^2/ });

    $list->signal_connect(select_row => sub {
	my ($w, $row, undef, $e) = @_;
	$curr = $row;
    });
    $list->signal_connect(key_press_event => sub {
        my ($w, $e) = @_;
	my $c = chr $e->{keyval};

	DrakXGtk::timeout_remove($timeout) if $timeout; $timeout = '';

	if ($e->{keyval} >= 0x100) {
	    &$leave if $c eq "\r" || $c eq "\x8d";
	    $starting_word = '' if $e->{keyval} != 0xffe4; # control
	} else {
	    if ($e->{state} & 4) {
		#- control pressed
		$c eq "s" or return 1;
		$start_reg and $start_reg = '', return 1;
		$curr++;
	    } else {
		&$leave if $c eq ' ';

		$curr++ if $starting_word eq '' || $starting_word eq $c;
		$starting_word .= $c unless $starting_word eq $c;
	    }
	    my $word = quotemeta $starting_word;
	    my $j; for ($j = 0; $j < @$l; $j++) {
		 $l->[($j + $curr) % @$l] =~ /$start_reg$word/i and last;
	    }
	    $j == @$l ?
	      $starting_word = '' :
	      &$select(($j + $curr) % @$l);

	    $timeout = DrakXGtk::timeout_add($forgetTime, sub { $timeout = $starting_word = ''; 0 });
	}
	1;
    });
    $list->set_selection_mode(1); #- 'browse' (see gtkenums.h)
    $list->set_column_auto_resize(0, 1);

    $o->{ok_clicked} = $leave;
    $o->{cancel_clicked} = sub { $o->destroy; die "ask_from_list cancel" }; #- make sure windows doesn't live any more.
    gtkadd($o->{window},
	   gtkpack($o->create_box_with_title(@$messages),
		   gtkpack_(DrakXGtk::vbox_new(0,7),
			    1, @$l > 15 ? gtkset_usize(createScrolledWindow($list), 200, 280) : $list,
			    @okcancel || !ref $title ? (0, create_okcancel($o, @okcancel)) : ())
		  ));
    $o->show; #- otherwise the moveto is not done
    my $toselect; map_index {
	$list->clist_append($_);
	$toselect = $::i if $def && $_ eq $def;
    } @$l;
    &$select($toselect);

    $list->grab_focus;
}

sub _ask_file($$) {
    my ($o, $title) = @_;
    my $f = $o->{rwindow} = new DrakXGtk::FileSelection $title;
    $f->ok_button->signal_connect(clicked => sub { $o->{retval} = $f->get_filename ; DrakXGtk::main_quit() });
    $f->cancel_button->signal_connect(clicked => sub { DrakXGtk::main_quit() });
    $f->hide_fileop_buttons;
}
