#include "url.h"
#include "ftp.h"

struct iurlinfo {
    char * address;
    char * login;
    char * password;
    char * prefix;
    char * proxy;
    char * proxyPort;
    char * urlprefix;
};

enum urlprotocol_t { URL_METHOD_FTP, URL_METHOD_HTTP };
typedef enum urlprotocol_t urlprotocol;

/* returns a socket file descriptor, a ftpFinishTransfer() must occur after 
   this call */
FD_t urlinstStartTransfer(struct iurlinfo * ui, char * filename);
int urlinstFinishTransfer(FD_t fi, urlprotocol protocol);
int urlinstGetFile(struct iurlinfo * ui, char * filename, char * dest);
int urlSecondarySetupPanel(struct iurlinfo * ui, urlprotocol protocol);
int urlMainSetupPanel(struct iurlinfo * ui, urlprotocol protocol,
		      char * doSecondarySetup);

