#include <alloca.h>
#include <newt.h>
#include <sys/wait.h>
#include <malloc.h>
#include <strings.h>
#include <unistd.h>

#include "setup.h"
#include "install.h"
#include "hints.h"
#include "kickstart.h"
#include "log.h"
#include "fs.h"

static int runConfigTool(char * rootPath,
			 char * tool, int argc, char ** inargv) {
    int childpid;
    int status;
    char ** argv = NULL;

    if (inargv) {
	argv = alloca(sizeof(*argv) * (argc + 1));
	memcpy(argv, inargv, sizeof(*argv) * argc);
	argv[argc] = NULL;
	argv[0] = tool;
    }

    logMessage("running %s", tool);
    newtSuspend();

    if (!(childpid = fork())) {
	if (!testing) chroot(rootPath);
	chdir("/");

	if (argv)
	    execv(argv[0], argv);
	else
	    execl(tool, tool, NULL);
	exit(2);
    } 

    waitpid(childpid, &status, 0);
    newtResume();
    if (WIFEXITED(status)) {
	if (WEXITSTATUS(status) == 1) {
	    logMessage("    tool canceled");
	    return INST_CANCEL;
	} else if (WEXITSTATUS(status) == 0) {
	    return 0;
	}
    }

    logMessage("    tool failed");

    return INST_ERROR;
}

int timeConfig(char * rootPath) {
    char ** argv; 
    int argc;
    char * otherArgv[] = { "timeconfig", "--back", NULL };

    if (kickstart && !ksGetCommand(KS_CMD_TIMEZONE, NULL, &argc, &argv)) {
	return runConfigTool(rootPath, "/usr/sbin/timeconfig", argc, argv);
    }

    return runConfigTool(rootPath, "/usr/sbin/timeconfig", 2, otherArgv);
}

int servicesConfig(char * rootPath) {
    char * otherArgv[] = { "/usr/sbin/ntsysv", "--back",
			   "--level", "35", "--hide", NULL };

    return runConfigTool(rootPath, "/usr/sbin/ntsysv", 5, otherArgv);
}

int authConfig(char * rootPath, struct hints * hints) {
    char ** ksargv; 
    int argc = 5;
    char * otherArgv[] = { "/usr/sbin/authconfig", "--back", "--nostart",
			   "--useshadow", "--enablemd5", NULL };
    char ** argv = otherArgv;

    if (kickstart && !ksGetCommand(KS_CMD_AUTH, NULL, &argc, &ksargv)) {
	/* XXX Broken, fix me */
	argv = alloca(sizeof(*argv) * (argc + 10));
	argv[0] = "/usr/sbin/authconfig";
	argv[1] = "--kickstart";
	argv[2] = "--nostart";
	argc--;
	memcpy(argv + 3, ksargv + 1, sizeof(*argv) * argc);
	argv[argc + 3] = NULL;
	argc += 3;
    } else if (hints->flags & HINT_AUTH) {
	argc = 0;
	argv = alloca(sizeof(*argv) * 10);
	argv[argc++] = "/usr/sbin/authconfig";
	argv[argc++] = "--kickstart";
	argv[argc++] = "--nostart";
	if (hints->auth & AUTHHINT_MD5)
	    argv[argc++] = "--enablemd5";
	if (hints->auth & AUTHHINT_SHADOW)
	    argv[argc++] = "--useshadow";
	argv[argc++] = NULL;
    }
    
    return runConfigTool(rootPath, "/usr/sbin/authconfig", argc, argv);
}

int mouseConfig(char * rootPath) {
    char ** argv, **kargv; 
    int argc;
    int i;
    int shift;

#ifdef __sparc__
    umount("/mnt/proc");
    doMount("/proc", "/mnt/proc", "proc", 0, 0);
#endif
    
    if (!kickstart || ksGetCommand(KS_CMD_MOUSE, NULL, &argc, &argv)) {
	/* no options, or in normal mode */
	argc = 1;
	argv = alloca(sizeof(*argv));
	argv[0] = alloca(sizeof("mouse")+1);
	strcpy(argv[0],"mouse");
    }	

    /* add --kickstart and --expert options */
    shift = 0;
    if (kickstart)
	shift++;
    if (expert)
	shift++;
    
    kargv = alloca(sizeof(*argv) * (argc + shift));
    memcpy(kargv, argv, sizeof(*argv) * argc);
    for (i=argc+shift-1; i>shift; i--)
	kargv[i]=kargv[i-shift];

    i = 1;
    if (kickstart) {
	kargv[i++] = "--kickstart";
    }
    if (expert) {
	kargv[i++] = "--expert";
	kargv[i++] = "--noprobe";
    }

    argc += shift;
    i = runConfigTool(rootPath, "/usr/sbin/mouseconfig", argc, kargv);
#ifdef __sparc__
    umount("/mnt/proc");
#endif
    return i;
}

#if 0
int desktopConfig(char * rootPath) {
    char ** argv, **kargv; 
    int argc;
    int i;
    int shift;
    
    argc = 1;
    argv = alloca(sizeof(*argv));

    if (!kickstart || ksGetCommand(KS_CMD_MOUSE, NULL, &argc, &argv)) {
      /* no options, or in normal mode */
	argv[0] = alloca(sizeof("desktopcfg")+1);
	strcpy(argv[0],"desktopcfg");
    }	

    /* add --kickstart and --expert options */
    shift = 0;
    if (kickstart)
	shift++;
    if (expert)
	shift++;
    
    kargv = alloca(sizeof(*argv) * (argc + shift));
    memcpy(kargv, argv, sizeof(*argv) * argc);
    for (i=argc+shift-1; i>shift; i--)
	kargv[i]=kargv[i-shift];

    i = 1;
    kargv[i++] = "--systemwide"; argc++;
    if (kickstart) {
	kargv[i++] = "--kickstart";
    }
    if (expert) {
	kargv[i++] = "--expert";
    }

    argc += shift;
    return runConfigTool(rootPath, "/usr/bin/desktopcfg", argc, kargv);
}
#endif

int xfree86Config(char * rootPath, char *mode) {
    char **argv, **kargv;
    int argc;
    int i;
    int shift;

    argv  = NULL;
    kargv = NULL;
    if (!kickstart || ksGetCommand(KS_CMD_XCONFIG, argv, &argc, &argv)) {
	/* they didnt specify anything, or in normal mode */
	argc=1;
	argv=alloca(sizeof(*argv));
	argv[0]=alloca(strlen("xconfig"+1));
	strcpy(argv[0],"xconfig");
    }
    
    /* make commandline, add mode and --kickstart, and maybe --expert */
    shift = 1;
    if (expert)
	shift++;
    if (kickstart)
	shift++;

    kargv = alloca(sizeof(*argv) * (argc + shift));
    memcpy(kargv, argv, sizeof(*argv) * argc);
    for (i=argc+shift-1; i>shift; i--)
	kargv[i]=kargv[i-shift];

    i = 1;
    if (kickstart) {
	kargv[i] = "--kickstart";
	i++;
    }
    if (expert) {
	kargv[i] = "--expert";
	i++;
    }

    kargv[i] = alloca(strlen(mode)+1);
    strcpy(kargv[i],mode);
    i++;
    
    argc+=shift;
	
    return runConfigTool(rootPath, "/usr/X11R6/bin/Xconfigurator",argc, kargv);
}

void configPCMCIA(char * rootPath, char * pcic) {
    FILE * f;
    char * path;

    if (testing) return;

    path = alloca(strlen(rootPath) + 30);
    sprintf(path, "%s/etc/sysconfig/pcmcia", rootPath);

    f = fopen(path, "w");
    if (pcic) {
	fprintf(f, "PCMCIA=yes\n");
	fprintf(f, "PCIC=%s\n", pcic);
    } else {
	fprintf(f, "PCMCIA=no\n");
	fprintf(f, "PCIC=\n");
    }

    fprintf(f, "PCIC_OPTS=\nCORE_OPTS=\n");

    fclose(f);
}
