/* Text based printer configuration for the RHS install program */
/* Michael Fulbright - 1997                                     */
/*                                                              */

/* Most of this should be hidden in printercfg.c rather then exported
   to the world, but... -ewt */

#ifndef _RHS_PRINTERCFG_H

#define _RHS_PRINTERCFG_H


/* An entry in the 'printerdb' file, which describes each type of */
/* supported printer                                              */

struct prnDBEntry {
  char  *Entry;          /* Human-readable name of the entry       */
  char  *GSDriver;       /* gs driver used by this printer         */
  char  *Descr;          /* Single line description of printer     */
  char  *About;          /* Lengthy description of printer         */
  char **Resolution;     /* List of resolutions supported          */
  char **ResDescr;       /* Description of each resolution         */
  int    NumRes;         /* Length of list of resolutions          */
  char **BitsPerPixel;   /* List of color depths supported         */
  char **BppDescr;       /* Description of each color depth        */
  int    NumBpp;         /* Length of list of color depths         */
};
typedef struct prnDBEntry DBEntry;

#define PRINTER_NONE	0
#define PRINTER_LOCAL	1
#define PRINTER_LPRREM	2
#define PRINTER_SMB	3
#define PRINTER_NCP	4

/* A printcap entry */
/* Only represents a subset of possible options available */
/* Sufficient for the simple configuration we are interested in */
struct prnPCEntry {
    char *Queue;           /* Queue name, can have multi separated by '|' */
    char *SpoolDir;        /* Spool directory                             */
    char *Device;          /* Print device                                */
    char *IF;              /* input filter                                */
    char *AF;              /* accounting filter (needed for smbprint)     */
    
    int Type;
    
    /* these apply to all types and are not represented by printcap entry */

    /* following 4 are OBSOLETE */
#if 0
    char *PrinterDescr;    /* Engligh description of gsdriver             */
    char *PrinterType;     /* Database entry for this queue               */
    char *PrinterAbout;    /* Lengthy description                         */
    char *GSDriver;        /* ghostscript driver to use                   */
#endif
    /* replaced by */
    DBEntry *db;    /* entry in printer database for this printer  */
    char *Resolution;      /* ghostscript resolution to use               */
    char *PaperSize;       /* Papersize                                   */
    char *BitsPerPixel;    /* ghostscript color option                    */
    int CRLF;              /* Whether or not to do CR/LF xlation          */
    
    /* REMOTE (lpd) printers only */
    char *RemoteHost;      /* Remote host (not used for all entries)      */
    char *RemoteQueue;     /* Queue on the remote machine                 */
    
    /* SMB (LAN Manager) only */
    char *SMBHost;         /* Server name (NMB name, can have spaces)      */
    char *SMBHostIP;       /* Can optional specify and IP address for host */
    char *SMBShare;        /* Name of share on the SMB server              */
    char *SMBUser;         /* User to log in as on SMB server              */
    char *SMBPasswd;       /* Corresponding password                       */
    char *SMBWorkgroup;    /* SMB workgroup name                           */
    
    /* NCP (NetWare) only */
    char *NCPHost;         /* Server name (NCP name)                       */
    char *NCPQueue;        /* Queue on server                              */
    char *NCPUser;         /* User to log in as on NCP server              */
    char *NCPPasswd;       /* Corresponding password                       */
};
typedef struct prnPCEntry PCEntry;

/* location of the printer database in an installed system*/
#define PRINTER_DB_FILE "/usr/lib/rhs/rhs-printfilters/printerdb"
#define PRINTER_FILTER_DIR "/usr/lib/rhs/rhs-printfilters/"

int doConfigurePrinters (char *theroot, int direction);

#endif
