/* very simple set of routines to get back what is stored in /proc/pci in */
/* a programmer friendly fashion. Also tries to map a pci entry into a    */
/* kernel module name to aid autoloading modules during an install        */
/* Michael Fulbright Sept 1997                                            */

#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <malloc.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>

#include "pciprobe.h"
#include "pci-ids.h"



/* create a new clean pciDevice entry */
struct pciDevice *pciNewDevice( void ) {
    struct pciDevice *p;

    p = (struct pciDevice *) malloc( sizeof(struct pciDevice) );
    p->nhits = 0;
    p->name=NULL;
    p->module=NULL;
    p->class=PCI_UNSET;
    return p;
}

/* remove a pciDevice */
void pciFreeDevice( struct pciDevice *p ) {
    int i;

    if (p->name) {
	for (i=0; i<p->nhits; i++)
	    free(p->name[i]);
	free(p->name);
    }

    if (p->module) {
	for (i=0; i<p->nhits; i++)
	    free(p->module[i]);
	free(p->module);
    }

    free(p);
}

int pciProbeDevice( enum pciClass type, struct pciDevice ***devs) {
    FILE *f;
    int ndevs,len;
    char buf[100];
    struct pci_module_map *pcidb;
    
    f=fopen("/proc/bus/pci/devices","r");
    
    if (!f) return -1;
    
    ndevs = 0;
    *devs = NULL;

    switch (type) {
	 case PCI_ETHERNET:
	    pcidb = eth_pci_ids;
	    len   = eth_num_ids;
	    break;
	 case PCI_SCSI:
	    pcidb = scsi_pci_ids;
	    len   = scsi_num_ids;
	    break;
	 case PCI_VIDEO:
	    pcidb = video_pci_ids;
	    len   = video_num_ids;
	    break;
	 case PCI_AUDIO:
	    pcidb = audio_pci_ids;
	    len   = audio_num_ids;
	    break;
	 default:
	    pcidb = NULL;
	    len = 0;
    }

    while (1) {
	int i, garb, vendor, device;
	
	if (!fgets(buf,100,f)) break;

	sscanf(buf,"%x %04x%04x", &garb, &vendor, &device);
 
	for (i = 0; i < len; i++) {
	  if (pcidb[i].vendor == vendor && pcidb[i].device == device) {
	    if ((ndevs % 4) == 0) 
	      *devs=(struct pciDevice **) realloc(*devs,(ndevs+4)*sizeof(struct pciDevice *));
	    (*devs)[ndevs]=pciNewDevice();
	    (*devs)[ndevs]->name=malloc(sizeof(char *));
	    (*devs)[ndevs]->module=malloc(sizeof(char *));
	    (*devs)[ndevs]->name[0]=strdup(pcidb[i].name);
	    (*devs)[ndevs]->module[0]=strdup(pcidb[i].module);
	    (*devs)[ndevs]->nhits=1;
	    (*devs)[ndevs]->class=type;
	    ndevs++;
	  }
	}
    }
    return ndevs;
}
