#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <zlib.h>
#include <fcntl.h>
#include <sys/utsname.h>
#include <sys/wait.h>

#include "cpio.h"

/* hack */
int insmod_main(int argc, char ** argv);

int ourInsmodCommand(int argc, char ** argv) {
    char * file;
    char finalName[100];
    char archiveName[100];
    char * chptr;
    FD_t fd;
    int rc, rmObj = 0;
    int sparc64 = 0;
#ifdef __sparc__

    struct utsname u;

    fprintf(stderr, "insmod wrapper starting\n");

    if (!uname(&u) && !strcmp(u.machine, "sparc64"))
       sparc64 = 1;
#endif

    if (argc < 2) {
	fprintf(stderr, "usage: insmod <module>.o [params]\n");
	return 1;
    }

    file = argv[1];
    fprintf(stderr, "testing for %s\n", file);
    if (access(file, R_OK)) {
      fprintf(stderr, "not found %s\n", file);
	/*
	 * modified to take into account a leading directory
	 * to search the cpio compressed archive. this is
	 * usefull for the pcmcia bootable disk.
	 */
	chptr = strrchr(file, '/');
	if (chptr) {
	    strncpy(archiveName, file, chptr - file);
	    strcpy(archiveName + (chptr - file),
		   sparc64 ? "/modules64.cgz" : "/modules.cgz");
	    fd = fdOpen(archiveName, O_RDONLY, 0);
	    if (fdFileno(fd) >= 0) {
		file = chptr + 1;
		sprintf(finalName, "/tmp/%s", file);
		if (!installCpioFile(fd, file, finalName, 0)) {
		    rmObj = 1;
		    file = finalName;
		} else {
		    chptr = NULL; /* for searching into /modules */
		}
	    } else {
		chptr = NULL; /* for searching into /modules */
	    }
	}

	/* to test of chptr for searching into /modules */
	if (!chptr) {
	    /* it might be having a ball */
	    fd = fdOpen(sparc64 ?
		        "/modules/modules64.cgz" : "/modules/modules.cgz",
		        O_RDONLY, 0);
	    if (fdFileno(fd) < 0) {
	        return 1;
	    }

	    if (chptr) file = chptr + 1;
	    sprintf(finalName, "/tmp/%s", file);

	    if (installCpioFile(fd, file, finalName, 0))
	        return 1;

	    rmObj = 1;
	    file = finalName;
        }
    }
    fprintf(stderr, "try with %s\n", file);

    argv[1] = file;

    rc = -1;
#ifdef __sparc__
    if (sparc64) {
       int pid, status;
       
       if (!(pid = fork())) {
           execv("/bin/insmod64", argv);
           exit(-1);
       }
       waitpid(pid, &status, 0);
       if (WIFEXITED(status))
           rc = WEXITSTATUS(status);
       else
           rc = -1;
    }
#endif
    if (rc)
       rc = insmod_main(argc, argv);
    
    if (rmObj) unlink(file);

    return rc;
}

