#ifndef FSEDIT_H
#define FSEDIT_H

#include "hd.h"
#include "fs.h"

/* drives is NULL terminated */
int kickstartPartitioning(struct partitionTable * parts, struct fstab * fstab, 
		     char **drives);

#define FSEDIT_READONLY		(1 << 0)
#define FSEDIT_CLEARLINUX	(1 << 1)
#define FSEDIT_CLEARALL 	(1 << 2)
#define FSEDIT_USEEXISTING 	(1 << 3)

struct attemptedPartition {
    char * mount;		/* NULL for the last in the list */
    int size;			/* size in megs */
    int type;
    int grow;
    int start;
};

int FSResizePartitions(struct partitionTable * parts, char ** drives);

int FSEditPartitions(struct partitionTable * parts, struct fstab * fstab, 
		     char **drives,
		     struct intfInfo * intf, struct netInfo * netc,
		     struct driversLoaded ** dl, 
		     struct attemptedPartition * goals,
		     int flags);

#endif

