#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "vbe.h"
#include "vesamode.h"
#ident "$Id: ddcxinfos.c,v 1.1 1999/11/15 13:02:13 prigaux Exp $"

#define SQR(x) ((x) * (x))

int main(int argc, char **argv)
{
	int i, j;
	u_int16_t *mode_list;
	unsigned char hmin, hmax, vmin, vmax;
	struct vbe_info *vbe_info;
	struct vbe_edid1_info *edid;
	struct vbe_modeline *modelines;
	

	if ((vbe_info = vbe_get_vbe_info()) == NULL) return 1;

	printf("%dKB of video ram\n", vbe_info->memory_size * 64);

	/* List supported standard modes. */
	for (mode_list = vbe_info->mode_list.list; *mode_list != 0xffff; mode_list++)
	  for (i = 0; known_vesa_modes[i].x; i++)
	    if (known_vesa_modes[i].number == *mode_list)
	      printf("%d %d %d\n", 
		     known_vesa_modes[i].colors,
		     known_vesa_modes[i].x,
		     known_vesa_modes[i].y
		     );
	printf("\n");

	if ((edid = vbe_get_edid_info()) == NULL) return 0;
	if (edid->version == 255 && edid->revision == 255) return 0;

	vbe_get_edid_ranges(edid, &hmin, &hmax, &vmin, &vmax);
	modelines = vbe_get_edid_modelines(edid);

	printf(hmin ? "%d-%d\n" : "\n", hmin, hmax);
	printf(vmin ? "%d-%d\n" : "\n", vmin, vmax);

	{ 
	  double size = sqrt(SQR(edid->max_size_horizontal) + 
			     SQR(edid->max_size_vertical)) / 2.54;
	  printf(size ? "%3.2f inches monitor (truly %3.2f')\n" : "\n", size * 1.08, size);
	}

	for(j=0; modelines && (modelines[j].refresh != 0); j++){
	  printf("# %dx%d, %1.1f%sHz",
		 modelines[j].width,
		 modelines[j].height,
		 modelines[j].refresh,
		 modelines[j].interlaced?"i":""
		 );
	  if(modelines[j].modeline) {
	    printf("; hfreq=%f, vfreq=%f\n%s\n",
		   modelines[j].hfreq,
		   modelines[j].vfreq,
		   modelines[j].modeline);
	  } else printf("\n");
	}
	return 0;
}
