%define version 3.0.3

Summary: The Red Hat package management system.
Name: rpm
Version: %{version}
Release: 44drakx
Group: System Environment/Base
Source: ftp://ftp.rpm.org/pub/rpm/dist/rpm-3.0.x/rpm-%{version}.tar.bz2
Source1: k6-rpmrc.bz2
Patch0: rpm-3.0.3-path.patch.bz2
Patch1: rpm-3.3-rpmgettext.patch.bz2
Patch2: rpm-rpmlibsucks.patch.bz2
Patch3: rpm-3.3-bashort.patch.bz2
Patch4: rpm-3.0.3-compile.patch.bz2
Patch5: rpm-3.0.3-pass.patch.bz2
Copyright: GPL
Conflicts: patch < 2.5
Prereq: gawk fileutils textutils sh-utils mktemp
BuildRequires: bzip2 >= 0.9.0c-2
Requires: bzip2 >= 0.9.0c-2
BuildRoot: /var/tmp/rpm-%{version}-root

%description 
This package contains the RPM C library and header files.  These
development files will simplify the process of writing programs
which manipulate RPM packages and databases and are intended to make
it easier to create graphical package managers or any other tools
that need an intimate knowledge of RPM packages in order to function.

This package should be installed if you want to develop programs that
will manipulate RPM packages and databases.

%prep
#%setup -q -n %{name}
%setup -q
%patch0 -p1 
%patch1 -p0
%patch2 -p1
%patch3 -p1
%patch4 -p0
%patch5 -p0

%build
#sh ./autogen.sh
find . -type 'd' -name 'CVS'|xargs rm -rf
perl -p -i -e "s/optflags: i386 .*/optflags: i386 -O3 -fomit-frame-pointer -fno-exceptions -fno-rtti -pipe -s -mcpu=i486 -march=i386 -ffast-math -fexpensive-optimizations -malign-loops=2 -malign-jumps=2 -malign-functions=2 -mpreferred-stack-boundary=2/" rpmrc.in
echo "optflags: i486 -O3 -fomit-frame-pointer -fno-exceptions -fno-rtti -pipe -s -m486 -mcpu=i486 -march=i486 -ffast-math -fexpensive-optimizations -malign-loops=2 -malign-jumps=2 -malign-functions=2 -mpreferred-stack-boundary=2" >>rpmrc.in
echo "optflags: i586 -O3 -fomit-frame-pointer -fno-exceptions -fno-rtti -pipe -s -mpentium -mcpu=pentium -march=pentium -ffast-math -fexpensive-optimizations -malign-loops=2 -malign-jumps=2 -malign-functions=2 -mpreferred-stack-boundary=2" >>rpmrc.in
echo "optflags: i686 -O3 -fomit-frame-pointer -fno-exceptions -fno-rtti -pipe -s -mpentiumpro -mcpu=pentiumpro -march=pentiumpro -ffast-math -fexpensive-optimizations -malign-loops=2 -malign-jumps=2 -malign-functions=2 -mpreferred-stack-boundary=2" >>rpmrc.in
echo "optflags: k6   -O3 -fomit-frame-pointer -fno-exceptions -fno-rtti -pipe -s -mcpu=k6 -march=k6 -ffast-math -fexpensive-optimizations -malign-loops=2 -malign-jumps=2 -malign-functions=2 -mpreferred-stack-boundary=2" >>rpmrc.in

cat rpmrc.in|sed -e \
    "s|buildarchtranslate: osfmach3_i686: i386|buildarchtranslate: osfmach3_i686: i686|g" \
	>rpmrc.in.mdk
cat rpmrc.in.mdk|sed -e \
    "s|buildarchtranslate: osfmach3_i586: i386|buildarchtranslate: osfmach3_i586: i586|g" \
        >rpmrc.in.mdk.2
cat rpmrc.in.mdk.2|sed -e \
    "s|buildarchtranslate: osfmach3_i486: i386|buildarchtranslate: osfmach3_i486: i486|g" \
        >rpmrc.in.mdk.3

cat rpmrc.in.mdk.3|sed -e \
    "s|buildarchtranslate: i686: i386|buildarchtranslate: i686: i686|g" \
	>rpmrc.in.mdk.4
cat rpmrc.in.mdk.4|sed -e \
    "s|buildarchtranslate: i586: i386|buildarchtranslate: i586: i586|g" \
	>rpmrc.in.mdk.5
cat rpmrc.in.mdk.5|sed -e \
    "s|buildarchtranslate: i486: i386|buildarchtranslate: i486: i486|g" \
	>rpmrc.in
bzcat %{SOURCE1} >> rpmrc.in
perl -p -i -e "s/-all-static/-static/" *
perl -p -i -e "s/-all-static/-static/" *
perl -p -i -e "s/-all-static/-static/" scripts/*
perl -p -i -e "s/-all-static/-static/" scripts/*
perl -p -i -e "s/-all-static/-static/" tests/*
perl -p -i -e "s/-all-static/-static/" tests/*
CFLAGS="-O -fomit-frame-pointer" ./configure --prefix=/usr --disable-shared --enable-v4-packages
perl -p -i -e "s/-all-static/-static/" *
perl -p -i -e "s/-all-static/-static/" *
perl -p -i -e "s/-all-static/-static/" scripts/*
perl -p -i -e "s/-all-static/-static/" scripts/*
perl -p -i -e "s/-all-static/-static/" tests/*
perl -p -i -e "s/-all-static/-static/" tests/*

make


%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr/lib

mkdir -p $RPM_BUILD_ROOT/usr/src/RPM/SOURCES
mkdir -p $RPM_BUILD_ROOT/usr/src/RPM/SPECS
mkdir -p $RPM_BUILD_ROOT/usr/src/RPM/SRPMS
mkdir -p $RPM_BUILD_ROOT/usr/src/RPM/BUILD
mkdir -p $RPM_BUILD_ROOT/usr/src/RPM/RPMS/{i386,i486,i586,i686,k6}
mkdir -p $RPM_BUILD_ROOT/usr/src/RPM/RPMS/noarch

make DESTDIR="$RPM_BUILD_ROOT" install

make DESTDIR="$RPM_BUILD_ROOT" install
pushd $RPM_BUILD_ROOT; {
    strip ./bin/rpm
    strip ./usr/bin/rpm2cpio
    mv ./usr/lib/rpm/rpmgettext ./usr/bin/
    mv ./usr/lib/rpm/rpmputtext ./usr/bin/
}
popd

#
find $RPM_BUILD_ROOT/usr/man/ -name '*[0-9]'|xargs bzip2 -9
for i in `find $RPM_BUILD_ROOT/ -type 'f' -perm '+a=x'`;do
	file $i|grep -q "not stripped" && strip $i
done

{ cd $RPM_BUILD_ROOT
  strip ./bin/rpm
  strip ./usr/bin/rpm2cpio
}

%clean
#rm -rf $RPM_BUILD_ROOT
echo "rm -rf $RPM_BUILD_ROOT, cause i'm not gonna"


%post
/bin/rpm --initdb
if [ ! -e /etc/rpm/macros -a -e /etc/rpmrc -a -f /usr/lib/rpm/convertrpmrc.sh ] 
then
	sh /usr/lib/rpm/convertrpmrc.sh 2>&1 > /dev/null
fi

# RpmSucks he doen't want thing and/or in %post
if grep -qi AMD-K6 /proc/cpuinfo;then
	perl -p -i -e "s/#K6#//g" /usr/lib/rpm/rpmrc
fi


%files
%defattr(-,root,root)
/usr/include/rpm
/usr/lib/librpm.a
/usr/lib/librpm.la
/usr/lib/librpmbuild.a
/usr/lib/librpmbuild.la

%changelog
* Fri Mar  3 2000 Pixel <pixel@mandrakesoft.com> 3.0.3-43mdk
- hack it for DrakX
