/*
 * kpvm_demo.h
 *
 * Copyright (c) 1998 Michael Kropfberger (michael.kropfberger@gmx.net)
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef __KPVM_DEMO_H__
#define __KPVM_DEMO_H__


#include <qmlined.h>

#include "vartuple.h"
#include "serialize.h"
#include "kpvm.h"

#define NUMPROCS 2

/****************************************************************************/
/************************    CLASS   Person    ******************************/
/****************************************************************************/


/**
  * @short Person is an Example of a sendable structured OO-Data-Type
  * It inherits from Serialize, to be a pvm_sendable object
  * @author Michael Kropfberger <michael.kropfberger@gmx.net>
 **/ 
class Person : public Serialize
{ Q_OBJECT

   public:

/** 
  * is needed to let MyKPvm force an object dump or to restore an object
 **/
    friend class MyKPvm;

    Person(Serialize *parent=0, const char *name=0);

    QString firstName() {return _firstName;};

    QString surName() {return _surName;};

    int persNr() {return _persNr;};
   
    float money() {return _money;};

  public slots:

    void setFirstName(QString fname);

    void setSurName(QString sname);

    void setPersNr(int pnr);
   
    void setMoney(float m);

  signals:
    
    void firstNameChanged();

    void surNameChanged();

    void persNrChanged();
 
    void moneyChanged();


  protected:

    /**
      * outputs the Persons data (Name, etc) into the QList of VarTuples
     **/
    QList<VarTuple> objState() const;

    /**
      * initializes the objects state by the given QList of VarTuples
      * , which is built in the same order as it was dumped in @ref #objState.
     **/
    void setFixedOrderObjState(QList<VarTuple> state);

    /**
      * initializes the objects state by the given QList of VarTuples
      * , which is built in any order and may not be complete 
      * as it was dumped in @ref #objState.
     **/
    void setObjState(QList<VarTuple> state);

 private:

    QString _firstName;
    QString _surName;
    int     _persNr;
    double  _money;

}; // Person


/****************************************************************************/
/*********************    CLASS   TransferFinished    ***********************/
/****************************************************************************/


/**
  * @short TransferFinished is just a helper-class for MyKpvm.
  * It is used to indicate the end of a pvm-session. 
  * It has absolutely no objectState to save.
  *
  * It inherits from Serialize, to be a pvm_sendable object
  * and implements the virtual methods with empty bodies.
  * @author Michael Kropfberger <michael.kropfberger@gmx.net>
 **/ 
class TransferFinished : public Serialize
{ Q_OBJECT

  protected:
    /**
     * returns just an empty QList of VarTuples
     **/
     QList<VarTuple> objState() const { QList<VarTuple> vt; return vt; };
    /**
     * does nothing
     **/
     void setFixedOrderObjState(QList<VarTuple>) {} ;
    /**
     * does nothing again ;)
     **/
     void setObjState(QList<VarTuple>) {};


};


/****************************************************************************/
/************************    CLASS   MyKPvm    ******************************/
/****************************************************************************/

/**
  * @short myKPvm is an Example for the main pvm-object
  * It inherits from KPvm and implements the constructor and a handle
  * for receiving data
  * @author Michael Kropfberger <michael.kropfberger@gmx.net>
 **/ 
class MyKPvm : public KPvm
{ Q_OBJECT

  public:

/**
  * is the Constructor of MyKPvm and is the so-called main-routine where
  * SLOT/SIGNAL-connections for handling sent/received data are installed.
  *
  * Here you may also distinct between beeing a parent or a child.
 **/
    MyKPvm(KPvm *parent=0, const char *name=0);

 protected:
/**
  * catches the closeEvent (CTRL-C, SIGTERM, window close etc...)
  *
  **/
  void closeEvent( QCloseEvent *);

  private slots:

  /**
    * is a possible SLOT for a dataReceived-Signal. 
    * 
    * It checks className to rebuild the class locally.
    * @param msgId is the used msgId given to @ref #send
    * @param objState is the object state of the sent class, which has to be
    *        restored
    * @param className contains the @ref #Persist child which was sent.
    * @param entity is the sender object from where the data comes
   **/
    void childHandleReceivedData(QString className, QList<VarTuple> objState
                      , int msgId, KPvmEntity *entity);

  private:

  /**
    * stores the database of persons in main memory
    **/
   QList<Person> _persons;

  /**
    * is the main output window where all text is written to
    **/
   QMultiLineEdit *output;
 
   QString        outputS;

};


#endif
