/* This file is part of the KDE libraries
    Copyright (c) 1998 Emmeran Seehuber (the_emmy@hotmail.com)
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include "klwidgetbase.h"
#include "qwidget.h"
#include "kldevice.h"
#include "qtableview.h"
#include "qscrollbar.h"
#include "qpainter.h"
#include "qdrawutil.h"


KLWidgetBase::KLWidgetBase()
{
  a_widget = 0;
}

void KLWidgetBase::setKLWidget(QWidget *widget)
{
  a_widget = widget;
}


bool KLWidgetBase::klSetup( KLSetupInfo *setupInfo )
{
  if( !KLChild::klSetup(setupInfo) )
    return false;
  HASSERT( a_widget );
  QWidget::FocusPolicy pol = a_widget->focusPolicy();
  QColor col = a_widget->backgroundColor();
  a_widget->recreate( setupInfo->device->getDeviceHandle(),0,QPoint(0,0),FALSE);
  a_widget->setFocusPolicy(pol); 
  a_widget->setBackgroundColor(col);
  a_widget->hide();
  return true;
}


bool KLWidgetBase::klShow(KLShowInfo *showInfo)
{
  if( !KLChild::klShow(showInfo) )
    return false;
  HASSERT( a_widget );
  a_widget->setGeometry(showInfo->y,showInfo->x,showInfo->ySize,showInfo->xSize);
  a_widget->show();
  return true;
}

void KLWidgetBase::klHide()
{
  HASSERT( a_widget );
  a_widget->hide();
  KLChild::klHide();
}

void KLWidgetBase::klCleanup()
{
  HASSERT( a_widget );
  a_widget->recreate(0,0,QPoint(0,0),false), // Just detach it from the parent widget 
  KLChild::klCleanup();
}

void KLWidgetBase::setupGrap()
{
  a_widget->installEventFilter(a_setupInfo.device->getGrapper());
  a_acceptDrops = a_widget->acceptDrops();
  a_widget->setAcceptDrops(true);
}

void KLWidgetBase::cleanupGrap()
{
  a_widget->setAcceptDrops(a_acceptDrops);
  a_widget->removeEventFilter(a_setupInfo.device->getGrapper());
}

IMPLEMENT_KLMETA_STANDALONE(KLWidgetBase,KLChild,"KDE Widget");
