
#include "changewin.h"

KLMyGroup::KLMyGroup() : KLHVGroup(false)
{
  *this << (*(details = new KLHVGroup(true))
            << new KLLabel("Description")
            << new KLLineEdit("This is just a simple description")
            << new KLLabel("Time from")
            << new KLLineEdit("12:00")
            << new KLLabel("to")
            << new KLLineEdit("13:00"))
        << (*(new KLHVGroup(true))
            << ::setSameSize
            << new KLHVSpace()
            << new KLHVSpace()
            << new KLHVSpace()
            << (chk = new KLCheckBox("Details"))
            << (neu = new KLButton("New"))
            << (del = new KLButton("Delete")));
  chk->setChecked(true);
  connect(chk,SIGNAL(toggled(bool)),this,SLOT(togDetails(bool)));
  connect(neu,SIGNAL(clicked()),this,SLOT(addNew()));
  connect(del,SIGNAL(clicked()),this,SLOT(remThis()));
}

void KLMyGroup::addNew()
{
  KLGroup *child = new KLMyGroup;
  if( parentChild )
    ((KLGroup *)parentChild)->addChild(child);
}

void KLMyGroup::remThis()
{
  if( parentChild )
    ((KLGroup *)parentChild)->remChild(this);
  delete this;
}

void KLMyGroup::togDetails(bool on)
{
  details->setHidden(!on);
}


int main( int argc, char **argv ) 
{
  KApplication app(argc,argv);
  KLDialog dlg;
  KLGroup &group = (*(new KLHVGroup(false))
                     << (*(new KLHVGroup(true))
                        << new KLHVSpace()
                        << new KLLabel("This example just shows a little dynamic ...")
                        << new KLHVSpace())
                     << new KLMyGroup());
      
  dlg.setRootChild(&group);
  dlg.show();
  app.setMainWidget( &dlg );
  app.exec();
}

#include "changewin.moc"
