/*
 * This file is part of telepathy-presence-applet
 *
 * Copyright (C) 2011 Francesco Nwokeka <francesco.nwokeka@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

import Qt 4.7
import org.kde.plasma.core 0.1 as PlasmaCore

Item {
    id: panel;

    property string globalPresence;
    property string globalPresenceMessage: "";

    // global signals emitted from LeftPanel to main->RightPanel
    signal setGlobalStatusMessageSignal(variant globalStatus);
    signal setGlobalNickSignal(variant globalNick);
    signal setGlobalAvatarSignal(variant globalAvatar);
    signal setGlobalPresenceSignal(variant globalPresenceIconName);

    // updates to do on global properties changing
    onGlobalPresenceChanged: {
        globalAvatar.setPresenceColor(panel.globalPresence);
        globalPresenceChooser.setFrontPresence(panel.globalPresence, panel.globalPresence);
    }
    
    onGlobalPresenceMessageChanged: {
        globalStatusMessage.editableText = globalPresenceMessage;
    }


    Avatar {
        id: globalAvatar;
        avatarPath: "";
        presence: globalPresence;

        anchors {
            top: parent.top;
            left: parent.left;
            margins: 5;
        }

        onAvatarChanged: {
            panel.setGlobalAvatar(newAvatarSource);
        }
    }

    EditableText {
        id: globalNick;
        height: 30;
        boldText: true;
        clickMessage: i18n("Click to set nick");
        editableText: "";//globalNickFromConfig;

        anchors {
            top: parent.top;
            left: globalAvatar.right;
            right: parent.right;
            margins: 5;
        }

        onTextChanged: {
            panel.setGlobalNick(newText);
        }
    }

    PresenceChooser {
        id: globalPresenceChooser;
        flipEnabled: true;
        presenceIconType: globalPresence;
        presenceText: globalPresence;

        anchors {
            top: globalNick.bottom;
            left: globalAvatar.right;
            right: parent.right;
            margins: 5;
        }

        onPresenceChanged: {
            panel.setGlobalPresenceSignal(presenceIconName);
        }
    }

    EditableText {
        id: globalStatusMessage;
        height: 20;
        width: 100;
        italicText: true;
        clickMessage: i18n("Click to set personal message");
        editableText: globalPresenceMessage;

        anchors {
            top: globalAvatar.bottom;
            left: parent.left;
            right: parent.right;
            topMargin: 10;
        }

        onTextChanged: {
            panel.setGlobalStatusMessageSignal(newText);
        }
    }

    LauncherPanel {
        id: globalLauncherPanel;
        height: 80;

        anchors {
            left: parent.left;
            right: parent.right;
            bottom: parent.bottom;
        }
    }

    // to verify if contactlist is installed
    PlasmaCore.DataSource {
        id: telepathyContactListSource;
        engine: "apps";
        interval: 0;

        onSourceAdded: {
            connectSource(source);
        }
        Component.onCompleted: {
            connectedSources = sources;
        }
    }

    // determine if telepathy-contactlist is installed on system
    // this determines the visibility of the launcher for the contactlist
    PlasmaCore.DataModel {
        dataSource: telepathyContactListSource;

        Component.onCompleted: {
            var found = false;

            // check if contactlist is installed
            // available from version >= 4
            if (plasmoid.applicationExists) {
                found = plasmoid.applicationExists("kde4-telepathy-kde-contactlist.desktop");
            } else {
                // for version < 4
                for(var i = 0; i < telepathyContactListSource.sources.length && !found; ++i) {
                    var sourceName = telepathyContactListSource.sources[i];
                    if (sourceName == "kde4-telepathy-kde-contactlist.desktop") {
                        found = true;
                    }
                }
            }
            globalLauncherPanel.contactlistInstalled = found;
        }
    }

    function setGlobalAvatar(newAvatarSource)
    {
        // get new avatar from the component and set it + save to config
        globalAvatarFromConfig = newAvatarSource;

        // show new avatar
        globalAvatar.setAvatar(newAvatarSource);

        // save to config
        plasmoid.writeConfig("Avatar", newAvatarSource);

        // send signal to right panel
        setGlobalAvatarSignal(newAvatarSource);
    }

    function setGlobalNick(newNick)
    {
        globalNickFromConfig = newNick;
        plasmoid.writeConfig("Nick", newNick);

        // send signal to right panel
        setGlobalNickSignal(newNick);
    }
}
