/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a plugin for debug.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgdebugplugin.h"

#include <KActionCollection>
#include <KAboutData>
#include <KGenericFactory>

#include "skgdebugpluginwidget.h"
#include "skgmainpanel.h"
#include "skgtraces.h"

/**
 * This plugin factory.
 */
K_PLUGIN_FACTORY(SKGDebugPluginFactory, registerPlugin<SKGDebugPlugin>();)
/**
 * This plugin export.
 */
K_EXPORT_PLUGIN(SKGDebugPluginFactory("skg_debug", "skg_debug"))

SKGDebugPlugin::SKGDebugPlugin(QWidget* iWidget, QObject* iParent, const QVariantList& /*iArg*/) : SKGInterfacePlugin(iParent)
{
    Q_UNUSED(iWidget);
    SKGTRACEIN(10, "SKGDebugPlugin::SKGDebugPlugin");
}

SKGDebugPlugin::~SKGDebugPlugin()
{
    SKGTRACEIN(10, "SKGDebugPlugin::~SKGDebugPlugin");
    m_currentDocument = NULL;
}

bool SKGDebugPlugin::setupActions(SKGDocument* iDocument, const QStringList& iArgument)
{
    SKGTRACEIN(10, "SKGDebugPlugin::setupActions");
    Q_UNUSED(iArgument);

    m_currentDocument = iDocument;

    setComponentData(KGlobal::mainComponent());
    setXMLFile("../skg_debug/skg_debug.rc");

    // Menu
    KAction* restartProfiling = new KAction(KIcon("fork"), i18nc("Restart the profiling, a method used for analysing performances", "Restart profiling"), this);
    connect(restartProfiling, SIGNAL(triggered(bool)), this, SLOT(onRestartProfiling()));
    restartProfiling->setShortcut(Qt::CTRL + Qt::Key_Pause);
    registerGlobalAction("debug_restart_profiling", restartProfiling);

    QStringList overlayopen;
    overlayopen.push_back("skg_open");
    KAction* openProfiling = new KAction(KIcon("fork", NULL, overlayopen), i18nc("Open the profiling, a method used for analysing performances", "Open profiling"), this);
    connect(openProfiling, SIGNAL(triggered(bool)), this, SLOT(onOpenProfiling()));
    openProfiling->setShortcut(Qt::ALT + Qt::Key_Pause);
    registerGlobalAction("debug_open_profiling", openProfiling);
    return true;
}

SKGTabPage* SKGDebugPlugin::getWidget()
{
    SKGTRACEIN(10, "SKGDebugPlugin::getWidget");
    return new SKGDebugPluginWidget(m_currentDocument);
}

QString SKGDebugPlugin::title() const
{
    return i18nc("Noun, a plugin allowing to access the SQLite database, useful to debug", "Debug");
}

QString SKGDebugPlugin::icon() const
{
    return "tools-report-bug";
}

QString SKGDebugPlugin::toolTip() const
{
    return i18nc("A tool tip, explaining that the plugin is useful for debugging purposes", "Useful for debug");
}

bool SKGDebugPlugin::isInPagesChooser() const
{
    return true;
}

bool SKGDebugPlugin::isEnabled() const
{
    return (SKGTraces::SKGLevelTrace > 0 || SKGTraces::SKGPerfo);
}

void SKGDebugPlugin::onRestartProfiling()
{
    SKGTraces::cleanProfilingStatistics();
}

void SKGDebugPlugin::onOpenProfiling()
{
    // Call debug plugin
    QString dumpString;
    QStringList dump = SKGTraces::getProfilingStatistics();

    int nbl = dump.count();
    for (int i = 0; i < nbl; ++i) {
        dumpString += dump[i];
        dumpString += '\n';
    }

    if (SKGMainPanel::getMainPanel()) SKGMainPanel::getMainPanel()->openPage("skg://debug_plugin/?sqlResult=" % SKGServices::encodeForUrl(dumpString));
}
#include "skgdebugplugin.moc"
