#some configure checks

# LIBXML_ENABLE_THREADS
if(ENABLE_THREADS)
    if(UNIX)
        add_definitions(-DLIBXML_THREAD_ENABLED)
    else(UNIX)
        add_definitions(-DHAVE_WIN32_THREADS)
    endif(UNIX)
endif(ENABLE_THREADS)

# set ICONV_CONST
set(ICONV_CONST ${LIBICONV_CONST})

# HAVE_LIBZ
if(ZLIB_FOUND)
    set(HAVE_LIBZ ON)
endif(ZLIB_FOUND)

# HAVE_LIBM
if(UNIX)
    set(HAVE_LIBM ON)
endif(UNIX)

# HAVE_LIBPTHREAD
if(CMAKE_SYSTEM_NAME STREQUAL GNU)
    set(CMAKE_SHARED_LINKER_FLAGS "${CMAKE_SHARED_LINKER_FLAGS} -pthread")
    set(CMAKE_MODULE_LINKER_FLAGS "${CMAKE_MODULE_LINKER_FLAGS} -pthread")
    check_include_file("pthread.h" HAVE_PTHREAD_H)
    set(HAVE_LIBPTHREAD ON)

endif(CMAKE_SYSTEM_NAME STREQUAL GNU)

# HAVE_LIBHISTORY
# HAVE_LIBREADLINE

set(CMAKE_REQUIRED_INCLUDES ${ZLIB_INCLUDE_DIR} ${CMAKE_REQUIRED_INCLUDES})
set(CMAKE_REQUIRED_LIBRARIES ${ZLIB_LIBRARIES} ${CMAKE_REQUIRED_LIBRARIES})
include(CheckIncludeFile)
include(CheckFunctionExists)
include(CheckSymbolExists)

check_include_file("fcntl.h" HAVE_FCNTL_H)
check_include_file("ansidecl.h" HAVE_ANSIDECL_H)
check_include_file("arpa/inet.h" HAVE_ARPA_INET_H)
check_include_file("arpa/nameser.h" HAVE_ARPA_NAMESER_H)
check_include_file("ctype.h" HAVE_CTYPE_H)
check_include_file("dirent.h" HAVE_DIRENT_H)
check_include_file("dlfcn.h" HAVE_DLFCN_H)
check_include_file("dl.h" HAVE_DL_H)
check_include_file("errno.h" HAVE_ERRNO_H)
check_include_file("float.h" HAVE_FLOAT_H)
check_include_file("fp_class.h" HAVE_FP_CLASS_H)
check_include_file("ieeefp.h" HAVE_IEEEFP_H)
check_include_file("inttypes.h" HAVE_INTTYPES_H)
check_include_file("inttypes.h.h" HAVE_INTTYPES_H_H)
check_include_file("limits.h" HAVE_LIMITS_H)
check_include_file("malloc.h" HAVE_MALLOC_H)
check_include_file("math.h" HAVE_MATH_H)
check_include_file("memory.h" HAVE_MEMORY_H)
check_include_file("nan.h" HAVE_NAN_H)
check_include_file("ndir.h" HAVE_NDIR_H)
check_include_file("netdb.h" HAVE_NETDB_H)
check_include_file("netinet/in.h" HAVE_NETINET_IN_H)
check_include_file("poll.h" HAVE_POLL_H)
check_include_file("resolv.h" HAVE_RESOLV_H)
check_include_file("signal.h" HAVE_SIGNAL_H)
check_include_file("stdarg.h" HAVE_STDARG_H)
check_include_file("stdint.h" HAVE_STDINT_H)
check_include_file("stdlib.h" HAVE_STDLIB_H)
check_include_file("strings.h" HAVE_STRINGS_H)
check_include_file("string.h" HAVE_STRING_H)
check_include_file("sys/dir.h" HAVE_SYS_DIR_H)
check_include_file("sys/mman.h" HAVE_SYS_MMAN_H)
check_include_file("sys/ndir.h" HAVE_SYS_NDIR_H)
check_include_file("sys/select.h" HAVE_SYS_SELECT_H)
check_include_file("sys/socket.h" HAVE_SYS_SOCKET_H)
check_include_file("sys/stat.h" HAVE_SYS_STAT_H)
check_include_file("sys/timeb.h" HAVE_SYS_TIMEB_H)
check_include_file("sys/time.h" HAVE_SYS_TIME_H)
check_include_file("sys/types.h" HAVE_SYS_TYPES_H)
check_include_file("time.h" HAVE_TIME_H)
check_include_file("unistd.h" HAVE_UNISTD_H)
check_include_file("zlib.h" HAVE_ZLIB_H)

if(NOT HAVE_RESOLV_H)
set(SUPPORT_IP6 OFF)
endif(NOT HAVE_RESOLV_H)

#/* Whether struct sockaddr::__ss_family exists */ ???
#cmakedefine HAVE_BROKEN_SS_FAMILY

check_function_exists("strdup" HAVE_STRDUP)
check_function_exists("getaddrinfo" HAVE_GETADDRINFO)
check_function_exists("class" HAVE_CLASS)
check_function_exists("dlopen" HAVE_DLOPEN)
check_function_exists("shl_load" HAVE_SHLLOAD)
check_function_exists("finite" HAVE_FINITE)
check_function_exists("fpclass" HAVE_FPCLASS)
check_function_exists("fprintf" HAVE_FPRINTF)
check_function_exists("fp_class" HAVE_FP_CLASS)
check_function_exists("ftime" HAVE_FTIME)
check_function_exists("gettimeofday" HAVE_GETTIMEOFDAY)
check_function_exists("isinf" HAVE_ISINF)
check_function_exists("isnan" HAVE_ISNAN)
check_function_exists("isnand" HAVE_ISNAND)
check_function_exists("localtime" HAVE_LOCALTIME)
check_function_exists("printf" HAVE_PRINTF)
check_function_exists("signal" HAVE_SIGNAL)
check_function_exists("snprintf" HAVE_SNPRINTF)
check_function_exists("sprintf" HAVE_SPRINTF)
check_function_exists("sscanf" HAVE_SSCANF)
check_function_exists("stat" HAVE_STAT)
check_function_exists("strdup" HAVE_STRDUP)
check_function_exists("strerror" HAVE_STRERROR)
check_function_exists("strftime" HAVE_STRFTIME)
check_function_exists("strndup" HAVE_STRNDUP)
check_function_exists("vfprintf" HAVE_VFPRINTF)
check_function_exists("vsnprintf" HAVE_VSNPRINTF)
check_function_exists("vsprintf" HAVE_VSPRINTF)
check_function_exists("va_copy" HAVE_VA_COPY)
check_function_exists("_stat" HAVE__STAT)
check_function_exists("__va_copy" HAVE___VA_COPY)

if(MSVC)
    add_definitions(-D_CRT_SECURE_NO_WARNINGS)
endif(MSVC)

if(ZLIB_FOUND)
    # disable large file support in case the functions are not contained in the dll
    check_symbol_exists("gzopen64" "zlib.h" GZOPEN64)
    if(NOT GZOPEN64)
        add_definitions(-DNO_LARGEFILE_SOURCE)
        message(STATUS "No Large File Support in libz!")
    endif(NOT GZOPEN64)
endif(ZLIB_FOUND)

configure_file(config.h.cmake config.h)

configure_file(include/libxml/xmlversion.h.in ${CMAKE_BINARY_DIR}/include/libxml/xmlversion.h)

