# Try to find Yajl functionality
# Once done this will define
#
#  YAJL_FOUND - system has Yajl
#  YAJL_INCLUDE_DIR - Yajl include directory
#  YAJL_LIBRARIES - Libraries needed to use Yajl
#
# Copyright (c) 2011, Patrick Spendrin, <ps_ml@gmx.de>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.

if(YAJL_INCLUDE_DIR AND YAJL_FOUND)
  set(YAJL_FIND_QUIETLY TRUE)
endif(YAJL_INCLUDE_DIR AND YAJL_FOUND)

set(YAJL_FOUND FALSE)

find_path(YAJL_INCLUDE_DIR yajl/yajl_version.h)

find_library(YAJL_LIBRARIES NAMES yajl yajl_s)

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(Yajl  DEFAULT_MSG  YAJL_LIBRARIES  YAJL_INCLUDE_DIR)

mark_as_advanced(YAJL_INCLUDE_DIR YAJL_LIBRARIES YAJL_FOUND)
