// ***************************************************************** -*- C++ -*-
/*
 * Copyright (C) 2004-2011 Andreas Huggel <ahuggel@gmx.net>
 *
 * This program is part of the Exiv2 distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, 5th Floor, Boston, MA 02110-1301 USA.
 */
/*!
  @file    exiv2.hpp
  @brief   Include all Exiv2 header files.
  @version $Rev: 2479 $
  @author  Andreas Huggel (ahu)
           <a href="mailto:ahuggel@gmx.net">ahuggel@gmx.net</a>
  @date    21-Jun-10, ahu: created
 */
#ifndef EXIV2_HPP_
#define EXIV2_HPP_

// *****************************************************************************
// included header files
#include "basicio.hpp"
#include "bmpimage.hpp"
#include "convert.hpp"
#include "cr2image.hpp"
#include "crwimage.hpp"
#include "datasets.hpp"
#include "easyaccess.hpp"
#include "epsimage.hpp"
#include "error.hpp"
#include "exif.hpp"
#include "futils.hpp"
#include "gifimage.hpp"
#include "image.hpp"
#include "iptc.hpp"
#include "jp2image.hpp"
#include "jpgimage.hpp"
#include "metadatum.hpp"
#include "mrwimage.hpp"
#include "orfimage.hpp"
#include "pgfimage.hpp"
#include "pngimage.hpp"
#include "preview.hpp"
#include "properties.hpp"
#include "psdimage.hpp"
#include "rafimage.hpp"
#include "rw2image.hpp"
#include "tags.hpp"
#include "tgaimage.hpp"
#include "tiffimage.hpp"
#include "types.hpp"
#include "value.hpp"
#include "version.hpp"
#include "xmp.hpp"
#include "xmpsidecar.hpp"

#endif                                  // #ifndef EXIV2_HPP_
