.\" Copyright 1993 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtCreate-Popup-Shell XtVaCreate-Popup-Shell wid-get
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft CW
.ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de IN		\" send an index entry to the stderr
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.ny0
.TH XtCreatePopupShell __libmansuffix__ __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtCreatePopupShell, XtVaCreatePopupShell \- create a popup shell
.SH SYNTAX
.HP
Widget XtCreatePopupShell(String \fIname\fP, WidgetClass \fIwidget_class\fP,
Widget \fIparent\fP, ArgList \fIargs\fP, Cardinal \fInum_args\fP);
.HP
Widget XtVaCreatePopupShell(String \fIname\fP, WidgetClass \fIwidget_class\fP,
Widget \fIparent\fP, ...\^);
.SH ARGUMENTS
.ds Al to override the resource defaults
.IP \fIargs\fP 1i
Specifies the argument list \*(Al.
.ds Sh \ shell
.IP \fIname\fP 1i
Specifies the text name for the created\*(Sh widget.
.IP \fInum_args\fP 1i
Specifies the number of arguments in the argument list.
.IP \fIparent\fP 1i
Specifies the parent widget.
.ds Wc \ pointer for the created shell widget
.IP \fIwidget_class\fP 1i
Specifies the widget class\*(Wc.
.IP \fI...\fP 1i
Specifies the variable argument list \*(Al.
.SH DESCRIPTION
The
.ZN XtCreatePopupShell
function ensures that the specified class is a subclass of
.ZN Shell
and, rather than using insert_child to attach the widget to the parent's
.IN "insert_child procedure"
children list, attaches the shell to the parent's pop-ups list directly.
.LP
A spring-loaded pop-up invoked from a translation table already must exist
at the time that the translation is invoked,
so the translation manager can find the shell by name.
Pop-ups invoked in other ways can be created ``on-the-fly'' when
the pop-up actually is needed.
This delayed creation of the shell is particularly useful when you pop up
an unspecified number of pop-ups.
You can look to see if an appropriate unused shell (that is, not
currently popped up) exists and create a new shell if needed.
.SH "SEE ALSO"
XtCreateWidget(__libmansuffix__),
XtPopdown(__libmansuffix__),
XtPopup(__libmansuffix__)
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
