.\" zip_file_add.mdoc \-- add files to zip archive
.\" Copyright (C) 2004-2012 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_FILE_ADD 3 "October 6, 2012" NiH
.SH "NAME"
zip_file_add , \- .Nm zip_file_replace
add file to zip archive or replace file in zip archive
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
#include <zip.h>
.PP
zip_int64_t
zip_file_add(struct zip *archive, const char *name); \
"struct zip_source *source" "zip_flags_t flags"
.PP
int
zip_file_replace(struct zip *archive, zip_uint64_t index); \
"struct zip_source *source" "zip_flags_t flags"
.SH "DESCRIPTION"
The function
zip_file_add
adds a file to a zip archive, while
zip_file_replace
replaces an existing file in a zip archive.
The argument
\fBarchive\fR
specifies the zip archive to which the file should be added.
\fBname\fR
is the file's name in the zip archive (for
zip_file_add ),
while
\fBindex\fR
specifies which file should be replaced (for
zip_file_replace ).
The
\fBflags\fR
argument can be any combination of
\fBZIP_FL_OVERWRITE\fR
with one of
\fBZIP_FL_ENC_* :\fR
.RS
.TP 22
\fBZIP_FL_OVERWRITE\fR
Overwrite any existing file of the same name.
For
.Nm zip_file_add
only.
.TP 22
\fBZIP_FL_ENC_GUESS\fR
Guess encoding of
\fBname\fR
(default).
.TP 22
\fBZIP_FL_ENC_UTF_8\fR
Interpret
\fBname\fR
as UTF-8.
.TP 22
\fBZIP_FL_ENC_CP437\fR
Interpret
\fBname\fR
as code page 437 (CP-437).
.RE
The data is obtained from the
\fBsource\fR
argument.
See the
zip_source_*
functions cited in
SEE ALSO.
.SH "RETURN VALUES"
Upon successful completion,
zip_file_add
returns the index of the new file in the archive, and
zip_file_replace
returns 0.
Otherwise, \-1 is returned and the error code in
\fBarchive\fR
is set to indicate the error.
.SH "EXAMPLES"
.Bd \-literal \-offset indent
struct zip_source *s;
const char buf="teststring";

if ((s=zip_source_buffer(archive, buffer, sizeof(buf), 0)) == NULL ||
    zip_file_add(archive, name, s, ZIP_FL_ENC_UTF_8) \*[Lt] 0) {
    zip_source_free(s);
    printf("error adding file: %s\en", zip_strerror(archive));
}
.Ed
.SH "ERRORS"
zip_file_add
and
zip_file_replace
fail if:
.RS
.TP 4
[ZIP_ER_EXISTS]
There is already a file called
\fBname\fR
in the archive.
(Only applies to
zip_file_add,
and only if
\fBZIP_FL_OVERWRITE\fR
is not provided).
.TP 4
[ZIP_ER_INVAL]
\fBsource\fR
or
\fBname\fR
are
\fBNULL,\fR
or
\fBindex\fR
is invalid.
.TP 4
[ZIP_ER_MEMORY]
Required memory could not be allocated.
.TP 4
[ZIP_ER_RDONLY]
Archive was opened in read-only mode.
.RE
.SH "SEE ALSO"
libzip(3),
zip_source_file(3),
zip_source_filep(3),
zip_source_function(3),
zip_source_zip(3)
.SH "AUTHORS"

Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
