.\" zip_file_extra_field_delete.mdoc \-- delete extra field for file in zip
.\" Copyright (C) 2012-2013 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP files.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_FILE_EXTRA_FIELD_DELETE 3 "February 20, 2013" NiH
.SH "NAME"
zip_file_extra_field_delete , \- .Nm zip_file_extra_field_delete_by_id
delete extra field for file in zip
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
#include <zip.h>
.PP
int
zip_file_extra_field_delete(struct zip *archive, zip_uint64_t index); \
"zip_uint16_t extra_field_index" "zip_flags_t flags"
.PP
int
zip_file_extra_field_delete_by_id(struct zip *archive, zip_uint64_t index); \
"zip_uint16_t extra_field_id" "zip_uint16_t extra_field_index" "zip_flags_t flags"
.SH "DESCRIPTION"
The
zip_file_extra_field_delete
function deletes the extra field with index
\fBextra_field_index\fR
for the file at position
\fBindex\fR
in the zip archive.
.PP
If
\fBindex\fR
is
\fBZIP_EXTRA_FIELD_ALL,\fR
then all extra fields will be deleted.
.PP
The following
\fBflags\fR
are supported:
.RS
.TP 18
\fBZIP_FL_CENTRAL\fR
Delete extra fields from the archive's central directory.
.TP 18
\fBZIP_FL_LOCAL\fR
Delete extra fields from the local file headers.
.RE
.PP
The
zip_file_extra_field_delete_by_id
function deletes the extra field with ID (two-byte signature)
\fBextra_field_id\fR
and index
\fBextra_field_index\fR
(in other words, the
\fBextra_field_index'th\fR
extra field with ID
\fBextra_field_id )\fR
The other arguments are the same as for
zip_file_extra_field_delete
\fB( ZIP_EXTRA_FIELD_ALL\fR
will delete all extra fields the specified ID).
.SH "RETURN VALUES"
Upon successful completion 0 is returned.
Otherwise, \-1 is returned and the error code in
\fBarchive\fR
is set to indicate the error.
.SH "ERRORS"
zip_file_extra_field_delete
and
zip_file_extra_field_delete_by_id
fail if:
.RS
.TP 4
[ZIP_ER_NOENT]
\fBindex\fR
is not a valid file index in
\fBarchive.\fR
.RE
.SH "SEE ALSO"
libzip(3),
zip_file_extra_field_get(3),
zip_file_extra_field_set(3),
zip_file_extra_fields_count(3)
.SH "AUTHORS"

Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
